/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.DistanceFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.range.Range;
import network.aika.neuron.relation.Relation;

public class Synapse
implements Writable {
    public static final int OUTPUT = -1;
    public static final int VARIABLE = -2;
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.input.compareTo(s2.input);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.output.compareTo(s2.output);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public Neuron input;
    public Neuron output;
    public Integer id;
    public boolean isRecurrent;
    public int rangeInput;
    public Range.Output rangeOutput;
    public boolean identity;
    public Map<Integer, Set<Relation>> relations = new TreeMap<Integer, Set<Relation>>();
    public DistanceFunction distanceFunction = null;
    public Writable extension;
    public boolean inactive;
    public double weight;
    public double weightDelta;
    public double bias;
    public double biasDelta;
    public double limit;
    public double limitDelta;
    public boolean toBeDeleted;
    public boolean isConjunction;
    public int createdInDoc;
    public int committedInDoc;

    public Synapse() {
        this.relations = new TreeMap<Integer, Set<Relation>>();
    }

    public Synapse(Neuron input, Neuron output, Integer id) {
        this.id = id;
        this.input = input;
        this.output = output;
        if (output.model.getSynapseExtensionFactory() != null) {
            this.extension = output.model.getSynapseExtensionFactory().createObject();
        }
    }

    public void link() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.put(this, this);
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        ((Neuron)out.provider).inMemoryInputSynapses.put(this, this);
        ((Neuron)out.provider).inputSynapsesById.put(this.id, this);
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        if (this.isConjunction(true, false)) {
            out.inputSynapses.put(this, this);
            this.isConjunction = true;
            out.setModified();
        } else {
            in.outputSynapses.put(this, this);
            this.isConjunction = false;
            in.setModified();
        }
        out.registerSynapseId(this.id);
        if (in.isPassiveInputNeuron()) {
            out.registerPassiveInputSynapse(this);
        }
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    public void relink() {
        boolean newIsConjunction = this.isConjunction(true, false);
        if (newIsConjunction != this.isConjunction) {
            INeuron in = (INeuron)this.input.get();
            INeuron out = (INeuron)this.output.get();
            boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
            (dir ? in : out).lock.acquireWriteLock();
            (dir ? out : in).lock.acquireWriteLock();
            if (newIsConjunction) {
                out.inputSynapses.put(this, this);
                this.isConjunction = true;
                out.setModified();
            } else {
                in.outputSynapses.put(this, this);
                this.isConjunction = false;
                in.setModified();
            }
            (dir ? in : out).lock.releaseWriteLock();
            (dir ? out : in).lock.releaseWriteLock();
        }
    }

    public void unlink() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.remove(this);
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        ((Neuron)out.provider).inMemoryInputSynapses.remove(this);
        ((Neuron)out.provider).inputSynapsesById.remove(this.id);
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void removeLinkInternal(INeuron in, INeuron out) {
        if (this.isConjunction(false, false)) {
            if (out.inputSynapses.remove(this) != null) {
                out.setModified();
                --out.synapseIdCounter;
            }
        } else if (in.outputSynapses.remove(this) != null) {
            in.setModified();
            --out.synapseIdCounter;
        }
    }

    public double getMaxInputValue() {
        return this.limit * this.weight;
    }

    public boolean exists() {
        if (((INeuron)this.input.get()).outputSynapses.containsKey(this)) {
            return true;
        }
        return ((INeuron)this.output.get()).inputSynapses.containsKey(this);
    }

    public boolean isConjunction(boolean v, boolean absolute) {
        INeuron out = (INeuron)this.output.get();
        return (v ? (this.limit + this.limitDelta) * this.getNewWeight() : this.limit * this.weight) + (absolute ? 0.0 : out.requiredSum) + (v ? out.getNewBiasSum() : out.biasSum) <= 0.0;
    }

    public void updateDelta(Document doc, double weightDelta, double biasDelta, double limitDelta) {
        this.weightDelta += weightDelta;
        this.biasDelta += biasDelta;
        this.limitDelta += limitDelta;
        ((INeuron)this.output.get()).biasSumDelta += biasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public void update(Document doc, double weight, double bias, double limit) {
        this.weightDelta = weight - this.weight;
        double newBiasDelta = bias - this.bias;
        this.limitDelta = limit - this.limit;
        ((INeuron)this.output.get()).biasSumDelta += newBiasDelta - this.biasDelta;
        this.biasDelta = newBiasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public boolean isNegative() {
        return this.weight < 0.0;
    }

    public Set<Relation> getRelationById(Integer id) {
        return this.relations.get(id);
    }

    public String toString() {
        return "S NW:" + this.getNewWeight() + " NB:" + this.getNewBias() + " rec:" + this.isRecurrent + " o:" + this.rangeOutput + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeBoolean(this.isRecurrent);
        out.writeInt(this.rangeInput);
        this.rangeOutput.write(out);
        out.writeBoolean(this.identity);
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.relations.size());
        for (Map.Entry<Integer, Set<Relation>> me : this.relations.entrySet()) {
            out.writeInt(me.getKey());
            out.writeInt(me.getValue().size());
            for (Relation rel : me.getValue()) {
                rel.write(out);
            }
        }
        out.writeBoolean(this.distanceFunction != null);
        if (this.distanceFunction != null) {
            out.writeUTF(this.distanceFunction.name());
        }
        out.writeDouble(this.weight);
        out.writeDouble(this.bias);
        out.writeDouble(this.limit);
        out.writeBoolean(this.isConjunction);
        out.writeBoolean(this.extension != null);
        if (this.extension != null) {
            this.extension.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.id = in.readInt();
        this.isRecurrent = in.readBoolean();
        this.rangeInput = in.readInt();
        this.rangeOutput = Range.Output.read(in, m);
        this.identity = in.readBoolean();
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            Integer relId = in.readInt();
            TreeSet<Relation> relSet = new TreeSet<Relation>(Relation.COMPARATOR);
            int s = in.readInt();
            for (int j = 0; j < s; ++j) {
                Relation r = Relation.read(in, m);
                relSet.add(r);
            }
            this.relations.put(relId, relSet);
        }
        if (in.readBoolean()) {
            this.distanceFunction = DistanceFunction.valueOf(in.readUTF());
        }
        this.weight = in.readDouble();
        this.bias = in.readDouble();
        this.limit = in.readDouble();
        this.isConjunction = in.readBoolean();
        if (in.readBoolean()) {
            this.extension = m.getSynapseExtensionFactory().createObject();
            this.extension.readFields(in, m);
        }
    }

    public static Synapse read(DataInput in, Model m) throws IOException {
        Synapse s = new Synapse();
        s.readFields(in, m);
        return s;
    }

    public static Synapse createOrLookup(Document doc, Integer synapseId, Neuron inputNeuron, Neuron outputNeuron) {
        outputNeuron.get(doc);
        inputNeuron.get(doc);
        outputNeuron.lock.acquireWriteLock();
        Synapse synapse = null;
        if (synapseId != null) {
            synapse = (Synapse)outputNeuron.inputSynapsesById.get(synapseId);
        } else {
            Map.Entry<Synapse, Synapse> me = outputNeuron.inMemoryInputSynapses.subMap(new Synapse(inputNeuron, outputNeuron, Integer.MIN_VALUE), true, new Synapse(inputNeuron, outputNeuron, Integer.MAX_VALUE), true).firstEntry();
            if (me != null) {
                synapse = me.getKey();
            }
        }
        outputNeuron.lock.releaseWriteLock();
        if (synapse == null) {
            synapse = new Synapse(inputNeuron, outputNeuron, synapseId);
            if (synapseId == null) {
                synapse.id = ((INeuron)outputNeuron.get(doc)).getNewSynapseId();
            }
            synapse.link();
            if (doc != null) {
                synapse.createdInDoc = doc.id;
            }
        }
        return synapse;
    }

    public double getNewWeight() {
        return this.weight + this.weightDelta;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public static class Builder
    implements Neuron.Builder {
        public boolean recurrent;
        public Neuron neuron;
        public double weight;
        public double bias;
        public double limit = 1.0;
        public DistanceFunction distanceFunction;
        public int rangeInput = -1;
        public Range.Output rangeOutput = Range.Output.NONE;
        public boolean identity;
        public Integer synapseId;

        public Builder setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Builder setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setBias(double bias) {
            this.bias = bias;
            return this;
        }

        public Builder setLimit(double limit) {
            this.limit = limit;
            return this;
        }

        public Builder setDistanceFunction(DistanceFunction distFunc) {
            this.distanceFunction = distFunc;
            return this;
        }

        public Builder setRangeInput(int synapseId) {
            this.rangeInput = synapseId;
            return this;
        }

        public Builder setIdentity(boolean identity) {
            this.identity = identity;
            return this;
        }

        public Builder setRangeOutput(Range.Output rangeOutput) {
            this.rangeOutput = rangeOutput;
            return this;
        }

        public Builder setRangeOutput(Range.Mapping begin, Range.Mapping end) {
            this.rangeOutput = Range.Output.create(begin, end);
            return this;
        }

        public Builder setSynapseId(int synapseId) {
            assert (synapseId >= 0);
            this.synapseId = synapseId;
            return this;
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.synapseId);
        }

        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = Synapse.createOrLookup(null, this.synapseId, this.neuron, outputNeuron);
            s.isRecurrent = this.recurrent;
            s.rangeInput = this.rangeInput;
            s.rangeOutput = this.rangeOutput;
            s.identity = this.identity;
            s.distanceFunction = this.distanceFunction;
            return s;
        }
    }
}

