/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.range.Position;

public class Candidate
implements Comparable<Candidate> {
    public SearchNode currentSearchNode;
    public SearchNode.Decision cachedDecision = SearchNode.Decision.UNKNOWN;
    public boolean repeat = false;
    public SearchNode cachedSearchNode;
    public SearchNode bestChildNode;
    public Activation activation;
    public int[] debugCounts = new int[3];
    public int[] debugDecisionCounts = new int[3];
    public int[] debugComputed = new int[3];
    public int id;
    int sequence = 0;

    public Candidate(Activation act, int id) {
        this.activation = act;
        this.id = id;
        act.candidate = this;
        this.sequence = act.getSequence();
    }

    public boolean isConflicting() {
        return !this.activation.getConflicts().isEmpty();
    }

    public boolean checkDependenciesSatisfied(long v) {
        return !this.activation.getInputLinks(false, false).anyMatch(l2 -> l2.input.markedHasCandidate != v && !l2.synapse.isRecurrent && l2.input.upperBound > 0.0);
    }

    public String toString() {
        return " ACT-ID:" + this.activation.id + " " + this.activation.range + " " + this.activation.identityToString() + " " + this.activation.getLabel() + " CID:" + this.id + " CD:" + (Object)((Object)this.cachedDecision) + " REPEAT:" + this.repeat + " CONFLICT:" + this.isConflicting() + " LIMITED:" + this.debugCounts[SearchNode.DebugState.LIMITED.ordinal()] + " CACHED:" + this.debugCounts[SearchNode.DebugState.CACHED.ordinal()] + " EXPLORE:" + this.debugCounts[SearchNode.DebugState.EXPLORE.ordinal()] + " SELECTED:" + this.debugDecisionCounts[0] + " EXCLUDED:" + this.debugDecisionCounts[1] + " SIM-CACHED:" + this.debugComputed[0] + " SIM-COMPUTED:" + this.debugComputed[1] + " MODIFIED:" + this.debugComputed[2];
    }

    @Override
    public int compareTo(Candidate c) {
        if (!this.isConflicting() && c.isConflicting()) {
            return -1;
        }
        if (this.isConflicting() && !c.isConflicting()) {
            return 1;
        }
        int r = Position.compare(this.activation.range.begin, c.activation.range.begin);
        if (r != 0) {
            return r;
        }
        r = Position.compare(this.activation.range.end, c.activation.range.end);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.sequence, c.sequence);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }
}

