/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.range;

import java.util.SortedSet;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.neuron.activation.Activation;

public class Position {
    public static final Position MIN = new Position(null, Integer.MIN_VALUE);
    public static final Position MAX = new Position(null, Integer.MAX_VALUE);
    public SortedSet<Activation> beginActivations = new TreeSet<Activation>();
    public SortedSet<Activation> endActivations = new TreeSet<Activation>();
    public Document doc;
    public final int id;
    private Integer finalPosition;
    private long visited;

    public Position(Document doc) {
        this(doc, null);
    }

    public Position(Document doc, Integer pos) {
        int n;
        this.doc = doc;
        if (doc != null) {
            int n2 = doc.positionIdCounter;
            n = n2;
            doc.positionIdCounter = n2 + 1;
        } else {
            n = -1;
        }
        this.id = n;
        this.finalPosition = pos;
    }

    public static int compare(Position a, Position b) {
        return a.compare(b);
    }

    public int compare(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return Integer.compare(this.finalPosition, pos.finalPosition);
        }
        return 0;
    }

    public String toString() {
        return this.finalPosition != null ? "" + this.finalPosition : "<" + this.id + ">";
    }

    public boolean compare(Operator o, Position pos) {
        if (o == Operator.NONE) {
            return true;
        }
        if (o == Operator.EQUALS) {
            return this == pos;
        }
        if (this.finalPosition != null && pos.finalPosition != null) {
            switch (o) {
                case LESS_THAN_EQUAL: {
                    return this.finalPosition <= pos.finalPosition;
                }
                case GREATER_THAN_EQUAL: {
                    return this.finalPosition >= pos.finalPosition;
                }
                case LESS_THAN: {
                    return this.finalPosition < pos.finalPosition;
                }
                case GREATER_THAN: {
                    return this.finalPosition > pos.finalPosition;
                }
            }
            return true;
        }
        if (this == pos) {
            return o == Operator.EQUALS || o == Operator.LESS_THAN_EQUAL || o == Operator.GREATER_THAN_EQUAL;
        }
        return this.lessThan(pos, this.doc.visitedCounter++) && o == Operator.LESS_THAN;
    }

    private boolean lessThan(Position pos, long v) {
        if (this.visited == v) {
            return false;
        }
        this.visited = v;
        if (this == pos) {
            return true;
        }
        for (Activation act : this.beginActivations) {
            Position nextPos = act.range.end;
            if (!this.lessThan(nextPos, v)) continue;
            return true;
        }
        return false;
    }

    public Integer getDistance(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return pos.finalPosition - this.finalPosition;
        }
        return null;
    }

    public Integer getFinalPosition() {
        return this.finalPosition;
    }

    public void setFinalPosition(int finalPos) {
        this.finalPosition = finalPos;
    }

    public void addBeginActivation(Activation act) {
        this.beginActivations.add(act);
    }

    public void addEndActivations(Activation act) {
        this.endActivations.add(act);
    }

    public static enum Operator {
        EQUALS(0),
        LESS_THAN_EQUAL(1),
        GREATER_THAN_EQUAL(2),
        LESS_THAN(3),
        GREATER_THAN(4),
        NONE(5);

        int id;

        private Operator(int id) {
            this.id = (short)id;
        }

        public static Operator getById(int id) {
            for (Operator o : Operator.values()) {
                if (o.id != id) continue;
                return o;
            }
            return null;
        }

        public boolean isGreaterThanOrGreaterThanEqual() {
            return this == GREATER_THAN || this == GREATER_THAN_EQUAL;
        }

        public boolean isLessThanOrLessThanEqual() {
            return this == LESS_THAN || this == LESS_THAN_EQUAL;
        }

        public boolean includesEqual() {
            return this == EQUALS || this == GREATER_THAN_EQUAL || this == LESS_THAN_EQUAL;
        }

        public int getId() {
            return this.id;
        }

        public Operator invert() {
            switch (this) {
                case EQUALS: {
                    return EQUALS;
                }
                case LESS_THAN_EQUAL: {
                    return GREATER_THAN_EQUAL;
                }
                case GREATER_THAN_EQUAL: {
                    return LESS_THAN_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
            }
            return NONE;
        }
    }
}

