/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.range;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import network.aika.Document;
import network.aika.Model;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.neuron.range.Position;

public class Range {
    public static Comparator<Range> BEGIN_COMP = (r1, r2) -> {
        int r = Position.compare(r1.begin, r2.begin);
        if (r != 0) {
            return r;
        }
        return Position.compare(r1.end, r2.end);
    };
    public static Comparator<Range> END_COMP = (r1, r2) -> {
        int r = Position.compare(r1.end, r2.end);
        if (r != 0) {
            return r;
        }
        return Position.compare(r1.begin, r2.begin);
    };
    public final Position begin;
    public final Position end;

    public Range(Document doc, Integer begin, Integer end) {
        this(doc.lookupFinalPosition(begin), doc.lookupFinalPosition(end));
    }

    public Range(Position begin, Position end) {
        this.begin = begin;
        this.end = end;
    }

    public Position getBegin(boolean invert) {
        return invert ? this.end : this.begin;
    }

    public Position getEnd(boolean invert) {
        return invert ? this.begin : this.end;
    }

    public Range invert(boolean inv) {
        return inv ? new Range(this.end, this.begin) : this;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public Integer length() {
        if (this.begin == null || this.end == null) {
            return Integer.MAX_VALUE;
        }
        return this.begin.getDistance(this.end);
    }

    public boolean equals(Range r) {
        return this.begin.compare(Position.Operator.EQUALS, r.begin) && this.end.compare(Position.Operator.EQUALS, r.end);
    }

    public boolean equalsIgnoreNull(Range r) {
        if (this.begin != null && r.begin != null && !this.begin.compare(Position.Operator.EQUALS, r.begin)) {
            return false;
        }
        return this.end == null || r.end == null || this.end.compare(Position.Operator.EQUALS, r.end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.begin);
        sb.append(",");
        sb.append(this.end);
        sb.append(")");
        return sb.toString();
    }

    public static int compare(Range ra, Range rb, boolean inv) {
        int a = Position.compare(ra.getBegin(inv), rb.getBegin(inv));
        if (a != 0) {
            return a;
        }
        int b = Position.compare(ra.getEnd(inv), rb.getEnd(inv));
        return b;
    }

    public static int compare(Range ra, Range rb) {
        int a = Position.compare(ra.begin, rb.begin);
        if (a != 0) {
            return a;
        }
        int b = Position.compare(ra.end, rb.end);
        return b;
    }

    public static enum Mapping {
        BEGIN(0),
        END(1),
        NONE(2);

        int id;

        private Mapping(int id) {
            this.id = id;
        }

        public static Mapping getById(int id) {
            for (Mapping m : Mapping.values()) {
                if (m.id != id) continue;
                return m;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public Position map(Range r) {
            switch (this) {
                case BEGIN: {
                    return r.begin;
                }
                case END: {
                    return r.end;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case BEGIN: {
                    return "S";
                }
                case END: {
                    return "E";
                }
                case NONE: {
                    return "N";
                }
            }
            return "";
        }
    }

    public static class Output
    implements Writable,
    Comparable<Output> {
        private static SortedMap<Output, Output> map = new TreeMap<Output, Output>();
        public static Output NONE = Output.create(Mapping.NONE, Mapping.NONE);
        public static Output DIRECT = Output.create(Mapping.BEGIN, Mapping.END);
        public static Output BEGIN = Output.create(Mapping.BEGIN, Mapping.NONE);
        public static Output END = Output.create(Mapping.NONE, Mapping.END);
        public Mapping begin = Mapping.NONE;
        public Mapping end = Mapping.NONE;

        private Output() {
        }

        private Output(Mapping begin, Mapping end) {
            this.begin = begin;
            this.end = end;
        }

        public Range map(Range r) {
            return new Range(this.begin.map(r), this.end.map(r));
        }

        public Output invert() {
            return new Output(this.begin == Mapping.BEGIN ? Mapping.BEGIN : (this.end == Mapping.BEGIN ? Mapping.END : Mapping.NONE), this.begin == Mapping.END ? Mapping.BEGIN : (this.end == Mapping.END ? Mapping.END : Mapping.NONE));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("O(");
            sb.append(this.begin.name());
            sb.append(",");
            sb.append(this.end.name());
            sb.append(")");
            return sb.toString();
        }

        public static Output create(Mapping begin, Mapping end) {
            return Output.lookup(new Output(begin, end));
        }

        public static Output lookup(Output r) {
            Output rr = (Output)map.get(r);
            if (rr == null) {
                rr = r;
                map.put(r, r);
            }
            return rr;
        }

        @Override
        public int compareTo(Output ro) {
            int r = Utils.compareInteger(this.begin.ordinal(), ro.begin.ordinal());
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.end.ordinal(), ro.end.ordinal());
            return r;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.begin.getId());
            out.writeByte(this.end.getId());
        }

        public static Output read(DataInput in, Model m) throws IOException {
            Output r = new Output();
            r.readFields(in, m);
            return Output.lookup(r);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.begin = Mapping.getById(in.readByte());
            this.end = Mapping.getById(in.readByte());
        }
    }

    public static class Relation
    implements Writable,
    Comparable<Relation> {
        private static SortedMap<Relation, Relation> map = new TreeMap<Relation, Relation>();
        public static Relation EQUALS = Relation.create(Position.Operator.EQUALS, Position.Operator.EQUALS);
        public static Relation BEGIN_EQUALS = Relation.create(Position.Operator.EQUALS, Position.Operator.NONE);
        public static Relation END_EQUALS = Relation.create(Position.Operator.NONE, Position.Operator.EQUALS);
        public static Relation BEGIN_TO_END_EQUALS = Relation.create(Position.Operator.NONE, Position.Operator.EQUALS, Position.Operator.NONE, Position.Operator.NONE);
        public static Relation END_TO_BEGIN_EQUALS = Relation.create(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.EQUALS);
        public static Relation CONTAINS = Relation.create(Position.Operator.LESS_THAN_EQUAL, Position.Operator.GREATER_THAN_EQUAL);
        public static Relation CONTAINED_IN = Relation.create(Position.Operator.GREATER_THAN_EQUAL, Position.Operator.LESS_THAN_EQUAL);
        public static Relation OVERLAPS = Relation.create(Position.Operator.NONE, Position.Operator.LESS_THAN, Position.Operator.NONE, Position.Operator.GREATER_THAN);
        public static Relation NONE = Relation.create(Position.Operator.NONE, Position.Operator.NONE);
        public static Relation BETWEEN = Relation.create(Position.Operator.GREATER_THAN, Position.Operator.LESS_THAN);
        public static Relation BEFORE = Relation.create(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.LESS_THAN_EQUAL);
        public static Relation AFTER = Relation.create(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.GREATER_THAN_EQUAL);
        public Position.Operator beginToBegin = Position.Operator.NONE;
        public Position.Operator beginToEnd = Position.Operator.NONE;
        public Position.Operator endToEnd = Position.Operator.NONE;
        public Position.Operator endToBegin = Position.Operator.NONE;

        public Relation() {
        }

        private Relation(Position.Operator beginToBegin, Position.Operator beginToEnd, Position.Operator endToEnd, Position.Operator endToBegin) {
            this.beginToBegin = beginToBegin;
            this.beginToEnd = beginToEnd;
            this.endToEnd = endToEnd;
            this.endToBegin = endToBegin;
        }

        public static Relation create(Position.Operator beginToBegin, Position.Operator beginToEnd, Position.Operator endToEnd, Position.Operator endToBegin) {
            return Relation.lookup(new Relation(beginToBegin, beginToEnd, endToEnd, endToBegin));
        }

        public static Relation create(Position.Operator beginToBegin, Position.Operator endToEnd) {
            return Relation.create(beginToBegin, Position.Operator.NONE, endToEnd, Position.Operator.NONE);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BB:" + this.beginToBegin.name() + ",");
            sb.append("BE:" + this.beginToEnd.name() + ",");
            sb.append("EB:" + this.endToBegin.name() + ",");
            sb.append("EE:" + this.endToEnd.name());
            return sb.toString();
        }

        public boolean compare(Range ra, Range rb) {
            return ra.begin.compare(this.beginToBegin, rb.begin) && ra.begin.compare(this.beginToEnd, rb.end) && ra.end.compare(this.endToEnd, rb.end) && ra.end.compare(this.endToBegin, rb.begin);
        }

        public Relation invert() {
            return new Relation(this.beginToBegin.invert(), this.endToBegin.invert(), this.endToEnd.invert(), this.beginToEnd.invert());
        }

        @Override
        public int compareTo(Relation rr) {
            int r = this.beginToBegin.compareTo(rr.beginToBegin);
            if (r != 0) {
                return r;
            }
            r = this.beginToEnd.compareTo(rr.beginToEnd);
            if (r != 0) {
                return r;
            }
            r = this.endToEnd.compareTo(rr.endToEnd);
            if (r != 0) {
                return r;
            }
            r = this.endToBegin.compareTo(rr.endToBegin);
            return r;
        }

        public static Relation lookup(Relation r) {
            Relation rr = (Relation)map.get(r);
            if (rr == null) {
                rr = r;
                map.put(r, r);
            }
            return rr;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.beginToBegin.getId());
            out.writeByte(this.beginToEnd.getId());
            out.writeByte(this.endToEnd.getId());
            out.writeByte(this.endToBegin.getId());
        }

        public static Relation read(DataInput in, Model m) throws IOException {
            Relation r = new Relation();
            r.readFields(in, m);
            return Relation.lookup(r);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.beginToBegin = Position.Operator.getById(in.readByte());
            this.beginToEnd = Position.Operator.getById(in.readByte());
            this.endToEnd = Position.Operator.getById(in.readByte());
            this.endToBegin = Position.Operator.getById(in.readByte());
        }
    }
}

