/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;

public class AncestorRelation
extends Relation {
    public Type type;

    AncestorRelation() {
    }

    public AncestorRelation(Type type) {
        this.type = type;
    }

    @Override
    public Collection<Activation> getActivations(INeuron n, Activation linkedAct) {
        ArrayList<Activation> results = new ArrayList<Activation>();
        switch (this.type) {
            case COMMON_ANCESTOR: {
                this.collectCommonAncestor(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            }
            case IS_DESCENDANT_OF: {
                this.collectContains(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            }
            case IS_ANCESTOR_OF: {
                this.collectContainedIn(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            }
        }
        return results;
    }

    private void collectCommonAncestor(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        this.collectContains(results, n, linkedAct, v);
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectCommonAncestor(results, n, l2.input, v));
    }

    private void collectContains(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getOutputLinks(false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectContains(results, n, l2.output, v));
    }

    private void collectContainedIn(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectContainedIn(results, n, l2.input, v));
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        switch (this.type) {
            case COMMON_ANCESTOR: {
                return AncestorRelation.hasCommonAncestor(act, linkedAct);
            }
            case IS_DESCENDANT_OF: {
                return AncestorRelation.contains(act, linkedAct, act.doc.visitedCounter++);
            }
            case IS_ANCESTOR_OF: {
                return AncestorRelation.contains(linkedAct, act, act.doc.visitedCounter++);
            }
        }
        return true;
    }

    @Override
    public Relation invert() {
        switch (this.type) {
            case COMMON_ANCESTOR: {
                return this;
            }
            case IS_DESCENDANT_OF: {
                return new AncestorRelation(Type.IS_ANCESTOR_OF);
            }
            case IS_ANCESTOR_OF: {
                return new AncestorRelation(Type.IS_DESCENDANT_OF);
            }
        }
        return null;
    }

    private static boolean contains(Activation actA, Activation actB, long v) {
        if (actA.visited == v) {
            return false;
        }
        actA.visited = v;
        if (actA == actB) {
            return true;
        }
        return actA.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l2 -> AncestorRelation.contains(l2.input, actB, v));
    }

    private static boolean hasCommonAncestor(Activation act, Activation linkedAct) {
        long v = act.doc.visitedCounter++;
        AncestorRelation.markAncestors(linkedAct, v);
        return AncestorRelation.hasCommonAncestor(act, v, act.doc.visitedCounter++);
    }

    private static void markAncestors(Activation act, long v) {
        if (act.visited == v) {
            return;
        }
        act.visited = v;
        act.markedAncestor = v;
        act.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.markAncestors(l2.input, v));
    }

    private static boolean hasCommonAncestor(Activation act, long v1, long v2) {
        if (act.visited == v2) {
            return false;
        }
        act.visited = v2;
        if (act.markedAncestor == v1) {
            return true;
        }
        return act.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l3 -> AncestorRelation.hasCommonAncestor(l3.input, v1, v2));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeUTF(this.type.name());
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.type = Type.valueOf(in.readUTF());
    }

    public static AncestorRelation read(DataInput in, Model m) throws IOException {
        AncestorRelation ir = new AncestorRelation();
        ir.readFields(in, m);
        return ir;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public int getRelationType() {
        return 1;
    }

    @Override
    public int compareTo(Relation rel) {
        AncestorRelation ir = (AncestorRelation)rel;
        return this.type.compareTo(ir.type);
    }

    public static enum Type {
        COMMON_ANCESTOR,
        IS_DESCENDANT_OF,
        IS_ANCESTOR_OF;

    }
}

