/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import network.aika.Document;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.range.Position;
import network.aika.neuron.range.Range;
import network.aika.neuron.relation.Relation;

public class RangeRelation
extends Relation {
    public Range.Relation relation;

    RangeRelation() {
    }

    public RangeRelation(Range.Relation relation) {
        this.relation = relation;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        return this.relation.compare(act.range, linkedAct.range);
    }

    public String toString() {
        return "RR(" + this.relation + ")";
    }

    @Override
    public Relation invert() {
        return new RangeRelation(this.relation.invert());
    }

    @Override
    public int getRelationType() {
        return 0;
    }

    @Override
    public int compareTo(Relation rel) {
        RangeRelation rr = (RangeRelation)rel;
        return this.relation.compareTo(rr.relation);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        this.relation.write(out);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.relation = Range.Relation.read(in, m);
    }

    public static RangeRelation read(DataInput in, Model m) throws IOException {
        RangeRelation rr = new RangeRelation();
        rr.readFields(in, m);
        return rr;
    }

    @Override
    public boolean isExact() {
        return this.relation.beginToBegin == Position.Operator.EQUALS || this.relation.beginToEnd == Position.Operator.EQUALS || this.relation.endToBegin == Position.Operator.EQUALS || this.relation.endToEnd == Position.Operator.EQUALS;
    }

    @Override
    public Collection<Activation> getActivations(INeuron n, Activation linkedAct) {
        INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
        if (th == null || th.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Range r = linkedAct.range;
        Collection<Activation> results = this.isExact() ? RangeRelation.getActivationsByRangeEquals(th, r, this.relation) : ((this.relation.beginToBegin.isGreaterThanOrGreaterThanEqual() || this.relation.beginToEnd.isGreaterThanOrGreaterThanEqual()) && r.begin.compare(Position.Operator.LESS_THAN_EQUAL, r.end) ? RangeRelation.getActivationsByRangeBeginGreaterThan(th, r, this.relation) : ((this.relation.endToEnd.isGreaterThanOrGreaterThanEqual() || this.relation.endToBegin.isGreaterThanOrGreaterThanEqual()) && r.begin.compare(Position.Operator.GREATER_THAN_EQUAL, r.end) ? RangeRelation.getActivationsByRangeEndGreaterThan(th, r, this.relation) : ((this.relation.beginToBegin.isLessThanOrLessThanEqual() || this.relation.beginToEnd.isLessThanOrLessThanEqual()) && r.begin.compare(Position.Operator.LESS_THAN_EQUAL, r.end) ? RangeRelation.getActivationsByRangeBeginLessThanEqual(th, r, this.relation) : ((this.relation.endToEnd.isLessThanOrLessThanEqual() || this.relation.endToBegin.isLessThanOrLessThanEqual()) && r.begin.compare(Position.Operator.GREATER_THAN_EQUAL, r.end) ? RangeRelation.getActivationsByRangeEndLessThanEqual(th, r, this.relation) : th.getActivations()))));
        return results.stream().filter(act -> this.test((Activation)act, linkedAct)).collect(Collectors.toList());
    }

    private static Collection<Activation> getActivationsByRangeBeginGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        Position toKey;
        boolean fromInclusive;
        Position fromKey;
        if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = r.end;
            fromInclusive = rr.beginToEnd.includesEqual();
        }
        if (rr.endToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = Position.MAX;
            toInclusive = true;
        }
        return th.getActivationsByRangeBegin(fromKey, fromInclusive, toKey, toInclusive);
    }

    private static Collection<Activation> getActivationsByRangeEndGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        Position toKey;
        boolean fromInclusive;
        Position fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end;
            fromInclusive = rr.endToEnd.includesEqual();
        } else {
            fromKey = r.begin;
            fromInclusive = rr.endToBegin.includesEqual();
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else if (rr.beginToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        } else {
            toKey = Position.MAX;
            toInclusive = true;
        }
        return th.getActivationsByRangeEnd(fromKey, fromInclusive, toKey, toInclusive);
    }

    private static Collection<Activation> getActivationsByRangeBeginLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        Position toKey;
        boolean fromInclusive;
        Position fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end;
            fromInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin;
            fromInclusive = rr.endToBegin.includesEqual();
        } else {
            fromKey = Position.MIN;
            fromInclusive = true;
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        }
        return th.getActivationsByRangeBeginLimited(fromKey, fromInclusive, toKey, toInclusive);
    }

    private static Collection<Activation> getActivationsByRangeEndLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        Position toKey;
        boolean fromInclusive;
        Position fromKey;
        if (rr.beginToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end;
            fromInclusive = rr.beginToEnd.includesEqual();
        } else if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = Position.MIN;
            fromInclusive = true;
        }
        if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        }
        return th.getActivationsByRangeEndLimited(fromKey, fromInclusive, toKey, toInclusive);
    }

    public static Collection<Activation> getActivationsByRangeEquals(INeuron.ThreadState th, Range r, Range.Relation rr) {
        if (rr.beginToBegin == Position.Operator.EQUALS || rr.beginToEnd == Position.Operator.EQUALS) {
            Position key = rr.beginToBegin == Position.Operator.EQUALS ? r.begin : r.end;
            return th.getActivationsByRangeBegin(key, true, key, true);
        }
        if (rr.endToEnd == Position.Operator.EQUALS || rr.endToBegin == Position.Operator.EQUALS) {
            Position key = rr.endToEnd == Position.Operator.EQUALS ? r.end : r.begin;
            return th.getActivationsByRangeEnd(key, true, key, true);
        }
        throw new RuntimeException("Invalid Range Relation");
    }

    public static Collection<Activation> getActivationsByRangeEquals(Document doc, Range r, Range.Relation rr) {
        if (rr.beginToBegin == Position.Operator.EQUALS || rr.beginToEnd == Position.Operator.EQUALS) {
            Position key = rr.beginToBegin == Position.Operator.EQUALS ? r.begin : r.end;
            return doc.getActivationsByRangeBegin(new Range(key, Position.MIN), true, new Range(key, Position.MAX), true);
        }
        if (rr.endToEnd == Position.Operator.EQUALS || rr.endToBegin == Position.Operator.EQUALS) {
            Position key = rr.endToEnd == Position.Operator.EQUALS ? r.end : r.begin;
            return doc.getActivationByRangeEnd(new Range(Position.MIN, key), true, new Range(Position.MAX, key), true);
        }
        throw new RuntimeException("Invalid Range Relation");
    }
}

