/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.range.Range;
import network.aika.neuron.relation.AncestorRelation;
import network.aika.neuron.relation.RangeRelation;

public abstract class Relation
implements Comparable<Relation>,
Writable {
    public static Comparator<Relation> COMPARATOR = (r1, r2) -> {
        int r = Integer.compare(r1.getRelationType(), r2.getRelationType());
        if (r != 0) {
            return r;
        }
        return r1.compareTo(r2);
    };

    public abstract int getRelationType();

    public abstract boolean test(Activation var1, Activation var2);

    public abstract Relation invert();

    public static Relation read(DataInput in, Model m) throws IOException {
        if (in.readBoolean()) {
            return AncestorRelation.read(in, m);
        }
        return RangeRelation.read(in, m);
    }

    public abstract boolean isExact();

    public abstract Collection<Activation> getActivations(INeuron var1, Activation var2);

    public boolean follow(Activation rAct, Activation oAct, Map<Integer, Set<Relation>> relations) {
        return true;
    }

    public static void addRelation(Map<Integer, Set<Relation>> relMap, Integer synId, Relation r) {
        Set<Relation> relSet = relMap.get(synId);
        if (relSet == null) {
            relSet = new TreeSet<Relation>(COMPARATOR);
            relMap.put(synId, relSet);
        }
        relSet.add(r);
    }

    public static Map<Integer, Set<Relation>> getRelationsMap(int synapseId, Neuron n) {
        if (synapseId == -1) {
            INeuron in = (INeuron)n.get();
            if (in.outputRelations == null) {
                in.outputRelations = new TreeMap<Integer, Set<Relation>>();
            }
            return in.outputRelations;
        }
        Synapse s = n.getSynapseById(synapseId);
        return s.relations;
    }

    public static class Builder
    implements Neuron.Builder {
        private int from;
        private int to;
        private Relation relation;

        public Builder setFrom(int synapseId) {
            assert (synapseId >= -1);
            this.from = synapseId;
            return this;
        }

        public Builder setTo(int synapseId) {
            assert (synapseId >= -1);
            this.to = synapseId;
            return this;
        }

        public Builder setAncestorRelation(AncestorRelation.Type type) {
            this.relation = new AncestorRelation(type);
            return this;
        }

        public Builder setRangeRelation(Range.Relation rr) {
            this.relation = new RangeRelation(rr);
            return this;
        }

        public Builder setRelation(Relation rel) {
            this.relation = rel;
            return this;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void connect(Neuron n) {
            Map<Integer, Set<Relation>> fromRel = Relation.getRelationsMap(this.from, n);
            Map<Integer, Set<Relation>> toRel = Relation.getRelationsMap(this.to, n);
            Relation r = this.getRelation();
            Relation.addRelation(fromRel, this.to, r);
            Relation.addRelation(toRel, this.from, r.invert());
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.from);
            n.registerSynapseId(this.to);
        }
    }
}

