/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.relation.Relation;

public class Converter {
    public static int MAX_AND_NODE_SIZE = 6;
    public static Comparator<Synapse> SYNAPSE_COMP = (s1, s2) -> {
        int r = Boolean.compare(s2.linksAnyOutput() || s2.identity, s1.linksAnyOutput() || s1.identity);
        if (r != 0) {
            return r;
        }
        r = Double.compare(s2.weight, s1.weight);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    private int threadId;
    private INeuron neuron;
    private Document doc;
    private OrNode outputNode;
    private Collection<Synapse> modifiedSynapses;
    public static final int DIRECT = 0;
    public static final int RECURRENT = 1;
    public static final int POSITIVE = 0;
    public static final int NEGATIVE = 1;

    public static boolean convert(int threadId, Document doc, INeuron neuron, Collection<Synapse> modifiedSynapses) {
        return new Converter(threadId, doc, neuron, modifiedSynapses).convert();
    }

    private Converter(int threadId, Document doc, INeuron neuron, Collection<Synapse> modifiedSynapses) {
        this.doc = doc;
        this.neuron = neuron;
        this.threadId = threadId;
        this.modifiedSynapses = modifiedSynapses;
    }

    private boolean convert() {
        this.outputNode = this.neuron.node.get();
        this.initInputNodesAndComputeWeightSums();
        this.initSlotFlags();
        if (this.neuron.biasSum + this.neuron.posDirSum + this.neuron.posRecSum <= 0.0) {
            this.neuron.requiredSum = this.neuron.posDirSum + this.neuron.posRecSum;
            this.outputNode.removeParents(this.threadId);
            return false;
        }
        List<Synapse> candidates = this.prepareCandidates();
        NodeContext nodeContext = null;
        boolean noFurtherRefinement = false;
        TreeSet<Synapse> reqSyns = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
        double sum = 0.0;
        this.neuron.requiredSum = 0.0;
        if (this.neuron.numDisjunctiveSynapses == 0) {
            double v;
            double remainingSum = this.neuron.posDirSum;
            int i = 0;
            for (Synapse s : candidates) {
                boolean maxAndNodesReached;
                v = s.getMaxInputValue();
                boolean isOptionalInput = sum + remainingSum - v + this.neuron.posRecSum + this.neuron.posPassiveSum + this.neuron.biasSum > 0.0;
                boolean bl = maxAndNodesReached = i >= MAX_AND_NODE_SIZE;
                if (isOptionalInput || maxAndNodesReached) break;
                remainingSum -= v;
                this.neuron.requiredSum += v;
                reqSyns.add(s);
                NodeContext nlNodeContext = this.expandNode(nodeContext, s);
                if (nlNodeContext == null) break;
                nodeContext = nlNodeContext;
                ++i;
                boolean sumOfSynapseWeightsAboveThreshold = (sum += v) + this.neuron.posRecSum + this.neuron.posPassiveSum + this.neuron.biasSum > 0.0;
                if (!sumOfSynapseWeightsAboveThreshold) continue;
                noFurtherRefinement = true;
                break;
            }
            this.outputNode.removeParents(this.threadId);
            if (noFurtherRefinement || i == MAX_AND_NODE_SIZE) {
                this.outputNode.addInput(nodeContext.getSynapseIds(), this.threadId, nodeContext.node, true);
            } else {
                for (Synapse s : candidates) {
                    boolean belowThreshold;
                    v = s.getMaxInputValue();
                    boolean bl = belowThreshold = sum + v + remainingSum + this.neuron.posRecSum + this.neuron.posPassiveSum + this.neuron.biasSum <= 0.0;
                    if (!belowThreshold) {
                        NodeContext nlNodeContext;
                        if (reqSyns.contains(s) || (nlNodeContext = this.expandNode(nodeContext, s)) == null) continue;
                        this.outputNode.addInput(nlNodeContext.getSynapseIds(), this.threadId, nlNodeContext.node, true);
                        remainingSum -= v;
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (Synapse s : this.modifiedSynapses) {
                if (!s.isDisjunction || s.isRecurrent) continue;
                NodeContext nlNodeContext = this.expandNode(nodeContext, s);
                this.outputNode.addInput(nlNodeContext.getSynapseIds(), this.threadId, nlNodeContext.node, false);
            }
        }
        return true;
    }

    private void initSlotFlags() {
        this.modifiedSynapses.forEach(s -> {
            for (Integer slot : s.linksOutput()) {
                this.neuron.slotHasInputs.add(slot);
            }
            for (Relation rel : s.relations.values()) {
                rel.registerRequiredSlots(s.input);
            }
        });
    }

    private List<Synapse> prepareCandidates() {
        Synapse syn = this.getBestSynapse(this.neuron.inputSynapses.values());
        TreeSet<Integer> alreadyCollected = new TreeSet<Integer>();
        ArrayList<Synapse> selectedCandidates = new ArrayList<Synapse>();
        TreeMap<Integer, Synapse> relatedSyns = new TreeMap<Integer, Synapse>();
        while (syn != null && selectedCandidates.size() < MAX_AND_NODE_SIZE) {
            relatedSyns.remove(syn.id);
            selectedCandidates.add(syn);
            alreadyCollected.add(syn.id);
            for (Integer relId : syn.relations.keySet()) {
                Synapse rs;
                if (alreadyCollected.contains(relId) || (rs = syn.output.getSynapseById(relId)) == null) continue;
                relatedSyns.put(relId, rs);
            }
            syn = this.getBestSynapse(relatedSyns.values());
        }
        return selectedCandidates;
    }

    private Synapse getBestSynapse(Collection<Synapse> synapses) {
        Synapse maxSyn = null;
        for (Synapse s : synapses) {
            if (s.isNegative() || s.isRecurrent || s.inactive || ((INeuron)s.input.get()).isPassiveInputNeuron() || maxSyn != null && SYNAPSE_COMP.compare(maxSyn, s) <= 0) continue;
            maxSyn = s;
        }
        return maxSyn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInputNodesAndComputeWeightSums() {
        double[][] sumDelta = new double[2][2];
        double posPassiveSumDelta = 0.0;
        for (Synapse s : this.modifiedSynapses) {
            if (s.toBeDeleted) {
                s.update(this.doc, -s.weight, 0.0, s.limit);
            }
            INeuron in = (INeuron)s.input.get();
            in.lock.acquireWriteLock();
            try {
                if (!s.inactive) {
                    double[] dArray = sumDelta[s.isRecurrent ? 1 : 0];
                    int n = s.isNegative() ? 1 : 0;
                    dArray[n] = dArray[n] - s.limit * s.weight;
                    double[] dArray2 = sumDelta[s.isRecurrent ? 1 : 0];
                    int n2 = s.getNewWeight() <= 0.0 ? 1 : 0;
                    dArray2[n2] = dArray2[n2] + (s.limit + s.limitDelta) * s.getNewWeight();
                    if (in.isPassiveInputNeuron() && !s.isNegative()) {
                        posPassiveSumDelta -= !s.isNegative() ? s.limit * s.weight : 0.0;
                        posPassiveSumDelta += s.getNewWeight() > 0.0 ? (s.limit + s.limitDelta) * s.getNewWeight() : 0.0;
                    }
                    if (!s.isRecurrent) {
                        if (!s.isDisjunction(Synapse.State.OLD) && s.isDisjunction(Synapse.State.NEW)) {
                            ++this.neuron.numDisjunctiveSynapses;
                        } else if (s.isDisjunction(Synapse.State.OLD) && !s.isDisjunction(Synapse.State.NEW)) {
                            --this.neuron.numDisjunctiveSynapses;
                        }
                    }
                }
                s.weight += s.weightDelta;
                s.weightDelta = 0.0;
                s.bias += s.biasDelta;
                s.biasDelta = 0.0;
                s.limit += s.limitDelta;
                s.limitDelta = 0.0;
                if (this.doc != null) {
                    s.committedInDoc = this.doc.id;
                }
            }
            finally {
                in.lock.releaseWriteLock();
            }
            if (!s.toBeDeleted) continue;
            s.unlink();
        }
        this.neuron.bias += this.neuron.biasDelta;
        this.neuron.biasDelta = 0.0;
        this.neuron.biasSum += this.neuron.biasSumDelta;
        this.neuron.biasSumDelta = 0.0;
        assert (Double.isFinite(this.neuron.biasSum));
        this.neuron.posDirSum += sumDelta[0][0];
        this.neuron.negDirSum += sumDelta[0][1];
        this.neuron.negRecSum += sumDelta[1][1];
        this.neuron.posRecSum += sumDelta[1][0];
        this.neuron.posPassiveSum += posPassiveSumDelta;
        this.neuron.setModified();
    }

    private NodeContext expandNode(NodeContext nc, Synapse s) {
        int i;
        if (nc == null) {
            NodeContext nln = new NodeContext();
            nln.node = ((INeuron)s.input.get()).outputNode.get();
            nln.offsets = new Synapse[]{s};
            return nln;
        }
        Relation[] relations = new Relation[nc.offsets.length];
        for (int i2 = 0; i2 < nc.offsets.length; ++i2) {
            Synapse linkedSynapse = nc.offsets[i2];
            relations[i2] = s.getRelationById(linkedSynapse.id);
        }
        NodeContext nln = new NodeContext();
        nln.offsets = new Synapse[nc.offsets.length + 1];
        AndNode.Refinement ref = new AndNode.Refinement(new AndNode.RelationsMap(relations), ((INeuron)s.input.get()).outputNode);
        AndNode.RefValue rv = nc.node.extend(this.threadId, this.doc, ref, null);
        if (rv == null) {
            return null;
        }
        nln.node = rv.child.get(this.doc);
        for (i = 0; i < nc.offsets.length; ++i) {
            nln.offsets[rv.offsets[i].intValue()] = nc.offsets[i];
        }
        for (i = 0; i < nln.offsets.length; ++i) {
            if (nln.offsets[i] != null) continue;
            nln.offsets[i] = s;
        }
        return nln;
    }

    private class NodeContext {
        Node node;
        Synapse[] offsets;

        private NodeContext() {
        }

        int[] getSynapseIds() {
            int[] result = new int[this.offsets.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.offsets[i].id;
            }
            return result;
        }
    }
}

