/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import network.aika.Document;
import network.aika.Model;
import network.aika.PatternDiscovery;
import network.aika.Provider;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class InputNode
extends Node<InputNode, InputActivation> {
    public Neuron inputNeuron;
    public TreeMap<AndNode.Refinement, AndNode.RefValue> nonExactAndChildren;
    private long visitedDiscover;
    public static final Relation[] CANDIDATE_RELATIONS = new Relation[0];

    public InputNode() {
    }

    public InputNode(Model m) {
        super(m, 1);
    }

    public static InputNode add(Model m, INeuron input) {
        if (input.outputNode != null) {
            return input.outputNode.get();
        }
        InputNode in = new InputNode(m);
        if (input != null && in.inputNeuron == null) {
            in.inputNeuron = (Neuron)input.provider;
            input.outputNode = in.provider;
            input.setModified();
        }
        return in;
    }

    @Override
    public void addActivation(Activation inputAct) {
        if (inputAct.repropagateV != null && inputAct.repropagateV != this.markedCreated) {
            return;
        }
        InputActivation act = new InputActivation(inputAct.doc.logicNodeActivationIdCounter++, inputAct, this);
        this.addActivation(act);
    }

    @Override
    public void propagate(InputActivation act) {
        this.apply(act);
    }

    @Override
    public void reprocessInputs(Document doc) {
        ((INeuron)this.inputNeuron.get(doc)).getActivations(doc, false).forEach(act -> {
            act.repropagateV = this.markedCreated;
            if (act.upperBound > 0.0) {
                act.getINeuron().propagate((Activation)act);
            }
        });
    }

    @Override
    void addAndChild(AndNode.Refinement ref, AndNode.RefValue child) {
        super.addAndChild(ref, child);
        if (!ref.relations.isExact()) {
            if (this.nonExactAndChildren == null) {
                this.nonExactAndChildren = new TreeMap();
            }
            AndNode.RefValue n = this.nonExactAndChildren.put(ref, child);
            assert (n == null);
        }
    }

    @Override
    void removeAndChild(AndNode.Refinement ref) {
        super.removeAndChild(ref);
        if (!ref.relations.isExact() && this.nonExactAndChildren != null) {
            this.nonExactAndChildren.remove(ref);
            if (this.nonExactAndChildren.isEmpty()) {
                this.nonExactAndChildren = null;
            }
        }
    }

    @Override
    public AndNode.RefValue extend(int threadId, Document doc, AndNode.Refinement ref, PatternDiscovery.Config patterDiscoveryConfig) {
        if (ref.relations.size() == 0) {
            return null;
        }
        Relation rel = ref.relations.get(0);
        if (rel == null) {
            return null;
        }
        AndNode.RefValue rv = this.getAndChild(ref);
        if (rv != null) {
            return rv;
        }
        ArrayList<AndNode.Entry> nlParents = new ArrayList<AndNode.Entry>();
        AndNode.Refinement mirrorRef = new AndNode.Refinement(new AndNode.RelationsMap(new Relation[]{rel.invert()}), this.provider);
        nlParents.add(new AndNode.Entry(mirrorRef, new AndNode.RefValue(new Integer[]{1}, 0, ref.input)));
        rv = new AndNode.RefValue(new Integer[]{0}, 1, this.provider);
        nlParents.add(new AndNode.Entry(ref, rv));
        return AndNode.createAndNode(this.provider.model, doc, nlParents, this.level + 1, patterDiscoveryConfig) ? rv : null;
    }

    @Override
    void apply(InputActivation act) {
        try {
            this.lock.acquireReadLock();
            if (this.andChildren != null) {
                TreeMap children;
                if (this.andChildren.size() > 10) {
                    children = this.nonExactAndChildren;
                    this.applyExactRelations(act);
                } else {
                    children = this.andChildren;
                }
                if (children != null) {
                    children.forEach((ref, rv) -> {
                        InputNode in = ref.input.getIfNotSuspended();
                        if (in != null) {
                            InputNode.addNextLevelActivations(in, ref, rv.child.get(inputActivation.doc), act);
                        }
                    });
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        OrNode.processCandidate(this, act, false);
    }

    private void applyExactRelations(InputActivation act) {
        Activation iAct = act.input.input;
        for (Map.Entry<Integer, Position> me : iAct.slots.entrySet()) {
            for (Activation linkedAct : act.doc.getActivationsByPosition(me.getValue(), true, me.getValue(), true)) {
                Provider<InputNode> in = linkedAct.getINeuron().outputNode;
                for (Map.Entry mea : this.andChildren.subMap(new AndNode.Refinement(AndNode.RelationsMap.MIN, in), new AndNode.Refinement(AndNode.RelationsMap.MAX, in)).entrySet()) {
                    InputNode.addNextLevelActivations(in.get(act.doc), mea.getKey(), ((AndNode.RefValue)mea.getValue()).child.get(act.doc), act);
                }
            }
        }
    }

    private static void addNextLevelActivations(InputNode secondNode, AndNode.Refinement ref, AndNode nln, InputActivation act) {
        Document doc = act.doc;
        INeuron.ThreadState th = ((INeuron)secondNode.inputNeuron.get()).getThreadState(doc.threadId, false);
        if (th == null || th.isEmpty()) {
            return;
        }
        Activation iAct = act.input.input;
        if (act.repropagateV != null && act.repropagateV != nln.markedCreated) {
            return;
        }
        ref.relations.get(0).getActivations((INeuron)secondNode.inputNeuron.get(doc), iAct).forEach(secondIAct -> {
            InputActivation secondAct;
            if (secondIAct.outputToInputNode != null && (secondAct = secondIAct.outputToInputNode.output) != null) {
                AndNode.AndActivation oAct = new AndNode.AndActivation(document.logicNodeActivationIdCounter++, doc, nln);
                for (AndNode.Entry e : andNode.parents) {
                    boolean match = e.ref.compareTo(ref) == 0;
                    oAct.link(e.ref, e.rv, match ? secondAct : act, match ? act : secondAct);
                }
                nln.addActivation(oAct);
            }
        });
    }

    @Override
    public void discover(InputActivation act, PatternDiscovery.Config config) {
        if (!act.input.input.isFinalActivation()) {
            return;
        }
        Document doc = act.doc;
        doc.getActivations(true).forEach(secondNAct -> {
            InputActivation secondAct = secondNAct.outputToInputNode.output;
            if (act != secondAct && config.candidateCheck.check(act, secondAct)) {
                List<Relation> relations = InputNode.getRelations(inputActivation.input.input, secondNAct);
                for (Relation r : relations) {
                    AndNode.RelationsMap rm;
                    AndNode.Refinement ref;
                    AndNode.RefValue rv;
                    InputNode in = (InputNode)secondAct.node;
                    if (r == null || (rv = this.extend(document.threadId, doc, ref = new AndNode.Refinement(rm = new AndNode.RelationsMap(new Relation[]{r}), in.provider), config)) == null) continue;
                    AndNode nln = rv.child.get();
                    nln.isDiscovered = true;
                }
            }
        });
    }

    public static List<Relation> getRelations(Activation act1, Activation act2) {
        ArrayList<Relation> rels = new ArrayList<Relation>();
        for (Relation rel : CANDIDATE_RELATIONS) {
            if (!rel.test(act2, act1)) continue;
            rels.add(rel);
            break;
        }
        return rels;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.getLabel() != null) {
                sb.append(",");
                sb.append(this.inputNeuron.getLabel());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(73);
        super.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    public static class Link {
        public Activation input;
        public InputActivation output;

        public Link(Activation iAct, InputActivation oAct) {
            this.input = iAct;
            this.output = oAct;
        }
    }

    public static class InputActivation
    extends NodeActivation<InputNode> {
        public Link input;

        public InputActivation(int id, Activation iAct, InputNode node) {
            super(id, iAct.doc, node);
            iAct.outputToInputNode = this.input = new Link(iAct, this);
        }

        @Override
        public Activation getInputActivation(int i) {
            assert (i == 0);
            return this.input.input;
        }

        public String toString() {
            return "I-ACT(" + this.input.input.getLabel() + " " + this.input.input.slotsToString() + ")";
        }
    }
}

