/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import network.aika.Document;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Candidate;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.SearchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activation
extends OrNode.OrActivation {
    public static int BEGIN = 0;
    public static int END = 1;
    public static final Comparator<Activation> ACTIVATION_ID_COMP = Comparator.comparingInt(act -> act.id);
    public static int MAX_SELF_REFERENCING_DEPTH = 5;
    public static int MAX_PREDECESSOR_DEPTH = 100;
    public static Activation MIN_ACTIVATION = new Activation(Integer.MIN_VALUE, null, null);
    public static Activation MAX_ACTIVATION = new Activation(Integer.MAX_VALUE, null, null);
    private static final Logger log = LoggerFactory.getLogger(Activation.class);
    public Map<Integer, Position> slots = new TreeMap<Integer, Position>();
    private TreeSet<Link> selectedInputLinks = new TreeSet<Link>(Link.INPUT_COMP);
    private TreeMap<Link, Link> inputLinks = new TreeMap(Link.INPUT_COMP);
    private TreeMap<Link, Link> outputLinks = new TreeMap(Link.OUTPUT_COMP);
    public Integer sequence;
    public double upperBound;
    public double lowerBound;
    public State avgState;
    public Map<Integer, State> searchStates;
    public Rounds rounds;
    public Rounds finalRounds = this.rounds = new Rounds();
    public boolean ubQueued = false;
    public long markedHasCandidate;
    public long currentStateV;
    public StateChange currentStateChange;
    public long markedDirty;
    public long markedPredecessor;
    public Double targetValue;
    public Double inputValue;
    public Writable extension;
    public SearchNode.Decision inputDecision = SearchNode.Decision.UNKNOWN;
    public SearchNode.Decision decision = SearchNode.Decision.UNKNOWN;
    public SearchNode.Decision finalDecision = SearchNode.Decision.UNKNOWN;
    public Candidate candidate;
    private long visitedState;
    public long markedAncestor;
    public boolean blocked;
    private List<Activation> conflicts;

    public Activation(int id, Document doc, OrNode n) {
        super(id, doc, n);
        if (doc != null && doc.model.getActivationExtensionFactory() != null) {
            this.extension = doc.model.getActivationExtensionFactory().createObject();
        }
    }

    public Position getSlot(int slot) {
        return this.slots.get(slot);
    }

    public void setSlot(int slot, Position pos) {
        this.slots.put(slot, pos);
    }

    public void setSlots(Map<Integer, Position> slots) {
        for (Map.Entry<Integer, Position> me : slots.entrySet()) {
            this.setSlot(me.getKey(), me.getValue());
        }
    }

    public Integer length() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Position pos : this.slots.values()) {
            if (pos.getFinalPosition() == null) {
                return null;
            }
            min = Math.min(min, pos.getFinalPosition());
            max = Math.max(max, pos.getFinalPosition());
        }
        if (min > max) {
            return 0;
        }
        return min - max;
    }

    public void setTargetValue(Double targetValue) {
        this.targetValue = targetValue;
    }

    public String getLabel() {
        return this.getINeuron().label;
    }

    public INeuron.Type getType() {
        return this.getINeuron().type;
    }

    public String getText() {
        return this.doc.getText(this.getSlot(BEGIN), this.getSlot(END));
    }

    public INeuron getINeuron() {
        return (INeuron)this.getNeuron().get(this.doc);
    }

    public Neuron getNeuron() {
        return ((OrNode)this.node).neuron;
    }

    public void addLink(Linker.Direction dir, Link l) {
        switch (dir) {
            case INPUT: {
                this.outputLinks.put(l, l);
                break;
            }
            case OUTPUT: {
                if (l.input.decision == SearchNode.Decision.SELECTED) {
                    this.selectedInputLinks.add(l);
                }
                this.inputLinks.put(l, l);
            }
        }
    }

    public Link getLinkBySynapseId(int synapseId) {
        for (Link l : this.inputLinks.values()) {
            if (l.passive || l.synapse.id != synapseId) continue;
            return l;
        }
        return null;
    }

    public SortedSet<Link> getInputLinksOrderedBySynapse() {
        return this.inputLinks.navigableKeySet();
    }

    public Stream<Link> getInputLinks(boolean includePassive, boolean onlySelected) {
        Stream<Link> s = (onlySelected ? this.selectedInputLinks : this.inputLinks.values()).stream();
        return includePassive ? s : s.filter(l -> !l.passive);
    }

    public Stream<Link> getOutputLinks(boolean includePassive) {
        Stream<Link> s = this.outputLinks.values().stream();
        return includePassive ? s : s.filter(l -> !l.passive);
    }

    public Link getInputLink(Link l) {
        return this.inputLinks.get(l);
    }

    public Stream<Link> getInputLinksBySynapse(boolean includePassive, Synapse syn) {
        Stream<Link> s = this.inputLinks.subMap(new Link(syn, MIN_ACTIVATION, MIN_ACTIVATION, false), new Link(syn, MAX_ACTIVATION, MAX_ACTIVATION, false)).values().stream();
        return includePassive ? s : s.filter(l -> !l.passive);
    }

    public Stream<Link> getOutputLinksBySynapse(boolean includePassive, Synapse syn) {
        Stream<Link> s = this.outputLinks.subMap(new Link(syn, MIN_ACTIVATION, MIN_ACTIVATION, false), new Link(syn, MAX_ACTIVATION, MAX_ACTIVATION, false)).values().stream();
        return includePassive ? s : s.filter(l -> !l.passive);
    }

    public double process(SearchNode sn, int round, long v) {
        double delta = 0.0;
        State s = this.inputValue != null ? new State(this.inputValue, this.inputValue, 1.0, 0.0, 0.0, 0, 0.0) : this.computeValueAndWeight(round);
        if (round == 0 || !this.rounds.get(round).equalsWithWeights(s)) {
            this.saveOldState(sn.modifiedActs, v);
            State oldState = this.rounds.get(round);
            boolean propagate = this.rounds.set(round, s) && (oldState == null || !oldState.equals(s));
            this.saveNewState();
            if (propagate) {
                if (round > Document.MAX_ROUND) {
                    log.error("Error: Maximum number of rounds reached. The network might be oscillating.");
                    log.info(this.doc.activationsToString(false, true, true));
                    this.doc.dumpOscillatingActivations();
                    throw new RuntimeException("Maximum number of rounds reached. The network might be oscillating.");
                }
                if (Document.ROUND_LIMIT < 0 || round < Document.ROUND_LIMIT) {
                    this.doc.vQueue.propagateActivationValue(round, this);
                }
            }
            if (round == 0) {
                this.doc.vQueue.add(1, this);
            }
            if (this.rounds.getLastRound() != null && round >= this.rounds.getLastRound()) {
                delta += s.weight - oldState.weight;
            }
        }
        return delta;
    }

    public State computeValueAndWeight(int round) {
        double newWeight;
        INeuron n = this.getINeuron();
        double net = n.biasSum;
        double posNet = n.biasSum;
        int fired = -1;
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v, 0);
        for (InputState is : this.getInputStates(round, v)) {
            Synapse s = is.l.synapse;
            Activation iAct = is.l.input;
            if (iAct == this) continue;
            double x = Math.min(s.limit, is.s.value) * s.weight;
            if (s.distanceFunction != null) {
                x *= s.distanceFunction.f(iAct, this);
            }
            net += x;
            if (!s.isNegative()) {
                posNet += x;
            }
            if (s.isRecurrent || s.isNegative() || !(net >= 0.0) || fired >= 0) continue;
            fired = iAct.rounds.get((int)round).fired + 1;
        }
        if (n.passiveInputSynapses != null) {
            for (Synapse s : n.passiveInputSynapses.values()) {
                double x = s.weight * ((INeuron)s.input.get((Document)this.doc)).passiveInputFunction.getActivationValue(s, this);
                net += x;
                if (s.isNegative()) continue;
                posNet += x;
            }
        }
        double actValue = n.activationFunction.f(net);
        double posActValue = n.activationFunction.f(posNet);
        double w = Math.min(-n.negRecSum, net);
        double d = newWeight = this.decision == SearchNode.Decision.SELECTED ? Math.max(0.0, w) : 0.0;
        if (this.decision == SearchNode.Decision.SELECTED || INeuron.ALLOW_WEAK_NEGATIVE_WEIGHTS) {
            return new State(actValue, posActValue, 1.0, net, posNet, -1, newWeight);
        }
        return new State(0.0, posActValue, 0.0, 0.0, posNet, -1, newWeight);
    }

    public boolean isActiveable() {
        INeuron n = this.getINeuron();
        double net = n.biasSum;
        for (Link l : this.inputLinks.values()) {
            if (l.synapse.inactive || l.passive) continue;
            Synapse s = l.synapse;
            Activation iAct = l.input;
            if (iAct == this) continue;
            double iv = 0.0;
            if (!l.synapse.isNegative() && l.input.decision != SearchNode.Decision.EXCLUDED) {
                iv = Math.min(l.synapse.limit, l.input.upperBound);
            }
            double x = iv * s.weight;
            if (s.distanceFunction != null) {
                x *= s.distanceFunction.f(iAct, this);
            }
            net += x;
        }
        if (n.passiveInputSynapses != null) {
            for (Synapse s : n.passiveInputSynapses.values()) {
                double x = s.weight * ((INeuron)s.input.get((Document)this.doc)).passiveInputFunction.getActivationValue(s, this);
                net += x;
            }
        }
        return net > 0.0;
    }

    public void processBounds() {
        double oldUpperBound = this.upperBound;
        this.computeBounds();
        if (Math.abs(this.upperBound - oldUpperBound) > 0.01) {
            for (Link l : this.outputLinks.values()) {
                if (l.passive) continue;
                this.doc.ubQueue.add(l);
            }
        }
        if (oldUpperBound <= 0.0 && this.upperBound > 0.0 && !this.blocked) {
            this.getINeuron().propagate(this);
        }
    }

    public void computeBounds() {
        INeuron n = this.getINeuron();
        double ub = n.biasSum + n.posRecSum;
        double lb = n.biasSum + n.posRecSum;
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v, 0);
        for (Link l : this.inputLinks.values()) {
            Activation iAct;
            Synapse s = l.synapse;
            if (s.inactive || l.passive || (iAct = l.input) == this) continue;
            double x = s.weight;
            if (s.distanceFunction != null) {
                x *= s.distanceFunction.f(iAct, this);
            }
            if (s.isNegative()) {
                if (!s.isRecurrent && !iAct.checkSelfReferencing(false, 0, v)) {
                    ub += Math.min(s.limit, iAct.lowerBound) * x;
                }
                lb += s.limit * x;
                continue;
            }
            ub += Math.min(s.limit, iAct.upperBound) * x;
            lb += Math.min(s.limit, iAct.lowerBound) * x;
        }
        if (n.passiveInputSynapses != null) {
            for (Synapse s : n.passiveInputSynapses.values()) {
                double x = s.weight * ((INeuron)s.input.get((Document)this.doc)).passiveInputFunction.getActivationValue(s, this);
                ub += x;
                lb += x;
            }
        }
        this.upperBound = n.activationFunction.f(ub);
        this.lowerBound = n.activationFunction.f(lb);
    }

    private static State getInitialState(SearchNode.Decision c) {
        return new State(c == SearchNode.Decision.SELECTED ? 1.0 : 0.0, 0.0, 1.0, 0.0, 0.0, 0, 0.0);
    }

    private List<InputState> getInputStates(int round, long v) {
        ArrayList<InputState> tmp = new ArrayList<InputState>();
        Synapse lastSynapse = null;
        InputState maxInputState = null;
        for (Link l : this.inputLinks.values()) {
            if (l.synapse.inactive || l.passive) continue;
            if (lastSynapse != null && lastSynapse != l.synapse) {
                tmp.add(maxInputState);
                maxInputState = null;
            }
            State s = l.input.getInputState(round, l.synapse, v);
            if (maxInputState == null || maxInputState.s.value < s.value) {
                maxInputState = new InputState(l, s);
            }
            lastSynapse = l.synapse;
        }
        if (maxInputState != null) {
            tmp.add(maxInputState);
        }
        return tmp;
    }

    private State getInputState(int round, Synapse s, long v) {
        State is = State.ZERO;
        if (s.isRecurrent) {
            if (!s.isNegative() || !this.checkSelfReferencing(true, 0, v)) {
                is = round == 0 ? Activation.getInitialState(this.decision) : this.rounds.get(round - 1);
            }
        } else {
            is = this.rounds.get(round);
        }
        return is;
    }

    public List<Link> getFinalInputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.inputLinks.values()) {
            if (l.passive || !l.input.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public List<Link> getFinalOutputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.outputLinks.values()) {
            if (l.passive || !l.output.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public Collection<Activation> getConflicts() {
        if (this.conflicts != null) {
            return this.conflicts;
        }
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v, 0);
        this.conflicts = new ArrayList<Activation>();
        for (Link l : this.inputLinks.values()) {
            if (l.passive || !l.synapse.isNegative() || !l.synapse.isRecurrent) continue;
            l.input.collectIncomingConflicts(this.conflicts, v);
        }
        this.collectOutgoingConflicts(this.conflicts, v);
        return this.conflicts;
    }

    private void collectIncomingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        if (this.getINeuron().type != INeuron.Type.INHIBITORY) {
            conflicts.add(this);
        } else {
            for (Link l : this.inputLinks.values()) {
                if (l.passive || l.synapse.isNegative() || l.synapse.isRecurrent) continue;
                l.input.collectIncomingConflicts(conflicts, v);
            }
        }
    }

    private void collectOutgoingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        for (Link l : this.outputLinks.values()) {
            if (l.passive) continue;
            if (l.output.getINeuron().type != INeuron.Type.INHIBITORY) {
                if (!l.synapse.isNegative() || !l.synapse.isRecurrent) continue;
                conflicts.add(l.output);
                continue;
            }
            if (l.synapse.isNegative() || l.synapse.isRecurrent) continue;
            l.output.collectOutgoingConflicts(conflicts, v);
        }
    }

    public void adjustSelectedNeuronInputs(SearchNode.Decision d) {
        for (Link l : this.outputLinks.values()) {
            if (l.passive) continue;
            if (d == SearchNode.Decision.SELECTED) {
                l.output.selectedInputLinks.add(l);
                continue;
            }
            l.output.selectedInputLinks.remove(l);
        }
    }

    public boolean checkSelfReferencing(boolean onlySelected, int depth, long v) {
        if (this.markedPredecessor == v) {
            return true;
        }
        if (depth > MAX_SELF_REFERENCING_DEPTH) {
            return false;
        }
        for (Link l : onlySelected ? this.selectedInputLinks : this.inputLinks.values()) {
            if (l.passive || l.synapse.isNegative() || !l.input.checkSelfReferencing(onlySelected, depth + 1, v)) continue;
            return true;
        }
        return false;
    }

    public void setDecision(SearchNode.Decision newDecision, long v) {
        if (this.inputDecision != SearchNode.Decision.UNKNOWN && newDecision != this.inputDecision) {
            return;
        }
        if (newDecision == SearchNode.Decision.UNKNOWN && v != this.visitedState) {
            return;
        }
        if (this.decision == SearchNode.Decision.SELECTED != (newDecision == SearchNode.Decision.SELECTED)) {
            this.adjustSelectedNeuronInputs(newDecision);
        }
        this.decision = newDecision;
        this.visitedState = v;
    }

    public boolean isFinalActivation() {
        return this.getFinalState().value > 0.0;
    }

    public State getFinalState() {
        return this.finalRounds.getLast();
    }

    public Integer getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = 0;
        this.inputLinks.values().stream().filter(l -> !l.synapse.isRecurrent && !l.passive).forEach(l -> {
            this.sequence = Math.max(this.sequence, l.input.getSequence() + 1);
        });
        return this.sequence;
    }

    public void markDirty(long v) {
        this.markedDirty = Math.max(this.markedDirty, v);
    }

    public void markPredecessor(long v, int depth) {
        if (depth > MAX_PREDECESSOR_DEPTH) {
            throw new RuntimeException("MAX_PREDECESSOR_DEPTH limit exceeded. Probable cause is a non recurrent loop.");
        }
        this.markedPredecessor = v;
        for (Link l : this.inputLinks.values()) {
            if (l.passive || l.synapse.isNegative() || l.synapse.isRecurrent) continue;
            l.input.markPredecessor(v, depth + 1);
        }
    }

    public String toString() {
        return this.id + " " + this.slotsToString() + " " + this.identityToString() + " - " + this.node + " -" + (this.extension != null ? this.extension.toString() + " -" : "") + " UB:" + Utils.round(this.upperBound) + (this.inputValue != null ? " IV:" + Utils.round(this.inputValue) : "") + (this.targetValue != null ? " TV:" + Utils.round(this.targetValue) : "") + " V:" + Utils.round(this.rounds.getLast().value) + " FV:" + Utils.round(this.finalRounds.getLast().value);
    }

    public String toString(boolean finalOnly, boolean withTextSnippet, boolean withLogic) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id + " - ");
        sb.append((Object)((Object)(finalOnly ? this.finalDecision : this.decision)) + " - ");
        sb.append(this.slotsToString());
        if (withTextSnippet) {
            sb.append(" \"");
            if (((INeuron)((OrNode)this.node).neuron.get()).getOutputText() != null) {
                sb.append(Utils.collapseText(((INeuron)((OrNode)this.node).neuron.get()).getOutputText(), 7));
            } else {
                sb.append(Utils.collapseText(this.doc.getText(this.getSlot(BEGIN), this.getSlot(END)), 7));
            }
            sb.append("\"");
        }
        sb.append(this.identityToString());
        sb.append(" - ");
        sb.append(withLogic ? ((OrNode)this.node).toString() : ((OrNode)this.node).getNeuronLabel());
        if (this.extension != null) {
            sb.append(" - " + this.extension);
        }
        sb.append(" - UB:");
        sb.append(Utils.round(this.upperBound));
        if (this.avgState != null) {
            sb.append(" AVG:");
            sb.append(this.avgState);
        }
        sb.append(" - ");
        if (finalOnly) {
            if (this.isFinalActivation()) {
                State fs = this.getFinalState();
                sb.append(fs);
            }
        } else {
            for (Map.Entry<Integer, State> me : this.rounds.rounds.entrySet()) {
                State s = me.getValue();
                sb.append("[R: " + me.getKey() + " " + s + "]");
            }
        }
        if (this.inputValue != null) {
            sb.append(" - IV:" + Utils.round(this.inputValue));
        }
        if (this.targetValue != null) {
            sb.append(" - TV:" + Utils.round(this.targetValue));
        }
        return sb.toString();
    }

    public String slotsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Map.Entry<Integer, Position> me : this.slots.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(me.getKey());
            sb.append(":");
            sb.append(me.getValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String identityToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        boolean first = true;
        for (Link l : this.inputLinks.values()) {
            if (l.passive || !l.synapse.identity) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(l.input.id);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public String linksToString() {
        StringBuilder sb = new StringBuilder();
        for (Link l : this.inputLinks.values()) {
            if (l.passive) continue;
            sb.append("  " + l.input.getLabel() + "  W:" + l.synapse.weight + "\n");
        }
        return sb.toString();
    }

    public void saveOldState(Map<Activation, StateChange> changes, long v) {
        StateChange sc = this.currentStateChange;
        if (sc == null || this.currentStateV != v) {
            sc = new StateChange();
            sc.oldRounds = this.rounds.copy();
            this.currentStateChange = sc;
            this.currentStateV = v;
            if (changes != null) {
                changes.put(sc.getActivation(), sc);
            }
        }
    }

    public void saveNewState() {
        StateChange sc = this.currentStateChange;
        sc.newRounds = this.rounds.copy();
        sc.newState = this.decision;
    }

    public static class Builder {
        public SortedMap<Integer, Integer> positions = new TreeMap<Integer, Integer>();
        public double value = 1.0;
        public Double targetValue;
        public int fired;

        public Builder setRange(int begin, int end) {
            this.setPosition(BEGIN, begin);
            this.setPosition(END, end);
            return this;
        }

        public Builder setPosition(int slot, int pos) {
            this.positions.put(slot, pos);
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public Builder setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Builder setFired(int fired) {
            this.fired = fired;
            return this;
        }
    }

    public static class Link {
        public final Synapse synapse;
        public final Activation input;
        public final Activation output;
        public boolean passive;
        public static Comparator<Link> INPUT_COMP = (l1, l2) -> {
            int r = Synapse.INPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(l1.input.id, l2.input.id);
        };
        public static Comparator<Link> OUTPUT_COMP = (l1, l2) -> {
            int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(l1.output.id, l2.output.id);
        };

        public Link(Synapse s, Activation input, Activation output, boolean passive) {
            this.synapse = s;
            this.input = input;
            this.output = output;
            this.passive = passive;
        }

        public void link() {
            this.input.addLink(Linker.Direction.INPUT, this);
            this.output.addLink(Linker.Direction.OUTPUT, this);
        }

        public String toString() {
            return (this.passive ? "p" : "") + this.synapse + ": " + this.input + " --> " + this.output;
        }
    }

    public class StateChange {
        public Rounds oldRounds;
        public Rounds newRounds;
        public SearchNode.Decision newState;

        public void restoreState(Mode m) {
            Activation.this.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public Activation getActivation() {
            return Activation.this;
        }
    }

    public static enum Mode {
        OLD,
        NEW;

    }

    public static class State {
        public final double value;
        public final double posValue;
        public final double p;
        public final double net;
        public final double posNet;
        public final int fired;
        public final double weight;
        public static final State ZERO = new State(0.0, 0.0, 0.0, 0.0, 0.0, -1, 0.0);

        public State(double value, double posValue, double p, double net, double posNet, int fired, double weight) {
            assert (!Double.isNaN(value));
            this.value = value;
            this.posValue = posValue;
            this.p = p;
            this.net = net;
            this.posNet = posNet;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && Math.abs(this.weight - s.weight) <= INeuron.WEIGHT_TOLERANCE;
        }

        public String toString() {
            return "V:" + Utils.round(this.value) + " pV:" + Utils.round(this.posValue) + " Net:" + Utils.round(this.net) + " P:" + Utils.round(this.p) + " W:" + Utils.round(this.weight);
        }
    }

    public static class Rounds {
        private boolean[] isQueued = new boolean[3];
        public TreeMap<Integer, State> rounds = new TreeMap();

        public Rounds() {
            this.rounds.put(0, State.ZERO);
        }

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : null;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : State.ZERO;
        }

        public void setQueued(int r, boolean v) {
            if (r >= this.isQueued.length) {
                this.isQueued = Arrays.copyOf(this.isQueued, this.isQueued.length * 2);
            }
            this.isQueued[r] = v;
        }

        public boolean isQueued(int r) {
            return r < this.isQueued.length ? this.isQueued[r] : false;
        }

        public void reset() {
            this.rounds.clear();
            this.rounds.put(0, State.ZERO);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.rounds.forEach((r, s) -> sb.append(r + ":" + s.value + " "));
            return sb.toString();
        }

        public boolean compare(Rounds r) {
            if (this.rounds.size() != r.rounds.size()) {
                return false;
            }
            for (Map.Entry<Integer, State> me : this.rounds.entrySet()) {
                State sa = me.getValue();
                State sb = r.rounds.get(me.getKey());
                if (sb != null && !(Math.abs(sa.value - sb.value) > 1.0E-7)) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            return this.rounds.size() <= 1 && this.getLast().value > 0.0;
        }
    }

    private static class InputState {
        Link l;
        State s;

        public InputState(Link l, State s) {
            this.l = l;
            this.s = s;
        }
    }
}

