/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayDeque;
import java.util.Map;
import network.aika.Document;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.relation.Relation;

public class Linker {
    protected Document doc;
    ArrayDeque<Activation.Link> queue = new ArrayDeque();

    public Linker(Document doc) {
        this.doc = doc;
    }

    public SearchNode.Decision getLinkedDecision(Activation act) {
        return SearchNode.Decision.UNKNOWN;
    }

    public Activation computeInputActivation(Synapse s, Activation iAct) {
        return iAct;
    }

    public void link(Activation act, OrNode.Link ol) {
        this.linkOrNodeRelations(act, ol);
        this.process();
    }

    private void linkOrNodeRelations(Activation act, OrNode.Link ol) {
        for (int i = 0; i < ol.oe.synapseIds.length; ++i) {
            int synId = ol.oe.synapseIds[i];
            Synapse s = ((OrNode)act.node).neuron.getSynapseById(synId);
            Activation iAct = ol.input.getInputActivation(i);
            this.link(s, iAct, act);
        }
    }

    private void linkOutputRelations(Activation act) {
        INeuron n = act.getINeuron();
        if (n.outputRelations != null) {
            this.linkRelated(act, act, n.outputRelations);
        }
    }

    public void linkInput(Activation act) {
        for (Synapse s : act.getNeuron().inMemoryInputSynapses.values()) {
            for (Map.Entry<Integer, Relation> me : s.relations.entrySet()) {
                Relation rel = me.getValue();
                if (me.getKey() != -1) continue;
                rel.invert().getActivations((INeuron)s.input.get(act.doc), act).forEach(iAct -> this.link(s, (Activation)iAct, act));
            }
        }
        this.doc.linker.process();
    }

    public void lateLinking() {
        int oldSize;
        do {
            oldSize = this.doc.getNumberOfActivations();
            Activation act = null;
            while ((act = this.doc.getNextActivation(act)) != null) {
                this.linkOutputRelations(act);
                act.getInputLinks(false, false).forEach(l -> this.addToQueue((Activation.Link)l));
            }
            this.doc.linker.process();
        } while (oldSize != this.doc.getNumberOfActivations());
        this.postLateLinking();
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            Activation.Link l = this.queue.pollFirst();
            this.linkRelated(l.input, l.output, l.synapse.relations);
            this.doc.propagate();
        }
    }

    private void linkRelated(Activation rAct, Activation oAct, Map<Integer, Relation> relations) {
        for (Map.Entry<Integer, Relation> me : relations.entrySet()) {
            Synapse s;
            Relation rel = me.getValue();
            Integer relId = me.getKey();
            if (relId < 0 || (s = oAct.getNeuron().getSynapseById(relId)) == null || !rel.follow(rAct, oAct, relations)) continue;
            rel.invert().getActivations((INeuron)s.input.get(rAct.doc), rAct).forEach(iAct -> this.link(s, (Activation)iAct, oAct));
        }
    }

    protected void link(Synapse s, Activation iAct, Activation oAct) {
        Activation.Link el;
        if ((iAct = this.computeInputActivation(s, iAct)) == null || iAct.blocked || !this.checkRelations(s, iAct, oAct)) {
            return;
        }
        Activation.Link nl = new Activation.Link(s, iAct, oAct, false);
        if (oAct.getInputLink(nl) != null) {
            return;
        }
        if (s.identity && (el = oAct.getLinkBySynapseId(s.id)) != null && el.input != iAct) {
            nl.passive = true;
        }
        nl.link();
        if (!nl.passive) {
            this.addToQueue(nl);
        }
    }

    private boolean checkRelations(Synapse s, Activation iAct, Activation oAct) {
        for (Map.Entry<Integer, Relation> me : s.relations.entrySet()) {
            Relation rel = me.getValue();
            if (me.getKey() != -1 || rel.test(iAct, oAct)) continue;
            return false;
        }
        return true;
    }

    protected void postLateLinking() {
        this.doc.getActivations(false).stream().flatMap(act -> act.getInputLinks(false, false)).filter(l -> l.synapse.isRecurrent && !l.synapse.isNegative()).forEach(l -> {
            if (!l.passive && !this.checkLoop(l.input, l.output)) {
                l.passive = true;
            }
        });
    }

    protected boolean checkLoop(Activation iAct, Activation oAct) {
        long v;
        oAct.markedPredecessor = v = this.doc.visitedCounter++;
        return iAct.checkSelfReferencing(false, 0, v);
    }

    private void addToQueue(Activation.Link l) {
        if (l == null) {
            return;
        }
        if (!l.synapse.isNegative()) {
            this.queue.add(l);
        }
        this.doc.ubQueue.add(l);
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

