/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Document;
import network.aika.neuron.activation.Activation;

public class Position {
    public static final Position MIN = new Position(null, Integer.MIN_VALUE);
    public static final Position MAX = new Position(null, Integer.MAX_VALUE);
    public SortedMap<ActKey, Activation> activations = new TreeMap<ActKey, Activation>();
    public Document doc;
    public final int id;
    private Integer finalPosition;

    public Position(Document doc) {
        this(doc, null);
    }

    public Position(Document doc, Integer pos) {
        int n;
        this.doc = doc;
        if (doc != null) {
            int n2 = doc.positionIdCounter;
            n = n2;
            doc.positionIdCounter = n2 + 1;
        } else {
            n = -1;
        }
        this.id = n;
        this.finalPosition = pos;
    }

    public static int compare(Position a, Position b) {
        return a.compare(b);
    }

    public int compare(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return Integer.compare(this.finalPosition, pos.finalPosition);
        }
        return 0;
    }

    public String toString() {
        return this.finalPosition != null ? "" + this.finalPosition : "<" + this.id + ">";
    }

    public Integer getDistance(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return pos.finalPosition - this.finalPosition;
        }
        return null;
    }

    public Integer getFinalPosition() {
        return this.finalPosition;
    }

    public void setFinalPosition(int finalPos) {
        this.finalPosition = finalPos;
    }

    public void addActivation(Integer slot, Activation act) {
        this.activations.put(new ActKey(slot, act.id), act);
    }

    public Stream<Activation> getActivations(int slot) {
        return this.activations.subMap(new ActKey(slot, Integer.MIN_VALUE), new ActKey(slot, Integer.MAX_VALUE)).values().stream();
    }

    public static class ActKey
    implements Comparable<ActKey> {
        int slot;
        int actId;

        public ActKey(int slot, int actId) {
            this.slot = slot;
            this.actId = actId;
        }

        @Override
        public int compareTo(ActKey ak) {
            int r = Integer.compare(this.slot, ak.slot);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.actId, ak.actId);
        }
    }

    public static enum Operator {
        EQUALS(0),
        LESS_THAN_EQUAL(1),
        GREATER_THAN_EQUAL(2),
        LESS_THAN(3),
        GREATER_THAN(4),
        NONE(5);

        int id;

        private Operator(int id) {
            this.id = (short)id;
        }

        public static Operator getById(int id) {
            for (Operator o : Operator.values()) {
                if (o.id != id) continue;
                return o;
            }
            return null;
        }

        public boolean isGreaterThanOrGreaterThanEqual() {
            return this == GREATER_THAN || this == GREATER_THAN_EQUAL;
        }

        public boolean isLessThanOrLessThanEqual() {
            return this == LESS_THAN || this == LESS_THAN_EQUAL;
        }

        public boolean includesEqual() {
            return this == EQUALS || this == GREATER_THAN_EQUAL || this == LESS_THAN_EQUAL;
        }

        public int getId() {
            return this.id;
        }

        public Operator invert() {
            switch (this) {
                case EQUALS: {
                    return EQUALS;
                }
                case LESS_THAN_EQUAL: {
                    return GREATER_THAN_EQUAL;
                }
                case GREATER_THAN_EQUAL: {
                    return LESS_THAN_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
            }
            return NONE;
        }

        public boolean compare(Position a, Position b) {
            if (this == NONE) {
                return true;
            }
            if (this == EQUALS) {
                return a == b;
            }
            if (a.finalPosition != null && b.finalPosition != null) {
                switch (this) {
                    case LESS_THAN_EQUAL: {
                        return a.finalPosition <= b.finalPosition;
                    }
                    case GREATER_THAN_EQUAL: {
                        return a.finalPosition >= b.finalPosition;
                    }
                    case LESS_THAN: {
                        return a.finalPosition < b.finalPosition;
                    }
                    case GREATER_THAN: {
                        return a.finalPosition > b.finalPosition;
                    }
                }
                return true;
            }
            if (a == b) {
                return this == EQUALS || this == LESS_THAN_EQUAL || this == GREATER_THAN_EQUAL;
            }
            return false;
        }
    }
}

