/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class AncestorRelation
extends Relation {
    public static final int RELATION_TYPE = 1;
    public Type type;

    AncestorRelation() {
    }

    public AncestorRelation(Type type) {
        this.type = type;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        ArrayList<Activation> results = new ArrayList<Activation>();
        switch (this.type) {
            case COMMON_ANCESTOR: {
                this.collectCommonAncestor(results, n, linkedAct, linkedAct.doc.visitedCounter++);
                break;
            }
            case IS_DESCENDANT_OF: {
                this.collectContains(results, n, linkedAct, linkedAct.doc.visitedCounter++);
                break;
            }
            case IS_ANCESTOR_OF: {
                this.collectContainedIn(results, n, linkedAct, linkedAct.doc.visitedCounter++);
                break;
            }
            case EQUALS: {
                this.collectEquals(results, n, linkedAct);
            }
        }
        return results.stream();
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
    }

    private void collectCommonAncestor(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        this.collectContains(results, n, linkedAct, v);
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectCommonAncestor(results, n, l2.input, v));
    }

    private void collectContains(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getOutputLinks(false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectContains(results, n, l2.output, v));
    }

    private void collectContainedIn(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> this.collectContainedIn(results, n, l2.input, v));
    }

    private void collectEquals(List<Activation> results, INeuron n, Activation linkedAct) {
        results.add(linkedAct);
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        switch (this.type) {
            case COMMON_ANCESTOR: {
                return AncestorRelation.hasCommonAncestor(act, linkedAct);
            }
            case IS_DESCENDANT_OF: {
                return AncestorRelation.contains(act, linkedAct, act.doc.visitedCounter++);
            }
            case IS_ANCESTOR_OF: {
                return AncestorRelation.contains(linkedAct, act, act.doc.visitedCounter++);
            }
            case NOT_DESCENDANT_OF: {
                return !AncestorRelation.contains(act, linkedAct, act.doc.visitedCounter++);
            }
            case NOT_ANCESTOR_OF: {
                return !AncestorRelation.contains(linkedAct, act, act.doc.visitedCounter++);
            }
        }
        return true;
    }

    @Override
    public Relation invert() {
        switch (this.type) {
            case COMMON_ANCESTOR: {
                return this;
            }
            case IS_DESCENDANT_OF: {
                return new AncestorRelation(Type.IS_ANCESTOR_OF);
            }
            case IS_ANCESTOR_OF: {
                return new AncestorRelation(Type.IS_DESCENDANT_OF);
            }
            case NOT_DESCENDANT_OF: {
                return new AncestorRelation(Type.NOT_ANCESTOR_OF);
            }
            case NOT_ANCESTOR_OF: {
                return new AncestorRelation(Type.NOT_DESCENDANT_OF);
            }
        }
        return null;
    }

    @Override
    public void mapRange(Map<Integer, Position> slots, Activation act) {
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
    }

    private static boolean contains(Activation actA, Activation actB, long v) {
        if (actA.visited == v) {
            return false;
        }
        actA.visited = v;
        if (actA == actB) {
            return true;
        }
        return actA.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l2 -> AncestorRelation.contains(l2.input, actB, v));
    }

    private static boolean hasCommonAncestor(Activation act, Activation linkedAct) {
        long v = act.doc.visitedCounter++;
        AncestorRelation.markAncestors(linkedAct, v);
        return AncestorRelation.hasCommonAncestor(act, v, act.doc.visitedCounter++);
    }

    private static void markAncestors(Activation act, long v) {
        if (act.visited == v) {
            return;
        }
        act.visited = v;
        act.markedAncestor = v;
        act.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.markAncestors(l2.input, v));
    }

    private static boolean hasCommonAncestor(Activation act, long v1, long v2) {
        if (act.visited == v2) {
            return false;
        }
        act.visited = v2;
        if (act.markedAncestor == v1) {
            return true;
        }
        return act.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l3 -> AncestorRelation.hasCommonAncestor(l3.input, v1, v2));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.type.name());
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.type = Type.valueOf(in.readUTF());
    }

    public static AncestorRelation read(DataInput in, Model m) throws IOException {
        AncestorRelation ir = new AncestorRelation();
        ir.readFields(in, m);
        return ir;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public int getRelationType() {
        return 1;
    }

    @Override
    public int compareTo(Relation rel) {
        AncestorRelation ir = (AncestorRelation)rel;
        return this.type.compareTo(ir.type);
    }

    public static enum Type {
        COMMON_ANCESTOR,
        IS_DESCENDANT_OF,
        IS_ANCESTOR_OF,
        NOT_DESCENDANT_OF,
        NOT_ANCESTOR_OF,
        EQUALS;

    }
}

