/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class MultiRelation
extends Relation {
    public static final int RELATION_TYPE = 2;
    private List<Relation> relations;

    public MultiRelation() {
        this.relations = new ArrayList<Relation>();
    }

    public MultiRelation(List<Relation> rels) {
        this.relations = rels;
    }

    @Override
    public int getRelationType() {
        return 2;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        for (Relation rel : this.relations) {
            if (rel.test(act, linkedAct)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Relation invert() {
        ArrayList<Relation> invRels = new ArrayList<Relation>();
        for (Relation rel : this.relations) {
            invRels.add(rel.invert());
        }
        return new MultiRelation(invRels);
    }

    @Override
    public void mapRange(Map<Integer, Position> slots, Activation act) {
        for (Relation rel : this.relations) {
            rel.mapRange(slots, act);
        }
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
        for (Relation rel : this.relations) {
            rel.linksOutputs(results);
        }
    }

    @Override
    public boolean isExact() {
        for (Relation rel : this.relations) {
            if (!rel.isExact()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        if (this.relations.isEmpty()) {
            INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
            return th != null ? th.getActivations() : Stream.empty();
        }
        Relation firstRelation = this.relations.get(0);
        return firstRelation.getActivations(n, linkedAct).filter(act -> {
            for (Relation rel : this.relations) {
                if (rel.test((Activation)act, linkedAct)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
        for (Relation rel : this.relations) {
            rel.registerRequiredSlots(input);
        }
    }

    @Override
    public int compareTo(Relation rel) {
        MultiRelation mr = (MultiRelation)rel;
        int r = Integer.compare(this.relations.size(), mr.relations.size());
        if (r != 0) {
            return r;
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            Relation b;
            Relation a = this.relations.get(i);
            r = Relation.COMPARATOR.compare(a, b = mr.relations.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.relations.size());
        for (Relation rel : this.relations) {
            rel.write(out);
        }
    }

    public static MultiRelation read(DataInput in, Model m) throws IOException {
        MultiRelation mr = new MultiRelation();
        mr.readFields(in, m);
        return mr;
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            this.relations.add(Relation.read(in, m));
        }
    }
}

