/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class PositionRelation
extends Relation {
    public static final int RELATION_TYPE = 0;
    public int fromSlot;
    public int toSlot;
    public Position.Operator relation;

    PositionRelation() {
    }

    public PositionRelation(int fromSlot, int toSlot, Position.Operator relation) {
        this.fromSlot = fromSlot;
        this.toSlot = toSlot;
        this.relation = relation;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        return this.relation.compare(act.getSlot(this.fromSlot), linkedAct.getSlot(this.toSlot));
    }

    public String toString() {
        return "RR(" + this.fromSlot + "," + this.toSlot + "," + (Object)((Object)this.relation) + ")";
    }

    @Override
    public Relation invert() {
        return new PositionRelation(this.toSlot, this.fromSlot, this.relation.invert());
    }

    @Override
    public void mapRange(Map<Integer, Position> slots, Activation act) {
        if (this.relation == Position.Operator.EQUALS) {
            slots.put(this.toSlot, act.getSlot(this.fromSlot));
        }
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
        results.add(this.toSlot);
    }

    @Override
    public int getRelationType() {
        return 0;
    }

    @Override
    public int compareTo(Relation rel) {
        PositionRelation pr = (PositionRelation)rel;
        int r = Integer.compare(this.fromSlot, pr.fromSlot);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.toSlot, pr.toSlot);
        if (r != 0) {
            return r;
        }
        return this.relation.compareTo(pr.relation);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.fromSlot);
        out.writeInt(this.toSlot);
        out.writeByte(this.relation.getId());
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.fromSlot = in.readInt();
        this.toSlot = in.readInt();
        this.relation = Position.Operator.getById(in.readByte());
    }

    public static PositionRelation read(DataInput in, Model m) throws IOException {
        PositionRelation rr = new PositionRelation();
        rr.readFields(in, m);
        return rr;
    }

    @Override
    public boolean isExact() {
        return this.relation == Position.Operator.EQUALS;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
        if (th == null || th.isEmpty()) {
            return Stream.empty();
        }
        Position pos = linkedAct.getSlot(this.toSlot);
        Stream<Activation> results = this.relation == Position.Operator.EQUALS ? th.getActivations(this.fromSlot, pos, true, this.fromSlot, pos, true) : (this.relation == Position.Operator.LESS_THAN || this.relation == Position.Operator.LESS_THAN_EQUAL ? th.getActivations(this.fromSlot, Position.MIN, true, this.fromSlot, pos, this.relation == Position.Operator.LESS_THAN_EQUAL) : (this.relation == Position.Operator.GREATER_THAN || this.relation == Position.Operator.GREATER_THAN_EQUAL ? th.getActivations(this.fromSlot, pos, this.relation == Position.Operator.GREATER_THAN_EQUAL, this.fromSlot, Position.MAX, true) : th.getActivations()));
        return results.filter(act -> this.test((Activation)act, linkedAct));
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
        ((INeuron)input.get()).slotRequired.add(this.fromSlot);
    }
}

