/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.AncestorRelation;
import network.aika.neuron.relation.MultiRelation;
import network.aika.neuron.relation.PositionRelation;

public abstract class Relation
implements Comparable<Relation>,
Writable {
    public static Relation EQUALS = Relation.createRangeRelation(Position.Operator.EQUALS, Position.Operator.EQUALS);
    public static Relation BEGIN_EQUALS = Relation.createRangeRelation(Position.Operator.EQUALS, Position.Operator.NONE);
    public static Relation END_EQUALS = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.EQUALS);
    public static Relation BEGIN_TO_END_EQUALS = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.EQUALS, Position.Operator.NONE, Position.Operator.NONE);
    public static Relation END_TO_BEGIN_EQUALS = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.EQUALS);
    public static Relation CONTAINS = Relation.createRangeRelation(Position.Operator.LESS_THAN_EQUAL, Position.Operator.GREATER_THAN_EQUAL);
    public static Relation CONTAINED_IN = Relation.createRangeRelation(Position.Operator.GREATER_THAN_EQUAL, Position.Operator.LESS_THAN_EQUAL);
    public static Relation OVERLAPS = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.LESS_THAN, Position.Operator.NONE, Position.Operator.GREATER_THAN);
    public static Relation NONE = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.NONE);
    public static Relation BETWEEN = Relation.createRangeRelation(Position.Operator.GREATER_THAN, Position.Operator.LESS_THAN);
    public static Relation BEFORE = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.LESS_THAN_EQUAL);
    public static Relation AFTER = Relation.createRangeRelation(Position.Operator.NONE, Position.Operator.NONE, Position.Operator.NONE, Position.Operator.GREATER_THAN_EQUAL);
    public static Comparator<Relation> COMPARATOR = (r1, r2) -> {
        int r = Integer.compare(r1.getRelationType(), r2.getRelationType());
        if (r != 0) {
            return r;
        }
        return r1.compareTo(r2);
    };

    public static Relation createRangeRelation(Position.Operator beginToBegin, Position.Operator beginToEnd, Position.Operator endToEnd, Position.Operator endToBegin) {
        ArrayList<Relation> rels = new ArrayList<Relation>();
        if (beginToBegin != Position.Operator.NONE) {
            rels.add(new PositionRelation(Activation.BEGIN, Activation.BEGIN, beginToBegin));
        }
        if (beginToEnd != Position.Operator.NONE) {
            rels.add(new PositionRelation(Activation.BEGIN, Activation.END, beginToEnd));
        }
        if (endToEnd != Position.Operator.NONE) {
            rels.add(new PositionRelation(Activation.END, Activation.END, endToEnd));
        }
        if (endToBegin != Position.Operator.NONE) {
            rels.add(new PositionRelation(Activation.END, Activation.BEGIN, endToBegin));
        }
        if (rels.size() == 1) {
            return (Relation)rels.get(0);
        }
        return new MultiRelation(rels);
    }

    public static Relation createRangeRelation(Position.Operator beginToBegin, Position.Operator endToEnd) {
        return Relation.createRangeRelation(beginToBegin, Position.Operator.NONE, endToEnd, Position.Operator.NONE);
    }

    public abstract int getRelationType();

    public abstract boolean test(Activation var1, Activation var2);

    public abstract Relation invert();

    public abstract void mapRange(Map<Integer, Position> var1, Activation var2);

    public abstract void linksOutputs(Set<Integer> var1);

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getRelationType());
    }

    public static Relation read(DataInput in, Model m) throws IOException {
        switch (in.readInt()) {
            case 1: {
                return AncestorRelation.read(in, m);
            }
            case 0: {
                return PositionRelation.read(in, m);
            }
            case 2: {
                return MultiRelation.read(in, m);
            }
        }
        return null;
    }

    public abstract boolean isExact();

    public abstract Stream<Activation> getActivations(INeuron var1, Activation var2);

    public boolean follow(Activation rAct, Activation oAct, Map<Integer, Relation> relations) {
        return true;
    }

    public static void addRelation(Map<Integer, Relation> relMap, Integer synId, Integer targetSynId, Neuron n, Relation r) {
        Synapse s;
        if (targetSynId == -1 && ((s = n.getSynapseById(synId)) == null || s.isDisjunction)) {
            return;
        }
        relMap.put(synId, r);
    }

    public static Map<Integer, Relation> getRelationsMap(int synapseId, Neuron n) {
        if (synapseId == -1) {
            INeuron in = (INeuron)n.get();
            if (in.outputRelations == null) {
                in.outputRelations = new TreeMap<Integer, Relation>();
            }
            return in.outputRelations;
        }
        Synapse s = n.getSynapseById(synapseId);
        return s.relations;
    }

    public abstract void registerRequiredSlots(Neuron var1);

    public static class Builder
    implements Neuron.Builder {
        private int from;
        private int to;
        private Relation relation;

        public Builder setFrom(int synapseId) {
            assert (synapseId >= -1);
            this.from = synapseId;
            return this;
        }

        public Builder setTo(int synapseId) {
            assert (synapseId >= -1);
            this.to = synapseId;
            return this;
        }

        public Builder setAncestorRelation(AncestorRelation.Type type) {
            this.relation = new AncestorRelation(type);
            return this;
        }

        public Builder setPositionRelation(int fromSlot, int toSlot, Position.Operator operator) {
            this.relation = new PositionRelation(fromSlot, toSlot, operator);
            return this;
        }

        public Builder setRelation(Relation rel) {
            this.relation = rel;
            return this;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void connect(Neuron n) {
            Map<Integer, Relation> fromRel = Relation.getRelationsMap(this.from, n);
            Map<Integer, Relation> toRel = Relation.getRelationsMap(this.to, n);
            Relation r = this.getRelation();
            Relation.addRelation(fromRel, this.to, this.from, n, r);
            Relation.addRelation(toRel, this.from, this.to, n, r.invert());
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.from);
            n.registerSynapseId(this.to);
        }
    }
}

