/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import network.aika.AbstractNode;
import network.aika.Document;
import network.aika.Model;
import network.aika.PatternDiscovery;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.Writable;
import network.aika.lattice.AndNode;
import network.aika.lattice.InputNode;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.OrNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Node<T extends Node, A extends NodeActivation<T>>
extends AbstractNode<Provider<T>, A>
implements Comparable<Node> {
    public static final Node MIN_NODE = new InputNode();
    public static final Node MAX_NODE = new InputNode();
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public TreeMap<AndNode.Refinement, AndNode.RefValue> andChildren;
    public TreeSet<OrNode.OrEntry> orChildren;
    public int level;
    public Writable extension;
    public boolean isDiscovered;
    public AtomicInteger numberOfNeuronRefs = new AtomicInteger(0);
    volatile boolean isRemoved;
    public ReadWriteLock lock = new ReadWriteLock();
    public ThreadState<T, A>[] threads;
    public long markedCreated;

    public ThreadState<T, A> getThreadState(int threadId, boolean create) {
        ThreadState<T, A> th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = this.provider.model.docIdCounter.get();
        return th;
    }

    public abstract AndNode.RefValue extend(int var1, Document var2, AndNode.Refinement var3, PatternDiscovery.Config var4);

    abstract void apply(A var1);

    public abstract void discover(A var1, PatternDiscovery.Config var2);

    public abstract void reprocessInputs(Document var1);

    public abstract void cleanup();

    public abstract String logicToString();

    protected Node() {
    }

    public Node(Model m, int level) {
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Provider<Node>(m, this);
        this.level = level;
        this.setModified();
        if (m.getNodeExtensionFactory() != null) {
            this.extension = m.getNodeExtensionFactory().createObject();
        }
    }

    public void postCreate(Document doc) {
        if (doc != null) {
            this.markedCreated = doc.createV;
            doc.addedNodes.add(this);
        }
    }

    void addOrChild(OrNode.OrEntry rv) {
        this.lock.acquireWriteLock();
        if (this.orChildren == null) {
            this.orChildren = new TreeSet();
        }
        this.orChildren.add(rv);
        this.lock.releaseWriteLock();
    }

    void removeOrChild(OrNode.OrEntry rv) {
        this.lock.acquireWriteLock();
        if (this.orChildren != null) {
            this.orChildren.remove(rv);
            if (this.orChildren.isEmpty()) {
                this.orChildren = null;
            }
        }
        this.lock.releaseWriteLock();
    }

    void addAndChild(AndNode.Refinement ref, AndNode.RefValue child) {
        if (this.andChildren == null) {
            this.andChildren = new TreeMap();
        }
        if (!this.andChildren.containsKey(ref)) {
            this.andChildren.put(ref, child);
        }
    }

    void removeAndChild(AndNode.Refinement ref) {
        if (this.andChildren != null) {
            this.andChildren.remove(ref);
            if (this.andChildren.isEmpty()) {
                this.andChildren = null;
            }
        }
    }

    void processActivation(A act) {
        this.register(act);
        this.propagate(act);
    }

    public void register(A act) {
        Document doc = ((NodeActivation)act).doc;
        ThreadState<T, A> th = ((Node)((NodeActivation)act).node).getThreadState(doc.threadId, true);
        if (th.activations.isEmpty()) {
            doc.activatedNodes.add((Node)((NodeActivation)act).node);
        }
        th.activations.add(act);
        doc.addedNodeActivations.add((NodeActivation)act);
    }

    public void clearActivations(Document doc) {
        this.clearActivations(doc.threadId);
    }

    public void clearActivations(int threadId) {
        ThreadState<T, A> th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        th.added.clear();
    }

    public void clearActivations() {
        for (int i = 0; i < this.provider.model.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void processChanges(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, true);
        List tmpAdded = th.added;
        th.added = new ArrayList();
        tmpAdded.forEach(act -> this.processActivation(act));
    }

    public void addActivation(A act) {
        ThreadState<T, A> th = this.getThreadState(((NodeActivation)act).doc.threadId, true);
        th.added.add(act);
        ((NodeActivation)act).doc.queue.add(this);
    }

    public void remove() {
        assert (!this.isRemoved);
        this.lock.acquireWriteLock();
        this.setModified();
        while (this.andChildren != null && !this.andChildren.isEmpty()) {
            this.andChildren.firstEntry().getValue().child.get().remove();
        }
        while (this.orChildren != null && !this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().child.get().remove();
        }
        this.lock.releaseWriteLock();
        this.isRemoved = true;
    }

    AndNode.RefValue getAndChild(AndNode.Refinement ref) {
        this.lock.acquireReadLock();
        AndNode.RefValue result = this.andChildren != null ? this.andChildren.get(ref) : null;
        this.lock.releaseReadLock();
        return result;
    }

    public boolean isRequired() {
        return this.numberOfNeuronRefs.get() > 0 || this.isDiscovered;
    }

    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        ThreadState<T, A> th = this.getThreadState(threadId, true);
        if (th.visited == v) {
            return;
        }
        th.visited = v;
        this.numberOfNeuronRefs.addAndGet(d);
    }

    public Collection<A> getActivations(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.activations;
    }

    public String getNeuronLabel() {
        return "";
    }

    public String toString() {
        if (this == MIN_NODE) {
            return "MIN_NODE";
        }
        if (this == MAX_NODE) {
            return "MAX_NODE";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNeuronLabel());
        sb.append(" - ");
        sb.append(this.logicToString());
        return sb.toString();
    }

    @Override
    public int compareTo(Node n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NODE) {
            return -1;
        }
        if (n == MIN_NODE) {
            return 1;
        }
        if (this == MAX_NODE) {
            return 1;
        }
        if (n == MAX_NODE) {
            return -1;
        }
        return this.provider.compareTo(n.provider);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        out.writeBoolean(this.extension != null);
        if (this.extension != null) {
            this.extension.write(out);
        }
        out.writeBoolean(this.isDiscovered);
        out.writeInt(this.numberOfNeuronRefs.get());
        if (this.andChildren != null) {
            out.writeInt(this.andChildren.size());
            for (Map.Entry<AndNode.Refinement, AndNode.RefValue> me : this.andChildren.entrySet()) {
                me.getKey().write(out);
                me.getValue().write(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.orChildren != null) {
            out.writeInt(this.orChildren.size());
            for (OrNode.OrEntry oe : this.orChildren) {
                oe.write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int i;
        this.level = in.readInt();
        if (in.readBoolean()) {
            this.extension = m.getNodeExtensionFactory().createObject();
            this.extension.readFields(in, m);
        }
        this.isDiscovered = in.readBoolean();
        this.numberOfNeuronRefs.set(in.readInt());
        int s = in.readInt();
        for (i = 0; i < s; ++i) {
            this.addAndChild(AndNode.Refinement.read(in, m), AndNode.RefValue.read(in, m));
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            if (this.orChildren == null) {
                this.orChildren = new TreeSet();
            }
            this.orChildren.add(OrNode.OrEntry.read(in, m));
        }
        this.threads = new ThreadState[m.numberOfThreads];
    }

    public static Node readNode(DataInput in, Provider p) throws IOException {
        char type = in.readChar();
        Node n = null;
        switch (type) {
            case 'I': {
                n = new InputNode();
                break;
            }
            case 'A': {
                n = new AndNode();
                break;
            }
            case 'O': {
                n = new OrNode();
            }
        }
        n.provider = p;
        n.readFields(in, p.model);
        return n;
    }

    public static class ThreadState<T extends Node, A extends NodeActivation> {
        public long lastUsed;
        public List<A> added = new ArrayList<A>();
        public List<A> activations = new ArrayList<A>();
        public long visited;
        public boolean isQueued = false;
        public long queueId;
    }
}

