/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.AbstractNode;
import network.aika.Document;
import network.aika.Model;
import network.aika.PatternDiscovery;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrNode
extends Node<OrNode, Activation> {
    private static final Logger log = LoggerFactory.getLogger(OrNode.class);
    public TreeSet<OrEntry> andParents = new TreeSet();
    public Neuron neuron = null;

    public OrNode() {
    }

    public OrNode(Model m) {
        super(m, -1);
    }

    @Override
    public AndNode.RefValue extend(int threadId, Document doc, AndNode.Refinement ref, PatternDiscovery.Config patterDiscovery) {
        throw new UnsupportedOperationException();
    }

    public void addInputActivation(OrEntry oe, NodeActivation inputAct) {
        Document doc = inputAct.doc;
        TreeMap<Integer, Position> slots = new TreeMap<Integer, Position>();
        INeuron n = (INeuron)this.neuron.get(inputAct.doc);
        for (int i = 0; i < oe.synapseIds.length; ++i) {
            int synapseId = oe.synapseIds[i];
            Synapse s = this.neuron.getSynapseById(synapseId);
            for (Map.Entry<Integer, Relation> me : s.relations.entrySet()) {
                Relation rel = me.getValue();
                if (me.getKey() != -1) continue;
                Activation iAct = inputAct.getInputActivation(i);
                rel.mapSlots(slots, iAct);
            }
        }
        for (Integer slot : n.slotRequired) {
            if (slots.containsKey(slot)) continue;
            if (!n.slotHasInputs.contains(slot)) {
                slots.put(slot, new Position(doc));
                continue;
            }
            return;
        }
        Activation act = this.lookupActivation(doc, slots, oe, inputAct);
        if (act == null) {
            act = new Activation(doc.activationIdCounter++, doc, this);
            act.setSlots(slots);
            this.processActivation(act);
        } else {
            this.propagate(act);
        }
        Link ol = act.link(oe, inputAct);
        act.doc.linker.link(act, ol);
    }

    private Activation lookupActivation(Document doc, SortedMap<Integer, Position> slots, OrEntry oe, NodeActivation inputAct) {
        block0: for (Activation act : ((INeuron)this.neuron.get(doc)).getThreadState(doc.threadId, true).getActivations(slots)) {
            Synapse ls = null;
            boolean matched = false;
            for (Activation.Link l : act.getInputLinksOrderedBySynapse()) {
                if (ls != null && ls != l.synapse) {
                    if (!matched) continue block0;
                    matched = false;
                }
                if (l.synapse.identity) {
                    Integer i = oe.revSynapseIds.get(l.synapse.id);
                    if (i != null && l.input == doc.linker.computeInputActivation(l.synapse, inputAct.getInputActivation(i))) {
                        matched = true;
                    }
                } else {
                    matched = true;
                }
                ls = l.synapse;
            }
            if (!matched) continue;
            return act;
        }
        return null;
    }

    @Override
    public void propagate(Activation act) {
        act.doc.ubQueue.add(act);
    }

    @Override
    public void processActivation(Activation act) {
        super.processActivation(act);
        ((INeuron)this.neuron.get(act.doc)).register(act);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void apply(Activation act) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void discover(Activation act, PatternDiscovery.Config config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCandidate(Node<?, ? extends NodeActivation<?>> parentNode, NodeActivation inputAct, boolean train) {
        Document doc = inputAct.doc;
        try {
            parentNode.lock.acquireReadLock();
            if (parentNode.orChildren != null) {
                for (OrEntry oe : parentNode.orChildren) {
                    oe.child.get(doc).addInputActivation(oe, inputAct);
                }
            }
        }
        finally {
            parentNode.lock.releaseReadLock();
        }
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((AbstractNode)act.node).propagate((NodeActivation)act);
            }
        }
    }

    public void addInput(int[] synapseIds, int threadId, Node in, boolean andMode) {
        Model cfr_ignored_0 = this.provider.model;
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), 1);
        OrEntry oe = new OrEntry(synapseIds, in.provider, this.provider);
        in.addOrChild(oe);
        in.setModified();
        if (andMode) {
            this.lock.acquireWriteLock();
            this.setModified();
            this.andParents.add(oe);
            this.lock.releaseWriteLock();
        }
    }

    void remove(int threadId) {
        ((INeuron)this.neuron.get()).remove();
        super.remove();
        try {
            this.lock.acquireReadLock();
            this.removeParents(threadId);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void removeParents(int threadId) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            Model cfr_ignored_0 = this.provider.model;
            pn.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
            pn.removeOrChild(oe);
            pn.setModified();
        }
        this.andParents.clear();
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        for (OrEntry oe : this.andParents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(oe.parent.get().logicToString());
            if (i > 2) {
                sb.append(",...");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(79);
        super.write(out);
        out.writeInt(this.neuron.id);
        out.writeInt(this.andParents.size());
        for (OrEntry oe : this.andParents) {
            oe.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.neuron = m.lookupNeuron(in.readInt());
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            this.andParents.add(OrEntry.read(in, m));
        }
    }

    @Override
    public String getNeuronLabel() {
        String l = this.neuron.getLabel();
        return l != null ? l : "";
    }

    public static class Link {
        public OrEntry oe;
        public NodeActivation<?> input;
        public OrActivation output;

        public Link(OrEntry oe, NodeActivation<?> input, OrActivation output) {
            this.oe = oe;
            this.input = input;
            this.output = output;
        }
    }

    public static class OrActivation
    extends NodeActivation<OrNode> {
        public Map<Integer, Link> orInputs = new TreeMap<Integer, Link>();

        public OrActivation(int id, Document doc, OrNode node) {
            super(id, doc, node);
        }

        @Override
        public Activation getInputActivation(int i) {
            throw new UnsupportedOperationException();
        }

        public Link link(OrEntry oe, NodeActivation<?> input) {
            Link l = new Link(oe, input, this);
            this.orInputs.put(input.id, l);
            input.outputsToOrNode.put(this.id, l);
            return l;
        }
    }

    public static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public int[] synapseIds;
        public TreeMap<Integer, Integer> revSynapseIds = new TreeMap();
        public Provider<? extends Node> parent;
        public Provider<OrNode> child;

        private OrEntry() {
        }

        public OrEntry(int[] synapseIds, Provider<? extends Node> parent, Provider<OrNode> child) {
            this.synapseIds = synapseIds;
            for (int ofs = 0; ofs < synapseIds.length; ++ofs) {
                this.revSynapseIds.put(synapseIds[ofs], ofs);
            }
            this.parent = parent;
            this.child = child;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.synapseIds.length);
            for (int i = 0; i < this.synapseIds.length; ++i) {
                Integer ofs = this.synapseIds[i];
                out.writeBoolean(ofs != null);
                out.writeInt(ofs);
            }
            out.writeInt(this.parent.id);
            out.writeInt(this.child.id);
        }

        public static OrEntry read(DataInput in, Model m) throws IOException {
            OrEntry rv = new OrEntry();
            rv.readFields(in, m);
            return rv;
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            int l = in.readInt();
            this.synapseIds = new int[l];
            for (int i = 0; i < l; ++i) {
                if (!in.readBoolean()) continue;
                Integer ofs = in.readInt();
                this.synapseIds[i] = ofs;
                this.revSynapseIds.put(ofs, i);
            }
            this.parent = m.lookupNodeProvider(in.readInt());
            this.child = m.lookupNodeProvider(in.readInt());
        }

        @Override
        public int compareTo(OrEntry oe) {
            int r = this.child.compareTo(oe.child);
            if (r != 0) {
                return r;
            }
            r = this.parent.compareTo(oe.parent);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.synapseIds.length, oe.synapseIds.length);
            if (r != 0) {
                return r;
            }
            for (int i = 0; i < this.synapseIds.length; ++i) {
                r = Integer.compare(this.synapseIds[i], oe.synapseIds[i]);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }
}

