/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.Utils;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Candidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = Integer.MAX_VALUE;
    public static boolean ENABLE_CACHING = true;
    public static boolean OPTIMIZE_SEARCH = true;
    public static boolean COMPUTE_SOFT_MAX = false;
    public int id;
    SearchNode excludedParent;
    SearchNode selectedParent;
    long visited;
    public Candidate candidate;
    int level;
    DebugState debugState;
    double weightDelta;
    public double accumulatedWeight = 0.0;
    public Map<Activation, Activation.StateChange> modifiedActs = new TreeMap<Activation, Activation.StateChange>(Activation.ACTIVATION_ID_COMP);
    private Step step = Step.INIT;
    private Decision preDecision;
    private SearchNode selectedChild = null;
    private SearchNode excludedChild = null;
    private double selectedWeight = 0.0;
    private double excludedWeight = 0.0;
    private double selectedWeightExpSum = 0.0;
    private double excludedWeightExpSum = 0.0;
    private long processVisited;
    private boolean bestPath;
    private Decision skip = Decision.UNKNOWN;

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, int level) {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        Candidate c = this.getParent() != null ? this.getParent().candidate : null;
        SearchNode csn = null;
        boolean modified = true;
        if (c != null) {
            c.currentSearchNode = this;
            csn = c.cachedSearchNode;
            if (csn == null || csn.getDecision() != this.getDecision()) {
                Activation act = c.activation;
                act.markDirty(this.visited);
                act.getOutputLinks(false).forEach(l -> l.output.markDirty(this.visited));
            } else {
                modified = csn.isModified();
                if (modified) {
                    c.debugComputed[2] = c.debugComputed[2] + 1;
                }
            }
        }
        if (modified) {
            this.weightDelta = doc.vQueue.process(this);
            this.markDirty();
            if (c != null) {
                c.cachedSearchNode = this;
            }
        } else if (ENABLE_CACHING) {
            c.cachedSearchNode.changeState(Activation.Mode.NEW);
            this.weightDelta = c.cachedSearchNode.weightDelta;
            for (Activation act : c.cachedSearchNode.modifiedActs.keySet()) {
                act.saveOldState(this.modifiedActs, doc.visitedCounter++);
                act.saveNewState();
            }
        } else {
            this.weightDelta = doc.vQueue.process(this);
            if (Math.abs(this.weightDelta - csn.weightDelta) > 1.0E-5 || !this.compareNewState(csn)) {
                log.error("Cached search node activation do not match the newly computed results.");
                log.info("Computed results:");
                this.dumpDebugState();
                log.info("Cached results:");
                csn.dumpDebugState();
            }
        }
        if (c != null) {
            int[] nArray = c.debugComputed;
            int n = modified ? 1 : 0;
            nArray[n] = nArray[n] + 1;
        }
        if (this.getParent() != null) {
            SearchNode pn = this.getParent();
            this.accumulatedWeight = this.weightDelta + pn.accumulatedWeight;
        }
    }

    private boolean isModified() {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            if (sc.getActivation().markedDirty > this.visited || sc.newState != sc.getActivation().decision) {
                return true;
            }
            if (!sc.newRounds.isActive() || !sc.getActivation().getOutputLinks(false).anyMatch(l -> l.output.decision != Decision.UNKNOWN && l.output.markedDirty > this.visited)) continue;
            return true;
        }
        return false;
    }

    private void markDirty() {
        if (this.getParent() == null || this.getParent().candidate == null) {
            return;
        }
        SearchNode csn = this.getParent().candidate.cachedSearchNode;
        TreeSet<Activation> acts = new TreeSet<Activation>(Activation.ACTIVATION_ID_COMP);
        acts.addAll(this.modifiedActs.keySet());
        if (csn != null) {
            acts.addAll(csn.modifiedActs.keySet());
        }
        acts.forEach(act -> {
            Activation.StateChange scb;
            Activation.StateChange sca = this.modifiedActs.get(act);
            Activation.StateChange stateChange = scb = csn != null ? searchNode.modifiedActs.get(act) : null;
            if (sca == null || scb == null || !sca.newRounds.compare(scb.newRounds)) {
                act.getOutputLinks(false).forEach(l -> l.output.markDirty(this.visited));
            }
        });
    }

    public boolean compareNewState(SearchNode cachedNode) {
        if (this.modifiedActs == null && cachedNode.modifiedActs == null) {
            return true;
        }
        if (this.modifiedActs == null || cachedNode.modifiedActs == null) {
            return false;
        }
        if (this.modifiedActs.size() != cachedNode.modifiedActs.size()) {
            return false;
        }
        for (Map.Entry<Activation, Activation.StateChange> me : this.modifiedActs.entrySet()) {
            Activation.StateChange sca = me.getValue();
            Activation.StateChange scb = cachedNode.modifiedActs.get(me.getKey());
            if (sca.newRounds.compare(scb.newRounds)) continue;
            return false;
        }
        return true;
    }

    public void dumpDebugState() {
        String weights = "";
        Decision decision = Decision.UNKNOWN;
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            System.out.println(n.level + " " + (Object)((Object)n.debugState) + " DECISION:" + (Object)((Object)decision) + weights + " " + (n.candidate != null ? n.candidate.toString() : "") + " MOD-ACTS:" + n.modifiedActs.size());
            decision = n.getDecision();
            weights = " AW:" + Utils.round(n.accumulatedWeight) + " DW:" + Utils.round(n.weightDelta);
        }
    }

    public static void search(Document doc, SearchNode root, long v, Long timeoutInMilliSeconds) throws TimeoutException {
        SearchNode sn = root;
        double returnWeight = 0.0;
        double returnWeightExpSum = 0.0;
        long startTime = System.currentTimeMillis();
        do {
            if (sn.processVisited != v) {
                sn.step = Step.INIT;
                sn.processVisited = v;
            }
            switch (sn.step) {
                case INIT: {
                    if (sn.level >= doc.candidates.size()) {
                        if (timeoutInMilliSeconds != null && System.currentTimeMillis() > startTime + timeoutInMilliSeconds) {
                            throw new TimeoutException("Interpretation search took too long: " + (System.currentTimeMillis() - startTime) + "ms");
                        }
                        returnWeight = sn.processResult(doc);
                        returnWeightExpSum = Math.exp(returnWeight);
                        sn.step = Step.FINAL;
                        sn = sn.getParent();
                        break;
                    }
                    sn.initStep(doc);
                    sn.step = Step.PREPARE_SELECT;
                    break;
                }
                case PREPARE_SELECT: {
                    sn.step = sn.prepareSelectStep(doc) ? Step.SELECT : Step.PREPARE_EXCLUDE;
                    break;
                }
                case SELECT: {
                    sn.step = Step.POST_SELECT;
                    sn = sn.selectedChild;
                    break;
                }
                case POST_SELECT: {
                    sn.selectedWeight = returnWeight;
                    sn.selectedWeightExpSum = returnWeightExpSum;
                    sn.storeSearchState(returnWeightExpSum);
                    sn.postReturn(sn.selectedChild);
                    sn.step = Step.PREPARE_EXCLUDE;
                    break;
                }
                case PREPARE_EXCLUDE: {
                    sn.step = sn.prepareExcludeStep(doc) ? Step.EXCLUDE : Step.FINAL;
                    break;
                }
                case EXCLUDE: {
                    sn.step = Step.POST_EXCLUDE;
                    sn = sn.excludedChild;
                    break;
                }
                case POST_EXCLUDE: {
                    sn.excludedWeight = returnWeight;
                    sn.excludedWeightExpSum = returnWeightExpSum;
                    sn.postReturn(sn.excludedChild);
                    sn.step = sn.candidate.repeat && OPTIMIZE_SEARCH ? Step.PREPARE_SELECT : Step.FINAL;
                    break;
                }
                case FINAL: {
                    returnWeight = sn.finalStep();
                    returnWeightExpSum = sn.getWeightExpSum();
                    SearchNode pn = sn.getParent();
                    if (pn != null) {
                        pn.skip = sn.getDecision();
                    }
                    sn = pn;
                    break;
                }
            }
        } while (sn != null);
    }

    public double getWeightExpSum() {
        return this.selectedWeightExpSum + this.excludedWeightExpSum;
    }

    private void initStep(Document doc) {
        this.candidate = doc.candidates.get(this.level);
        boolean precondition = this.candidate.activation.isActiveable();
        this.preDecision = this.candidate.activation.inputDecision;
        if (this.preDecision == Decision.UNKNOWN && (!precondition || this.checkExcluded(this.candidate.activation))) {
            this.preDecision = Decision.EXCLUDED;
        }
        if (this.preDecision == Decision.UNKNOWN && !this.candidate.isConflicting()) {
            this.preDecision = Decision.SELECTED;
        }
        if (this.preDecision == Decision.UNKNOWN && OPTIMIZE_SEARCH) {
            Decision cd = this.getCachedDecision();
            switch (cd) {
                case SELECTED: {
                    this.excludedWeightExpSum = this.candidate.alternativeCachedWeightExpSum;
                    break;
                }
                case EXCLUDED: {
                    this.selectedWeightExpSum = this.candidate.alternativeCachedWeightExpSum;
                }
            }
            this.preDecision = cd;
        }
        if (doc.searchStepCounter > MAX_SEARCH_STEPS) {
            this.dumpDebugState();
            throw new RuntimeException("Max search step exceeded.");
        }
        ++doc.searchStepCounter;
        this.storeDebugInfos();
    }

    private Decision getCachedDecision() {
        return this.preDecision != Decision.EXCLUDED ? this.candidate.cachedDecision : Decision.UNKNOWN;
    }

    private boolean prepareSelectStep(Document doc) {
        this.candidate.repeat = false;
        if (this.preDecision == Decision.EXCLUDED) {
            return false;
        }
        if (this.skip == Decision.SELECTED) {
            return false;
        }
        if (doc.model.getSkipSelectStep().evaluate(this.candidate.activation)) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.SELECTED, this.visited);
        if (this.candidate.cachedDecision == Decision.UNKNOWN) {
            this.invalidateCachedDecisions();
        }
        this.selectedChild = new SearchNode(doc, this, this.excludedParent, this.level + 1);
        this.candidate.debugDecisionCounts[0] = this.candidate.debugDecisionCounts[0] + 1;
        return true;
    }

    private boolean prepareExcludeStep(Document doc) {
        if (this.preDecision == Decision.SELECTED) {
            return false;
        }
        if (this.skip == Decision.EXCLUDED) {
            return false;
        }
        if (this.preDecision != Decision.EXCLUDED && this.generatesUnsuppressedExcluded()) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.EXCLUDED, this.visited);
        this.excludedChild = new SearchNode(doc, this.selectedParent, this, this.level + 1);
        this.candidate.debugDecisionCounts[1] = this.candidate.debugDecisionCounts[1] + 1;
        return true;
    }

    private boolean generatesUnsuppressedExcluded() {
        block0: for (Activation cAct : this.candidate.activation.getConflicts()) {
            if (cAct.decision != Decision.EXCLUDED) continue;
            for (Activation icAct : cAct.getConflicts()) {
                if (this.candidate.activation == icAct || icAct.decision == Decision.EXCLUDED) continue;
                continue block0;
            }
            return true;
        }
        for (Activation cAct : this.candidate.activation.getConflicts()) {
            if (cAct.decision == Decision.EXCLUDED) continue;
            return false;
        }
        return true;
    }

    private void postReturn(SearchNode child) {
        child.changeState(Activation.Mode.OLD);
        this.candidate.activation.setDecision(Decision.UNKNOWN, this.visited);
        this.candidate.activation.rounds.reset();
    }

    private double finalStep() {
        SearchNode cn;
        Decision d;
        Decision cd = this.getCachedDecision();
        if (cd == Decision.UNKNOWN) {
            Decision decision = this.preDecision != Decision.UNKNOWN ? this.preDecision : (d = this.selectedWeight >= this.excludedWeight ? Decision.SELECTED : Decision.EXCLUDED);
            if (this.preDecision != Decision.EXCLUDED) {
                this.candidate.cachedDecision = d;
                switch (this.candidate.cachedDecision) {
                    case SELECTED: {
                        this.candidate.alternativeCachedWeightExpSum = this.excludedWeightExpSum;
                        break;
                    }
                    case EXCLUDED: {
                        this.candidate.alternativeCachedWeightExpSum = this.selectedWeightExpSum;
                    }
                }
            }
        } else {
            d = cd;
        }
        SearchNode searchNode = cn = d == Decision.SELECTED ? this.selectedChild : this.excludedChild;
        if (cn != null && cn.bestPath) {
            this.candidate.bestChildNode = cn;
            this.bestPath = true;
        }
        if (!this.bestPath || d != Decision.SELECTED) {
            this.selectedChild = null;
        }
        if (!this.bestPath || d != Decision.EXCLUDED) {
            this.excludedChild = null;
        }
        return d == Decision.SELECTED ? this.selectedWeight : this.excludedWeight;
    }

    private void invalidateCachedDecisions() {
        this.candidate.activation.getOutputLinks(false).filter(l -> !l.synapse.isNegative()).forEach(l -> SearchNode.invalidateCachedDecision(l.output));
    }

    public static void invalidateCachedDecision(Activation act) {
        Candidate pos = act.candidate;
        if (pos != null && pos.cachedDecision == Decision.EXCLUDED) {
            pos.cachedDecision = Decision.UNKNOWN;
            pos.repeat = true;
        }
        for (Activation c : act.getConflicts()) {
            Candidate neg = c.candidate;
            if (neg == null || neg.cachedDecision != Decision.SELECTED) continue;
            neg.cachedDecision = Decision.UNKNOWN;
        }
    }

    private double processResult(Document doc) {
        double accNW = this.accumulatedWeight;
        if (this.level > doc.selectedSearchNode.level || accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
            SearchNode.storeFinalState(this);
            this.bestPath = true;
        } else {
            this.bestPath = false;
        }
        if (COMPUTE_SOFT_MAX) {
            this.dumpDebugState();
            System.out.println(this.accumulatedWeight);
            System.out.println();
        }
        return this.accumulatedWeight;
    }

    private void storeSearchState(double interpretationWeight) {
        if (COMPUTE_SOFT_MAX) {
            Activation act = this.candidate.activation;
            if (act.searchStates == null) {
                act.searchStates = new ArrayList<Activation.AvgState>();
            }
            act.searchStates.add(new Activation.AvgState(act.rounds.getLast(), interpretationWeight));
        }
    }

    private static void storeFinalState(SearchNode sn) {
        while (sn != null) {
            if (sn.candidate != null) {
                Activation act = sn.candidate.activation;
                act.finalRounds = act.rounds.copy();
                act.finalDecision = act.decision;
            }
            sn = sn.getParent();
        }
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight : -1.0;
    }

    private boolean checkExcluded(Activation ref) {
        for (Activation cn : ref.getConflicts()) {
            if (cn.decision != Decision.SELECTED) continue;
            return true;
        }
        return false;
    }

    public String pathToString() {
        return (this.selectedParent != null ? this.selectedParent.pathToString() : "") + " - " + this.toString();
    }

    public String toString() {
        return this.candidate.activation.id + " Decision:" + (Object)((Object)this.getDecision());
    }

    public void changeState(Activation.Mode m) {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public SearchNode getParent() {
        return this.getDecision() == Decision.SELECTED ? this.selectedParent : this.excludedParent;
    }

    public Decision getDecision() {
        return this.excludedParent == null || this.selectedParent != null && this.selectedParent.id > this.excludedParent.id ? Decision.SELECTED : Decision.EXCLUDED;
    }

    private void storeDebugInfos() {
        this.debugState = this.preDecision != Decision.UNKNOWN ? DebugState.LIMITED : (this.getCachedDecision() != Decision.UNKNOWN ? DebugState.CACHED : DebugState.EXPLORE);
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
    }

    public static interface SkipSelectStep {
        public boolean evaluate(Activation var1);
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException(String message) {
            super(message);
        }
    }

    private static enum Step {
        INIT,
        PREPARE_SELECT,
        SELECT,
        POST_SELECT,
        PREPARE_EXCLUDE,
        EXCLUDE,
        POST_EXCLUDE,
        FINAL;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }

    public static enum Decision {
        SELECTED('S'),
        EXCLUDED('E'),
        UNKNOWN('U');

        char s;

        private Decision(char s) {
            this.s = s;
        }
    }
}

