/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public abstract class AncestorRelation
extends Relation {
    public static AncestorRelation COMMON_ANCESTOR = new CommonAncestor();
    public static AncestorRelation IS_DESCENDANT_OF = new IsDescendantOf();
    public static AncestorRelation IS_ANCESTOR_OF = new IsAncestorOf();
    public static AncestorRelation NOT_DESCENDANT_OF = new NotDescendantOf();
    public static AncestorRelation NOT_ANCESTOR_OF = new NotAncestorOf();

    AncestorRelation() {
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
    }

    private static void collectCommonAncestor(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        AncestorRelation.collectContains(results, n, linkedAct, v);
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.collectCommonAncestor(results, n, l2.input, v));
    }

    private static void collectContains(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getOutputLinks(false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.collectContains(results, n, l2.output, v));
    }

    private static void collectContainedIn(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.visited == v) {
            return;
        }
        linkedAct.visited = v;
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.collectContainedIn(results, n, l2.input, v));
    }

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
    }

    private static boolean contains(Activation actA, Activation actB, long v) {
        if (actA.visited == v) {
            return false;
        }
        actA.visited = v;
        if (actA == actB) {
            return true;
        }
        return actA.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l2 -> AncestorRelation.contains(l2.input, actB, v));
    }

    private static boolean hasCommonAncestor(Activation act, Activation linkedAct) {
        long v = act.doc.visitedCounter++;
        AncestorRelation.markAncestors(linkedAct, v);
        return AncestorRelation.hasCommonAncestor(act, v, act.doc.visitedCounter++);
    }

    private static void markAncestors(Activation act, long v) {
        if (act.visited == v) {
            return;
        }
        act.visited = v;
        act.markedAncDesc = v;
        act.getInputLinks(false, false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.markAncestors(l2.input, v));
    }

    private static void markDescendants(Activation act, long v) {
        if (act.visited == v) {
            return;
        }
        act.visited = v;
        act.markedAncDesc = v;
        act.getOutputLinks(false).filter(l -> l.synapse.identity).forEach(l2 -> AncestorRelation.markDescendants(l2.input, v));
    }

    private static boolean hasCommonAncestor(Activation act, long v1, long v2) {
        if (act.visited == v2) {
            return false;
        }
        act.visited = v2;
        if (act.markedAncDesc == v1) {
            return true;
        }
        return act.getInputLinks(false, false).filter(l -> l.synapse.identity).anyMatch(l3 -> AncestorRelation.hasCommonAncestor(l3.input, v1, v2));
    }

    @Override
    public boolean isExact() {
        return false;
    }

    public static class NotAncestorOf
    extends AncestorRelation {
        public static int TYPE = 54;

        public NotAncestorOf() {
        }

        public NotAncestorOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new NotDescendantOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new NotAncestorOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return !AncestorRelation.contains(linkedAct, act, act.doc.visitedCounter++);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            long v = linkedAct.doc.visitedCounter++;
            AncestorRelation.markAncestors(linkedAct, v);
            INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
            return th.getActivations().filter(act -> act.markedAncDesc != v);
        }

        static {
            NotAncestorOf.registerRelation(TYPE, () -> NOT_ANCESTOR_OF);
        }
    }

    public static class NotDescendantOf
    extends AncestorRelation {
        public static int TYPE = 53;

        public NotDescendantOf() {
        }

        public NotDescendantOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new NotAncestorOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new NotDescendantOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return !AncestorRelation.contains(act, linkedAct, act.doc.visitedCounter++);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            long v = linkedAct.doc.visitedCounter++;
            AncestorRelation.markDescendants(linkedAct, v);
            INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
            return th.getActivations().filter(act -> act.markedAncDesc != v);
        }

        static {
            NotDescendantOf.registerRelation(TYPE, () -> NOT_DESCENDANT_OF);
        }
    }

    public static class IsAncestorOf
    extends AncestorRelation {
        public static int TYPE = 52;

        public IsAncestorOf() {
        }

        public IsAncestorOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new IsDescendantOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new IsAncestorOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.contains(linkedAct, act, act.doc.visitedCounter++);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList results = new ArrayList();
            AncestorRelation.collectContainedIn(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            return results.stream();
        }

        static {
            IsAncestorOf.registerRelation(TYPE, () -> IS_ANCESTOR_OF);
        }
    }

    public static class IsDescendantOf
    extends AncestorRelation {
        public static int TYPE = 51;

        public IsDescendantOf() {
        }

        public IsDescendantOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new IsAncestorOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new IsDescendantOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.contains(act, linkedAct, act.doc.visitedCounter++);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList results = new ArrayList();
            AncestorRelation.collectContains(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            return results.stream();
        }

        static {
            IsDescendantOf.registerRelation(TYPE, () -> IS_DESCENDANT_OF);
        }
    }

    public static class CommonAncestor
    extends AncestorRelation {
        public static int TYPE = 50;

        public CommonAncestor() {
        }

        public CommonAncestor(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new CommonAncestor(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new CommonAncestor(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.hasCommonAncestor(act, linkedAct);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList results = new ArrayList();
            AncestorRelation.collectCommonAncestor(results, n, linkedAct, linkedAct.doc.visitedCounter++);
            return results.stream();
        }

        static {
            CommonAncestor.registerRelation(TYPE, () -> COMMON_ANCESTOR);
        }
    }
}

