/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.HashSet;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.corpus.Range;

public class Document
implements Comparable<Document> {
    public final int id = docIdCounter++;
    public static int docIdCounter = 0;
    private String content;
    public int optionIdCounter = 1;
    public int expandNodeIdCounter = 0;
    public Option bottom = new Option(this, -1, 0, 0);
    public ExpandNode root = ExpandNode.createInitialExpandNode(this);
    public ExpandNode selectedExpandNode = null;
    public Option selectedOption = null;
    public long selectedMark = -1L;

    public Document(String content) {
        this.content = content;
    }

    public static Document create(String content) {
        return new Document(content);
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String getText(Range r) {
        return this.content.substring(Math.max(0, Math.min(r.begin, this.length())), Math.max(0, Math.min(r.end, this.length())));
    }

    public String conflictsToString() {
        HashSet<Option> conflicts = new HashSet<Option>();
        this.bottom.collectConflicts(conflicts, Option.visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("Conflicts:\n");
        for (Option n : conflicts) {
            sb.append(n.conflicts.primaryToString());
        }
        sb.append("\n");
        return sb.toString();
    }

    public String selectedOptionsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected Options:\n");
        sb.append(this.selectedOption.toString());
        sb.append("\n");
        return sb.toString();
    }

    public boolean contains(Range r) {
        return r.begin >= 0 && r.end <= this.length();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }
}

