/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.neuron.Neuron;

public class ExpandNode
implements Comparable<ExpandNode> {
    public static boolean INCOMPLETE_OPTIMIZATION = false;
    public static int MAX_SEARCH_STEPS = 10000;
    public int id;
    ExpandNode excludedParent;
    ExpandNode selectedParent;
    ExpandNode parent;
    long visited;
    Option refinement;
    Neuron.NormWeight weightDelta = Neuron.NormWeight.ZERO_WEIGHT;
    public List<StateChange> modifiedActs = new ArrayList<StateChange>();
    public TreeSet<ExpandNode> candidates = new TreeSet();

    public ExpandNode(ExpandNode parent) {
        this.parent = parent;
    }

    private void collectResults(Collection<Option> results) {
        results.add(this.refinement);
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    private void markSelected(long v) {
        this.refinement.markSelected(v);
        if (this.selectedParent != null) {
            this.selectedParent.markSelected(v);
        }
    }

    public static ExpandNode createInitialExpandNode(Document doc) {
        ArrayList<Option> changed = new ArrayList<Option>();
        changed.add(doc.bottom);
        return ExpandNode.createCandidate(doc, changed, null, null, null, doc.bottom);
    }

    public void computeSelectedOption(Iteration t) {
        Document doc = t.doc;
        ArrayList<Option> results = new ArrayList<Option>();
        results.add(doc.bottom);
        try {
            doc.selectedExpandNode = null;
            int[] searchSteps = new int[1];
            List<Option> rootRefs = ExpandNode.expandRootRefinement(doc);
            this.refinement = this.expandRefinement(Option.add(doc, false, rootRefs.toArray(new Option[rootRefs.size()])));
            this.markCovered(null, this.visited, this.refinement);
            this.markExcluded(null, this.visited, this.refinement);
            this.weightDelta = t.vQueue.adjustWeight(this, rootRefs);
            if (Iteration.OPTIMIZE_DEBUG_OUTPUT) {
                System.out.println("Root ExpandNode:" + this.toString());
            }
            doc.selectedExpandNode = doc.root;
            doc.selectedMark = Option.visitedCounter++;
            this.markSelected(doc.selectedMark);
            doc.bottom.storeFinalWeight(Option.visitedCounter++);
            this.generateInitialCandidates(t);
            ExpandNode child = doc.root.selectCandidate();
            if (child != null) {
                child.search(t, doc.root, null, searchSteps);
            }
            if (doc.selectedExpandNode != null) {
                doc.selectedExpandNode.reconstructSelectedResult(t);
                doc.selectedExpandNode.collectResults(results);
                System.out.println("Selected ExandNode ID: " + doc.selectedExpandNode.id);
            }
        }
        catch (ExpandNodeException e) {
            System.err.println("Too many search steps!");
        }
        doc.selectedOption = Option.add(doc, true, results.toArray(new Option[results.size()]));
    }

    private void reconstructSelectedResult(Iteration t) {
        if (this.selectedParent != null) {
            this.selectedParent.reconstructSelectedResult(t);
        }
        this.changeState(StateChange.Mode.NEW);
        for (StateChange sc : this.modifiedActs) {
            Activation act = sc.act;
            if (act.finalState == null || !(act.finalState.value > 0.0)) continue;
            t.activatedNeurons.add(act.key.n.neuron);
        }
    }

    private void search(Iteration t, ExpandNode selectedParent, ExpandNode excludedParent, int[] searchSteps) {
        ExpandNode child;
        Document doc = t.doc;
        if (searchSteps[0] > MAX_SEARCH_STEPS) {
            throw new ExpandNodeException();
        }
        searchSteps[0] = searchSteps[0] + 1;
        this.markCovered(null, this.visited, this.refinement);
        this.markExcluded(null, this.visited, this.refinement);
        if (Iteration.OPTIMIZE_DEBUG_OUTPUT) {
            System.out.println("Search Step: " + this.id);
            System.out.println(this.toString());
        }
        boolean f = doc.selectedMark == -1L || this.refinement.markedSelected != doc.selectedMark;
        this.changeState(StateChange.Mode.NEW);
        if (Iteration.OPTIMIZE_DEBUG_OUTPUT) {
            System.out.println(t.networkStateToString(true, true));
            System.out.println();
        }
        double accNW = this.computeAccumulatedWeight().getNormWeight();
        double selectedAccNW = doc.selectedExpandNode != null ? doc.selectedExpandNode.computeAccumulatedWeight().getNormWeight() : 0.0;
        this.generateNextLevelCandidates(t, selectedParent, excludedParent);
        if (this.candidates.size() == 0 && accNW > selectedAccNW) {
            doc.selectedExpandNode = this;
            doc.selectedMark = Option.visitedCounter++;
            this.markSelected(doc.selectedMark);
            doc.bottom.storeFinalWeight(Option.visitedCounter++);
        }
        if ((child = this.selectCandidate()) != null) {
            child.search(t, this, excludedParent, searchSteps);
        }
        this.changeState(StateChange.Mode.OLD);
        if ((f || !INCOMPLETE_OPTIMIZATION) && (child = selectedParent.selectCandidate()) != null) {
            child.search(t, selectedParent, this, searchSteps);
        }
    }

    private ExpandNode selectCandidate() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.pollFirst();
    }

    public void generateInitialCandidates(Iteration t) {
        this.candidates = new TreeSet();
        for (Option cn : ExpandNode.collectConflicts(t.doc)) {
            ArrayList<Option> changed = new ArrayList<Option>();
            ExpandNode c = ExpandNode.createCandidate(t.doc, changed, this, this, null, cn);
            c.weightDelta = t.vQueue.adjustWeight(c, changed);
            if (Iteration.OPTIMIZE_DEBUG_OUTPUT) {
                System.out.println("Search Step: " + c.id + "  Candidate Weight Delta: " + c.weightDelta);
                System.out.println(t.networkStateToString(true, true));
                System.out.println();
            }
            c.changeState(StateChange.Mode.OLD);
            this.candidates.add(c);
        }
    }

    public void generateNextLevelCandidates(Iteration t, ExpandNode selectedParent, ExpandNode excludedParent) {
        this.candidates = new TreeSet();
        for (ExpandNode pc : selectedParent.candidates) {
            if (this.isCovered(pc.refinement.markedCovered) || this.checkExcluded(pc.refinement, Option.visitedCounter++) || pc.refinement.contains(this.refinement, false)) continue;
            ArrayList<Option> changed = new ArrayList<Option>();
            ExpandNode c = ExpandNode.createCandidate(t.doc, changed, this, this, excludedParent, pc.refinement);
            c.weightDelta = t.vQueue.adjustWeight(c, changed);
            c.changeState(StateChange.Mode.OLD);
            this.candidates.add(c);
        }
    }

    private boolean checkExcluded(Option ref, long v) {
        if (ref.visitedCheckExcluded == v) {
            return false;
        }
        ref.visitedCheckExcluded = v;
        if (this.isCovered(ref.markedExcluded)) {
            return true;
        }
        for (Option pn : ref.parents) {
            if (!this.checkExcluded(pn, v)) continue;
            return true;
        }
        return false;
    }

    public static List<Option> collectConflicts(Document doc) {
        ArrayList<Option> results = new ArrayList<Option>();
        long v = Option.visitedCounter++;
        for (Option n : doc.bottom.children) {
            for (Conflicts.Conflict c : n.conflicts.primary.values()) {
                if (c.secondary.visitedCollectConflicts == v) continue;
                c.secondary.visitedCollectConflicts = v;
                results.add(c.secondary);
            }
        }
        return results;
    }

    private static List<Option> expandRootRefinement(Document doc) {
        ArrayList<Option> tmp = new ArrayList<Option>();
        tmp.add(doc.bottom);
        for (Option pn : doc.bottom.children) {
            if (pn.orOptions != null && !pn.orOptions.isEmpty() || !pn.conflicts.primary.isEmpty() || !pn.conflicts.secondary.isEmpty()) continue;
            tmp.add(pn);
        }
        return tmp;
    }

    private Option expandRefinement(Option ref) {
        ArrayList<Option> tmp = new ArrayList<Option>();
        tmp.add(ref);
        this.expandRefinementRecursiveStep(tmp, ref, Option.visitedCounter++);
        Option expRef = Option.add(ref.doc, false, tmp.toArray(new Option[tmp.size()]));
        if (ref == expRef) {
            return ref;
        }
        return this.expandRefinement(expRef);
    }

    private void expandRefinementRecursiveStep(Collection<Option> results, Option n, long v) {
        if (n.visitedExpandRefinementRecursiveStep == v) {
            return;
        }
        n.visitedExpandRefinementRecursiveStep = v;
        if (n.refByOrOption != null) {
            for (Option on : n.refByOrOption) {
                if (on.conflicts.hasConflicts()) continue;
                results.add(on);
            }
        }
        for (Option pn : n.parents) {
            this.expandRefinementRecursiveStep(results, pn, v);
        }
        if (n.isBottom()) {
            return;
        }
        for (Option cn : n.children) {
            if (cn.visitedExpandRefinementRecursiveStep == v) break;
            boolean covered = true;
            for (Option cnp : cn.parents) {
                if (cnp.visitedExpandRefinementRecursiveStep == v || this.isCovered(cnp.markedCovered)) continue;
                covered = false;
                break;
            }
            if (!covered) continue;
            this.expandRefinementRecursiveStep(results, cn, v);
        }
    }

    public Neuron.NormWeight computeAccumulatedWeight() {
        return this.selectedParent != null ? this.weightDelta.add(this.selectedParent.computeAccumulatedWeight()) : this.weightDelta;
    }

    public boolean isCovered(long g) {
        return g == this.visited || this.selectedParent != null && this.selectedParent.isCovered(g);
    }

    private boolean markCovered(List<Option> changed, long v, Option n) {
        if (n.visitedMarkCovered == v) {
            return false;
        }
        n.visitedMarkCovered = v;
        if (this.isCovered(n.markedCovered)) {
            return false;
        }
        n.markedCovered = v;
        if (n.isBottom()) {
            return false;
        }
        for (Option p : n.parents) {
            if (!this.markCovered(changed, v, p)) continue;
            return true;
        }
        for (Option c : n.children) {
            if (c.visitedMarkCovered == v || !this.containedInSelectedBranch(v, c)) continue;
            if (c.isConflicting(Option.visitedCounter++)) {
                return true;
            }
            c.markedCovered = v;
            if (!this.markCovered(changed, v, c)) continue;
            return true;
        }
        if (changed != null) {
            changed.add(n);
        }
        return false;
    }

    private void markExcluded(List<Option> changed, long v, Option n) {
        ArrayList<Option> conflicting = new ArrayList<Option>();
        Conflicts cfr_ignored_0 = n.conflicts;
        Conflicts.collectAllConflicting(conflicting, n, Option.visitedCounter++);
        for (Option cn : conflicting) {
            this.markExcludedRecursiveStep(changed, v, cn);
        }
    }

    private void markExcludedRecursiveStep(List<Option> changed, long v, Option n) {
        if (n.markedExcluded == v || this.isCovered(n.markedExcluded)) {
            return;
        }
        n.markedExcluded = v;
        for (Option c : n.children) {
            this.markExcludedRecursiveStep(changed, v, c);
        }
        if (n.linkedByLCS != null) {
            for (Option c : n.linkedByLCS) {
                this.markExcludedRecursiveStep(changed, v, c);
            }
        }
        if (changed != null) {
            changed.add(n);
        }
    }

    public boolean containedInSelectedBranch(long v, Option n) {
        for (Option p : n.parents) {
            if (p.markedCovered == v || this.isCovered(p.markedCovered)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return (this.selectedParent != null ? this.selectedParent.toString() : "") + "->" + this.refinement.toString() + ":" + this.computeAccumulatedWeight();
    }

    public static ExpandNode createCandidate(Document doc, List<Option> changed, ExpandNode parent, ExpandNode selectedParent, ExpandNode excludedParent, Option ref) {
        ExpandNode cand = new ExpandNode(parent);
        cand.id = doc.expandNodeIdCounter++;
        cand.visited = Option.visitedCounter++;
        cand.selectedParent = selectedParent;
        cand.excludedParent = excludedParent;
        cand.refinement = cand.expandRefinement(ref);
        cand.markCovered(changed, cand.visited, cand.refinement);
        cand.markExcluded(changed, cand.visited, cand.refinement);
        if (Iteration.OPTIMIZE_DEBUG_OUTPUT) {
            System.out.println();
            System.out.println();
            System.out.println("Generate Candidate: " + cand.refinement.toString());
        }
        return cand;
    }

    public void changeState(StateChange.Mode m) {
        for (StateChange sc : this.modifiedActs) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(ExpandNode c) {
        int r = Double.compare(c.computeAccumulatedWeight().getNormWeight(), this.computeAccumulatedWeight().getNormWeight());
        if (r != 0) {
            return r;
        }
        return this.refinement.compareTo(c.refinement);
    }

    public static class StateChange {
        public Activation act;
        public Activation.Rounds oldRounds;
        public Activation.Rounds newRounds;

        public static void saveOldState(List<StateChange> changes, Activation act, long v) {
            StateChange sc = act.currentStateChange;
            if (sc == null || act.currentStateV != v) {
                sc = new StateChange();
                sc.oldRounds = act.rounds.copy();
                act.currentStateChange = sc;
                act.currentStateV = v;
                sc.act = act;
                if (changes != null) {
                    changes.add(sc);
                }
            }
        }

        public static void saveNewState(Activation act) {
            StateChange sc = act.currentStateChange;
            sc.newRounds = act.rounds;
        }

        public void restoreState(Mode m) {
            this.act.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public static enum Mode {
            OLD,
            NEW;

        }
    }

    public static class ExpandNodeException
    extends RuntimeException {
    }
}

