/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.Model;
import org.aika.Utils;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.OrNode;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;
import org.apache.commons.math3.distribution.BinomialDistribution;

public class AndNode
extends Node {
    public static double SIGNIFICANCE_THRESHOLD = 0.98;
    public static int MAX_POS_NODES = 4;
    public static int MAX_RID_RANGE = 5;
    public SortedMap<Refinement, Node> parents = new TreeMap<Refinement, Node>();
    public volatile int numberOfPositionsNotify;
    public volatile int frequencyNotify;
    public double weight = -1.0;

    public AndNode() {
    }

    public AndNode(Iteration t, int level, SortedMap<Refinement, Node> parents) {
        super(t, level);
        this.parents = parents;
        Model m = t.m;
        ++m.stat.nodes;
        int n = level;
        m.stat.nodesPerLevel[n] = m.stat.nodesPerLevel[n] + 1;
        this.rangeVisibility = new Synapse.RangeVisibility[]{Synapse.RangeVisibility.MAX_OUTPUT, Synapse.RangeVisibility.MAX_OUTPUT};
        this.matchRange = new boolean[]{false, false};
        this.ridRequired = false;
        for (Map.Entry<Refinement, Node> me : parents.entrySet()) {
            Refinement ref = me.getKey();
            Node pn = me.getValue();
            pn.addAndChild(ref, this);
            if (!ref.input.key.isNeg && !ref.input.key.isRecurrent) {
                if (ref.input.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                    this.rangeVisibility[0] = Synapse.RangeVisibility.MATCH_INPUT;
                }
                if (ref.input.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                    this.rangeVisibility[1] = Synapse.RangeVisibility.MATCH_INPUT;
                }
                if (ref.input.key.startSignal != Synapse.RangeSignal.NONE && ref.input.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                    this.matchRange[0] = true;
                }
                if (ref.input.key.endSignal != Synapse.RangeSignal.NONE && ref.input.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                    this.matchRange[1] = true;
                }
            }
            if (ref.rid == null) continue;
            this.ridRequired = true;
        }
        this.endRequired = false;
    }

    @Override
    public boolean isAllowedOption(Iteration t, Option n, Activation act, long v) {
        Node.ThreadState th = this.getThreadState(t);
        if (th.visitedAllowedOption == v) {
            return false;
        }
        th.visitedAllowedOption = v;
        for (Activation pAct : act.inputs.values()) {
            if (!pAct.key.n.isAllowedOption(t, n, pAct, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Range preProcessAddedActivation(Iteration t, Activation.Key ak, Collection<Activation> inputActs) {
        for (Activation iAct : inputActs) {
            if (!iAct.isRemoved) continue;
            return null;
        }
        return ak.r;
    }

    public void addActivation(Iteration t, Activation.Key ak, Collection<Activation> directInputActs) {
        Node.addActivationAndPropagate(t, ak, directInputActs);
    }

    protected static void removeActivation(Iteration t, Activation iAct) {
        for (Activation act : iAct.outputs.values()) {
            if (!(act.key.n instanceof AndNode)) continue;
            Node.removeActivationAndPropagate(t, act, Collections.singleton(iAct));
        }
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Option removedConflict) {
        this.apply(t, act, removedConflict);
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act) {
        this.removeFromNextLevel(t, act);
    }

    @Override
    protected boolean hasSupport(Activation act) {
        int expected = this.parents.size();
        int support = 0;
        Activation lastAct = null;
        for (Activation iAct : act.inputs.values()) {
            if (!(iAct.isRemoved || lastAct != null && lastAct.key.n == iAct.key.n)) {
                ++support;
            }
            lastAct = iAct;
        }
        assert (support <= expected);
        return support == expected;
    }

    @Override
    public void computeNullHyp(Model m) {
        double avgSize = this.sizeSum / this.instanceSum;
        double n = (double)(m.numberOfPositions - this.nOffset) / avgSize;
        double nullHyp = 0.0;
        for (Map.Entry<Refinement, Node> me : this.parents.entrySet()) {
            Node pn = me.getValue();
            InputNode in = me.getKey().input;
            double inputNA = (double)(m.numberOfPositions - in.nOffset) / avgSize;
            double inputNB = (double)(m.numberOfPositions - pn.nOffset) / avgSize;
            double nh = Math.min(1.0, (double)in.frequency / inputNA) * Math.min(1.0, Math.max((double)pn.frequency, pn.nullHypFreq) / inputNB);
            nullHyp = Math.max(nullHyp, nh);
        }
        this.nullHypFreq = nullHyp * n;
    }

    public void updateWeight(Iteration t, long v) {
        Node.ThreadState th = this.getThreadState(t);
        Model m = t.m;
        if (this.isBlocked || m.numberOfPositions - this.nOffset == 0 || this.frequency < Node.minFrequency || th.visitedComputeWeight == v || this.numberOfPositionsNotify > m.numberOfPositions && this.frequencyNotify > this.frequency && Math.abs(this.nullHypFreq - this.oldNullHypFreq) < 0.01) {
            return;
        }
        th.visitedComputeWeight = v;
        double avgSize = this.sizeSum / this.instanceSum;
        double n = (double)(m.numberOfPositions - this.nOffset) / avgSize;
        t.m.numberOfPositionsQueue.remove(this);
        this.numberOfPositionsNotify = this.computeNotify(n) + m.numberOfPositions;
        t.m.numberOfPositionsQueue.add(this);
        BinomialDistribution binDist = new BinomialDistribution(null, (int)Math.round(n), this.nullHypFreq / n);
        this.weight = binDist.cumulativeProbability(this.frequency - 1);
        this.frequencyNotify = this.computeNotify(this.frequency) + this.frequency;
        this.oldNullHypFreq = this.nullHypFreq;
        if (this.weight >= SIGNIFICANCE_THRESHOLD) {
            // empty if block
        }
    }

    public int computeNotify(double x) {
        return 1 + (int)Math.floor(Math.pow(x, 1.15) - x);
    }

    public double computeFMeasure(Node.Similarity sim, Neuron n) {
        double fPattern = this.frequency - sim.nodeFreqOffset;
        double fNeuron = n.node.frequency - sim.neuronFreqOffset;
        double recall = (double)sim.frequency / fPattern;
        double precision = (double)sim.frequency / fNeuron;
        if (recall > 1.0 || precision > 1.0) assert (false);
        return 2.0 * precision * recall / (precision + recall);
    }

    @Override
    public void cleanup(Iteration t) {
        if (!(this.isRemoved || this.isFrequent() || this.isRequired())) {
            this.remove(t);
            for (Node p : this.parents.values()) {
                p.cleanup(t);
            }
        }
    }

    @Override
    public void apply(Iteration t, Activation act, Option removedConflict) {
        if (act.isRemoved) {
            return;
        }
        for (Activation pAct : act.inputs.values()) {
            Node pn = pAct.key.n;
            pn.lock.acquireReadLock();
            Refinement ref = pn.reverseAndChildren.get(new Node.ReverseAndRefinement(act.key.n, act.key.rid, pAct.key.rid));
            for (Activation secondAct : pAct.outputs.values()) {
                Refinement nRef;
                AndNode nlp;
                Refinement secondRef;
                if (act == secondAct || secondAct.isRemoved || (secondRef = pn.reverseAndChildren.get(new Node.ReverseAndRefinement(secondAct.key.n, secondAct.key.rid, pAct.key.rid))) == null || (nlp = this.getAndChild(nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input))) == null) continue;
                AndNode.addNextLevelActivation(t, act, secondAct, nlp, removedConflict);
            }
            pn.lock.releaseReadLock();
        }
        if (removedConflict == null) {
            OrNode.processCandidate(t, this, act, false);
        }
    }

    @Override
    public void discover(Iteration t, Activation act) {
        if (!this.isExpandable(true)) {
            return;
        }
        for (Activation pAct : act.inputs.values()) {
            Node pn = pAct.key.n;
            pn.lock.acquireReadLock();
            Refinement ref = pn.reverseAndChildren.get(new Node.ReverseAndRefinement(act.key.n, act.key.rid, pAct.key.rid));
            for (Activation secondAct : pAct.outputs.values()) {
                if (!(secondAct.key.n instanceof AndNode)) continue;
                Node secondNode = secondAct.key.n;
                Integer ridDelta = Utils.nullSafeSub(act.key.rid, false, secondAct.key.rid, false);
                if (act == secondAct || secondNode.isBlocked || !secondNode.isFrequent() || ridDelta != null && ridDelta >= MAX_RID_RANGE) continue;
                Refinement secondRef = pn.reverseAndChildren.get(new Node.ReverseAndRefinement(secondAct.key.n, secondAct.key.rid, pAct.key.rid));
                Refinement nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input);
                AndNode.createNextLevelNode(t, this, nRef, true);
            }
            pn.lock.releaseReadLock();
        }
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        if (checkFrequency && !this.isFrequent()) {
            return false;
        }
        int numPosNodes = 0;
        for (Refinement ref : this.parents.keySet()) {
            if (ref.input.key.isNeg) continue;
            ++numPosNodes;
        }
        return numPosNodes < MAX_POS_NODES;
    }

    private static boolean checkRidRange(SortedMap<Refinement, Node> parents) {
        int maxRid = 0;
        for (Refinement ref : parents.keySet()) {
            if (ref.rid == null) continue;
            maxRid = Math.max(maxRid, ref.rid);
        }
        return maxRid < MAX_RID_RANGE;
    }

    public static AndNode createNextLevelNode(Iteration t, Node n, Refinement ref, boolean discoverPatterns) {
        SortedMap<Refinement, Node> parents;
        AndNode nln = n.getAndChild(ref);
        if (nln != null) {
            return nln;
        }
        if (n instanceof InputNode) {
            if (n == ref.input && ref.rid == 0) {
                return null;
            }
        } else {
            AndNode an = (AndNode)n;
            an.lock.acquireReadLock();
            boolean flag = an.parents.containsKey(ref);
            an.lock.releaseReadLock();
            if (flag) {
                return null;
            }
        }
        if ((parents = AndNode.computeNextLevelParents(t, n, ref, discoverPatterns)) != null && (!discoverPatterns || AndNode.checkRidRange(parents))) {
            TreeSet<Node> parentsForLocking = new TreeSet<Node>(parents.values());
            for (Node pn : parentsForLocking) {
                pn.lock.acquireWriteLock(t.threadId);
            }
            if (n.andChildren == null || !n.andChildren.containsKey(ref)) {
                nln = new AndNode(t, n.level + 1, parents);
                nln.isBlocked = n.isBlocked || ref.input.isBlocked;
            }
            for (Node pn : parentsForLocking) {
                pn.lock.releaseWriteLock();
            }
            if (discoverPatterns) {
                t.addedNodes.add(nln);
            }
        }
        return nln;
    }

    public static void addNextLevelActivation(Iteration t, Activation act, Activation secondAct, AndNode nlp, Option conflict) {
        Activation.Key ak = act.key;
        Option o = Option.add(t.doc, true, ak.o, secondAct.key.o);
        if (o != null && (conflict == null || o.contains(conflict, false))) {
            nlp.addActivation(t, new Activation.Key(nlp, Range.applyVisibility(ak.r, ak.n.rangeVisibility, secondAct.key.r, secondAct.key.n.rangeVisibility), Utils.nullSafeMin(ak.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
        }
    }

    public static Collection<Activation> prepareInputActs(Activation firstAct, Activation secondAct) {
        ArrayList<Activation> inputActs = new ArrayList<Activation>(2);
        inputActs.add(firstAct);
        inputActs.add(secondAct);
        return inputActs;
    }

    public static SortedMap<Refinement, Node> computeNextLevelParents(Iteration t, Node pa, Refinement ref, boolean discoverPatterns) {
        Collection<Refinement> refinements = pa.collectNodeAndRefinements(ref);
        long v = visitedCounter++;
        TreeMap<Refinement, Node> parents = new TreeMap<Refinement, Node>();
        for (Refinement pRef : refinements) {
            TreeSet<Refinement> childInputs = new TreeSet<Refinement>(refinements);
            childInputs.remove(pRef);
            if (pRef.input.computeAndParents(t, pRef.getRelativePosition(), childInputs, parents, discoverPatterns, v)) continue;
            return null;
        }
        return parents;
    }

    @Override
    protected Collection<Refinement> collectNodeAndRefinements(Refinement newRef) {
        ArrayList<Refinement> inputs = new ArrayList<Refinement>(this.parents.size() + 1);
        inputs.add(newRef);
        int numRidRefs = 0;
        for (Refinement ref : this.parents.keySet()) {
            if (ref.rid == null) continue;
            ++numRidRefs;
        }
        for (Refinement ref : this.parents.keySet()) {
            if (newRef.rid != null && newRef.rid != null && (newRef.rid < 0 || numRidRefs == 1)) {
                inputs.add(new Refinement(ref.getRelativePosition(), newRef.rid, ref.input));
                continue;
            }
            if (ref.rid != null && newRef.rid != null && ref.getOffset() < 0) {
                inputs.add(new Refinement(0, Math.min(-ref.getOffset().intValue(), newRef.getRelativePosition()), ref.input));
                continue;
            }
            inputs.add(ref);
        }
        return inputs;
    }

    @Override
    protected void changeNumberOfNeuronRefs(Iteration t, long v, int d) {
        Node.ThreadState th = this.getThreadState(t);
        if (th.visitedNeuronRefsChange == v) {
            return;
        }
        th.visitedNeuronRefsChange = v;
        this.numberOfNeuronRefs += d;
        for (Node n : this.parents.values()) {
            n.changeNumberOfNeuronRefs(t, v, d);
        }
    }

    @Override
    public boolean isCovered(Iteration t, Integer offset, long v) {
        for (Map.Entry<Refinement, Node> me : this.parents.entrySet()) {
            Node.RidVisited nv = me.getValue().getThreadState(t).lookupVisited(Utils.nullSafeSub(offset, true, me.getKey().getOffset(), false));
            if (nv.outputNode != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        double sum = n.bias;
        for (Refinement ref : this.parents.keySet()) {
            Synapse s = ref.getSynapse(offset, n);
            sum += Math.abs(s.w);
        }
        return sum;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
    }

    @Override
    public void remove(Iteration t) {
        super.remove(t);
        for (Map.Entry<Refinement, Node> me : this.parents.entrySet()) {
            Node pn = me.getValue();
            pn.lock.acquireWriteLock(t.threadId);
            pn.removeAndChild(me.getKey());
            pn.lock.releaseWriteLock();
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND[");
        boolean first = true;
        for (Refinement ref : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(ref);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String weightsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" - ");
        sb.append(" F:");
        sb.append(this.frequency);
        sb.append("  BW:");
        sb.append(Utils.round(this.weight));
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("A");
        super.write(out);
        out.writeInt(this.numberOfPositionsNotify);
        out.writeInt(this.frequencyNotify);
        out.writeDouble(this.weight);
        out.writeInt(this.parents.size());
        for (Map.Entry<Refinement, Node> me : this.parents.entrySet()) {
            me.getKey().write(out);
            out.writeInt(me.getValue().id);
        }
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        super.readFields(in, t);
        this.numberOfPositionsNotify = in.readInt();
        this.frequencyNotify = in.readInt();
        this.weight = in.readDouble();
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Refinement ref = Refinement.read(in, t);
            Node pn = t.m.initialNodes.get(in.readInt());
            this.parents.put(ref, pn);
            pn.addAndChild(ref, this);
        }
    }

    public static class Refinement
    implements Comparable<Refinement> {
        public static Refinement MIN = new Refinement(null, null);
        public static Refinement MAX = new Refinement(null, null);
        public Integer rid;
        public InputNode input;

        private Refinement() {
        }

        public Refinement(Integer rid, InputNode input) {
            this.rid = rid;
            this.input = input;
        }

        public Refinement(Integer rid, Integer offset, InputNode input) {
            this.rid = offset == null && rid != null ? Integer.valueOf(0) : (offset == null || rid == null ? null : Integer.valueOf(rid - offset));
            this.input = input;
        }

        public Integer getOffset() {
            return this.rid != null ? Integer.valueOf(Math.min(0, this.rid)) : null;
        }

        public Integer getRelativePosition() {
            return this.rid != null ? Integer.valueOf(Math.max(0, this.rid)) : null;
        }

        public Synapse getSynapse(Integer offset, Neuron n) {
            this.input.lock.acquireReadLock();
            Synapse s = this.input.synapses != null ? this.input.synapses.get(new InputNode.SynapseKey(Utils.nullSafeAdd(this.getRelativePosition(), false, offset, false), n)) : null;
            this.input.lock.releaseReadLock();
            return s;
        }

        public String toString() {
            return "(" + (this.rid != null ? this.rid + ":" : "") + this.input.logicToString() + ")";
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.input.id);
        }

        public void readFields(DataInput in, Iteration t) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.input = (InputNode)t.m.initialNodes.get(in.readInt());
        }

        public static Refinement read(DataInput in, Iteration t) throws IOException {
            Refinement k = new Refinement();
            k.readFields(in, t);
            return k;
        }

        @Override
        public int compareTo(Refinement ref) {
            if (this == MIN || ref == MAX) {
                return -1;
            }
            if (this == MAX || ref == MIN) {
                return 1;
            }
            int r = this.input.compareTo(ref.input);
            if (r != 0) {
                return r;
            }
            return Utils.compareInteger(this.rid, ref.rid);
        }
    }
}

