/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.Model;
import org.aika.Utils;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.OrNode;
import org.aika.neuron.InputNeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class InputNode
extends Node {
    public Synapse.Key key;
    public Neuron inputNeuron;
    public Map<SynapseKey, Synapse> synapses;
    private long visitedTrain = -1L;
    static int dbc = 0;

    public InputNode() {
    }

    public InputNode(Iteration t, Synapse.Key key) {
        super(t, 1);
        this.key = key;
        Model m = t.m;
        if (m != null) {
            ++m.stat.nodes;
            int n = this.level;
            m.stat.nodesPerLevel[n] = m.stat.nodesPerLevel[n] + 1;
        }
        this.endRequired = false;
        this.ridRequired = false;
        if (key != null) {
            this.rangeVisibility = new Synapse.RangeVisibility[]{key.startVisibility, key.endVisibility};
            this.matchRange = new boolean[]{key.startSignal != Synapse.RangeSignal.NONE && key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT, key.endSignal != Synapse.RangeSignal.NONE && key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT};
            this.endRequired = key.startSignal == Synapse.RangeSignal.NONE;
            this.ridRequired = key.relativeRid != null || key.absoluteRid != null;
        }
    }

    public static InputNode add(Iteration t, Synapse.Key key, Neuron input) {
        InputNode in;
        InputNode inputNode = in = input != null ? input.outputNodes.get(key) : null;
        if (in != null) {
            return in;
        }
        in = new InputNode(t, key);
        if (input != null) {
            in.inputNeuron = input;
            in.passive = input.node != null && input.node.passive;
            input.outputNodes.put(key, in);
        }
        return in;
    }

    @Override
    protected void changeNumberOfNeuronRefs(Iteration t, long v, int d) {
        Node.ThreadState th = this.getThreadState(t);
        if (th.visitedNeuronRefsChange == v) {
            return;
        }
        th.visitedNeuronRefsChange = v;
        this.numberOfNeuronRefs += d;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            t.inputNeuronActivations.add(act);
            if (this.getThreadState((Iteration)t).activations.isEmpty()) {
                t.activatedInputNeurons.add(this.neuron);
            }
        } else if (!this.isBlocked) {
            t.inputNodeActivations.add(act);
        }
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            t.inputNeuronActivations.remove(act);
            if (this.getThreadState((Iteration)t).activations.isEmpty()) {
                t.activatedInputNeurons.add(this.neuron);
            }
        } else if (!this.isBlocked) {
            t.inputNodeActivations.remove(act);
        }
    }

    private Activation.Key computeActivationKey(Activation iAct) {
        Activation.Key ak = iAct.key;
        if (this.key.absoluteRid != null && this.key.absoluteRid != ak.rid || ak.o.isConflicting(Option.visitedCounter++)) {
            return null;
        }
        return new Activation.Key(this, new Range(this.key.startSignal.getSignalPos(ak.r, Integer.MIN_VALUE), this.key.endSignal.getSignalPos(ak.r, Integer.MAX_VALUE)), this.key.relativeRid != null ? ak.rid : null, ak.o);
    }

    @Override
    public void computeNullHyp(Model m) {
        this.nullHypFreq = this.frequency;
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        return true;
    }

    @Override
    protected boolean hasSupport(Activation act) {
        for (Activation iAct : act.inputs.values()) {
            if (iAct.isRemoved || !(iAct.upperBound > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Range preProcessAddedActivation(Iteration t, Activation.Key ak, Collection<Activation> inputActs) {
        ++dbc;
        if (this.neuron == null && (this.key.startSignal == Synapse.RangeSignal.NONE || this.key.endSignal == Synapse.RangeSignal.NONE)) {
            boolean dir = this.key.startSignal == Synapse.RangeSignal.NONE;
            int pos = ak.r.getBegin(dir);
            Activation cAct = Activation.getNextSignal(this, t, pos, ak.rid, ak.o, dir, dir);
            return new Range(ak.r.getBegin(dir), cAct != null ? cAct.key.r.getBegin(dir) : (dir ? Integer.MIN_VALUE : Integer.MAX_VALUE)).invert(dir);
        }
        return ak.r;
    }

    @Override
    protected void postProcessRemovedActivation(Iteration t, Activation act, Collection<Activation> inputActs) {
        Activation.Key ak = act.key;
        if (this.neuron == null && (this.key.startSignal == Synapse.RangeSignal.NONE || this.key.endSignal == Synapse.RangeSignal.NONE)) {
            boolean dir = this.key.startSignal == Synapse.RangeSignal.NONE;
            for (Activation cAct : Activation.select(t, this, ak.rid, new Range(ak.r.getBegin(dir), dir ? Integer.MAX_VALUE : Integer.MIN_VALUE).invert(!dir), dir ? Range.Relation.BEGINS_WITH : Range.Relation.ENDS_WITH, ak.o, Option.Relation.CONTAINS)) {
                Activation.Key cak = cAct.key;
                this.processAddedActivation(t, new Activation.Key(cak.n, new Range(dir ? Integer.MIN_VALUE : cak.r.begin, dir ? cak.r.end : Integer.MAX_VALUE), cak.rid, cak.o), cAct.inputs.values());
                ++Activation.removedIdCounter;
                cAct.removedId = cAct.removedId;
                cAct.isRemoved = true;
                this.removeActivationInternal(t, cAct, cAct.inputs.values());
            }
        }
    }

    public void addActivation(Iteration t, Activation inputAct) {
        Activation.Key ak = this.computeActivationKey(inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(t, ak, Collections.singleton(inputAct));
        }
    }

    public void removeActivation(Iteration t, Activation inputAct) {
        for (Activation act : inputAct.outputs.values()) {
            if (act.key.n != this) continue;
            InputNode.removeActivationAndPropagate(t, act, Collections.singleton(inputAct));
        }
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Option removedConflict) {
        if (this.neuron instanceof InputNeuron) {
            if (removedConflict == null) {
                this.neuron.propagateAddedActivation(t, act);
            }
        } else if (!this.key.isNeg && !this.key.isRecurrent) {
            this.apply(t, act, removedConflict);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            this.neuron.propagateRemovedActivation(t, act);
        } else if (!this.key.isNeg && !this.key.isRecurrent) {
            this.removeFromNextLevel(t, act);
        }
    }

    @Override
    public boolean isAllowedOption(Iteration t, Option n, Activation act, long v) {
        return false;
    }

    @Override
    protected Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        ArrayList<AndNode.Refinement> result = new ArrayList<AndNode.Refinement>(2);
        result.add(new AndNode.Refinement(this.key.relativeRid, newRef.rid, this));
        result.add(newRef);
        return result;
    }

    @Override
    public void apply(Iteration t, Activation act, Option removedConflict) {
        if (act.isRemoved || this.passive) {
            return;
        }
        this.lock.acquireReadLock();
        if (this.andChildren != null) {
            for (Map.Entry me : this.andChildren.entrySet()) {
                InputNode.addNextLevelActivations(t, ((AndNode.Refinement)me.getKey()).input, (AndNode.Refinement)me.getKey(), (AndNode)me.getValue(), act, removedConflict);
            }
        }
        this.lock.releaseReadLock();
        if (removedConflict == null) {
            OrNode.processCandidate(t, this, act, false);
        }
    }

    private static void addNextLevelActivations(Iteration t, InputNode secondNode, AndNode.Refinement ref, AndNode nlp, Activation act, Option removedConflict) {
        Activation.Key ak = act.key;
        Integer secondRid = Utils.nullSafeAdd(ak.rid, false, ref.rid, false);
        for (Activation secondAct : Activation.select(t, secondNode, secondRid, ak.r, new Range.BeginEndMatcher(ak.n.matchRange, secondNode.matchRange), null, null)) {
            Option o;
            if (secondAct.isRemoved || (o = Option.add(t.doc, true, ak.o, secondAct.key.o)) == null || removedConflict != null && !o.contains(removedConflict, false)) continue;
            nlp.addActivation(t, new Activation.Key(nlp, Range.applyVisibility(ak.r, ak.n.rangeVisibility, secondAct.key.r, secondAct.key.n.rangeVisibility), Utils.nullSafeMin(ak.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
        }
    }

    @Override
    public void discover(Iteration t, Activation act) {
        long v = Node.visitedCounter++;
        for (Activation secondAct : t.inputNodeActivations) {
            AndNode.Refinement ref = new AndNode.Refinement(secondAct.key.rid, act.key.rid, (InputNode)secondAct.key.n);
            Range.BeginEndMatcher mr = new Range.BeginEndMatcher(this.matchRange, ref.input.matchRange);
            Integer ridDelta = Utils.nullSafeSub(act.key.rid, false, secondAct.key.rid, false);
            if (act == secondAct || this == ref.input || ref.input.visitedTrain == v || ref.input.key.isNeg || ref.input.key.isRecurrent || !mr.match(act.key.r, secondAct.key.r) && (ridDelta == null || ridDelta >= AndNode.MAX_RID_RANGE)) continue;
            ref.input.visitedTrain = v;
            AndNode.createNextLevelNode(t, this, ref, true);
        }
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        return n.bias + Math.abs(this.getSynapse((SynapseKey)new SynapseKey((Integer)(this.key.relativeRid == null ? null : offset), (Neuron)n)).w);
    }

    public Synapse getSynapse(SynapseKey sk) {
        this.lock.acquireReadLock();
        Synapse s = this.synapses != null ? this.synapses.get(sk) : null;
        this.lock.releaseReadLock();
        return s;
    }

    public void setSynapse(Iteration t, SynapseKey sk, Synapse s) {
        this.lock.acquireWriteLock(t.threadId);
        if (this.synapses == null) {
            this.synapses = new TreeMap<SynapseKey, Synapse>();
        }
        this.synapses.put(sk, s);
        this.lock.releaseWriteLock();
    }

    @Override
    public void cleanup(Iteration t) {
    }

    @Override
    public void remove(Iteration t) {
        this.inputNeuron.outputNodes.remove(this.key);
        super.remove(t);
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.isNeg ? "N" : "P");
        sb.append(this.key.isRecurrent ? "R" : "");
        if (this.key.startSignal == Synapse.RangeSignal.NONE) {
            sb.append("|");
        } else if (this.key.startSignal == Synapse.RangeSignal.START) {
            if (this.key.startVisibility == Synapse.RangeVisibility.MAX_OUTPUT) {
                sb.append("<");
            } else {
                sb.append("[");
            }
        } else if (this.key.startSignal == Synapse.RangeSignal.END) {
            if (this.key.startVisibility == Synapse.RangeVisibility.MAX_OUTPUT) {
                sb.append(">");
            } else {
                sb.append("]");
            }
        }
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.label != null) {
                sb.append(",");
                sb.append(this.inputNeuron.label);
            }
        }
        if (this.key.endSignal == Synapse.RangeSignal.NONE) {
            sb.append("|");
        } else if (this.key.endSignal == Synapse.RangeSignal.START) {
            if (this.key.endVisibility == Synapse.RangeVisibility.MAX_OUTPUT) {
                sb.append("<");
            } else {
                sb.append("[");
            }
        } else if (this.key.endSignal == Synapse.RangeSignal.END) {
            if (this.key.endVisibility == Synapse.RangeVisibility.MAX_OUTPUT) {
                sb.append(">");
            } else {
                sb.append("]");
            }
        }
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("I");
        super.write(out);
        this.key.write(out);
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        super.readFields(in, t);
        this.key = Synapse.Key.read(in, t);
    }

    public static class SynapseKey
    implements Comparable<SynapseKey> {
        final Integer rid;
        final Neuron n;

        public SynapseKey(Integer rid, Neuron n) {
            this.rid = rid;
            this.n = n;
        }

        @Override
        public int compareTo(SynapseKey sk) {
            int r = Utils.compareInteger(this.rid, sk.rid);
            if (r != 0) {
                return r;
            }
            return this.n.compareTo(sk.n);
        }
    }
}

