/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.Model;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class OrNode
extends Node {
    public TreeSet<OrEntry> parents = new TreeSet();

    public OrNode() {
    }

    public OrNode(Iteration t) {
        super(t, -1);
        Model m = t.m;
        ++m.stat.nodes;
        ++m.stat.orNodes;
        this.endRequired = true;
        this.ridRequired = true;
    }

    @Override
    public void computeNullHyp(Model m) {
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        return false;
    }

    @Override
    public boolean isAllowedOption(Iteration t, Option n, Activation act, long v) {
        return false;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
        for (Synapse s : this.neuron.inputSynapses) {
            if (!s.key.isNeg && !s.key.isRecurrent) continue;
            for (Activation iAct : Activation.select(t, s.inputNode, Utils.nullSafeAdd(act.key.rid, false, s.key.relativeRid, false), act.key.r, Range.Relation.OVERLAPS, null, null)) {
                iAct.outputs.put(act.key, act);
            }
        }
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
    }

    public void updateActivation(Iteration t, Range inputR, Integer rid) {
        ArrayList<Activation> inputs = new ArrayList<Activation>();
        Range r = null;
        for (OrEntry orEntry : this.parents) {
            for (Activation iAct : Activation.select(t, orEntry.node, Utils.nullSafeAdd(rid, true, orEntry.ridOffset, false), inputR, Range.Relation.OVERLAPS, null, null)) {
                if (iAct.isRemoved || this.checkSelfReferencing(t, iAct)) continue;
                inputs.add(iAct);
                r = r == null ? iAct.key.r : new Range(Math.min(r.begin, iAct.key.r.begin), Math.max(r.end, iAct.key.r.end));
            }
        }
        for (Activation activation : Activation.select(t, this, rid, inputR, Range.Relation.OVERLAPS, null, null)) {
            Iterator<Activation> it = activation.inputs.values().iterator();
            while (it.hasNext()) {
                Activation iAct;
                iAct = it.next();
                if (r == null || Range.compare(r, activation.key.r) != 0) {
                    activation.isReplaced = true;
                    activation.key.o.removeOrOption(iAct, iAct.key.o);
                    OrNode.removeActivationAndPropagate(t, activation, activation.inputs.values());
                }
                if (!iAct.isRemoved) continue;
                activation.key.o.removeOrOption(iAct, iAct.key.o);
                it.remove();
            }
        }
        if (inputs.isEmpty()) {
            return;
        }
        Option no = this.lookupOrOption(t, r, true);
        for (Activation iAct : inputs) {
            no.addOrOption(iAct, iAct.key.o);
        }
        Activation.Key key = new Activation.Key(this, r, rid, no);
        OrNode.addActivationAndPropagate(t, key, inputs);
    }

    public void addActivation(Iteration t, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(t, inputAct)) {
            return;
        }
        Activation.Key ak = inputAct.key;
        this.updateActivation(t, ak.r, Utils.nullSafeSub(ak.rid, true, ridOffset, false));
    }

    public void removeActivation(Iteration t, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(t, inputAct)) {
            return;
        }
        Activation.Key ak = inputAct.key;
        this.updateActivation(t, ak.r, Utils.nullSafeSub(ak.rid, true, ridOffset, false));
    }

    private boolean checkSelfReferencing(Iteration t, Activation inputAct) {
        Option o = this.lookupOrOption(t, inputAct.key.r, false);
        if (o == null) {
            return false;
        }
        return inputAct.key.o.contains(o, true);
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Option removedConflict) {
        if (removedConflict == null) {
            this.neuron.propagateAddedActivation(t, act);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act) {
        this.neuron.propagateRemovedActivation(t, act);
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup(Iteration t) {
    }

    @Override
    protected boolean hasSupport(Activation act) {
        if (act.isReplaced) {
            return false;
        }
        for (Activation iAct : act.inputs.values()) {
            if (iAct.isRemoved) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(Iteration t, Activation act, Option conflict) {
        if (conflict == null) {
            OrNode.processCandidate(t, this, act, false);
        }
    }

    @Override
    public void discover(Iteration t, Activation act) {
    }

    public static void processCandidate(Iteration t, Node parentNode, Activation inputAct, boolean train) {
        Activation.Key ak = inputAct.key;
        parentNode.lock.acquireReadLock();
        if (parentNode.orChildren != null) {
            for (OrEntry oe : parentNode.orChildren) {
                if (ak.o.isConflicting(Option.visitedCounter++)) continue;
                ((OrNode)oe.node).addActivation(t, oe.ridOffset, inputAct);
            }
        }
        parentNode.lock.releaseReadLock();
    }

    public Option lookupOrOption(Iteration t, Range r, boolean create) {
        Iterator<Activation> iterator = Activation.select(t, this, null, r, Range.Relation.CONTAINS, null, null).iterator();
        if (iterator.hasNext()) {
            Activation act = iterator.next();
            return act.key.o;
        }
        for (Activation.Key ak : this.getThreadState((Iteration)t).added.keySet()) {
            if (Range.compare(ak.r, r) != 0) continue;
            return ak.o;
        }
        return create ? Option.addPrimitive(t.doc) : null;
    }

    protected Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void changeNumberOfNeuronRefs(Iteration t, long v, int d) {
        throw new UnsupportedOperationException();
    }

    public void addInput(Iteration t, Integer ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(t, Node.visitedCounter++, 1);
        in.addOrChild(t, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(t.threadId);
        this.parents.add(new OrEntry(ridOffset, in));
        this.lock.releaseWriteLock();
    }

    public void removeInput(Iteration t, int ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(t, Node.visitedCounter++, -1);
        in.removeOrChild(t, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(t.threadId);
        this.parents.remove(new OrEntry(ridOffset, in));
        this.lock.releaseWriteLock();
    }

    public void removeAllInputs(Iteration t) {
        this.lock.acquireWriteLock(t.threadId);
        for (OrEntry oe : this.parents) {
            oe.node.changeNumberOfNeuronRefs(t, Node.visitedCounter++, -1);
            oe.node.removeOrChild(t, new OrEntry(oe.ridOffset, this));
        }
        this.parents.clear();
        this.lock.releaseWriteLock();
    }

    @Override
    public void remove(Iteration t) {
        super.remove(t);
        this.lock.acquireReadLock();
        for (OrEntry oe : this.parents) {
            oe.node.removeOrChild(t, new OrEntry(oe.ridOffset, this));
        }
        this.lock.releaseReadLock();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        for (OrEntry oe : this.parents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            if (oe.ridOffset != null) {
                sb.append(oe.ridOffset);
                sb.append(":");
            }
            sb.append(oe.node.logicToString());
            if (i > 10) {
                sb.append(",...");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("O");
        super.write(out);
        out.writeInt(this.parents.size());
        for (OrEntry oe : this.parents) {
            oe.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        super.readFields(in, t);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            OrEntry oe = OrEntry.read(in, t);
            this.parents.add(oe);
            oe.node.addOrChild(t, new OrEntry(oe.ridOffset, this));
        }
    }

    public static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public Integer ridOffset;
        public Node node;

        private OrEntry() {
        }

        public OrEntry(Integer ridOffset, Node node) {
            this.ridOffset = ridOffset;
            this.node = node;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ridOffset != null);
            if (this.ridOffset != null) {
                out.writeInt(this.ridOffset);
            }
            out.writeInt(this.node.id);
        }

        @Override
        public void readFields(DataInput in, Iteration t) throws IOException {
            if (in.readBoolean()) {
                this.ridOffset = in.readInt();
            }
            this.node = t.m.initialNodes.get(in.readInt());
        }

        public static OrEntry read(DataInput in, Iteration t) throws IOException {
            OrEntry n = new OrEntry();
            n.readFields(in, t);
            return n;
        }

        @Override
        public int compareTo(OrEntry on) {
            int r = Utils.compareInteger(this.ridOffset, on.ridOffset);
            if (r != 0) {
                return r;
            }
            return this.node.compareTo(on.node);
        }
    }
}

