/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.util.Collections;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class InputNeuron
extends Neuron {
    public InputNeuron() {
    }

    public InputNeuron(String label) {
        this.label = label;
    }

    public InputNeuron(String label, boolean isBlocked) {
        super(label, isBlocked, true);
    }

    public static InputNeuron create(Iteration t, InputNeuron n) {
        n.m = t.m;
        InputNode node = InputNode.add(t, new Synapse.Key(false, false, null, 0, false, Synapse.RangeSignal.NONE, Synapse.RangeVisibility.MATCH_INPUT, Synapse.RangeSignal.NONE, Synapse.RangeVisibility.MATCH_INPUT), null);
        node.neuron = n;
        n.node = node;
        n.publish(t);
        n.initialized = true;
        return n;
    }

    @Override
    public void remove(Iteration t) {
        this.unpublish(t);
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act) {
        Activation.State s = new Activation.State(1.0, 0, Neuron.NormWeight.ZERO_WEIGHT);
        act.rounds.set(0, s);
        act.finalState = s;
        act.upperBound = 1.0;
        act.lowerBound = 1.0;
        for (InputNode out : this.outputNodes.values()) {
            out.addActivation(t, act);
        }
    }

    public void addInput(Iteration t, int begin, int end) {
        this.addInput(t, begin, end, null, t.doc.bottom);
    }

    public void addInput(Iteration t, int begin, int end, Option o) {
        this.addInput(t, begin, end, null, o);
    }

    public void addInput(Iteration t, int begin, int end, Integer rid) {
        this.addInput(t, begin, end, rid, t.doc.bottom);
    }

    public void addInput(Iteration t, int begin, int end, Integer rid, Option o) {
        Node.addActivationAndPropagate(t, new Activation.Key(this.node, new Range(begin, end), rid, o), Collections.EMPTY_SET);
        t.propagate();
    }

    public void removeInput(Iteration t, int begin, int end) {
        this.removeInput(t, begin, end, null, t.doc.bottom);
    }

    public void removeInput(Iteration t, int begin, int end, Option o) {
        this.removeInput(t, begin, end, null, o);
    }

    public void removeInput(Iteration t, int begin, int end, Integer rid) {
        this.removeInput(t, begin, end, rid, t.doc.bottom);
    }

    public void removeInput(Iteration t, int begin, int end, Integer rid, Option o) {
        Range r = new Range(begin, end);
        Activation act = Activation.get(t, this.node, rid, r, Range.Relation.EQUALS, o, Option.Relation.EQUALS);
        Node.removeActivationAndPropagate(t, act, Collections.EMPTY_SET);
        t.propagate();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("in(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }
}

