/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.aika.Iteration;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class Activation
implements Comparable<Activation> {
    public final Key key;
    public boolean isReplaced;
    public boolean isRemoved;
    public int removedId;
    public long visitedNeuronTrain = -1L;
    public static int removedIdCounter = 1;
    public static long visitedCounter = 1L;
    public double upperBound;
    public double lowerBound;
    public Rounds rounds = new Rounds();
    public State finalState;
    public long currentStateV = -1L;
    public ExpandNode.StateChange currentStateChange;
    public boolean isTrainingAct;
    public double initialErrorSignal;
    public double errorSignal;
    public TreeMap<Key, Activation> inputs = new TreeMap();
    public TreeMap<Key, Activation> outputs = new TreeMap();
    public TreeSet<SynapseActivation> neuronInputs;
    public TreeSet<SynapseActivation> neuronOutputs;
    public boolean ubQueued = false;
    public boolean isQueued = false;
    public long queueId;

    public Activation(Key key) {
        this.key = key;
    }

    public Activation(Node n, Range pos, Integer rid, Option o) {
        this.key = new Key(n, pos, rid, o);
    }

    public void link(Collection<Activation> inputActs) {
        for (Activation iAct : inputActs) {
            this.inputs.put(iAct.key, iAct);
            iAct.outputs.put(this.key, this);
        }
    }

    public void unlink(Collection<Activation> inputActs) {
        for (Activation iAct : inputActs) {
            this.inputs.remove(iAct.key);
            iAct.outputs.remove(this.key);
        }
    }

    public void unlink() {
        for (Activation act : this.inputs.values()) {
            act.outputs.remove(this.key);
        }
        for (Activation act : this.outputs.values()) {
            act.inputs.remove(this.key);
        }
    }

    public void register(Iteration t) {
        TreeMap<Key, Activation> actRid;
        Node.ThreadState th = this.key.n.getThreadState(t);
        if (th.activations.isEmpty()) {
            (this.isTrainingAct ? t.activatedNodesForTraining : t.activatedNodes).add(this.key.n);
        }
        th.activations.put(this.key, this);
        TreeMap<Key, Activation> actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.put(this.key, this);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.put(this.key, this);
        }
        if (this.key.o.activations == null) {
            this.key.o.activations = new TreeMap<Key, Activation>();
        }
        this.key.o.activations.put(this.key, this);
        if (this.key.n.neuron != null) {
            if (this.key.o.neuronActivations == null) {
                this.key.o.neuronActivations = new TreeSet<Activation>();
            }
            this.key.o.neuronActivations.add(this);
        }
        if (this.key.rid != null) {
            t.activationsByRid.put(this.key, this);
        }
    }

    public void unregister(Iteration t) {
        TreeMap<Key, Activation> actRid;
        assert (!this.key.o.activations.isEmpty());
        Node.ThreadState th = this.key.n.getThreadState(t);
        th.activations.remove(this.key);
        TreeMap<Key, Activation> actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.remove(this.key);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.remove(this.key);
        }
        if (th.activations.isEmpty()) {
            (this.isTrainingAct ? t.activatedNodesForTraining : t.activatedNodes).remove(this.key.n);
        }
        this.key.o.activations.remove(this.key);
        if (this.key.n.neuron != null) {
            this.key.o.neuronActivations.remove(this);
        }
        if (this.key.rid != null) {
            t.activationsByRid.remove(this.key);
        }
    }

    public static Activation get(Iteration t, Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or) {
        return Activation.select(t, n, rid, r, rr, o, or).findFirst().orElse(null);
    }

    public static Activation get(Iteration t, Node n, Key ak) {
        return Activation.get(t, n, ak.rid, ak.r, Range.Relation.EQUALS, ak.o, Option.Relation.EQUALS);
    }

    public static Activation getNextSignal(Node n, Iteration t, int from, Integer rid, Option o, boolean dir, boolean inv) {
        Node.ThreadState th = n.getThreadState(t);
        Key bk = new Key(null, new Range(from, dir ? Integer.MIN_VALUE : Integer.MAX_VALUE).invert(inv), rid, o);
        TreeMap<Key, Activation> tmp = inv ? th.activationsEnd : th.activations;
        tmp = dir ? tmp.descendingMap() : tmp;
        for (Activation act : tmp.tailMap(bk, false).values()) {
            if (!act.filter(n, rid, null, null, o, Option.Relation.CONTAINED_IN)) continue;
            return act;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Stream<Activation> select(Iteration t, Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or) {
        void var7_17;
        if (n != null) {
            Node.ThreadState th = n.getThreadState(t);
            int s = th.activations.size();
            if (s == 0) {
                return Stream.empty();
            }
            if (s == 1) {
                Stream<Activation> stream = th.activations.values().stream();
                return var7_17.filter(act -> act.filter(n, rid, r, rr, o, or));
            } else if (rid != null) {
                Key bk = new Key(n, Range.MIN, rid, Option.MIN);
                Key ek = new Key(n, Range.MAX, rid, Option.MAX);
                Stream stream = th.activationsRid.subMap(bk, true, ek, true).values().stream();
                return var7_17.filter(act -> act.filter(n, rid, r, rr, o, or));
            } else {
                if (rr != null) return rr.getActivations(t, n, rid, r, o, or);
                Stream<Activation> stream = th.activations.values().stream();
            }
            return var7_17.filter(act -> act.filter(n, rid, r, rr, o, or));
        } else if (rid != null) {
            Key bk = new Key(Node.MIN_NODE, Range.MIN, rid, Option.MIN);
            Key ek = new Key(Node.MAX_NODE, Range.MAX, rid, Option.MAX);
            Stream stream = t.activationsByRid.subMap(bk, true, ek, true).values().stream();
            return var7_17.filter(act -> act.filter(n, rid, r, rr, o, or));
        } else {
            Stream stream = t.activatedNodes.stream().flatMap(node -> node.getThreadState((Iteration)iteration).activations.values().stream());
        }
        return var7_17.filter(act -> act.filter(n, rid, r, rr, o, or));
    }

    public boolean filter(Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or) {
        return !(n != null && this.key.n != n || rid != null && (this.key.rid == null || this.key.rid.intValue() != rid.intValue()) || r != null && rr != null && !rr.match(this.key.r, r) || o != null && !or.compare(this.key.o, o));
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.r);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.r.begin - 3), Math.min(doc.length(), this.key.r.end + 3)));
        sb.append(",");
        sb.append(this.key.n);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Activation act) {
        return this.key.compareTo(act.key);
    }

    public static int compare(Activation a, Activation b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static class SynapseActivation {
        public final Synapse s;
        public final Activation input;
        public final Activation output;
        public static Comparator<SynapseActivation> INPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.INPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.input.compareTo(sa2.input);
            }
        };
        public static Comparator<SynapseActivation> OUTPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.output.compareTo(sa2.output);
            }
        };

        public SynapseActivation(Synapse s, Activation input, Activation output) {
            this.s = s;
            this.input = input;
            this.output = output;
        }
    }

    public static class Rounds {
        TreeMap<Integer, State> rounds = new TreeMap();

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : State.ZERO;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : null;
        }
    }

    public static class State {
        public final double value;
        public final int fired;
        public final Neuron.NormWeight weight;
        public static final State ZERO = new State(0.0, -1, Neuron.NormWeight.ZERO_WEIGHT);

        public State(double value, int fired, Neuron.NormWeight weight) {
            this.value = value;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= 0.001;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && this.weight.equals(s.weight);
        }

        public String toString() {
            return "V:" + this.value;
        }
    }

    public static final class Key
    implements Comparable<Key> {
        public final Node n;
        public final Range r;
        public final Integer rid;
        public final Option o;
        private int refCount = 0;

        public Key(Node n, Range r, Integer rid, Option o) {
            this.n = n;
            this.r = r;
            this.rid = rid;
            this.o = o;
            this.countRef();
            if (o != null) {
                o.countRef();
            }
        }

        public void countRef() {
            ++this.refCount;
        }

        public void releaseRef() {
            assert (this.refCount > 0);
            --this.refCount;
            if (this.refCount == 0) {
                this.o.releaseRef();
            }
        }

        @Override
        public int compareTo(Key k) {
            int x = this.n.compareTo(k.n);
            if (x != 0) {
                return x;
            }
            x = Range.compare(this.r, k.r, false);
            if (x != 0) {
                return x;
            }
            x = Utils.compareInteger(this.rid, k.rid);
            if (x != 0) {
                return x;
            }
            return this.o.compareTo(k.o);
        }

        public String toString() {
            return (this.n != null ? this.n.id + (this.n.neuron != null && this.n.neuron.label != null ? ":" + this.n.neuron.label : "") + " " : "") + this.r + " " + this.rid + " " + this.o;
        }
    }
}

