/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.aika.Activation;
import org.aika.Model;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.neuron.InputNeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iteration {
    private static final Logger log = LoggerFactory.getLogger(Iteration.class);
    public static boolean APPLY_DEBUG_OUTPUT = false;
    public static boolean OPTIMIZE_DEBUG_OUTPUT = false;
    public static boolean TRAIN_DEBUG_OUTPUT = false;
    public static int CLEANUP_INTERVAL = 20;
    public Document doc;
    public Model m;
    public int threadId;
    public long iterationId;
    public Queue queue = new Queue();
    public ValueQueue vQueue = new ValueQueue();
    public UpperBoundQueue ubQueue = new UpperBoundQueue();
    public BackPropagationQueue bQueue = new BackPropagationQueue();
    public TreeSet<Node> activatedNodes = new TreeSet();
    public TreeSet<Node> activatedNodesForTraining = new TreeSet();
    public TreeSet<Neuron> activatedInputNeurons = new TreeSet();
    public TreeSet<Neuron> activatedNeurons = new TreeSet();
    public TreeSet<Neuron> finallyActivatedNeurons = new TreeSet();
    public TreeSet<Activation> inputNeuronActivations = new TreeSet();
    public TreeSet<Activation> inputNodeActivations = new TreeSet();
    public TreeMap<Activation.Key, Activation> activationsByRid = new TreeMap(new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key act1, Activation.Key act2) {
            int r = Integer.compare(act1.rid, act2.rid);
            if (r != 0) {
                return r;
            }
            return act1.compareTo(act2);
        }
    });
    public TreeSet<Node> addedNodes = new TreeSet();
    public static int numberOfPositionsDelta;
    public static Comparator<Activation> ACTIVATIONS_OUTPUT_COMPARATOR;

    Iteration(Document doc, Model m, int threadId, long iterationId) {
        this.doc = doc;
        this.m = m;
        this.threadId = threadId;
        this.iterationId = iterationId;
    }

    public void propagate() {
        boolean flag = true;
        while (flag) {
            this.queue.processChanges();
            flag = this.ubQueue.process();
        }
    }

    public void process() {
        for (Activation act : this.inputNeuronActivations) {
            this.vQueue.propagateWeight(0, act, Activation.visitedCounter++);
        }
        this.doc.root.computeSelectedOption(this);
    }

    public void count() {
        for (Node node : this.activatedNodes) {
            node.count(this);
        }
        for (Neuron neuron : this.finallyActivatedNeurons) {
            neuron.count(this);
        }
    }

    public void train() {
        this.m.numberOfPositions += numberOfPositionsDelta;
        numberOfPositionsDelta = 0;
        long v = Node.visitedCounter++;
        this.count();
        for (Node node : this.activatedNodes) {
            if (node.neuron instanceof InputNeuron) continue;
            node.computeNullHyp(this.m);
            if (!node.frequencyHasChanged || node.isBlocked || !node.isFrequent()) continue;
            node.frequencyHasChanged = false;
            if (node instanceof AndNode) {
                AndNode an = (AndNode)node;
                an.updateWeight(this, v);
            }
            for (Activation act : node.getThreadState((Iteration)this).activations.values()) {
                node.discover(this, act);
            }
        }
        while (true) {
            AndNode n;
            AndNode andNode = n = !this.m.numberOfPositionsQueue.isEmpty() ? this.m.numberOfPositionsQueue.iterator().next() : null;
            if (n == null || n.numberOfPositionsNotify > this.m.numberOfPositions) break;
            n.updateWeight(this, v);
        }
        this.bQueue.backpropagtion();
        for (Neuron neuron : this.finallyActivatedNeurons) {
            if (neuron.noTraining) continue;
            for (Activation act : neuron.node.getThreadState((Iteration)this).activations.values()) {
                neuron.train(this, act);
            }
        }
    }

    public void clearActivations() {
        for (Node n : this.activatedNodes) {
            n.clearActivations(this);
        }
        for (Node n : this.activatedNodesForTraining) {
            n.clearActivations(this);
        }
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if ((long)(this.m.lastCleanup[this.threadId] + CLEANUP_INTERVAL) < this.iterationId) {
            for (Node n : this.m.allNodes[this.threadId]) {
                Node.ThreadState th = n.threads[this.threadId];
                if (th == null || th.lastUsed + (long)CLEANUP_INTERVAL >= this.iterationId) continue;
                n.threads[this.threadId] = null;
            }
        }
    }

    public void changeNumberOfPositions(int delta) {
        numberOfPositionsDelta += delta;
    }

    public InputNeuron createOrLookupInputSignal(String label) {
        return this.createOrLookupInputSignal(label, false);
    }

    public InputNeuron createOrLookupInputSignal(String label, boolean isBlocked) {
        InputNeuron n = (InputNeuron)this.m.labeledNeurons.get(label);
        if (n == null) {
            n = InputNeuron.create(this, new InputNeuron(label, isBlocked));
            this.m.labeledNeurons.put(label, n);
        }
        return n;
    }

    public Neuron createAndNeuron(Neuron n, double threshold, Input ... inputs) {
        return this.createAndNeuron(n, threshold, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createAndNeuron(Neuron n, double threshold, Collection<Input> inputs) {
        n.m = this.m;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double bias = 0.0;
        double negDirSum = 0.0;
        double negRecSum = 0.0;
        double posRecSum = 0.0;
        double minWeight = Double.MAX_VALUE;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.matchRange, Synapse.RangeSignal.START, ni.startVisibility, Synapse.RangeSignal.END, ni.endVisibility));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            if (ni.weight < 0.0) {
                if (!ni.recurrent) {
                    negDirSum += ni.weight;
                } else {
                    negRecSum += ni.weight;
                }
            } else if (ni.recurrent) {
                posRecSum += ni.weight;
            }
            if (!ni.optional) {
                bias -= Math.abs(ni.weight) * ni.minInput;
                minWeight = Math.min(minWeight, Math.abs(ni.weight) * ni.minInput);
            }
            is.add(s);
        }
        return Neuron.create(this, n, bias += minWeight * threshold, negDirSum, negRecSum, posRecSum, is);
    }

    public Neuron createNeuron(Neuron n, double bias, Input ... inputs) {
        return this.createNeuron(n, bias, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createNeuron(Neuron n, double bias, Collection<Input> inputs) {
        n.m = this.m;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double negDirSum = 0.0;
        double negRecSum = 0.0;
        double posRecSum = 0.0;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.matchRange, Synapse.RangeSignal.START, ni.startVisibility, Synapse.RangeSignal.END, ni.endVisibility));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            if (ni.weight < 0.0) {
                if (!ni.recurrent) {
                    negDirSum += ni.weight;
                } else {
                    negRecSum += ni.weight;
                }
            } else if (ni.recurrent) {
                posRecSum += ni.weight;
            }
            is.add(s);
        }
        return Neuron.create(this, n, bias, negDirSum, negRecSum, posRecSum, is);
    }

    public Neuron createOrNeuron(Neuron n, Input ... inputs) {
        return this.createOrNeuron(n, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createOrNeuron(Neuron n, Set<Input> inputs) {
        n.m = this.m;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double bias = -0.001;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.matchRange, Synapse.RangeSignal.START, ni.startVisibility, Synapse.RangeSignal.END, ni.endVisibility));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            is.add(s);
        }
        return Neuron.create(this, n, bias, 0.0, 0.0, 0.0, is);
    }

    public Neuron createRelationalNeuron(Neuron n, Neuron ctn, Neuron inputSignal, boolean dirIS) {
        n.m = this.m;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        double bias = -30.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (inputSignal != null) {
            Synapse iss = new Synapse(inputSignal, new Synapse.Key(false, false, null, null, true, dirIS ? Synapse.RangeSignal.END : Synapse.RangeSignal.START, Synapse.RangeVisibility.MATCH_INPUT, dirIS ? Synapse.RangeSignal.START : Synapse.RangeSignal.END, Synapse.RangeVisibility.MAX_OUTPUT));
            iss.w = 20.0;
            iss.maxLowerWeightsSum = 20.0;
            is.add(iss);
        }
        if (ctn != null) {
            Synapse ctns = new Synapse(ctn, new Synapse.Key(false, false, 0, null, true, Synapse.RangeSignal.START, Synapse.RangeVisibility.MATCH_INPUT, Synapse.RangeSignal.END, Synapse.RangeVisibility.MATCH_INPUT));
            ctns.w = 20.0;
            ctns.maxLowerWeightsSum = 20.0;
            is.add(ctns);
        }
        return Neuron.create(this, n, bias, 0.0, 0.0, 0.0, is);
    }

    public Neuron createCounterNeuron(Neuron n, Neuron clockSignal, boolean dirCS, Neuron startSignal, boolean dirSS, boolean direction) {
        n.m = this.m;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        double bias = -44.0;
        double negRecSum = -20.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (clockSignal != null) {
            Synapse css = new Synapse(clockSignal, new Synapse.Key(false, false, null, null, true, Synapse.RangeSignal.NONE, Synapse.RangeVisibility.MATCH_INPUT, dirCS ? Synapse.RangeSignal.START : Synapse.RangeSignal.END, Synapse.RangeVisibility.MATCH_INPUT));
            css.w = 20.0;
            css.maxLowerWeightsSum = 8.0;
            is.add(css);
        }
        if (startSignal != null) {
            Synapse sss = new Synapse(startSignal, new Synapse.Key(false, false, 0, null, true, dirSS ? Synapse.RangeSignal.START : Synapse.RangeSignal.END, Synapse.RangeVisibility.MATCH_INPUT, Synapse.RangeSignal.NONE, Synapse.RangeVisibility.MATCH_INPUT));
            sss.w = 8.0;
            sss.maxLowerWeightsSum = 0.0;
            is.add(sss);
        }
        Synapse lastCycle = new Synapse(n, new Synapse.Key(false, false, -1, null, true, direction ? Synapse.RangeSignal.NONE : Synapse.RangeSignal.END, Synapse.RangeVisibility.MATCH_INPUT, direction ? Synapse.RangeSignal.START : Synapse.RangeSignal.NONE, Synapse.RangeVisibility.MATCH_INPUT));
        lastCycle.w = 8.0;
        lastCycle.maxLowerWeightsSum = 0.0;
        is.add(lastCycle);
        Synapse neg = new Synapse(n, new Synapse.Key(true, true, 0, null, true, Synapse.RangeSignal.START, Synapse.RangeVisibility.MAX_OUTPUT, Synapse.RangeSignal.END, Synapse.RangeVisibility.MAX_OUTPUT));
        neg.w = -20.0;
        neg.maxLowerWeightsSum = 28.0;
        is.add(neg);
        Neuron neuron = Neuron.create(this, n, bias, 0.0, negRecSum, 0.0, is);
        neuron.node.passive = true;
        return neuron;
    }

    public String networkStateToString(boolean withWeights) {
        return this.networkStateToString(true, withWeights);
    }

    /*
     * WARNING - void declaration
     */
    public String networkStateToString(boolean neuronsOnly, boolean withWeights) {
        void var5_13;
        TreeSet<Activation> acts = new TreeSet<Activation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        if (neuronsOnly) {
            for (Neuron neuron : this.m.neurons.values()) {
                acts.addAll(Activation.select(this, neuron.node, null, null, null, null, Option.Relation.CONTAINED_IN).collect(Collectors.toList()));
            }
        } else {
            if (this.m.initialNodes != null) {
                for (Node node : this.m.initialNodes.values()) {
                    acts.addAll(Activation.select(this, node, null, null, null, null, Option.Relation.CONTAINED_IN).collect(Collectors.toList()));
                }
            }
            for (int th = 0; th < this.m.numberOfThreads; ++th) {
                for (Node n : this.m.allNodes[th]) {
                    acts.addAll(Activation.select(this, n, null, null, null, null, Option.Relation.CONTAINED_IN).collect(Collectors.toList()));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        Neuron.NormWeight normWeight = Neuron.NormWeight.ZERO_WEIGHT;
        for (Activation act : acts) {
            if (act.key.n.neuron != null && "SPACE".equals(act.key.n.neuron.label)) continue;
            sb.append(act.key.r);
            sb.append(" - ");
            sb.append(act.key.o);
            sb.append(" - ");
            sb.append(act.key.n);
            sb.append(" - Rid:");
            sb.append(act.key.rid);
            sb.append(" - UB:");
            sb.append(Utils.round(act.upperBound));
            if (withWeights) {
                if (act.key.n instanceof AndNode) {
                    AndNode an = (AndNode)act.key.n;
                    sb.append(" - BW:");
                    sb.append(an.weight);
                }
                sb.append(" - ");
                for (Map.Entry<Integer, Activation.State> me : act.rounds.rounds.entrySet()) {
                    Activation.State s = me.getValue();
                    sb.append("[R:" + me.getKey());
                    sb.append(" V:" + Utils.round(s.value));
                    sb.append(" F:" + s.fired);
                    sb.append(" W:" + Utils.round(s.weight.w));
                    sb.append(" N:" + Utils.round(s.weight.n));
                    sb.append("]");
                }
                if (act.finalState != null && act.finalState.weight != null) {
                    sb.append(" - FV:" + Utils.round(act.finalState.value));
                    sb.append(" FW:" + Utils.round(act.finalState.weight.w));
                    sb.append(" FN:" + Utils.round(act.finalState.weight.n));
                }
            }
            if (act.finalState != null && act.finalState.weight != null) {
                Neuron.NormWeight normWeight2 = var5_13.add(act.finalState.weight);
            }
            sb.append("\n");
        }
        sb.append("\nWeightSum:" + var5_13.toString() + "\n");
        return sb.toString();
    }

    static {
        ACTIVATIONS_OUTPUT_COMPARATOR = new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                int r = Range.compare(act1.key.r, act2.key.r, false);
                if (r != 0) {
                    return r;
                }
                r = Utils.compareInteger(act1.key.rid, act2.key.rid);
                if (r != 0) {
                    return r;
                }
                r = act1.key.o.compareTo(act2.key.o);
                if (r != 0) {
                    return r;
                }
                return Integer.compare(act1.key.n.id, act2.key.n.id);
            }
        };
    }

    public static class Input
    implements Comparable<Input> {
        public boolean recurrent;
        public boolean optional;
        public Neuron neuron;
        public double weight;
        public double maxLowerWeightsSum = Double.MAX_VALUE;
        public double minInput;
        public boolean matchRange = true;
        public Synapse.RangeVisibility startVisibility = Synapse.RangeVisibility.MAX_OUTPUT;
        public Synapse.RangeVisibility endVisibility = Synapse.RangeVisibility.MAX_OUTPUT;
        public Synapse.RangeSignal startSignal = Synapse.RangeSignal.START;
        public Synapse.RangeSignal endSignal = Synapse.RangeSignal.END;
        public Integer relativeRid;
        public Integer absoluteRid;

        public Input setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Input setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Input setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Input setMaxLowerWeightsSum(double maxLowerWeightsSum) {
            this.maxLowerWeightsSum = maxLowerWeightsSum;
            return this;
        }

        public Input setWeight(Double weight) {
            this.weight = weight;
            return this;
        }

        public Input setMinInput(double minInput) {
            this.minInput = minInput;
            return this;
        }

        public Input setAbsoluteRid(Integer absoluteRid) {
            this.absoluteRid = absoluteRid;
            return this;
        }

        public Input setRelativeRid(Integer relativeRid) {
            this.relativeRid = relativeRid;
            return this;
        }

        public Input setMatchRange(boolean matchRange) {
            this.matchRange = matchRange;
            return this;
        }

        public Input setStartVisibility(Synapse.RangeVisibility rv) {
            this.startVisibility = rv;
            return this;
        }

        public Input setEndVisibility(Synapse.RangeVisibility rv) {
            this.endVisibility = rv;
            return this;
        }

        public Input setStartSignal(Synapse.RangeSignal startSignal) {
            this.startSignal = startSignal;
            return this;
        }

        public Input setEndSignal(Synapse.RangeSignal endSignal) {
            this.endSignal = endSignal;
            return this;
        }

        @Override
        public int compareTo(Input in) {
            int r = Double.compare(this.weight, in.weight);
            if (r != 0) {
                return r;
            }
            r = Double.compare(this.minInput, in.minInput);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.optional, in.optional);
            if (r != 0) {
                return r;
            }
            r = this.neuron.compareTo(in.neuron);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.matchRange, in.matchRange);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, in.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, in.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.startVisibility.ordinal(), in.startVisibility.ordinal());
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.endVisibility.ordinal(), in.endVisibility.ordinal());
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.startSignal.ordinal(), in.startSignal.ordinal());
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.endSignal.ordinal(), in.endSignal.ordinal());
            return r;
        }
    }

    public class BackPropagationQueue {
        public final TreeSet<Activation> queue = new TreeSet<Activation>(new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                Activation.State fs1 = act1.finalState;
                Activation.State fs2 = act2.finalState;
                int r = 0;
                if (fs2 == null && fs1 != null) {
                    return -1;
                }
                if (fs2 != null && fs1 == null) {
                    return 1;
                }
                if (fs2 != null && fs1 != null) {
                    r = Integer.compare(fs2.fired, fs1.fired);
                }
                if (r != 0) {
                    return r;
                }
                return act1.key.compareTo(act2.key);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Activation act) {
            if (!act.isQueued && !act.key.n.neuron.noTraining) {
                act.isQueued = true;
                act.queueId = this.queueIdCounter++;
                this.queue.add(act);
            }
        }

        public void backpropagtion() {
            while (!this.queue.isEmpty()) {
                Activation act = this.queue.pollFirst();
                act.isQueued = false;
                act.key.n.neuron.computeErrorSignal(Iteration.this, act);
            }
        }
    }

    public static class VEntry
    implements Comparable<VEntry> {
        public int round;
        public Activation act;

        public VEntry(int round, Activation act) {
            this.round = round;
            this.act = act;
        }

        @Override
        public int compareTo(VEntry ve) {
            int r = Integer.compare(this.round, ve.round);
            if (r != 0) {
                return r;
            }
            return this.act.compareTo(ve.act);
        }
    }

    public class ValueQueue {
        public final TreeSet<VEntry> queue = new TreeSet();

        public void propagateWeight(int round, Activation act, long v) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                int r = sa.s.key.isRecurrent ? round + 1 : round;
                this.add(r, sa.output, v);
            }
        }

        public Neuron.NormWeight adjustWeight(ExpandNode cand, List<Option> changed) {
            long v = Activation.visitedCounter++;
            for (Option n : changed) {
                this.addAllActs(n.getNeuronActivations(), v);
                if (n.refByOrOption == null) continue;
                for (Option on : n.refByOrOption) {
                    this.addAllActs(on.getNeuronActivations(), v);
                }
            }
            return this.processChanges(cand, v);
        }

        private void addAllActs(Collection<Activation> acts, long v) {
            for (Activation act : acts) {
                if (act.key.n.neuron instanceof InputNeuron) continue;
                this.add(0, act, v);
            }
        }

        public void add(int round, Activation act, long v) {
            this.queue.add(new VEntry(round, act));
        }

        public Neuron.NormWeight processChanges(ExpandNode en, long v) {
            Neuron.NormWeight delta = Neuron.NormWeight.ZERO_WEIGHT;
            while (!this.queue.isEmpty()) {
                VEntry e = this.queue.pollFirst();
                int round = e.round;
                Activation act = e.act;
                Activation.State s = act.key.n.neuron.computeWeight(e.round, act, en);
                if (OPTIMIZE_DEBUG_OUTPUT) {
                    log.info(act.key + " Round:" + round);
                    log.info("Value:" + s.value + "  Weight:" + s.weight.w + "  Norm:" + s.weight.n + "\n");
                }
                if (round != 0 && act.rounds.get(round).equalsWithWeights(s)) continue;
                ExpandNode.StateChange.saveOldState(en.modifiedActs, act, v);
                Activation.State oldState = act.rounds.get(round);
                boolean propagate = act.rounds.set(round, s);
                ExpandNode.StateChange.saveNewState(act);
                if (propagate) {
                    this.propagateWeight(round, act, v);
                }
                if (round == 0) {
                    this.add(1, act, v);
                }
                if (act.rounds.getLastRound() == null || round < act.rounds.getLastRound()) continue;
                Neuron.NormWeight oldWeight = oldState.weight;
                delta = delta.add(s.weight.sub(oldWeight));
            }
            return delta;
        }
    }

    public class UpperBoundQueue {
        public final ArrayDeque<Activation> queue = new ArrayDeque();

        public void add(Activation act) {
            if (!act.ubQueued) {
                act.ubQueued = true;
                this.queue.addLast(act);
            }
        }

        public boolean process() {
            boolean flag = false;
            while (!this.queue.isEmpty()) {
                flag = true;
                Activation act = this.queue.pollFirst();
                act.ubQueued = false;
                double oldUpperBound = act.upperBound;
                Neuron n = act.key.n.neuron;
                n.computeBounds(act);
                if (Math.abs(act.upperBound - oldUpperBound) > 0.01) {
                    for (Activation.SynapseActivation sa : act.neuronOutputs) {
                        this.add(sa.output);
                    }
                }
                if (oldUpperBound <= 0.0 && act.upperBound > 0.0) {
                    for (InputNode out : n.outputNodes.values()) {
                        out.addActivation(Iteration.this, act);
                    }
                    continue;
                }
                if (!(oldUpperBound > 0.0) || !(act.upperBound <= 0.0)) continue;
                for (InputNode out : n.outputNodes.values()) {
                    out.removeActivation(Iteration.this, act);
                }
            }
            return flag;
        }
    }

    public class Queue {
        public final TreeSet<Node> queue = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                return Long.compare(n1.queueId, n2.queueId);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Node n) {
            if (!n.isQueued) {
                n.isQueued = true;
                n.queueId = this.queueIdCounter++;
                this.queue.add(n);
            }
        }

        public void processChanges() {
            while (!this.queue.isEmpty()) {
                Node n = this.queue.pollFirst();
                n.isQueued = false;
                n.processChanges(Iteration.this);
                if (!APPLY_DEBUG_OUTPUT) continue;
                log.info("QueueId:" + n.queueId);
                log.info(n.toString() + "\n");
                log.info("\n" + Iteration.this.networkStateToString(false, false));
            }
        }
    }
}

