/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Iteration;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class Model
implements Writable {
    public int numberOfThreads = 1;
    public int[] lastCleanup;
    public int[] iterationCounter;
    public Map<String, Neuron> labeledNeurons = Collections.synchronizedMap(new LinkedHashMap());
    public Map<Integer, Neuron> neurons = Collections.synchronizedMap(new TreeMap());
    public Map<Integer, Node> initialNodes;
    public Set<Node>[] allNodes;
    public Statistic stat = new Statistic();
    public Set<AndNode> numberOfPositionsQueue = Collections.synchronizedSet(new TreeSet<AndNode>(new Comparator<AndNode>(){

        @Override
        public int compare(AndNode n1, AndNode n2) {
            int r = Integer.compare(n1.numberOfPositionsNotify, n2.numberOfPositionsNotify);
            if (r != 0) {
                return r;
            }
            return n1.compareTo(n2);
        }
    }));
    public volatile int numberOfPositions;

    public Model() {
        this(1);
    }

    public Model(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        this.lastCleanup = new int[numberOfThreads];
        this.iterationCounter = new int[numberOfThreads];
        this.allNodes = new Set[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.allNodes[i] = new TreeSet<Node>();
        }
    }

    public Iteration startIteration(Document doc, int threadId) {
        int n = threadId;
        int n2 = this.iterationCounter[n];
        this.iterationCounter[n] = n2 + 1;
        Iteration t = new Iteration(doc, this, threadId, n2);
        if (doc != null) {
            t.changeNumberOfPositions(doc.length());
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Network Weights:\n");
        sb.append(this.networkWeightsToString(false));
        sb.append("\n\n\n");
        return sb.toString();
    }

    public void reset() {
        this.labeledNeurons.clear();
        this.neurons.clear();
    }

    public void resetFrequency() {
        for (int t = 0; t < this.numberOfThreads; ++t) {
            for (Node n : this.allNodes[t]) {
                n.frequency = 0;
            }
        }
    }

    public String networkWeightsToString(boolean all) {
        StringBuilder sb = new StringBuilder();
        for (Neuron n : this.neurons.values()) {
            if (!all && n.node.frequency <= 0) continue;
            sb.append(n.toStringWithSynapses());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numberOfThreads);
        out.writeInt(this.numberOfPositions);
        TreeSet<Node> nodes = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                if (n1.level != -1 && n2.level == -1) {
                    return -1;
                }
                if (n1.level == -1 && n2.level != -1) {
                    return 1;
                }
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                return n1.compareTo(n2);
            }
        });
        if (this.initialNodes != null) {
            nodes.addAll(this.initialNodes.values());
        }
        for (Set<Node> n : this.allNodes) {
            nodes.addAll(n);
        }
        out.writeInt(nodes.size());
        for (Node n : nodes) {
            n.write(out);
        }
        out.writeInt(this.neurons.size());
        for (Neuron n : this.neurons.values()) {
            n.write(out);
        }
        out.writeInt(this.neurons.size());
        for (Neuron n : this.neurons.values()) {
            out.writeInt(n.id);
            for (Synapse s : n.inputSynapses) {
                if (s.input == null || !s.input.initialized || s.output == null || !s.output.initialized) continue;
                out.writeBoolean(true);
                s.write(out);
            }
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        Comparable<Node> n;
        int i;
        this.numberOfThreads = in.readInt();
        this.numberOfPositions = in.readInt();
        int s = in.readInt();
        this.initialNodes = new TreeMap<Integer, Node>();
        for (i = 0; i < s; ++i) {
            n = Node.read(in, t);
            this.initialNodes.put(n.id, (Node)n);
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            n = Neuron.read(in, t);
            this.neurons.put(((Neuron)n).id, (Neuron)n);
            if (((Neuron)n).label == null) continue;
            this.labeledNeurons.put(((Neuron)n).label, (Neuron)n);
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            n = t.m.neurons.get(in.readInt());
            while (in.readBoolean()) {
                Synapse syn = Synapse.read(in, t);
                ((Neuron)n).inputSynapses.add(syn);
                ((Neuron)n).inputSynapsesByWeight.add(syn);
            }
        }
    }

    public static Model read(DataInput in) throws IOException {
        Model m = new Model();
        Iteration t = m.startIteration(null, 0);
        m.readFields(in, t);
        return m;
    }

    public static class Statistic {
        public volatile int synapses;
        public volatile int neurons;
        public volatile int neuronFromPattern;
        public volatile int nodes;
        public volatile int[] nodesPerLevel = new int[AndNode.MAX_POS_NODES + 1];
        public volatile int orNodes;
    }
}

