/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.lattice.Node;

public class Option
implements Comparable<Option> {
    public static final Option MIN = new Option(null, -1, 0, 0);
    public static final Option MAX = new Option(null, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int primId;
    public int minPrim = -1;
    public int maxPrim = -1;
    public final int id;
    public int length;
    public Map<Activation, Option> orOptions;
    public Set<Option> refByOrOption;
    public Option largestCommonSubset;
    public Set<Option> linkedByLCS;
    private long visitedLinkRelations;
    private long visitedContains;
    private long visitedCollect;
    private long visitedExpandActivations;
    private long visitedRemoveActivations;
    public long visitedMarkCovered;
    public long markedCovered = -1L;
    public long markedExcluded = -1L;
    private long visitedIsConflicting;
    public long visitedCollectAllConflicting = -1L;
    private long visitedStoreFinalWeight = -1L;
    public long visitedExpandRefinementRecursiveStep = -1L;
    public long visitedCollectConflicts = -1L;
    private long visitedComputeLargestCommonSubset = -1L;
    private long visitedComputeLength = -1L;
    public long visitedCheckExcluded = -1L;
    public long markedConflict = -1L;
    private long visitedComputeParents = -1L;
    private long visitedNumberInnerInputs = -1L;
    public long visitedHasUnsatisfiedPosFeedbackLinks = -1L;
    private int numberInnerInputs = 0;
    private int largestCommonSubsetCount = 0;
    public static long visitedCounter = 1L;
    public final Document doc;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public Option[] parents;
    public Option[] children;
    public int isConflict = -1;
    public Conflicts conflicts = new Conflicts();
    public NavigableMap<Activation.Key, Activation> activations;
    public NavigableSet<Activation> neuronActivations;
    public int refCount = 0;
    private static Comparator<Option> LENGTH_COMP = new Comparator<Option>(){

        @Override
        public int compare(Option n1, Option n2) {
            return Integer.compare(n2.length, n1.length);
        }
    };
    private long visitedComputeChildren = -1L;
    private int numberOfInputsComputeChildren = 0;

    public Option(Document doc, int primId, int id, int length) {
        this(doc, primId, id);
        this.length = length;
    }

    public Option(Document doc, int primId, int id) {
        this.doc = doc;
        this.primId = primId;
        this.id = id;
        this.parents = new Option[0];
        this.children = new Option[0];
    }

    public void computeLargestCommonSubset() {
        int s = this.orOptions.size();
        long vMin = visitedCounter++;
        ArrayList<Option> results = new ArrayList<Option>();
        for (Option on : this.orOptions.values()) {
            on.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, s, 0);
        }
        this.setLCS(results.isEmpty() ? null : Option.add(this.doc, true, results));
    }

    public void computeLargestCommonSubsetIncremental(Option no) {
        if (this.orOptions.size() == 0) {
            this.setLCS(no);
            return;
        }
        long vMin = visitedCounter++;
        ArrayList<Option> results = new ArrayList<Option>();
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, 2, 0);
        }
        no.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, 2, 0);
        this.setLCS(Option.add(this.doc, true, results));
    }

    private void setLCS(Option lcs) {
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.linkedByLCS.remove(this);
        }
        this.largestCommonSubset = lcs;
        if (this.largestCommonSubset != null) {
            if (this.largestCommonSubset.linkedByLCS == null) {
                this.largestCommonSubset.linkedByLCS = new TreeSet<Option>();
            }
            this.largestCommonSubset.linkedByLCS.add(this);
        }
    }

    private void computeLargestCommonSubsetRecursiveStep(List<Option> results, long v, long vMin, int s, int depth) {
        if (this.visitedComputeLargestCommonSubset == v) {
            return;
        }
        if (this.visitedComputeLargestCommonSubset <= vMin) {
            this.largestCommonSubsetCount = 0;
        }
        this.visitedComputeLargestCommonSubset = v;
        ++this.largestCommonSubsetCount;
        if (depth > 10) {
            return;
        }
        if (this.largestCommonSubsetCount == s) {
            results.add(this);
            return;
        }
        for (Option pn : this.parents) {
            pn.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
    }

    public void addOrOption(Activation inputAct, Option n) {
        if (this.orOptions == null) {
            this.orOptions = new TreeMap<Activation, Option>();
        }
        this.computeLargestCommonSubsetIncremental(n);
        this.orOptions.put(inputAct, n);
        if (n.refByOrOption == null) {
            n.refByOrOption = new TreeSet<Option>();
        }
        n.refByOrOption.add(this);
    }

    public void removeOrOption(Activation inputAct, Option n) {
        this.orOptions.remove(inputAct);
        n.refByOrOption.remove(this);
        this.computeLargestCommonSubset();
    }

    public void countRef() {
        if (this.isBottom()) {
            return;
        }
        ++this.refCount;
    }

    public void releaseRef() {
        if (this.isBottom()) {
            return;
        }
        assert (this.refCount > 0);
        --this.refCount;
        if (this.refCount == 0) {
            this.remove();
        }
    }

    void expandActivationsRecursiveStep(Iteration t, Option conflict, long v) {
        if (v == this.visitedExpandActivations) {
            return;
        }
        this.visitedExpandActivations = v;
        for (Activation act : this.getActivations()) {
            act.key.n.propagateAddedActivation(t, act, conflict);
        }
        for (Option p : this.parents) {
            p.expandActivationsRecursiveStep(t, conflict, v);
        }
    }

    void removeActivationsRecursiveStep(Iteration t, Option conflict, long v) {
        if (v == this.visitedRemoveActivations) {
            return;
        }
        this.visitedRemoveActivations = v;
        for (Activation act : this.getActivations()) {
            if (!act.key.o.contains(conflict, false)) continue;
            Node.removeActivationAndPropagate(t, act, act.inputs.values());
        }
        if (this.children != null) {
            for (Option c : this.children) {
                if (c.isRemoved) continue;
                c.removeActivationsRecursiveStep(t, conflict, v);
            }
        }
    }

    public Collection<Activation> getActivations() {
        return this.activations != null ? this.activations.values() : Collections.emptySet();
    }

    public Collection<Activation> getNeuronActivations() {
        return this.neuronActivations != null ? this.neuronActivations : Collections.emptySet();
    }

    public static Option add(Document doc, boolean nonConflicting, Option ... input) {
        ArrayList<Option> in = new ArrayList<Option>();
        for (Option n : input) {
            if (n == null || n.isBottom()) continue;
            in.add(n);
        }
        return Option.add(doc, nonConflicting, in);
    }

    public static Option add(Document doc, boolean nonConflicting, List<Option> inputs) {
        if (inputs.size() == 0) {
            return doc.bottom;
        }
        Iterator<Option> it = inputs.iterator();
        while (it.hasNext()) {
            if (!it.next().isBottom()) continue;
            it.remove();
        }
        if (inputs.size() == 1 || inputs.size() == 2 && inputs.get(0) == inputs.get(1)) {
            Option n = inputs.get(0);
            if (nonConflicting && n.isConflicting(visitedCounter++)) {
                return null;
            }
            n.countRef();
            return n;
        }
        ArrayList<Option> parents = new ArrayList<Option>();
        ArrayList<Option> children = new ArrayList<Option>();
        Option.computeRelations(parents, children, inputs);
        if (parents.size() == 1) {
            Option n = parents.get(0);
            if (nonConflicting && n.isConflicting(visitedCounter++)) {
                return null;
            }
            n.countRef();
            return n;
        }
        if (nonConflicting) {
            for (Option p : parents) {
                if (!p.isConflicting(visitedCounter++)) continue;
                return null;
            }
        }
        Option n = new Option(doc, -1, doc.optionIdCounter++);
        super.linkRelations(parents, children, visitedCounter++);
        n.length = super.computeLength(visitedCounter++);
        n.minPrim = Integer.MAX_VALUE;
        n.maxPrim = Integer.MIN_VALUE;
        for (Option in : inputs) {
            n.minPrim = Math.min(n.minPrim, in.minPrim);
            n.maxPrim = Math.max(n.maxPrim, in.maxPrim);
        }
        n.countRef();
        return n;
    }

    public static void computeRelations(List<Option> parentsResults, List<Option> childrenResults, List<Option> inputs) {
        if (inputs.isEmpty()) {
            return;
        }
        long v = visitedCounter++;
        boolean i = false;
        int s = inputs.size();
        Collections.sort(inputs, LENGTH_COMP);
        if (s == 2 && inputs.get((int)1).primId >= 0 && inputs.get((int)1).children.length == 0) {
            parentsResults.addAll(inputs);
            return;
        }
        for (int pass = 0; pass <= 1; ++pass) {
            for (Option n : inputs) {
                n.computeParents(parentsResults, v, pass);
            }
            ++visitedCounter;
        }
        if (parentsResults.size() == 1) {
            return;
        }
        assert (parentsResults.size() != 0);
        for (Option n : inputs) {
            n.computeChildren(childrenResults, visitedCounter++, v, inputs.size(), 0);
        }
        inputs.get(0).computeChildren(childrenResults, visitedCounter++, v, inputs.size(), 1);
    }

    private void computeParents(List<Option> parentResults, long v, int pass) {
        if (this.visitedComputeParents == v || this.length == 0) {
            return;
        }
        this.visitedComputeParents = v;
        for (Option pn : this.parents) {
            pn.computeParents(parentResults, v, pass);
        }
        boolean flag = true;
        for (Option cn : this.children) {
            if (pass == 0) {
                if (cn.visitedNumberInnerInputs != v) {
                    cn.numberInnerInputs = 0;
                    cn.visitedNumberInnerInputs = v;
                }
                ++cn.numberInnerInputs;
            }
            if (cn.numberInnerInputs != cn.parents.length) continue;
            cn.computeParents(parentResults, v, pass);
            flag = false;
        }
        if (flag && pass == 1) {
            parentResults.add(this);
        }
    }

    private void computeChildren(List<Option> childrenResults, long v, long nv, int s, int pass) {
        if (this.visitedComputeChildren == v) {
            return;
        }
        if (pass == 0) {
            if (this.visitedComputeChildren <= nv) {
                this.numberOfInputsComputeChildren = 0;
            }
            ++this.numberOfInputsComputeChildren;
        }
        this.visitedComputeChildren = v;
        if (pass == 1 && this.numberOfInputsComputeChildren == s) {
            boolean covered = false;
            for (Option pn : this.parents) {
                if (pn.numberOfInputsComputeChildren != s) continue;
                covered = true;
                break;
            }
            if (!covered) {
                childrenResults.add(this);
            }
        } else {
            for (Option cn : this.children) {
                cn.computeChildren(childrenResults, v, nv, s, pass);
            }
        }
    }

    private int computeLength(long v) {
        if (this.visitedComputeLength == v) {
            return 0;
        }
        this.visitedComputeLength = v;
        if (this.primId >= 0) {
            return 1;
        }
        int result = 0;
        for (Option p : this.parents) {
            result += p.computeLength(v);
        }
        return result;
    }

    private void linkRelations(List<Option> pSet, List<Option> cSet, long v) {
        for (Option p : pSet) {
            Option.addLink(p, this);
        }
        for (Option c : cSet) {
            c.visitedLinkRelations = v;
            Option.addLink(this, c);
        }
        for (Option p : pSet) {
            ArrayList<Option> tmp = new ArrayList<Option>();
            for (Option c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (Option c : tmp) {
                Option.removeLink(p, c);
            }
        }
    }

    public static void addLink(Option a, Option b) {
        a.children = Option.addToArray(a.children, b);
        b.parents = Option.addToArray(b.parents, a);
    }

    public static void removeLink(Option a, Option b) {
        a.children = Option.removeToArray(a.children, b);
        b.parents = Option.removeToArray(b.parents, a);
    }

    private static Option[] addToArray(Option[] in, Option n) {
        Option[] r = Arrays.copyOf(in, in.length + 1);
        r[in.length] = n;
        return r;
    }

    private static Option[] removeToArray(Option[] in, Option n) {
        Option[] r = new Option[in.length - 1];
        int i = 0;
        for (Option x : in) {
            if (x == n) continue;
            r[i++] = x;
        }
        return r;
    }

    public static Option addPrimitive(Document doc) {
        assert (doc != null);
        Option n = new Option(doc, doc.bottom.children.length, doc.optionIdCounter++, 1);
        n.minPrim = n.primId;
        n.maxPrim = n.primId;
        n.countRef();
        Option.addLink(doc.bottom, n);
        return n;
    }

    private void remove() {
        assert (!this.isRemoved);
        this.isRemoved = true;
        this.removedId = removedIdCounter++;
        for (Option p : this.parents) {
            p.children = Option.removeToArray(p.children, this);
        }
        for (Option c : this.children) {
            c.parents = Option.removeToArray(c.parents, this);
        }
        for (Option p : this.parents) {
            for (Option c : this.children) {
                if (c.isLinked(p, visitedCounter++)) continue;
                Option.addLink(p, c);
            }
        }
        this.parents = null;
        this.children = null;
        this.conflicts = null;
    }

    public boolean isBottom() {
        return this.length == 0;
    }

    public boolean contains(boolean dir, Option n, boolean followLCS) {
        boolean r = !dir ? this.contains(n, followLCS) : n.contains(this, followLCS);
        return r;
    }

    public boolean contains(Option n, boolean followLCS) {
        return this.contains(n, followLCS, visitedCounter++);
    }

    private boolean contains(Option n, boolean followLCS, long v) {
        this.visitedContains = v;
        if (this == n || n.isBottom()) {
            return true;
        }
        if (!followLCS && this.length <= n.length) {
            return false;
        }
        for (Option p : this.parents) {
            if (n.maxPrim < p.minPrim || n.minPrim > p.maxPrim || p.visitedContains == v || !p.contains(n, followLCS, v)) continue;
            return true;
        }
        return followLCS && this.largestCommonSubset != null && this.largestCommonSubset.contains(n, followLCS, v);
    }

    private boolean isLinked(Option n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (this == n) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        for (Option p : this.parents) {
            if (p.visitedContains == v || !p.isLinked(n, v)) continue;
            return true;
        }
        return false;
    }

    private void collectPrimitiveNodes(Set<Option> results, long v) {
        if (v == this.visitedCollect) {
            return;
        }
        this.visitedCollect = v;
        if (this.primId >= 0) {
            results.add(this);
        } else {
            for (Option n : this.parents) {
                n.collectPrimitiveNodes(results, v);
            }
        }
    }

    public void collectConflicts(Set<Option> conflicts, long v) {
        if (this.visitedCollectConflicts == v) {
            return;
        }
        this.visitedCollectConflicts = v;
        for (Option n : this.children) {
            if (this.isConflict >= 0) {
                conflicts.add(n);
            }
            n.collectConflicts(conflicts, v);
        }
    }

    public boolean isConflicting(long v) {
        if (this.isConflict >= 0) {
            return true;
        }
        if (this.conflictsAllowed()) {
            if (this.visitedIsConflicting == v) {
                return false;
            }
            this.visitedIsConflicting = v;
            for (Option p : this.parents) {
                if (!p.isConflicting(v)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean conflictsAllowed() {
        return this.activations == null || this.activations.isEmpty();
    }

    public void storeFinalWeight(long v) {
        if (this.visitedStoreFinalWeight == v) {
            return;
        }
        this.visitedStoreFinalWeight = v;
        for (Activation act : this.getNeuronActivations()) {
            act.finalState = act.rounds.getLast();
        }
        for (Option cn : this.children) {
            cn.storeFinalWeight(v);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean level) {
        TreeSet<Option> ids = new TreeSet<Option>();
        this.collectPrimitiveNodes(ids, visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean f1 = true;
        for (Option n : ids) {
            if (!f1) {
                sb.append(",");
            }
            f1 = false;
            sb.append(n.primId);
            if (level || n.orOptions == null) continue;
            sb.append("[");
            boolean f2 = true;
            for (Option on : n.orOptions.values()) {
                if (!f2) {
                    sb.append(",");
                }
                f2 = false;
                sb.append(on.toString(true));
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(Option n) {
        int r = Integer.compare(this.length, n.length);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, n.id);
    }

    public static int compare(Option oa, Option ob) {
        if (oa == ob) {
            return 0;
        }
        if (oa == null && ob != null) {
            return -1;
        }
        if (oa != null && ob == null) {
            return 1;
        }
        return oa.compareTo(ob);
    }

    public static enum Relation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN;


        public boolean compare(Option a, Option b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case CONTAINS: {
                    return a.contains(b, false);
                }
                case CONTAINED_IN: {
                    return b.contains(a, false);
                }
            }
            return false;
        }
    }
}

