/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.NavigableMap;
import java.util.stream.Stream;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.corpus.Option;
import org.aika.lattice.Node;
import org.aika.neuron.Synapse;

public class Range {
    public static final Range MIN = new Range(Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final Range MAX = new Range(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int begin;
    public final int end;

    public Range(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public static Range applyVisibility(Range ra, Synapse.RangeVisibility[] rav, Range rb, Synapse.RangeVisibility[] rbv) {
        return new Range(Synapse.RangeVisibility.apply(ra.begin, rav[0], rb.begin, rbv[0], false), Synapse.RangeVisibility.apply(ra.end, rav[1], rb.end, rbv[1], true));
    }

    public boolean contains(int p) {
        return this.begin <= p && p < this.end;
    }

    public static boolean contains(Range ra, Range rb) {
        return ra.begin <= rb.begin && ra.end >= rb.end;
    }

    public static boolean overlaps(Range ra, Range rb) {
        return ra.end > rb.begin && rb.end > ra.begin;
    }

    public int getBegin(boolean invert) {
        return invert ? this.end : this.begin;
    }

    public int getEnd(boolean invert) {
        return invert ? this.begin : this.end;
    }

    public Range invert(boolean inv) {
        return inv ? new Range(this.end, this.begin) : this;
    }

    public boolean isEmpty() {
        return this.end - this.begin == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.begin);
        sb.append(",");
        sb.append(this.end);
        sb.append(")");
        return sb.toString();
    }

    public static int compare(Range ra, Range rb, boolean inv) {
        if (ra == null && rb == null) {
            return 0;
        }
        if (ra == null && rb != null) {
            return -1;
        }
        if (ra != null && rb == null) {
            return 1;
        }
        int a = Integer.compare(ra.getBegin(inv), rb.getBegin(inv));
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.getEnd(inv), rb.getEnd(inv));
        return b;
    }

    public static int compare(Range ra, Range rb) {
        int a = Integer.compare(ra.begin, rb.begin);
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.end, rb.end);
        return b;
    }

    public static class BeginEndMatcher
    extends Relation {
        boolean[] mra;
        boolean[] mrb;

        public BeginEndMatcher(boolean[] mra, boolean[] mrb) {
            this.mra = mra;
            this.mrb = mrb;
        }

        @Override
        public boolean match(Range ra, Range rb) {
            if (this.mra[0] && this.mrb[0]) {
                return ra.begin == rb.begin;
            }
            if (this.mra[1] && this.mrb[1]) {
                return ra.end == rb.end;
            }
            if (this.mra[1] && this.mrb[0]) {
                return (rb.begin == Integer.MIN_VALUE && ra.begin < rb.end || ra.begin == rb.begin) && (ra.end == Integer.MAX_VALUE && rb.end > ra.begin || ra.end >= rb.end);
            }
            if (this.mra[0] && this.mrb[1]) {
                return (rb.end == Integer.MAX_VALUE && ra.end > rb.begin || ra.end == rb.end) && (ra.begin == Integer.MIN_VALUE && rb.begin < ra.end || ra.begin <= rb.begin);
            }
            return true;
        }

        @Override
        public Stream<Activation> getActivations(Iteration t, Node n, Integer rid, Range r, Option o, Option.Relation or) {
            NavigableMap<Activation.Key, Activation> tmp;
            boolean flag = false;
            Node.ThreadState th = n.getThreadState(t);
            if (this.mra[0] && this.mrb[0]) {
                tmp = th.activations.subMap(new Activation.Key(n, new Range(r.begin, Integer.MIN_VALUE), null, Option.MIN), true, new Activation.Key(n, new Range(r.begin, Integer.MAX_VALUE), Integer.MAX_VALUE, Option.MAX), true);
            } else if (this.mra[1] && this.mrb[1]) {
                tmp = th.activationsEnd.subMap(new Activation.Key(n, new Range(Integer.MIN_VALUE, r.end), null, Option.MIN), true, new Activation.Key(n, new Range(Integer.MAX_VALUE, r.end), Integer.MAX_VALUE, Option.MAX), true);
            } else if (this.mra[1] && this.mrb[0]) {
                tmp = th.activations.descendingMap().subMap(new Activation.Key(n, new Range(r.end, Integer.MAX_VALUE), Integer.MAX_VALUE, Option.MAX), false, new Activation.Key(n, MIN, null, Option.MIN), true);
                flag = true;
            } else if (this.mra[0] && this.mrb[1]) {
                tmp = th.activationsEnd.subMap(new Activation.Key(n, new Range(Integer.MIN_VALUE, r.begin), null, Option.MIN), false, new Activation.Key(n, MAX, Integer.MAX_VALUE, Option.MAX), true);
                flag = true;
            } else {
                tmp = th.activations;
            }
            Stream<Activation> s = tmp.values().stream().filter(act -> act.filter(n, rid, r, this, o, or));
            return !flag ? s : s.limit(1L);
        }
    }

    public static class SynapseRangeMatcher
    extends Relation {
        public boolean dir;
        public Synapse s;

        public SynapseRangeMatcher(Synapse s, boolean dir) {
            this.s = s;
            this.dir = dir;
        }

        @Override
        public boolean match(Range ra, Range rb) {
            int x = this.getDirection() ? ra.end : ra.begin;
            int y = this.getSignal() ? rb.end : rb.begin;
            return x == y;
        }

        private boolean getDirection() {
            if (!this.dir && this.s.key.startSignal == Synapse.RangeSignal.START && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (!this.dir && this.s.key.endSignal == Synapse.RangeSignal.START && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (this.dir && this.s.key.startSignal != Synapse.RangeSignal.NONE && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (!this.dir && this.s.key.startSignal == Synapse.RangeSignal.END && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return true;
            }
            if (!this.dir && this.s.key.endSignal == Synapse.RangeSignal.END && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return true;
            }
            return this.dir && this.s.key.endSignal != Synapse.RangeSignal.NONE && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT;
        }

        private boolean getSignal() {
            if (!this.dir && this.s.key.startSignal == Synapse.RangeSignal.START && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (!this.dir && this.s.key.startSignal == Synapse.RangeSignal.END && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (this.dir && this.s.key.startSignal == Synapse.RangeSignal.START && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (this.dir && this.s.key.endSignal == Synapse.RangeSignal.START && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return false;
            }
            if (!this.dir && this.s.key.endSignal == Synapse.RangeSignal.START && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return true;
            }
            if (!this.dir && this.s.key.endSignal == Synapse.RangeSignal.END && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return true;
            }
            if (this.dir && this.s.key.startSignal == Synapse.RangeSignal.END && this.s.key.startVisibility == Synapse.RangeVisibility.MATCH_INPUT) {
                return true;
            }
            return this.dir && this.s.key.endSignal == Synapse.RangeSignal.END && this.s.key.endVisibility == Synapse.RangeVisibility.MATCH_INPUT;
        }

        @Override
        public Stream<Activation> getActivations(Iteration t, Node n, Integer rid, Range r, Option o, Option.Relation or) {
            Node.ThreadState th = n.getThreadState(t);
            boolean x = this.getDirection();
            int y = this.getSignal() ? r.end : r.begin;
            NavigableMap<Activation.Key, Activation> tmp = (x ? th.activationsEnd : th.activations).subMap(new Activation.Key(n, x ? new Range(Integer.MIN_VALUE, y) : new Range(y, Integer.MIN_VALUE), null, Option.MIN), true, new Activation.Key(n, x ? new Range(Integer.MAX_VALUE, y) : new Range(y, Integer.MAX_VALUE), Integer.MAX_VALUE, Option.MAX), true);
            return tmp.values().stream().filter(act -> act.filter(n, rid, r, this, o, or));
        }
    }

    public static abstract class Relation {
        public static Relation EQUALS = new Relation(){

            @Override
            public boolean match(Range ra, Range rb) {
                return Range.compare(ra, rb, false) == 0;
            }

            public Stream getActivations(Iteration t, Node n, Integer rid, Range r, Option o, Option.Relation or) {
                return n.getThreadState((Iteration)t).activations.subMap(new Activation.Key(n, r, null, Option.MIN), true, new Activation.Key(n, r, Integer.MAX_VALUE, Option.MAX), true).values().stream().filter(act -> act.filter(n, rid, r, this, o, or));
            }
        };
        public static Relation CONTAINS = new Relation(){

            @Override
            public boolean match(Range ra, Range rb) {
                return Range.contains(ra, rb);
            }
        };
        public static Relation OVERLAPS = new Relation(){

            @Override
            public boolean match(Range ra, Range rb) {
                return Range.overlaps(ra, rb);
            }
        };
        public static Relation BEGINS_WITH = new Relation(){

            @Override
            public boolean match(Range ra, Range rb) {
                return ra.begin == rb.begin;
            }
        };
        public static Relation ENDS_WITH = new Relation(){

            @Override
            public boolean match(Range ra, Range rb) {
                return ra.end == rb.end;
            }
        };

        public abstract boolean match(Range var1, Range var2);

        public Stream<Activation> getActivations(Iteration t, Node n, Integer rid, Range r, Option o, Option.Relation or) {
            return n.getThreadState((Iteration)t).activations.values().stream().filter(act -> act.filter(n, rid, r, this, o, or));
        }
    }
}

