/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.aika.Activation;
import org.aika.Iteration;
import org.aika.Model;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class OrNode
extends Node {
    public TreeMap<Integer, TreeSet<Node>> parents = new TreeMap();

    public OrNode() {
    }

    public OrNode(Iteration t) {
        super(t, -1);
        Model m = t.m;
        ++m.stat.nodes;
        ++m.stat.orNodes;
        this.endRequired = true;
        this.ridRequired = true;
    }

    @Override
    public void computeNullHyp(Model m) {
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        return false;
    }

    @Override
    public boolean isAllowedOption(Iteration t, Option n, Activation act, long v) {
        return false;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
        for (Synapse s : this.neuron.inputSynapses) {
            if (!s.key.isNeg && !s.key.isRecurrent) continue;
            Activation.select(t, s.inputNode, Utils.nullSafeAdd(act.key.rid, false, s.key.relativeRid, false), act.key.r, Range.Relation.OVERLAPS, null, null).forEach(iAct -> iAct.outputs.put(activation.key, act));
        }
        if (this.getThreadState((Iteration)t).activations.isEmpty()) {
            t.activatedNeurons.add(this.neuron);
        }
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
        if (this.getThreadState((Iteration)t).activations.isEmpty()) {
            t.activatedNeurons.remove(this.neuron);
        }
    }

    public void updateActivation(Iteration t, Range inputR, Integer rid) {
        ArrayList<Activation> inputs = new ArrayList<Activation>();
        Range r = null;
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            r = this.extractRange(t, inputR, rid, inputs, r, me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, me.getValue());
        }
        Range fr = r;
        Activation.select(t, this, rid, inputR, Range.Relation.OVERLAPS, null, null).forEach(oAct -> {
            Iterator<Activation> it = oAct.inputs.values().iterator();
            while (it.hasNext()) {
                Activation iAct = it.next();
                if (fr == null || Range.compare(fr, oAct.key.r) != 0) {
                    oAct.isReplaced = true;
                    oAct.key.o.removeOrOption(iAct, iAct.key.o);
                    OrNode.removeActivationAndPropagate(t, oAct, oAct.inputs.values());
                }
                if (!iAct.isRemoved) continue;
                oAct.key.o.removeOrOption(iAct, iAct.key.o);
                it.remove();
            }
        });
        if (inputs.isEmpty()) {
            return;
        }
        Option no = this.lookupOrOption(t, r, true);
        for (Activation iAct : inputs) {
            no.addOrOption(iAct, iAct.key.o);
        }
        Activation.Key nak = new Activation.Key(this, r, rid, no);
        OrNode.addActivationAndPropagate(t, nak, inputs);
    }

    private Range extractRange(Iteration t, Range inputR, Integer rid, List<Activation> inputs, Range r, Integer pRidOffset, TreeSet<Node> parents) {
        if (parents.size() > 10) {
            return this.extractRange(t, null, inputR, rid, inputs, r, pRidOffset, parents);
        }
        for (Node pn : parents) {
            r = this.extractRange(t, pn, inputR, rid, inputs, r, pRidOffset, parents);
        }
        return r;
    }

    private Range extractRange(Iteration t, Node n, Range inputR, Integer rid, List<Activation> inputs, Range r, Integer pRidOffset, TreeSet<Node> parents) {
        for (Activation iAct : Activation.select(t, n, Utils.nullSafeAdd(rid, true, pRidOffset, false), inputR, Range.Relation.OVERLAPS, null, null).collect(Collectors.toList())) {
            if (iAct.isRemoved || !parents.contains(iAct.key.n) || this.checkSelfReferencing(t, iAct)) continue;
            inputs.add(iAct);
            r = r == null ? iAct.key.r : new Range(Math.min(r.begin, iAct.key.r.begin), Math.max(r.end, iAct.key.r.end));
        }
        return r;
    }

    public void addActivation(Iteration t, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(t, inputAct)) {
            return;
        }
        Activation.Key ak = inputAct.key;
        this.updateActivation(t, ak.r, Utils.nullSafeSub(ak.rid, true, ridOffset, false));
    }

    public void removeActivation(Iteration t, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(t, inputAct)) {
            return;
        }
        Activation.Key ak = inputAct.key;
        this.updateActivation(t, ak.r, Utils.nullSafeSub(ak.rid, true, ridOffset, false));
    }

    private boolean checkSelfReferencing(Iteration t, Activation inputAct) {
        Option o = this.lookupOrOption(t, inputAct.key.r, false);
        if (o == null) {
            return false;
        }
        return inputAct.key.o.contains(o, true);
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Option removedConflict) {
        if (removedConflict == null) {
            this.neuron.propagateAddedActivation(t, act);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act) {
        this.neuron.propagateRemovedActivation(t, act);
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup(Iteration t) {
    }

    @Override
    protected boolean hasSupport(Activation act) {
        if (act.isReplaced) {
            return false;
        }
        for (Activation iAct : act.inputs.values()) {
            if (iAct.isRemoved) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(Iteration t, Activation act, Option conflict) {
        if (conflict == null) {
            OrNode.processCandidate(t, this, act, false);
        }
    }

    @Override
    public void discover(Iteration t, Activation act) {
    }

    public static void processCandidate(Iteration t, Node parentNode, Activation inputAct, boolean train) {
        Activation.Key ak = inputAct.key;
        parentNode.lock.acquireReadLock();
        if (parentNode.orChildren != null) {
            for (OrEntry oe : parentNode.orChildren) {
                if (ak.o.isConflicting(Option.visitedCounter++)) continue;
                ((OrNode)oe.node).addActivation(t, oe.ridOffset, inputAct);
            }
        }
        parentNode.lock.releaseReadLock();
    }

    public Option lookupOrOption(Iteration t, Range r, boolean create) {
        Activation act = Activation.select(t, this, null, r, Range.Relation.CONTAINS, null, null).findFirst().orElse(null);
        if (act != null) {
            return act.key.o;
        }
        for (Activation.Key ak : this.getThreadState((Iteration)t).added.keySet()) {
            if (Range.compare(ak.r, r) != 0) continue;
            return ak.o;
        }
        return create ? Option.addPrimitive(t.doc) : null;
    }

    protected Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void changeNumberOfNeuronRefs(Iteration t, long v, int d) {
        throw new UnsupportedOperationException();
    }

    public void addInput(Iteration t, Integer ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(t, Node.visitedCounter++, 1);
        in.addOrChild(t, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(t.threadId);
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeSet<Node> pn = this.parents.get(key);
        if (pn == null) {
            pn = new TreeSet();
            this.parents.put(key, pn);
        }
        pn.add(in);
        this.lock.releaseWriteLock();
    }

    public void removeInput(Iteration t, Integer ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(t, Node.visitedCounter++, -1);
        in.removeOrChild(t, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(t.threadId);
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeSet<Node> pn = this.parents.get(key);
        if (pn != null) {
            pn.remove(in);
            if (pn.isEmpty() && ridOffset != null) {
                this.parents.remove(key);
            }
        }
        this.lock.releaseWriteLock();
    }

    public void removeAllInputs(Iteration t) {
        this.lock.acquireWriteLock(t.threadId);
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                pn.changeNumberOfNeuronRefs(t, Node.visitedCounter++, -1);
                pn.removeOrChild(t, new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this));
            }
        }
        this.parents.clear();
        this.lock.releaseWriteLock();
    }

    @Override
    public void remove(Iteration t) {
        super.remove(t);
        this.lock.acquireReadLock();
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                pn.removeOrChild(t, new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this));
            }
        }
        this.lock.releaseReadLock();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        block0: for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(me.getKey() != Integer.MIN_VALUE ? me.getKey() : "X");
                sb.append(":");
                sb.append(pn.logicToString());
                if (i > 10) {
                    sb.append(",...");
                    continue block0;
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("O");
        super.write(out);
        out.writeInt(this.parents.size());
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            out.writeInt(me.getKey());
            out.writeInt(me.getValue().size());
            for (Node pn : me.getValue()) {
                out.writeInt(pn.id);
            }
        }
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        super.readFields(in, t);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            TreeSet<Node> ridParents = new TreeSet<Node>();
            Integer ridOffset = in.readInt();
            this.parents.put(ridOffset, ridParents);
            int sa = in.readInt();
            for (int j = 0; j < sa; ++j) {
                Node pn = t.m.initialNodes.get(in.readInt());
                pn.addOrChild(t, new OrEntry(ridOffset, this));
                ridParents.add(pn);
            }
        }
    }

    public static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public Integer ridOffset;
        public Node node;

        private OrEntry() {
        }

        public OrEntry(Integer ridOffset, Node node) {
            this.ridOffset = ridOffset;
            this.node = node;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ridOffset != null);
            if (this.ridOffset != null) {
                out.writeInt(this.ridOffset);
            }
            out.writeInt(this.node.id);
        }

        @Override
        public void readFields(DataInput in, Iteration t) throws IOException {
            if (in.readBoolean()) {
                this.ridOffset = in.readInt();
            }
            this.node = t.m.initialNodes.get(in.readInt());
        }

        public static OrEntry read(DataInput in, Iteration t) throws IOException {
            OrEntry n = new OrEntry();
            n.readFields(in, t);
            return n;
        }

        @Override
        public int compareTo(OrEntry on) {
            int r = Utils.compareInteger(this.ridOffset, on.ridOffset);
            if (r != 0) {
                return r;
            }
            return this.node.compareTo(on.node);
        }
    }
}

