/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.aika.Iteration;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.neuron.Neuron;

public class Synapse
implements Writable {
    public static final Comparator<Synapse> INPUT_SYNAPSE_BY_WEIGHTS_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = Synapse.compareWeights(s1.w, s2.w, 1.0E-5);
            if (r != 0) {
                return r;
            }
            r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.output.compareTo(s2.output);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public Neuron input;
    public Neuron output;
    public InputNode inputNode;
    public Key key;
    public double w;
    public double maxLowerWeightsSum = Double.MAX_VALUE;

    public Synapse() {
    }

    public Synapse(Neuron input) {
        this.input = input;
    }

    public Synapse(Neuron input, Key key) {
        this.input = input;
        this.key = key;
        assert (this.w >= 0.0 && !key.isNeg || this.w <= 0.0 && key.isNeg);
    }

    public void link(Iteration t) {
        boolean dir = this.input.id < this.output.id;
        (dir ? this.input : this.output).lock.acquireWriteLock(t.threadId);
        (dir ? this.output : this.input).lock.acquireWriteLock(t.threadId);
        this.input.outputSynapses.add(this);
        this.output.inputSynapses.add(this);
        this.output.inputSynapsesByWeight.add(this);
        (dir ? this.input : this.output).lock.releaseWriteLock();
        (dir ? this.output : this.input).lock.releaseWriteLock();
        if (this.output.m != null) {
            ++this.output.m.stat.synapses;
        }
    }

    public static int compareWeights(Double a, Double b, double tolerance) {
        double bAbs;
        double aAbs = Math.abs(a);
        if (aAbs + tolerance < (bAbs = Math.abs(b))) {
            return -1;
        }
        if (aAbs > bAbs + tolerance) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "S " + this.w + " " + this.key.relativeRid + " S:" + (Object)((Object)this.key.startSignal) + " E:" + (Object)((Object)this.key.endSignal) + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.inputNode.id);
        this.key.write(out);
        out.writeDouble(this.w);
        out.writeDouble(this.maxLowerWeightsSum);
    }

    @Override
    public void readFields(DataInput in, Iteration t) throws IOException {
        this.input = t.m.neurons.get(in.readInt());
        this.output = t.m.neurons.get(in.readInt());
        this.inputNode = (InputNode)t.m.initialNodes.get(in.readInt());
        this.key = Key.read(in, t);
        this.w = in.readDouble();
        this.maxLowerWeightsSum = in.readDouble();
        this.input.outputSynapses.add(this);
        this.inputNode.setSynapse(t, new InputNode.SynapseKey(this.key.relativeRid, this.output), this);
    }

    public static Synapse read(DataInput in, Iteration t) throws IOException {
        Synapse k = new Synapse();
        k.readFields(in, t);
        return k;
    }

    public static class Key
    implements Comparable<Key>,
    Writable {
        public static final Key MIN_KEY = new Key();
        public static final Key MAX_KEY = new Key();
        public boolean isNeg;
        public boolean isRecurrent;
        public Integer relativeRid;
        public Integer absoluteRid;
        public boolean matchRange;
        public RangeSignal startSignal;
        public RangeVisibility startVisibility;
        public RangeSignal endSignal;
        public RangeVisibility endVisibility;

        public Key() {
        }

        public Key(boolean isNeg, boolean isRecurrent, Integer relativeRid, Integer absoluteRid, boolean matchRange, RangeSignal startSignal, RangeVisibility startVisibility, RangeSignal endSignal, RangeVisibility endVisibility) {
            this.isNeg = isNeg;
            this.isRecurrent = isRecurrent;
            this.relativeRid = relativeRid;
            this.absoluteRid = absoluteRid;
            this.matchRange = matchRange;
            this.startSignal = startSignal;
            this.startVisibility = startVisibility;
            this.endSignal = endSignal;
            this.endVisibility = endVisibility;
        }

        public Key createInputNodeKey() {
            return this.relativeRid != null ? new Key(this.isNeg, this.isRecurrent, 0, this.absoluteRid, this.matchRange, this.startSignal, this.startVisibility, this.endSignal, this.endVisibility) : this;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isNeg);
            out.writeBoolean(this.isRecurrent);
            out.writeBoolean(this.relativeRid != null);
            if (this.relativeRid != null) {
                out.writeInt(this.relativeRid);
            }
            out.writeBoolean(this.absoluteRid != null);
            if (this.absoluteRid != null) {
                out.writeInt(this.absoluteRid);
            }
            out.writeBoolean(this.matchRange);
            out.writeUTF(this.startSignal.name());
            out.writeUTF(this.startVisibility.name());
            out.writeUTF(this.endSignal.name());
            out.writeUTF(this.endVisibility.name());
        }

        @Override
        public void readFields(DataInput in, Iteration t) throws IOException {
            this.isNeg = in.readBoolean();
            this.isRecurrent = in.readBoolean();
            if (in.readBoolean()) {
                this.relativeRid = in.readInt();
            }
            if (in.readBoolean()) {
                this.absoluteRid = in.readInt();
            }
            this.matchRange = in.readBoolean();
            this.startSignal = RangeSignal.valueOf(in.readUTF());
            this.startVisibility = RangeVisibility.valueOf(in.readUTF());
            this.endSignal = RangeSignal.valueOf(in.readUTF());
            this.endVisibility = RangeVisibility.valueOf(in.readUTF());
        }

        public static Key read(DataInput in, Iteration t) throws IOException {
            Key k = new Key();
            k.readFields(in, t);
            return k;
        }

        @Override
        public int compareTo(Key k) {
            if (this == MIN_KEY && k != MIN_KEY) {
                return -1;
            }
            if (this != MIN_KEY && k == MIN_KEY) {
                return 1;
            }
            if (this == MAX_KEY && k != MAX_KEY) {
                return 1;
            }
            if (this != MAX_KEY && k == MAX_KEY) {
                return -1;
            }
            int r = Boolean.compare(this.isNeg, k.isNeg);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.isRecurrent, k.isRecurrent);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, k.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, k.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.matchRange, k.matchRange);
            if (r != 0) {
                return r;
            }
            r = this.startSignal.compareTo(k.startSignal);
            if (r != 0) {
                return r;
            }
            r = this.startVisibility.compareTo(k.startVisibility);
            if (r != 0) {
                return r;
            }
            r = this.endSignal.compareTo(k.endSignal);
            if (r != 0) {
                return r;
            }
            return this.endVisibility.compareTo(k.endVisibility);
        }
    }

    public static enum RangeVisibility {
        MATCH_INPUT,
        MAX_OUTPUT,
        NONE;


        public static int apply(int a, RangeVisibility rva, int b, RangeVisibility rvb, boolean dir) {
            if (rva == NONE) {
                return b;
            }
            if (rvb == NONE) {
                return a;
            }
            if (dir && a < b || !dir && a >= b) {
                if (rva == MATCH_INPUT) {
                    return a;
                }
                if (rvb == MATCH_INPUT) {
                    return b;
                }
            } else {
                if (rvb == MATCH_INPUT) {
                    return b;
                }
                if (rva == MATCH_INPUT) {
                    return a;
                }
            }
            if (dir) {
                return Math.max(a, b);
            }
            return Math.min(a, b);
        }
    }

    public static enum RangeSignal {
        START,
        END,
        NONE;


        public int getSignalPos(Range r, int def) {
            switch (this) {
                case START: {
                    return r.begin;
                }
                case END: {
                    return r.end;
                }
            }
            return def;
        }

        public String toString() {
            switch (this) {
                case START: {
                    return "S";
                }
                case END: {
                    return "E";
                }
                case NONE: {
                    return "N";
                }
            }
            return "";
        }
    }
}

