/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class Activation
implements Comparable<Activation> {
    public int id;
    public final Key key;
    public boolean isRemoved;
    public int removedId;
    public long visitedNeuronTrain = -1L;
    public static int removedIdCounter = 1;
    public static long visitedCounter = 1L;
    public double upperBound;
    public double lowerBound;
    public Rounds rounds = new Rounds();
    public State finalState;
    public long currentStateV = -1L;
    public SearchNode.StateChange currentStateChange;
    public boolean isTrainingAct;
    public double initialErrorSignal;
    public double errorSignal;
    public TreeMap<Key, Activation> inputs = new TreeMap();
    public TreeMap<Key, Activation> outputs = new TreeMap();
    public TreeSet<SynapseActivation> neuronInputs;
    public TreeSet<SynapseActivation> neuronOutputs;
    public boolean ubQueued = false;
    public boolean isQueued = false;
    public long queueId;

    public Activation(int id, Key key) {
        this.id = id;
        this.key = key;
    }

    public Activation(int id, Node n, Range pos, Integer rid, InterprNode o) {
        this.id = id;
        this.key = new Key(n, pos, rid, o);
    }

    public void link(Collection<Activation> inputActs) {
        for (Activation iAct : inputActs) {
            this.inputs.put(iAct.key, iAct);
            iAct.outputs.put(this.key, this);
        }
    }

    public void unlink(Collection<Activation> inputActs) {
        for (Activation iAct : inputActs) {
            this.inputs.remove(iAct.key);
            iAct.outputs.remove(this.key);
        }
    }

    public void unlink() {
        for (Activation act : this.inputs.values()) {
            act.outputs.remove(this.key);
        }
        for (Activation act : this.outputs.values()) {
            act.inputs.remove(this.key);
        }
    }

    public void register(Document doc) {
        TreeMap<Key, Activation> actRid;
        Node.ThreadState th = this.key.n.getThreadState(doc, true);
        if (th.activations.isEmpty()) {
            (this.isTrainingAct ? doc.activatedNodesForTraining : doc.activatedNodes).add(this.key.n);
        }
        th.activations.put(this.key, this);
        TreeMap<Key, Activation> actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.put(this.key, this);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.put(this.key, this);
        }
        if (this.key.o.activations == null) {
            this.key.o.activations = new TreeMap<Key, Activation>();
        }
        this.key.o.activations.put(this.key, this);
        if (this.key.n.neuron != null) {
            if (this.key.o.neuronActivations == null) {
                this.key.o.neuronActivations = new TreeSet<Activation>();
            }
            this.key.o.neuronActivations.add(this);
        }
        if (this.key.rid != null) {
            doc.activationsByRid.put(this.key, this);
        }
    }

    public void unregister(Document doc) {
        TreeMap<Key, Activation> actRid;
        assert (!this.key.o.activations.isEmpty());
        Node.ThreadState th = this.key.n.getThreadState(doc, true);
        th.activations.remove(this.key);
        TreeMap<Key, Activation> actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.remove(this.key);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.remove(this.key);
        }
        if (th.activations.isEmpty()) {
            (this.isTrainingAct ? doc.activatedNodesForTraining : doc.activatedNodes).remove(this.key.n);
        }
        this.key.o.activations.remove(this.key);
        if (this.key.n.neuron != null) {
            this.key.o.neuronActivations.remove(this);
        }
        if (this.key.rid != null) {
            doc.activationsByRid.remove(this.key);
        }
    }

    public static Activation get(Document doc, Node n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        return Activation.select(doc, n, rid, r, begin, end, o, or).findFirst().orElse(null);
    }

    public static Activation get(Document doc, Node n, Key ak) {
        return Activation.get(doc, n, ak.rid, ak.r, Range.Operator.EQUALS, Range.Operator.EQUALS, ak.o, InterprNode.Relation.EQUALS);
    }

    public static Activation getNextSignal(Node n, Document doc, int from, Integer rid, InterprNode o, boolean dir, boolean inv) {
        Node.ThreadState th = n.getThreadState(doc, false);
        if (th == null) {
            return null;
        }
        Key bk = new Key(null, new Range(from, dir ? Integer.MIN_VALUE : Integer.MAX_VALUE).invert(inv), rid, o);
        TreeMap<Key, Activation> tmp = inv ? th.activationsEnd : th.activations;
        tmp = dir ? tmp.descendingMap() : tmp;
        for (Activation act : tmp.tailMap(bk, false).values()) {
            if (!act.filter(n, rid, null, null, null, o, InterprNode.Relation.CONTAINED_IN)) continue;
            return act;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Stream<Activation> select(Document doc, Node n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        void var8_18;
        if (n != null) {
            Node.ThreadState th = n.getThreadState(doc, false);
            if (th == null) {
                return Stream.empty();
            }
            int s = th.activations.size();
            if (s == 0) {
                return Stream.empty();
            }
            if (s == 1) {
                Stream<Activation> stream = th.activations.values().stream();
                return var8_18.filter(act -> act.filter(n, rid, r, begin, end, o, or));
            } else if (rid != null) {
                Key bk = new Key(n, Range.MIN, rid, InterprNode.MIN);
                Key ek = new Key(n, Range.MAX, rid, InterprNode.MAX);
                if (th.activationsRid == null) return Stream.empty();
                Stream stream = th.activationsRid.subMap(bk, true, ek, true).values().stream();
                return var8_18.filter(act -> act.filter(n, rid, r, begin, end, o, or));
            } else {
                if (begin != null || end != null) return Activation.getActivationsByRange(th, n, rid, r, begin, end, o, or);
                Stream<Activation> stream = th.activations.values().stream();
            }
            return var8_18.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if (rid != null) {
            Key bk = new Key(Node.MIN_NODE, Range.MIN, rid, InterprNode.MIN);
            Key ek = new Key(Node.MAX_NODE, Range.MAX, rid, InterprNode.MAX);
            Stream stream = doc.activationsByRid.subMap(bk, true, ek, true).values().stream();
            return var8_18.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else {
            Stream stream = doc.activatedNodes.stream().flatMap(node -> Activation.getActivationsStream(node, doc));
        }
        return var8_18.filter(act -> act.filter(n, rid, r, begin, end, o, or));
    }

    public static Stream getActivationsByRange(Node.ThreadState th, Node n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<Activation> s;
        if ((begin == Range.Operator.GREATER_THAN || begin == Range.Operator.EQUALS || end == Range.Operator.FIRST) && r.begin != null) {
            int er = (end == Range.Operator.LESS_THAN || end == Range.Operator.EQUALS || end == Range.Operator.FIRST) && r.end != null ? r.end : Integer.MAX_VALUE;
            s = th.activations.subMap(new Key(n, new Range(r.begin, null), null, InterprNode.MIN), true, new Key(n, new Range(er, Integer.MAX_VALUE), Integer.MAX_VALUE, InterprNode.MAX), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if ((begin == Range.Operator.LESS_THAN || begin == Range.Operator.EQUALS) && r.begin != null) {
            s = th.activations.descendingMap().subMap(new Key(n, new Range(r.begin, Integer.MAX_VALUE), null, InterprNode.MAX), true, new Key(n, new Range(null, null), null, InterprNode.MIN), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if (end == Range.Operator.LAST) {
            s = th.activationsEnd.tailMap(new Key(n, new Range(null, r.begin), null, InterprNode.MIN), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else {
            if (begin == Range.Operator.LAST || begin == Range.Operator.FIRST || end == Range.Operator.FIRST) {
                throw new RuntimeException("Not implemented yet!");
            }
            s = th.activations.values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        }
        return s;
    }

    private static Stream<Activation> getActivationsStream(Node n, Document doc) {
        Node.ThreadState th = n.getThreadState(doc, false);
        return th == null ? Stream.empty() : th.activations.values().stream();
    }

    public boolean filter(Node n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        return !(n != null && this.key.n != n || rid != null && (this.key.rid == null || this.key.rid.intValue() != rid.intValue()) || r != null && (begin != null && !begin.compare(this.key.r.begin, this.key.r.end, r.begin, r.end) || end != null && !end.compare(this.key.r.end, this.key.r.begin, r.end, r.begin)) || o != null && !or.compare(this.key.o, o));
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.r);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.r.begin - 3), Math.min(doc.length(), this.key.r.end + 3)));
        sb.append(",");
        sb.append(this.key.n);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Activation act) {
        return this.key.compareTo(act.key);
    }

    public static int compare(Activation a, Activation b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static class SynapseActivation {
        public final Synapse s;
        public final Activation input;
        public final Activation output;
        public static Comparator<SynapseActivation> INPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.INPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.input.compareTo(sa2.input);
            }
        };
        public static Comparator<SynapseActivation> OUTPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.output.compareTo(sa2.output);
            }
        };

        public SynapseActivation(Synapse s, Activation input, Activation output) {
            this.s = s;
            this.input = input;
            this.output = output;
        }
    }

    public static class Rounds {
        public TreeMap<Integer, State> rounds = new TreeMap();

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : State.ZERO;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : null;
        }
    }

    public static class State {
        public final double value;
        public final int fired;
        public final Neuron.NormWeight weight;
        public static final State ZERO = new State(0.0, -1, Neuron.NormWeight.ZERO_WEIGHT);

        public State(double value, int fired, Neuron.NormWeight weight) {
            this.value = value;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= 0.001;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && this.weight.equals(s.weight);
        }

        public String toString() {
            return "V:" + this.value;
        }
    }

    public static final class Key
    implements Comparable<Key> {
        public final Node n;
        public final Range r;
        public final Integer rid;
        public final InterprNode o;
        private int refCount = 0;

        public Key(Node n, Range r, Integer rid, InterprNode o) {
            this.n = n;
            this.r = r;
            this.rid = rid;
            this.o = o;
            this.countRef();
            if (o != null) {
                o.countRef();
            }
        }

        public void countRef() {
            ++this.refCount;
        }

        public void releaseRef() {
            assert (this.refCount > 0);
            --this.refCount;
            if (this.refCount == 0) {
                this.o.releaseRef();
            }
        }

        @Override
        public int compareTo(Key k) {
            int x = this.n.compareTo(k.n);
            if (x != 0) {
                return x;
            }
            x = Range.compare(this.r, k.r, false);
            if (x != 0) {
                return x;
            }
            x = Utils.compareInteger(this.rid, k.rid);
            if (x != 0) {
                return x;
            }
            return this.o.compareTo(k.o);
        }

        public String toString() {
            return (this.n != null ? this.n.id + (this.n.neuron != null && this.n.neuron.label != null ? ":" + this.n.neuron.label : "") + " " : "") + this.r + " " + this.rid + " " + this.o;
        }
    }
}

