/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import org.aika.Utils;
import org.aika.corpus.Range;
import org.aika.neuron.Neuron;

public class Input
implements Comparable<Input> {
    public boolean recurrent;
    public boolean optional;
    public Neuron neuron;
    public double weight;
    public double maxLowerWeightsSum = Double.MAX_VALUE;
    public double minInput;
    public Range.Operator startRangeMatch = Range.Operator.NONE;
    public Range.Operator endRangeMatch = Range.Operator.NONE;
    public boolean startRangeOutput;
    public boolean endRangeOutput;
    public Range.Mapping startMapping = Range.Mapping.START;
    public Range.Mapping endMapping = Range.Mapping.END;
    public Integer relativeRid;
    public Integer absoluteRid;

    public Input setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
        return this;
    }

    public Input setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public Input setNeuron(Neuron neuron) {
        assert (neuron != null);
        this.neuron = neuron;
        return this;
    }

    public Input setMaxLowerWeightsSum(double maxLowerWeightsSum) {
        this.maxLowerWeightsSum = maxLowerWeightsSum;
        return this;
    }

    public Input setWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    public Input setMinInput(double minInput) {
        this.minInput = minInput;
        return this;
    }

    public Input setAbsoluteRid(Integer absoluteRid) {
        this.absoluteRid = absoluteRid;
        return this;
    }

    public Input setRelativeRid(Integer relativeRid) {
        this.relativeRid = relativeRid;
        return this;
    }

    public Input setStartRangeMatch(Range.Operator rm) {
        this.startRangeMatch = rm;
        return this;
    }

    public Input setEndRangeMatch(Range.Operator rm) {
        this.endRangeMatch = rm;
        return this;
    }

    public Input setRangeMatch(RangeRelation rr) {
        switch (rr) {
            case EQUALS: {
                this.setStartRangeMatch(Range.Operator.EQUALS);
                this.setEndRangeMatch(Range.Operator.EQUALS);
                break;
            }
            case CONTAINS: {
                this.setStartRangeMatch(Range.Operator.LESS_THAN);
                this.setEndRangeMatch(Range.Operator.GREATER_THAN);
                break;
            }
            case CONTAINED_IN: {
                this.setStartRangeMatch(Range.Operator.GREATER_THAN);
                this.setEndRangeMatch(Range.Operator.LESS_THAN);
                break;
            }
            default: {
                this.setStartRangeMatch(Range.Operator.NONE);
                this.setEndRangeMatch(Range.Operator.NONE);
            }
        }
        return this;
    }

    public Input setRangeOutput(boolean ro) {
        this.setStartRangeOutput(ro);
        this.setEndRangeOutput(ro);
        return this;
    }

    public Input setStartRangeOutput(boolean ro) {
        this.startRangeOutput = ro;
        return this;
    }

    public Input setEndRangeOutput(boolean ro) {
        this.endRangeOutput = ro;
        return this;
    }

    public Input setStartRangeMapping(Range.Mapping startMapping) {
        this.startMapping = startMapping;
        return this;
    }

    public Input setEndRangeMapping(Range.Mapping endMapping) {
        this.endMapping = endMapping;
        return this;
    }

    @Override
    public int compareTo(Input in) {
        int r = Double.compare(this.weight, in.weight);
        if (r != 0) {
            return r;
        }
        r = Double.compare(this.minInput, in.minInput);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.optional, in.optional);
        if (r != 0) {
            return r;
        }
        r = this.neuron.compareTo(in.neuron);
        if (r != 0) {
            return r;
        }
        r = this.startRangeMatch.compareTo(in.startRangeMatch);
        if (r != 0) {
            return r;
        }
        r = this.endRangeMatch.compareTo(in.endRangeMatch);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.relativeRid, in.relativeRid);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.absoluteRid, in.absoluteRid);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.startRangeOutput, in.startRangeOutput);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.endRangeOutput, in.endRangeOutput);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.startMapping.ordinal(), in.startMapping.ordinal());
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.endMapping.ordinal(), in.endMapping.ordinal());
        return r;
    }

    public static enum RangeRelation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN,
        NONE;

    }
}

