/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Input;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.InputNeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class Model
implements Writable {
    public int numberOfThreads = 1;
    public int[] lastCleanup;
    public int[] documentCounter;
    public Document[] docs;
    public Map<String, Neuron> labeledNeurons = Collections.synchronizedMap(new LinkedHashMap());
    public Map<Integer, Neuron> neurons = Collections.synchronizedMap(new TreeMap());
    public Map<Integer, Node> initialNodes;
    public Set<Node>[] allNodes;
    public Statistic stat = new Statistic();
    private Document dummyDoc;
    public Set<AndNode> numberOfPositionsQueue = Collections.synchronizedSet(new TreeSet<AndNode>(new Comparator<AndNode>(){

        @Override
        public int compare(AndNode n1, AndNode n2) {
            int r = Integer.compare(n1.numberOfPositionsNotify, n2.numberOfPositionsNotify);
            if (r != 0) {
                return r;
            }
            return n1.compareTo(n2);
        }
    }));
    public volatile int numberOfPositions;

    public Model() {
        this(1);
    }

    public Model(int numberOfThreads) {
        assert (numberOfThreads >= 1);
        this.numberOfThreads = numberOfThreads;
        this.lastCleanup = new int[numberOfThreads];
        this.documentCounter = new int[numberOfThreads];
        this.allNodes = new Set[numberOfThreads];
        this.docs = new Document[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.allNodes[i] = new TreeSet<Node>();
        }
        this.dummyDoc = this.createDocument(null, 0);
    }

    public Document createDocument(String txt) {
        return this.createDocument(txt, 0);
    }

    public Document createDocument(String txt, int threadId) {
        int n = threadId;
        int n2 = this.documentCounter[n];
        this.documentCounter[n] = n2 + 1;
        Document doc = new Document(txt, this, threadId, n2);
        if (txt != null) {
            doc.changeNumberOfPositions(doc.length());
            if (this.docs[threadId] != null) {
                throw new RuntimeException("Two documents are using the same thread. Call clearActivations() first.");
            }
            this.docs[threadId] = doc;
        }
        return doc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Network Weights:\n");
        sb.append(this.networkWeightsToString(false));
        sb.append("\n\n\n");
        return sb.toString();
    }

    public void reset() {
        this.labeledNeurons.clear();
        this.neurons.clear();
    }

    public void resetFrequency() {
        for (int t = 0; t < this.numberOfThreads; ++t) {
            for (Node n : this.allNodes[t]) {
                n.frequency = 0;
            }
        }
    }

    public String networkWeightsToString(boolean all) {
        StringBuilder sb = new StringBuilder();
        for (Neuron n : this.neurons.values()) {
            if (!all && n.node.frequency <= 0) continue;
            sb.append(n.toStringWithSynapses());
            sb.append("\n");
        }
        return sb.toString();
    }

    public InputNeuron createOrLookupInputNeuron(String label) {
        return this.createOrLookupInputNeuron(label, false);
    }

    public InputNeuron createOrLookupInputNeuron(String label, boolean isBlocked) {
        InputNeuron n = (InputNeuron)this.labeledNeurons.get(label);
        if (n == null) {
            n = InputNeuron.create(this.dummyDoc, new InputNeuron(label, isBlocked));
            this.labeledNeurons.put(label, n);
        }
        return n;
    }

    public Neuron createAndNeuron(Neuron n, double threshold, Input ... inputs) {
        return this.createAndNeuron(n, threshold, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createAndNeuron(Neuron n, double threshold, Collection<Input> inputs) {
        n.m = this;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double bias = 0.0;
        double negDirSum = 0.0;
        double negRecSum = 0.0;
        double posRecSum = 0.0;
        double minWeight = Double.MAX_VALUE;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.startRangeMatch, ni.startMapping, ni.startRangeOutput, ni.endRangeMatch, ni.endMapping, ni.endRangeOutput));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            if (ni.weight < 0.0) {
                if (!ni.recurrent) {
                    negDirSum += ni.weight;
                } else {
                    negRecSum += ni.weight;
                }
            } else if (ni.recurrent) {
                posRecSum += ni.weight;
            }
            if (!ni.optional) {
                bias -= Math.abs(ni.weight) * (ni.weight >= 0.0 ? ni.minInput : 1.0);
                if (ni.weight >= 0.0) {
                    minWeight = Math.min(minWeight, ni.weight * ni.minInput);
                }
            }
            is.add(s);
        }
        return Neuron.create(this.dummyDoc, n, bias += minWeight * threshold, negDirSum, negRecSum, posRecSum, is);
    }

    public Neuron createNeuron(Neuron n, double bias, Input ... inputs) {
        return this.createNeuron(n, bias, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createNeuron(Neuron n, double bias, Collection<Input> inputs) {
        n.m = this;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double negDirSum = 0.0;
        double negRecSum = 0.0;
        double posRecSum = 0.0;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.startRangeMatch, ni.startMapping, ni.startRangeOutput, ni.endRangeMatch, ni.endMapping, ni.endRangeOutput));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            if (ni.weight < 0.0) {
                if (!ni.recurrent) {
                    negDirSum += ni.weight;
                } else {
                    negRecSum += ni.weight;
                }
            } else if (ni.recurrent) {
                posRecSum += ni.weight;
            }
            is.add(s);
        }
        return Neuron.create(this.dummyDoc, n, bias, negDirSum, negRecSum, posRecSum, is);
    }

    public Neuron createOrNeuron(Neuron n, Input ... inputs) {
        return this.createOrNeuron(n, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron createOrNeuron(Neuron n, Set<Input> inputs) {
        n.m = this;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        double bias = -0.001;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.neuron, new Synapse.Key(ni.weight < 0.0, ni.recurrent, ni.relativeRid, ni.absoluteRid, ni.startRangeMatch, ni.startMapping, ni.startRangeOutput, ni.endRangeMatch, ni.endMapping, ni.endRangeOutput));
            s.w = ni.weight;
            s.maxLowerWeightsSum = ni.maxLowerWeightsSum;
            is.add(s);
        }
        return Neuron.create(this.dummyDoc, n, bias, 0.0, 0.0, 0.0, is);
    }

    public Neuron createRelationalNeuron(Neuron n, Neuron ctn, Neuron inputSignal, boolean dirIS) {
        n.m = this;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        double bias = -30.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (inputSignal != null) {
            Synapse iss = new Synapse(inputSignal, new Synapse.Key(false, false, null, null, Range.Operator.LESS_THAN, dirIS ? Range.Mapping.END : Range.Mapping.START, false, Range.Operator.GREATER_THAN, dirIS ? Range.Mapping.START : Range.Mapping.END, false));
            iss.w = 20.0;
            iss.maxLowerWeightsSum = 20.0;
            is.add(iss);
        }
        if (ctn != null) {
            Synapse ctns = new Synapse(ctn, new Synapse.Key(false, false, 0, null, Range.Operator.EQUALS, Range.Mapping.START, true, Range.Operator.EQUALS, Range.Mapping.END, true));
            ctns.w = 20.0;
            ctns.maxLowerWeightsSum = 20.0;
            is.add(ctns);
        }
        return Neuron.create(this.dummyDoc, n, bias, 0.0, 0.0, 0.0, is);
    }

    public Neuron createCounterNeuron(Neuron n, Neuron clockSignal, boolean dirCS, Neuron startSignal, boolean dirSS, boolean direction) {
        n.m = this;
        if (n.node != null) {
            throw new RuntimeException("This neuron has already been initialized!");
        }
        double bias = -44.0;
        double negRecSum = -20.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (clockSignal != null) {
            Synapse css = new Synapse(clockSignal, new Synapse.Key(false, false, null, null, Range.Operator.NONE, Range.Mapping.NONE, false, Range.Operator.FIRST, dirCS ? Range.Mapping.START : Range.Mapping.END, true));
            css.w = 20.0;
            css.maxLowerWeightsSum = 8.0;
            is.add(css);
        }
        if (startSignal != null) {
            Synapse sss = new Synapse(startSignal, new Synapse.Key(false, false, 0, null, Range.Operator.EQUALS, dirSS ? Range.Mapping.START : Range.Mapping.END, true, Range.Operator.NONE, Range.Mapping.NONE, false));
            sss.w = 8.0;
            sss.maxLowerWeightsSum = 0.0;
            is.add(sss);
        }
        Synapse lastCycle = new Synapse(n, new Synapse.Key(false, false, -1, null, direction ? Range.Operator.NONE : Range.Operator.EQUALS, direction ? Range.Mapping.NONE : Range.Mapping.END, !direction, direction ? Range.Operator.EQUALS : Range.Operator.NONE, direction ? Range.Mapping.START : Range.Mapping.NONE, direction));
        lastCycle.w = 8.0;
        lastCycle.maxLowerWeightsSum = 0.0;
        is.add(lastCycle);
        Synapse neg = new Synapse(n, new Synapse.Key(true, true, 0, null, Range.Operator.EQUALS, Range.Mapping.START, false, Range.Operator.EQUALS, Range.Mapping.END, false));
        neg.w = -20.0;
        neg.maxLowerWeightsSum = 28.0;
        is.add(neg);
        Neuron neuron = Neuron.create(this.dummyDoc, n, bias, 0.0, negRecSum, 0.0, is);
        neuron.node.passive = true;
        return neuron;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numberOfThreads);
        out.writeInt(this.numberOfPositions);
        TreeSet<Node> nodes = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                if (n1.level != -1 && n2.level == -1) {
                    return -1;
                }
                if (n1.level == -1 && n2.level != -1) {
                    return 1;
                }
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                return n1.compareTo(n2);
            }
        });
        if (this.initialNodes != null) {
            nodes.addAll(this.initialNodes.values());
        }
        for (Set<Node> n : this.allNodes) {
            nodes.addAll(n);
        }
        out.writeInt(nodes.size());
        for (Node n : nodes) {
            n.write(out);
        }
        out.writeInt(this.neurons.size());
        for (Neuron n : this.neurons.values()) {
            n.write(out);
        }
        out.writeInt(this.neurons.size());
        for (Neuron n : this.neurons.values()) {
            out.writeInt(n.id);
            for (Synapse s : n.inputSynapses) {
                if (s.input == null || !s.input.initialized || s.output == null || !s.output.initialized) continue;
                out.writeBoolean(true);
                s.write(out);
            }
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in, Document doc) throws IOException {
        Comparable<Node> n;
        int i;
        this.numberOfThreads = in.readInt();
        this.numberOfPositions = in.readInt();
        int s = in.readInt();
        this.initialNodes = new TreeMap<Integer, Node>();
        for (i = 0; i < s; ++i) {
            n = Node.read(in, doc);
            this.initialNodes.put(n.id, (Node)n);
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            n = Neuron.read(in, doc);
            this.neurons.put(((Neuron)n).id, (Neuron)n);
            if (((Neuron)n).label == null) continue;
            this.labeledNeurons.put(((Neuron)n).label, (Neuron)n);
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            n = doc.m.neurons.get(in.readInt());
            while (in.readBoolean()) {
                Synapse syn = Synapse.read(in, doc);
                ((Neuron)n).inputSynapses.add(syn);
                ((Neuron)n).inputSynapsesByWeight.add(syn);
            }
        }
    }

    public static Model read(DataInput in) throws IOException {
        Model m = new Model();
        Document doc = m.createDocument(null, 0);
        m.readFields(in, doc);
        return m;
    }

    public static class Statistic {
        public volatile int synapses;
        public volatile int neurons;
        public volatile int neuronFromPattern;
        public volatile int nodes;
        public volatile int[] nodesPerLevel = new int[AndNode.MAX_POS_NODES + 1];
        public volatile int orNodes;
    }
}

