/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

public class ReadWriteLock {
    private int readers = 0;
    private int writers = 0;
    private int writeRequests = 0;
    private int writerThreadId = -1;
    private Object writeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock(int threadId) {
        try {
            Object object = this;
            synchronized (object) {
                ++this.writeRequests;
                while (this.readers > 0) {
                    this.wait();
                }
            }
            object = this.writeLock;
            synchronized (object) {
                if (this.writerThreadId != threadId) {
                    while (this.writers > 0) {
                        this.writeLock.wait();
                    }
                    this.writerThreadId = threadId;
                }
                ++this.writers;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void acquireReadLock() {
        try {
            while (this.writeRequests > 0) {
                this.wait();
            }
            ++this.readers;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock() {
        Object object = this.writeLock;
        synchronized (object) {
            --this.writers;
            if (this.writers == 0) {
                this.writerThreadId = -1;
                this.writeLock.notify();
            }
        }
        object = this;
        synchronized (object) {
            --this.writeRequests;
            if (this.writeRequests == 0) {
                this.notifyAll();
            }
        }
    }

    public synchronized void releaseReadLock() {
        --this.readers;
        if (this.writeRequests > 0 && this.readers == 0) {
            this.notifyAll();
        }
    }
}

