/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.aika.Activation;
import org.aika.Model;
import org.aika.Utils;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.neuron.InputNeuron;
import org.aika.neuron.Neuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    public final int id = docIdCounter++;
    public static int docIdCounter = 0;
    public int activationIdCounter = 0;
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static boolean APPLY_DEBUG_OUTPUT = false;
    public static boolean OPTIMIZE_DEBUG_OUTPUT = false;
    public static boolean TRAIN_DEBUG_OUTPUT = false;
    public static int CLEANUP_INTERVAL = 20;
    private String content;
    public int interprIdCounter = 1;
    public int searchNodeIdCounter = 0;
    public InterprNode bottom = new InterprNode(this, -1, 0, 0);
    public SearchNode root = SearchNode.createInitialExpandNode(this);
    public SearchNode selectedSearchNode = null;
    public List<InterprNode> selectedInterprNode = null;
    public long selectedMark = -1L;
    public Model m;
    public int threadId;
    public long iterationId;
    public boolean interrupted;
    public Queue queue = new Queue();
    public ValueQueue vQueue = new ValueQueue();
    public UpperBoundQueue ubQueue = new UpperBoundQueue();
    public BackPropagationQueue bQueue = new BackPropagationQueue();
    public TreeSet<Node> activatedNodes = new TreeSet();
    public TreeSet<Node> activatedNodesForTraining = new TreeSet();
    public TreeSet<Neuron> activatedInputNeurons = new TreeSet();
    public TreeSet<Neuron> activatedNeurons = new TreeSet();
    public TreeSet<Neuron> finallyActivatedNeurons = new TreeSet();
    public TreeSet<Activation> inputNeuronActivations = new TreeSet();
    public TreeSet<Activation> inputNodeActivations = new TreeSet();
    public TreeMap<Activation.Key, Activation> activationsByRid = new TreeMap(new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key act1, Activation.Key act2) {
            int r = Integer.compare(act1.rid, act2.rid);
            if (r != 0) {
                return r;
            }
            return act1.compareTo(act2);
        }
    });
    public TreeSet<Node> addedNodes = new TreeSet();
    public static int numberOfPositionsDelta;
    public int debugActId = -1;
    public double debugActWeight = 0.0;
    public String debugOutput = "";
    public static Comparator<Activation> ACTIVATIONS_OUTPUT_COMPARATOR;

    public Document(String content, Model m, int threadId, long iterationId) {
        this.content = content;
        this.m = m;
        this.threadId = threadId;
        this.iterationId = iterationId;
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String getText(Range r) {
        return this.content.substring(Math.max(0, Math.min(r.begin, this.length())), Math.max(0, Math.min(r.end, this.length())));
    }

    public String conflictsToString() {
        HashSet<InterprNode> conflicts = new HashSet<InterprNode>();
        this.bottom.collectConflicts(conflicts, InterprNode.visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("Conflicts:\n");
        for (InterprNode n : conflicts) {
            sb.append(n.conflicts.primaryToString());
        }
        sb.append("\n");
        return sb.toString();
    }

    public String selectedInterpretationToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected Interpretation Nodes:\n");
        sb.append(this.selectedInterprNode.toString());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        boolean flag = true;
        while (flag) {
            this.queue.processChanges();
            flag = this.ubQueue.process();
        }
    }

    public void process() {
        for (Activation act : this.inputNeuronActivations) {
            this.vQueue.propagateWeight(0, act, Activation.visitedCounter++);
        }
        this.root.computeSelectedOption(this);
    }

    public void count() {
        for (Node node : this.activatedNodes) {
            node.count(this);
        }
        for (Neuron neuron : this.finallyActivatedNeurons) {
            neuron.count(this);
        }
    }

    public void train() {
        Node.ThreadState th;
        this.m.numberOfPositions += numberOfPositionsDelta;
        numberOfPositionsDelta = 0;
        long v = Node.visitedCounter++;
        this.count();
        for (Node node : this.activatedNodes) {
            if (node.neuron instanceof InputNeuron) continue;
            node.computeNullHyp(this.m);
            if (!node.frequencyHasChanged || node.isBlocked || !node.isFrequent()) continue;
            node.frequencyHasChanged = false;
            if (node instanceof AndNode) {
                AndNode an = (AndNode)node;
                an.updateWeight(this, v);
            }
            if ((th = node.getThreadState(this, false)) == null) continue;
            for (Activation act : th.activations.values()) {
                node.discover(this, act);
            }
        }
        while (true) {
            AndNode n;
            AndNode andNode = n = !this.m.numberOfPositionsQueue.isEmpty() ? this.m.numberOfPositionsQueue.iterator().next() : null;
            if (n == null || n.numberOfPositionsNotify > this.m.numberOfPositions) break;
            n.updateWeight(this, v);
        }
        this.bQueue.backpropagtion();
        for (Neuron neuron : this.finallyActivatedNeurons) {
            if (neuron.noTraining || (th = neuron.node.getThreadState(this, false)) == null) continue;
            for (Activation act : th.activations.values()) {
                neuron.train(this, act);
            }
        }
    }

    public void clearActivations() {
        for (Node n : this.activatedNodes) {
            n.clearActivations(this);
        }
        for (Node n : this.activatedNodesForTraining) {
            n.clearActivations(this);
        }
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if ((long)(this.m.lastCleanup[this.threadId] + CLEANUP_INTERVAL) < this.iterationId) {
            for (Node n : this.m.allNodes[this.threadId]) {
                Node.ThreadState th = n.threads[this.threadId];
                if (th == null || th.lastUsed + (long)CLEANUP_INTERVAL >= this.iterationId) continue;
                n.threads[this.threadId] = null;
            }
        }
        this.m.docs[this.threadId] = null;
    }

    public void changeNumberOfPositions(int delta) {
        numberOfPositionsDelta += delta;
    }

    public String networkStateToString(boolean withWeights) {
        return this.networkStateToString(true, withWeights);
    }

    /*
     * WARNING - void declaration
     */
    public String networkStateToString(boolean neuronsOnly, boolean withWeights) {
        void var5_13;
        TreeSet<Activation> acts = new TreeSet<Activation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        if (neuronsOnly) {
            for (Neuron neuron : this.m.neurons.values()) {
                acts.addAll(Activation.select(this, neuron.node, null, null, null, null, null, InterprNode.Relation.CONTAINED_IN).collect(Collectors.toList()));
            }
        } else {
            if (this.m.initialNodes != null) {
                for (Node node : this.m.initialNodes.values()) {
                    acts.addAll(Activation.select(this, node, null, null, null, null, null, InterprNode.Relation.CONTAINED_IN).collect(Collectors.toList()));
                }
            }
            for (int th = 0; th < this.m.numberOfThreads; ++th) {
                for (Node n : this.m.allNodes[th]) {
                    acts.addAll(Activation.select(this, n, null, null, null, null, null, InterprNode.Relation.CONTAINED_IN).collect(Collectors.toList()));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        Neuron.NormWeight normWeight = Neuron.NormWeight.ZERO_WEIGHT;
        for (Activation act : acts) {
            sb.append(act.id + " ");
            sb.append(act.key.r);
            sb.append(" - ");
            sb.append(act.key.o);
            sb.append(" - ");
            sb.append(act.key.n);
            sb.append(" - Rid:");
            sb.append(act.key.rid);
            sb.append(" - UB:");
            sb.append(Utils.round(act.upperBound));
            if (withWeights) {
                if (act.key.n instanceof AndNode) {
                    AndNode an = (AndNode)act.key.n;
                    sb.append(" - BW:");
                    sb.append(an.weight);
                }
                sb.append(" - ");
                for (Map.Entry<Integer, Activation.State> me : act.rounds.rounds.entrySet()) {
                    Activation.State s = me.getValue();
                    sb.append("[R:" + me.getKey());
                    sb.append(" V:" + Utils.round(s.value));
                    sb.append(" F:" + s.fired);
                    sb.append(" W:" + Utils.round(s.weight.w));
                    sb.append(" N:" + Utils.round(s.weight.n));
                    sb.append("]");
                }
                if (act.finalState != null && act.finalState.weight != null) {
                    sb.append(" - FV:" + Utils.round(act.finalState.value));
                    sb.append(" FW:" + Utils.round(act.finalState.weight.w));
                    sb.append(" FN:" + Utils.round(act.finalState.weight.n));
                }
            }
            if (act.finalState != null && act.finalState.weight != null) {
                Neuron.NormWeight normWeight2 = var5_13.add(act.finalState.weight);
            }
            sb.append("\n");
        }
        sb.append("\nWeightSum:" + var5_13.toString() + "\n");
        return sb.toString();
    }

    static {
        ACTIVATIONS_OUTPUT_COMPARATOR = new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                int r = Range.compare(act1.key.r, act2.key.r, false);
                if (r != 0) {
                    return r;
                }
                r = Utils.compareInteger(act1.key.rid, act2.key.rid);
                if (r != 0) {
                    return r;
                }
                r = act1.key.o.compareTo(act2.key.o);
                if (r != 0) {
                    return r;
                }
                return Integer.compare(act1.key.n.id, act2.key.n.id);
            }
        };
    }

    public class BackPropagationQueue {
        public final TreeSet<Activation> queue = new TreeSet<Activation>(new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                Activation.State fs1 = act1.finalState;
                Activation.State fs2 = act2.finalState;
                int r = 0;
                if (fs2 == null && fs1 != null) {
                    return -1;
                }
                if (fs2 != null && fs1 == null) {
                    return 1;
                }
                if (fs2 != null && fs1 != null) {
                    r = Integer.compare(fs2.fired, fs1.fired);
                }
                if (r != 0) {
                    return r;
                }
                return act1.key.compareTo(act2.key);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Activation act) {
            if (!act.isQueued && !act.key.n.neuron.noTraining) {
                act.isQueued = true;
                act.queueId = this.queueIdCounter++;
                this.queue.add(act);
            }
        }

        public void backpropagtion() {
            while (!this.queue.isEmpty()) {
                Activation act = this.queue.pollFirst();
                act.isQueued = false;
                act.key.n.neuron.computeErrorSignal(Document.this, act);
            }
        }
    }

    public static class VEntry
    implements Comparable<VEntry> {
        public int round;
        public Activation act;

        public VEntry(int round, Activation act) {
            this.round = round;
            this.act = act;
        }

        @Override
        public int compareTo(VEntry ve) {
            int r = Integer.compare(this.round, ve.round);
            if (r != 0) {
                return r;
            }
            return this.act.compareTo(ve.act);
        }
    }

    public class ValueQueue {
        public final TreeSet<VEntry> queue = new TreeSet();

        public void propagateWeight(int round, Activation act, long v) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                int r = sa.s.key.isRecurrent ? round + 1 : round;
                this.add(r, sa.output, v);
            }
        }

        public Neuron.NormWeight adjustWeight(SearchNode cand, List<InterprNode> changed) {
            long v = Activation.visitedCounter++;
            for (InterprNode n : changed) {
                this.addAllActs(n.getNeuronActivations(), v);
                if (n.refByOrInterprNode == null) continue;
                for (InterprNode on : n.refByOrInterprNode) {
                    this.addAllActs(on.getNeuronActivations(), v);
                }
            }
            return this.processChanges(cand, v);
        }

        private void addAllActs(Collection<Activation> acts, long v) {
            for (Activation act : acts) {
                if (act.key.n.neuron instanceof InputNeuron) continue;
                this.add(0, act, v);
            }
        }

        public void add(int round, Activation act, long v) {
            this.queue.add(new VEntry(round, act));
        }

        public Neuron.NormWeight processChanges(SearchNode en, long v) {
            Neuron.NormWeight delta = Neuron.NormWeight.ZERO_WEIGHT;
            while (!this.queue.isEmpty()) {
                VEntry e = this.queue.pollFirst();
                int round = e.round;
                Activation act = e.act;
                Activation.State s = act.key.n.neuron.computeWeight(e.round, act, en, Document.this);
                if (OPTIMIZE_DEBUG_OUTPUT) {
                    log.info(act.key + " Round:" + round);
                    log.info("Value:" + s.value + "  Weight:" + s.weight.w + "  Norm:" + s.weight.n + "\n");
                }
                if (round != 0 && act.rounds.get(round).equalsWithWeights(s)) continue;
                SearchNode.StateChange.saveOldState(en.modifiedActs, act, v);
                Activation.State oldState = act.rounds.get(round);
                boolean propagate = act.rounds.set(round, s);
                SearchNode.StateChange.saveNewState(act);
                if (propagate) {
                    this.propagateWeight(round, act, v);
                }
                if (round == 0) {
                    this.add(1, act, v);
                }
                if (act.rounds.getLastRound() == null || round < act.rounds.getLastRound()) continue;
                Neuron.NormWeight oldWeight = oldState.weight;
                delta = delta.add(s.weight.sub(oldWeight));
            }
            return delta;
        }
    }

    public class UpperBoundQueue {
        public final ArrayDeque<Activation> queue = new ArrayDeque();

        public void add(Activation act) {
            if (!act.ubQueued) {
                act.ubQueued = true;
                this.queue.addLast(act);
            }
        }

        public boolean process() {
            boolean flag = false;
            while (!this.queue.isEmpty()) {
                flag = true;
                Activation act = this.queue.pollFirst();
                act.ubQueued = false;
                double oldUpperBound = act.upperBound;
                Neuron n = act.key.n.neuron;
                n.computeBounds(act);
                if (Math.abs(act.upperBound - oldUpperBound) > 0.01) {
                    for (Activation.SynapseActivation sa : act.neuronOutputs) {
                        this.add(sa.output);
                    }
                }
                if (oldUpperBound <= 0.0 && act.upperBound > 0.0) {
                    for (InputNode out : n.outputNodes.values()) {
                        out.addActivation(Document.this, act);
                    }
                    continue;
                }
                if (!(oldUpperBound > 0.0) || !(act.upperBound <= 0.0)) continue;
                for (InputNode out : n.outputNodes.values()) {
                    out.removeActivation(Document.this, act);
                }
            }
            return flag;
        }
    }

    public class Queue {
        public final TreeSet<Node> queue = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                return Long.compare(n1.queueId, n2.queueId);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Node n) {
            if (!n.isQueued) {
                n.isQueued = true;
                n.queueId = this.queueIdCounter++;
                this.queue.add(n);
            }
        }

        public void processChanges() {
            while (!this.queue.isEmpty()) {
                Node n = this.queue.pollFirst();
                n.isQueued = false;
                n.processChanges(Document.this);
                if (!APPLY_DEBUG_OUTPUT) continue;
                log.info("QueueId:" + n.queueId);
                log.info(n.toString() + "\n");
                log.info("\n" + Document.this.networkStateToString(false, false));
            }
        }
    }
}

