/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.lattice.Node;

public class InterprNode
implements Comparable<InterprNode> {
    public static final InterprNode MIN = new InterprNode(null, -1, 0, 0);
    public static final InterprNode MAX = new InterprNode(null, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int primId;
    public int minPrim = -1;
    public int maxPrim = -1;
    public final int id;
    public int length;
    public Map<Activation, InterprNode> orInterprNodes;
    public Set<InterprNode> refByOrInterprNode;
    public InterprNode largestCommonSubset;
    public Set<InterprNode> linkedByLCS;
    private long visitedLinkRelations;
    private long visitedContains;
    private long visitedCollect;
    private long visitedExpandActivations;
    private long visitedRemoveActivations;
    public long visitedMarkCovered;
    public long markedCovered = -1L;
    public long markedExcluded = -1L;
    private long visitedIsConflicting;
    public long visitedCollectAllConflicting = -1L;
    private long visitedStoreFinalWeight = -1L;
    public long visitedExpandRefinementRecursiveStep = -1L;
    public long markedExpandRefinement = -1L;
    public long visitedCollectConflicts = -1L;
    private long visitedComputeLargestCommonSubset = -1L;
    private long visitedComputeLength = -1L;
    public long visitedCheckExcluded = -1L;
    public long markedConflict = -1L;
    private long visitedComputeParents = -1L;
    private long visitedNumberInnerInputs = -1L;
    public Boolean hasUnsatisfiedPosFeedbackLinksCache;
    private int numberInnerInputs = 0;
    private int largestCommonSubsetCount = 0;
    public static long visitedCounter = 1L;
    public final Document doc;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public InterprNode[] parents;
    public InterprNode[] children;
    public int isConflict = -1;
    public Conflicts conflicts = new Conflicts();
    public NavigableMap<Activation.Key, Activation> activations;
    public NavigableSet<Activation> neuronActivations;
    public int refCount = 0;
    private static Comparator<InterprNode> LENGTH_COMP = new Comparator<InterprNode>(){

        @Override
        public int compare(InterprNode n1, InterprNode n2) {
            return Integer.compare(n2.length, n1.length);
        }
    };
    private long visitedComputeChildren = -1L;
    private int numberOfInputsComputeChildren = 0;

    public InterprNode(Document doc, int primId, int id, int length) {
        this(doc, primId, id);
        this.length = length;
    }

    public InterprNode(Document doc, int primId, int id) {
        this.doc = doc;
        this.primId = primId;
        this.id = id;
        this.parents = new InterprNode[0];
        this.children = new InterprNode[0];
    }

    public void computeLargestCommonSubset() {
        int s = this.orInterprNodes.size();
        long vMin = visitedCounter++;
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        for (InterprNode on : this.orInterprNodes.values()) {
            on.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, s, 0);
        }
        this.setLCS(results.isEmpty() ? null : InterprNode.add(this.doc, true, results));
    }

    public void computeLargestCommonSubsetIncremental(InterprNode no) {
        if (this.orInterprNodes.size() == 0) {
            this.setLCS(no);
            return;
        }
        long vMin = visitedCounter++;
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, 2, 0);
        }
        no.computeLargestCommonSubsetRecursiveStep(results, visitedCounter++, vMin, 2, 0);
        this.setLCS(InterprNode.add(this.doc, true, results));
    }

    private void setLCS(InterprNode lcs) {
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.linkedByLCS.remove(this);
        }
        this.largestCommonSubset = lcs;
        if (this.largestCommonSubset != null) {
            if (this.largestCommonSubset.linkedByLCS == null) {
                this.largestCommonSubset.linkedByLCS = new TreeSet<InterprNode>();
            }
            this.largestCommonSubset.linkedByLCS.add(this);
        }
    }

    private void computeLargestCommonSubsetRecursiveStep(List<InterprNode> results, long v, long vMin, int s, int depth) {
        if (this.visitedComputeLargestCommonSubset == v) {
            return;
        }
        if (this.visitedComputeLargestCommonSubset <= vMin) {
            this.largestCommonSubsetCount = 0;
        }
        this.visitedComputeLargestCommonSubset = v;
        ++this.largestCommonSubsetCount;
        if (depth > 10) {
            return;
        }
        if (this.largestCommonSubsetCount == s) {
            results.add(this);
            return;
        }
        for (InterprNode pn : this.parents) {
            pn.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
    }

    public void addOrOption(Activation inputAct, InterprNode n) {
        if (this.orInterprNodes == null) {
            this.orInterprNodes = new TreeMap<Activation, InterprNode>();
        }
        this.computeLargestCommonSubsetIncremental(n);
        this.orInterprNodes.put(inputAct, n);
        if (n.refByOrInterprNode == null) {
            n.refByOrInterprNode = new TreeSet<InterprNode>();
        }
        n.refByOrInterprNode.add(this);
    }

    public void removeOrOption(Activation inputAct, InterprNode n) {
        this.orInterprNodes.remove(inputAct);
        n.refByOrInterprNode.remove(this);
        this.computeLargestCommonSubset();
    }

    public void countRef() {
        if (this.isBottom()) {
            return;
        }
        ++this.refCount;
    }

    public void releaseRef() {
        if (this.isBottom()) {
            return;
        }
        assert (this.refCount > 0);
        --this.refCount;
        if (this.refCount == 0) {
            this.remove();
        }
    }

    void expandActivationsRecursiveStep(Document doc, InterprNode conflict, long v) {
        if (v == this.visitedExpandActivations) {
            return;
        }
        this.visitedExpandActivations = v;
        for (Activation act : this.getActivations()) {
            act.key.n.propagateAddedActivation(doc, act, conflict);
        }
        for (InterprNode p : this.parents) {
            p.expandActivationsRecursiveStep(doc, conflict, v);
        }
    }

    void removeActivationsRecursiveStep(Document doc, InterprNode conflict, long v) {
        if (v == this.visitedRemoveActivations) {
            return;
        }
        this.visitedRemoveActivations = v;
        for (Activation act : this.getActivations()) {
            if (!act.key.o.contains(conflict, false)) continue;
            Node.removeActivationAndPropagate(doc, act, act.inputs.values());
        }
        if (this.children != null) {
            for (InterprNode c : this.children) {
                if (c.isRemoved) continue;
                c.removeActivationsRecursiveStep(doc, conflict, v);
            }
        }
    }

    public Collection<Activation> getActivations() {
        return this.activations != null ? this.activations.values() : Collections.emptySet();
    }

    public Collection<Activation> getNeuronActivations() {
        return this.neuronActivations != null ? this.neuronActivations : Collections.emptySet();
    }

    public static InterprNode add(Document doc, boolean nonConflicting, InterprNode ... input) {
        ArrayList<InterprNode> in = new ArrayList<InterprNode>();
        for (InterprNode n : input) {
            if (n == null || n.isBottom()) continue;
            in.add(n);
        }
        return InterprNode.add(doc, nonConflicting, in);
    }

    public static InterprNode add(Document doc, boolean nonConflicting, List<InterprNode> inputs) {
        if (inputs.size() == 0) {
            return doc.bottom;
        }
        Iterator<InterprNode> it = inputs.iterator();
        while (it.hasNext()) {
            if (!it.next().isBottom()) continue;
            it.remove();
        }
        if (inputs.size() == 1 || inputs.size() == 2 && inputs.get(0) == inputs.get(1)) {
            InterprNode n = inputs.get(0);
            if (nonConflicting && n.isConflicting(visitedCounter++)) {
                return null;
            }
            n.countRef();
            return n;
        }
        ArrayList<InterprNode> parents = new ArrayList<InterprNode>();
        ArrayList<InterprNode> children = new ArrayList<InterprNode>();
        InterprNode.computeRelations(parents, children, inputs);
        if (parents.size() == 1) {
            InterprNode n = parents.get(0);
            if (nonConflicting && n.isConflicting(visitedCounter++)) {
                return null;
            }
            n.countRef();
            return n;
        }
        if (nonConflicting) {
            for (InterprNode p : parents) {
                if (!p.isConflicting(visitedCounter++)) continue;
                return null;
            }
        }
        InterprNode n = new InterprNode(doc, -1, doc.interprIdCounter++);
        super.linkRelations(parents, children, visitedCounter++);
        n.length = super.computeLength(visitedCounter++);
        n.minPrim = Integer.MAX_VALUE;
        n.maxPrim = Integer.MIN_VALUE;
        for (InterprNode in : inputs) {
            n.minPrim = Math.min(n.minPrim, in.minPrim);
            n.maxPrim = Math.max(n.maxPrim, in.maxPrim);
        }
        n.countRef();
        return n;
    }

    public static void computeRelations(List<InterprNode> parentsResults, List<InterprNode> childrenResults, List<InterprNode> inputs) {
        if (inputs.isEmpty()) {
            return;
        }
        long v = visitedCounter++;
        boolean i = false;
        int s = inputs.size();
        Collections.sort(inputs, LENGTH_COMP);
        if (s == 2 && inputs.get((int)1).primId >= 0 && inputs.get((int)1).children.length == 0) {
            parentsResults.addAll(inputs);
            return;
        }
        for (int pass = 0; pass <= 1; ++pass) {
            for (InterprNode n : inputs) {
                n.computeParents(parentsResults, v, pass);
            }
            ++visitedCounter;
        }
        if (parentsResults.size() == 1) {
            return;
        }
        assert (parentsResults.size() != 0);
        for (InterprNode n : inputs) {
            n.computeChildren(childrenResults, visitedCounter++, v, inputs.size(), 0);
        }
        inputs.get(0).computeChildren(childrenResults, visitedCounter++, v, inputs.size(), 1);
    }

    private void computeParents(List<InterprNode> parentResults, long v, int pass) {
        if (this.visitedComputeParents == v || this.length == 0) {
            return;
        }
        this.visitedComputeParents = v;
        for (InterprNode pn : this.parents) {
            pn.computeParents(parentResults, v, pass);
        }
        boolean flag = true;
        for (InterprNode cn : this.children) {
            if (pass == 0) {
                if (cn.visitedNumberInnerInputs != v) {
                    cn.numberInnerInputs = 0;
                    cn.visitedNumberInnerInputs = v;
                }
                ++cn.numberInnerInputs;
            }
            if (cn.numberInnerInputs != cn.parents.length) continue;
            cn.computeParents(parentResults, v, pass);
            flag = false;
        }
        if (flag && pass == 1) {
            parentResults.add(this);
        }
    }

    private void computeChildren(List<InterprNode> childrenResults, long v, long nv, int s, int pass) {
        if (this.visitedComputeChildren == v) {
            return;
        }
        if (pass == 0) {
            if (this.visitedComputeChildren <= nv) {
                this.numberOfInputsComputeChildren = 0;
            }
            ++this.numberOfInputsComputeChildren;
        }
        this.visitedComputeChildren = v;
        if (pass == 1 && this.numberOfInputsComputeChildren == s) {
            boolean covered = false;
            for (InterprNode pn : this.parents) {
                if (pn.numberOfInputsComputeChildren != s) continue;
                covered = true;
                break;
            }
            if (!covered) {
                childrenResults.add(this);
            }
        } else {
            for (InterprNode cn : this.children) {
                cn.computeChildren(childrenResults, v, nv, s, pass);
            }
        }
    }

    private int computeLength(long v) {
        if (this.visitedComputeLength == v) {
            return 0;
        }
        this.visitedComputeLength = v;
        if (this.primId >= 0) {
            return 1;
        }
        int result = 0;
        for (InterprNode p : this.parents) {
            result += p.computeLength(v);
        }
        return result;
    }

    private void linkRelations(List<InterprNode> pSet, List<InterprNode> cSet, long v) {
        for (InterprNode p : pSet) {
            InterprNode.addLink(p, this);
        }
        for (InterprNode c : cSet) {
            c.visitedLinkRelations = v;
            InterprNode.addLink(this, c);
        }
        for (InterprNode p : pSet) {
            ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
            for (InterprNode c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (InterprNode c : tmp) {
                InterprNode.removeLink(p, c);
            }
        }
    }

    public static void addLink(InterprNode a, InterprNode b) {
        a.children = InterprNode.addToArray(a.children, b);
        b.parents = InterprNode.addToArray(b.parents, a);
    }

    public static void removeLink(InterprNode a, InterprNode b) {
        a.children = InterprNode.removeToArray(a.children, b);
        b.parents = InterprNode.removeToArray(b.parents, a);
    }

    private static InterprNode[] addToArray(InterprNode[] in, InterprNode n) {
        InterprNode[] r = Arrays.copyOf(in, in.length + 1);
        r[in.length] = n;
        return r;
    }

    private static InterprNode[] removeToArray(InterprNode[] in, InterprNode n) {
        InterprNode[] r = new InterprNode[in.length - 1];
        int i = 0;
        for (InterprNode x : in) {
            if (x == n) continue;
            r[i++] = x;
        }
        return r;
    }

    public static InterprNode addPrimitive(Document doc) {
        assert (doc != null);
        InterprNode n = new InterprNode(doc, doc.bottom.children.length, doc.interprIdCounter++, 1);
        n.minPrim = n.primId;
        n.maxPrim = n.primId;
        n.countRef();
        InterprNode.addLink(doc.bottom, n);
        return n;
    }

    private void remove() {
        assert (!this.isRemoved);
        this.isRemoved = true;
        this.removedId = removedIdCounter++;
        for (InterprNode p : this.parents) {
            p.children = InterprNode.removeToArray(p.children, this);
        }
        for (InterprNode c : this.children) {
            c.parents = InterprNode.removeToArray(c.parents, this);
        }
        for (InterprNode p : this.parents) {
            for (InterprNode c : this.children) {
                if (c.isLinked(p, visitedCounter++)) continue;
                InterprNode.addLink(p, c);
            }
        }
        this.parents = null;
        this.children = null;
        this.conflicts = null;
    }

    public boolean isBottom() {
        return this.length == 0;
    }

    public boolean contains(boolean dir, InterprNode n, boolean followLCS) {
        boolean r = !dir ? this.contains(n, followLCS) : n.contains(this, followLCS);
        return r;
    }

    public boolean contains(InterprNode n, boolean followLCS) {
        return this.contains(n, followLCS, visitedCounter++);
    }

    private boolean contains(InterprNode n, boolean followLCS, long v) {
        this.visitedContains = v;
        if (this == n || n.isBottom()) {
            return true;
        }
        if (!followLCS && this.length <= n.length) {
            return false;
        }
        for (InterprNode p : this.parents) {
            if (n.maxPrim < p.minPrim || n.minPrim > p.maxPrim || p.visitedContains == v || !p.contains(n, followLCS, v)) continue;
            return true;
        }
        return followLCS && this.largestCommonSubset != null && this.largestCommonSubset.contains(n, followLCS, v);
    }

    private boolean isLinked(InterprNode n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (this == n) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        for (InterprNode p : this.parents) {
            if (p.visitedContains == v || !p.isLinked(n, v)) continue;
            return true;
        }
        return false;
    }

    private void collectPrimitiveNodes(Set<InterprNode> results, long v) {
        if (v == this.visitedCollect) {
            return;
        }
        this.visitedCollect = v;
        if (this.primId >= 0) {
            results.add(this);
        } else {
            for (InterprNode n : this.parents) {
                n.collectPrimitiveNodes(results, v);
            }
        }
    }

    public void collectConflicts(Set<InterprNode> conflicts, long v) {
        if (this.visitedCollectConflicts == v) {
            return;
        }
        this.visitedCollectConflicts = v;
        for (InterprNode n : this.children) {
            if (this.isConflict >= 0) {
                conflicts.add(n);
            }
            n.collectConflicts(conflicts, v);
        }
    }

    public boolean isConflicting(long v) {
        if (this.isConflict >= 0) {
            return true;
        }
        if (this.conflictsAllowed()) {
            if (this.visitedIsConflicting == v) {
                return false;
            }
            this.visitedIsConflicting = v;
            for (InterprNode p : this.parents) {
                if (!p.isConflicting(v)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean conflictsAllowed() {
        return this.activations == null || this.activations.isEmpty();
    }

    public void storeFinalWeight(long v) {
        if (this.visitedStoreFinalWeight == v) {
            return;
        }
        this.visitedStoreFinalWeight = v;
        for (Activation act : this.getNeuronActivations()) {
            act.finalState = act.rounds.getLast();
        }
        for (InterprNode cn : this.children) {
            cn.storeFinalWeight(v);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean level) {
        TreeSet<InterprNode> ids = new TreeSet<InterprNode>();
        this.collectPrimitiveNodes(ids, visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean f1 = true;
        for (InterprNode n : ids) {
            if (!f1) {
                sb.append(",");
            }
            f1 = false;
            sb.append(n.primId);
            if (level || n.orInterprNodes == null) continue;
            sb.append("[");
            boolean f2 = true;
            for (InterprNode on : n.orInterprNodes.values()) {
                if (!f2) {
                    sb.append(",");
                }
                f2 = false;
                sb.append(on.toString(true));
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(InterprNode n) {
        int r = Integer.compare(this.length, n.length);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, n.id);
    }

    public static int compare(InterprNode oa, InterprNode ob) {
        if (oa == ob) {
            return 0;
        }
        if (oa == null && ob != null) {
            return -1;
        }
        if (oa != null && ob == null) {
            return 1;
        }
        return oa.compareTo(ob);
    }

    public static enum Relation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN;


        public boolean compare(InterprNode a, InterprNode b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case CONTAINS: {
                    return a.contains(b, false);
                }
                case CONTAINED_IN: {
                    return b.contains(a, false);
                }
            }
            return false;
        }
    }
}

