/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.aika.Activation;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.neuron.Neuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static boolean INCOMPLETE_OPTIMIZATION = true;
    public static int MAX_SEARCH_STEPS = 100000;
    public int id;
    SearchNode excludedParent;
    SearchNode selectedParent;
    SearchNode parent;
    long visited;
    List<InterprNode> refinement;
    RefMarker marker;
    Neuron.NormWeight weightDelta = Neuron.NormWeight.ZERO_WEIGHT;
    public List<StateChange> modifiedActs = new ArrayList<StateChange>();
    public TreeSet<SearchNode> candidates = new TreeSet();

    public SearchNode(SearchNode parent) {
        this.parent = parent;
    }

    private void collectResults(Collection<InterprNode> results) {
        results.addAll(this.refinement);
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    private void markSelected(long v) {
        if (this.marker != null) {
            this.marker.markedSelected = v;
        }
        if (this.selectedParent != null) {
            this.selectedParent.markSelected(v);
        }
    }

    public static SearchNode createInitialExpandNode(Document doc) {
        ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
        changed.add(doc.bottom);
        return SearchNode.createCandidate(doc, changed, null, null, null, Arrays.asList(doc.bottom), null);
    }

    public void computeSelectedOption(Document doc) {
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        results.add(doc.bottom);
        doc.selectedSearchNode = null;
        int[] searchSteps = new int[1];
        List<InterprNode> rootRefs = SearchNode.expandRootRefinement(doc);
        this.refinement = this.expandRefinement(rootRefs, InterprNode.visitedCounter++);
        this.markCovered(null, this.visited, this.refinement);
        this.markExcluded(null, this.visited, this.refinement);
        this.weightDelta = doc.vQueue.adjustWeight(this, rootRefs);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Root ExpandNode:" + this.toString());
        }
        doc.interrupted = false;
        doc.selectedSearchNode = doc.root;
        doc.selectedMark = InterprNode.visitedCounter++;
        this.markSelected(doc.selectedMark);
        doc.bottom.storeFinalWeight(InterprNode.visitedCounter++);
        this.generateInitialCandidates(doc);
        SearchNode child = doc.root.selectCandidate();
        if (child != null) {
            child.search(doc, doc.root, null, searchSteps);
        }
        if (doc.selectedSearchNode != null) {
            doc.selectedSearchNode.reconstructSelectedResult(doc);
            doc.selectedSearchNode.collectResults(results);
            log.info("Selected SearchNode ID: " + doc.selectedSearchNode.id);
        }
        doc.selectedInterprNode = results;
        if (doc.interrupted) {
            log.warn("The search for the best interpretation has been interrupted. Too many search steps!");
        }
    }

    private void reconstructSelectedResult(Document doc) {
        if (this.selectedParent != null) {
            this.selectedParent.reconstructSelectedResult(doc);
        }
        this.changeState(StateChange.Mode.NEW);
        for (StateChange sc : this.modifiedActs) {
            Activation act = sc.act;
            if (act.finalState == null || !(act.finalState.value > 0.0)) continue;
            doc.finallyActivatedNeurons.add(act.key.n.neuron);
        }
    }

    private void search(Document doc, SearchNode selectedParent, SearchNode excludedParent, int[] searchSteps) {
        SearchNode child;
        if (searchSteps[0] > MAX_SEARCH_STEPS) {
            doc.interrupted = true;
        }
        searchSteps[0] = searchSteps[0] + 1;
        this.markCovered(null, this.visited, this.refinement);
        this.markExcluded(null, this.visited, this.refinement);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id);
            log.info(this.toString());
        }
        boolean f = doc.selectedMark == -1L || this.marker.markedSelected != doc.selectedMark;
        this.changeState(StateChange.Mode.NEW);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info(doc.networkStateToString(true, true) + "\n");
        }
        double accNW = this.computeAccumulatedWeight().getNormWeight();
        double selectedAccNW = doc.selectedSearchNode != null ? doc.selectedSearchNode.computeAccumulatedWeight().getNormWeight() : 0.0;
        this.generateNextLevelCandidates(doc, selectedParent, excludedParent);
        if (this.candidates.size() == 0) {
            SearchNode en = this;
            while (en != null) {
                if (en.marker != null && !en.marker.complete) {
                    en.marker.complete = !this.hasUnsatisfiedPositiveFeedbackLink(en.refinement);
                }
                en = en.selectedParent;
            }
            if (accNW > selectedAccNW) {
                doc.selectedSearchNode = this;
                doc.selectedMark = InterprNode.visitedCounter++;
                this.markSelected(doc.selectedMark);
                doc.bottom.storeFinalWeight(InterprNode.visitedCounter++);
            }
        }
        if ((child = this.selectCandidate()) != null) {
            child.search(doc, this, excludedParent, searchSteps);
        }
        this.changeState(StateChange.Mode.OLD);
        if (doc.interrupted) {
            return;
        }
        while ((child = selectedParent.selectCandidate()) != null && !f && INCOMPLETE_OPTIMIZATION && child.marker.complete) {
        }
        if (child != null) {
            child.search(doc, selectedParent, this, searchSteps);
        }
    }

    private boolean hasUnsatisfiedPositiveFeedbackLink(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (!this.hasUnsatisfiedPositiveFeedbackLink(x)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsatisfiedPositiveFeedbackLink(InterprNode n) {
        if (n.hasUnsatisfiedPosFeedbackLinksCache != null) {
            return n.hasUnsatisfiedPosFeedbackLinksCache;
        }
        for (Activation act : n.getNeuronActivations()) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                if (!sa.s.key.isRecurrent || !(sa.s.w > 0.0) || this.isCovered(sa.output.key.o.markedCovered)) continue;
                n.hasUnsatisfiedPosFeedbackLinksCache = true;
                return true;
            }
        }
        for (InterprNode pn : n.parents) {
            if (!this.hasUnsatisfiedPositiveFeedbackLink(pn)) continue;
            n.hasUnsatisfiedPosFeedbackLinksCache = true;
            return true;
        }
        n.hasUnsatisfiedPosFeedbackLinksCache = false;
        return false;
    }

    private SearchNode selectCandidate() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.pollFirst();
    }

    public void generateInitialCandidates(Document doc) {
        this.candidates = new TreeSet();
        for (InterprNode cn : SearchNode.collectConflicts(doc)) {
            ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
            SearchNode c = SearchNode.createCandidate(doc, changed, this, this, null, Arrays.asList(cn), new RefMarker());
            c.weightDelta = doc.vQueue.adjustWeight(c, changed);
            if (Document.OPTIMIZE_DEBUG_OUTPUT) {
                log.info("Search Step: " + c.id + "  Candidate Weight Delta: " + c.weightDelta);
                log.info(doc.networkStateToString(true, true) + "\n");
            }
            c.changeState(StateChange.Mode.OLD);
            this.candidates.add(c);
        }
    }

    public void generateNextLevelCandidates(Document doc, SearchNode selectedParent, SearchNode excludedParent) {
        this.candidates = new TreeSet();
        for (SearchNode pc : selectedParent.candidates) {
            if (this.checkCovered(pc.refinement) || this.checkExcluded(pc.refinement, InterprNode.visitedCounter++)) continue;
            ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
            SearchNode c = SearchNode.createCandidate(doc, changed, this, this, excludedParent, pc.refinement, pc.marker);
            c.weightDelta = doc.vQueue.adjustWeight(c, changed);
            c.changeState(StateChange.Mode.OLD);
            this.candidates.add(c);
        }
    }

    private boolean checkCovered(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (this.isCovered(x.markedCovered)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExcluded(List<InterprNode> n, long v) {
        for (InterprNode x : n) {
            if (!this.checkExcluded(x, v)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExcluded(InterprNode ref, long v) {
        if (ref.visitedCheckExcluded == v) {
            return false;
        }
        ref.visitedCheckExcluded = v;
        if (this.isCovered(ref.markedExcluded)) {
            return true;
        }
        for (InterprNode pn : ref.parents) {
            if (!this.checkExcluded(pn, v)) continue;
            return true;
        }
        return false;
    }

    public static List<InterprNode> collectConflicts(Document doc) {
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        long v = InterprNode.visitedCounter++;
        for (InterprNode n : doc.bottom.children) {
            for (Conflicts.Conflict c : n.conflicts.primary.values()) {
                if (c.secondary.visitedCollectConflicts == v) continue;
                c.secondary.visitedCollectConflicts = v;
                results.add(c.secondary);
            }
        }
        return results;
    }

    private static List<InterprNode> expandRootRefinement(Document doc) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        tmp.add(doc.bottom);
        for (InterprNode pn : doc.bottom.children) {
            if (pn.orInterprNodes != null && !pn.orInterprNodes.isEmpty() || !pn.conflicts.primary.isEmpty() || !pn.conflicts.secondary.isEmpty()) continue;
            tmp.add(pn);
        }
        return tmp;
    }

    private List<InterprNode> expandRefinement(List<InterprNode> ref, long v) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        for (InterprNode n : ref) {
            this.markExpandRefinement(n, v);
            tmp.add(n);
        }
        for (InterprNode n : ref) {
            this.expandRefinementRecursiveStep(tmp, n, v);
        }
        if (ref.size() == tmp.size()) {
            return tmp;
        }
        return this.expandRefinement(tmp, v);
    }

    private void markExpandRefinement(InterprNode n, long v) {
        if (n.markedExpandRefinement == v) {
            return;
        }
        n.markedExpandRefinement = v;
        for (InterprNode pn : n.parents) {
            this.markExpandRefinement(pn, v);
        }
    }

    private boolean hasUncoveredConflicts(InterprNode n) {
        if (!n.conflicts.hasConflicts()) {
            return false;
        }
        ArrayList<InterprNode> conflicts = new ArrayList<InterprNode>();
        Conflicts.collectDirectConflicting(conflicts, n);
        for (InterprNode cn : conflicts) {
            if (this.isCovered(cn.markedExcluded)) continue;
            return true;
        }
        return false;
    }

    private void expandRefinementRecursiveStep(Collection<InterprNode> results, InterprNode n, long v) {
        if (n.visitedExpandRefinementRecursiveStep == v) {
            return;
        }
        n.visitedExpandRefinementRecursiveStep = v;
        if (n.refByOrInterprNode != null) {
            for (InterprNode on : n.refByOrInterprNode) {
                if (on.markedExpandRefinement == v || this.hasUncoveredConflicts(on) || this.isCovered(on.markedCovered)) continue;
                this.markExpandRefinement(on, v);
                results.add(on);
            }
        }
        for (InterprNode pn : n.parents) {
            if (pn.isBottom()) continue;
            this.expandRefinementRecursiveStep(results, pn, v);
        }
        if (n.isBottom()) {
            return;
        }
        for (InterprNode cn : n.children) {
            if (cn.visitedExpandRefinementRecursiveStep == v) break;
            boolean covered = true;
            for (InterprNode cnp : cn.parents) {
                if (cnp.visitedExpandRefinementRecursiveStep == v || this.isCovered(cnp.markedCovered)) continue;
                covered = false;
                break;
            }
            if (!covered) continue;
            this.expandRefinementRecursiveStep(results, cn, v);
        }
    }

    public Neuron.NormWeight computeAccumulatedWeight() {
        return this.selectedParent != null ? this.weightDelta.add(this.selectedParent.computeAccumulatedWeight()) : this.weightDelta;
    }

    public boolean isCovered(long g) {
        return g == this.visited || this.selectedParent != null && g < this.visited && this.selectedParent.isCovered(g);
    }

    private void markCovered(List<InterprNode> changed, long v, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markCovered(changed, v, x);
        }
    }

    private boolean markCovered(List<InterprNode> changed, long v, InterprNode n) {
        if (n.visitedMarkCovered == v) {
            return false;
        }
        n.visitedMarkCovered = v;
        if (this.isCovered(n.markedCovered)) {
            return false;
        }
        n.markedCovered = v;
        if (n.isBottom()) {
            return false;
        }
        for (InterprNode p : n.parents) {
            if (!this.markCovered(changed, v, p)) continue;
            return true;
        }
        for (InterprNode c : n.children) {
            if (c.visitedMarkCovered == v || !this.containedInSelectedBranch(v, c)) continue;
            if (c.isConflicting(InterprNode.visitedCounter++)) {
                return true;
            }
            c.markedCovered = v;
            if (!this.markCovered(changed, v, c)) continue;
            return true;
        }
        if (changed != null) {
            changed.add(n);
        }
        return false;
    }

    private void markExcluded(List<InterprNode> changed, long v, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markExcluded(changed, v, x);
        }
    }

    private void markExcluded(List<InterprNode> changed, long v, InterprNode n) {
        ArrayList<InterprNode> conflicting = new ArrayList<InterprNode>();
        Conflicts.collectAllConflicting(conflicting, n, InterprNode.visitedCounter++);
        for (InterprNode cn : conflicting) {
            this.markExcludedRecursiveStep(changed, v, cn);
        }
    }

    private void markExcludedRecursiveStep(List<InterprNode> changed, long v, InterprNode n) {
        if (n.markedExcluded == v || this.isCovered(n.markedExcluded)) {
            return;
        }
        n.markedExcluded = v;
        for (InterprNode c : n.children) {
            this.markExcludedRecursiveStep(changed, v, c);
        }
        if (n.linkedByLCS != null) {
            for (InterprNode c : n.linkedByLCS) {
                this.markExcludedRecursiveStep(changed, v, c);
            }
        }
        if (changed != null) {
            changed.add(n);
        }
    }

    public boolean containedInSelectedBranch(long v, InterprNode n) {
        for (InterprNode p : n.parents) {
            if (p.markedCovered == v || this.isCovered(p.markedCovered)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.refinement.toString() + " : " + this.computeAccumulatedWeight();
    }

    public static SearchNode createCandidate(Document doc, List<InterprNode> changed, SearchNode parent, SearchNode selectedParent, SearchNode excludedParent, List<InterprNode> ref, RefMarker marker) {
        SearchNode cand = new SearchNode(parent);
        cand.id = doc.searchNodeIdCounter++;
        cand.visited = InterprNode.visitedCounter++;
        cand.selectedParent = selectedParent;
        cand.excludedParent = excludedParent;
        cand.refinement = cand.expandRefinement(ref, InterprNode.visitedCounter++);
        cand.markCovered(changed, cand.visited, cand.refinement);
        cand.markExcluded(changed, cand.visited, cand.refinement);
        cand.marker = marker;
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("\n \n Generate Candidate: " + cand.refinement.toString());
        }
        return cand;
    }

    public void changeState(StateChange.Mode m) {
        for (StateChange sc : this.modifiedActs) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode c) {
        int r = Double.compare(c.computeAccumulatedWeight().getNormWeight(), this.computeAccumulatedWeight().getNormWeight());
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }

    public static class RefMarker {
        public long markedSelected;
        public boolean complete;
    }

    public static class StateChange {
        public Activation act;
        public Activation.Rounds oldRounds;
        public Activation.Rounds newRounds;

        public static void saveOldState(List<StateChange> changes, Activation act, long v) {
            StateChange sc = act.currentStateChange;
            if (sc == null || act.currentStateV != v) {
                sc = new StateChange();
                sc.oldRounds = act.rounds.copy();
                act.currentStateChange = sc;
                act.currentStateV = v;
                sc.act = act;
                if (changes != null) {
                    changes.add(sc);
                }
            }
        }

        public static void saveNewState(Activation act) {
            StateChange sc = act.currentStateChange;
            sc.newRounds = act.rounds;
        }

        public void restoreState(Mode m) {
            this.act.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public static enum Mode {
            OLD,
            NEW;

        }
    }
}

