/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.aika.Activation;
import org.aika.Model;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.OrNode;
import org.aika.neuron.InputNeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class InputNode
extends Node {
    public Synapse.Key key;
    public Neuron inputNeuron;
    public Map<SynapseKey, Synapse> synapses;
    private long visitedTrain = -1L;

    public InputNode() {
    }

    public InputNode(Document doc, Synapse.Key key) {
        super(doc, 1);
        this.key = key;
        Model m = doc.m;
        if (m != null) {
            ++m.stat.nodes;
            int n = this.level;
            m.stat.nodesPerLevel[n] = m.stat.nodesPerLevel[n] + 1;
        }
        this.endRequired = false;
        this.ridRequired = false;
        if (key != null) {
            this.endRequired = key.startRangeMapping == Range.Mapping.NONE;
            this.ridRequired = key.relativeRid != null || key.absoluteRid != null;
        }
    }

    public static InputNode add(Document doc, Synapse.Key key, Neuron input) {
        InputNode in;
        InputNode inputNode = in = input != null ? input.outputNodes.get(key) : null;
        if (in != null) {
            return in;
        }
        in = new InputNode(doc, key);
        if (input != null) {
            in.inputNeuron = input;
            in.passive = input.node != null && input.node.passive;
            input.outputNodes.put(key, in);
        }
        return in;
    }

    @Override
    protected void changeNumberOfNeuronRefs(Document doc, long v, int d) {
        Node.ThreadState th = this.getThreadState(doc, true);
        if (th.visitedNeuronRefsChange == v) {
            return;
        }
        th.visitedNeuronRefsChange = v;
        this.numberOfNeuronRefs += d;
    }

    @Override
    public void initActivation(Document doc, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            doc.inputNeuronActivations.add(act);
            Node.ThreadState th = this.getThreadState(doc, false);
            if (th == null || th.activations.isEmpty()) {
                doc.activatedNeurons.add(this.neuron);
                doc.activatedInputNeurons.add(this.neuron);
            }
        } else if (!this.isBlocked) {
            doc.inputNodeActivations.add(act);
        }
    }

    @Override
    public void deleteActivation(Document doc, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            doc.inputNeuronActivations.remove(act);
            Node.ThreadState th = this.getThreadState(doc, false);
            if (th == null || th.activations.isEmpty()) {
                doc.activatedNeurons.remove(this.neuron);
                doc.activatedInputNeurons.remove(this.neuron);
            }
        } else if (!this.isBlocked) {
            doc.inputNodeActivations.remove(act);
        }
    }

    private Activation.Key computeActivationKey(Activation iAct) {
        Activation.Key ak = iAct.key;
        if (this.key.absoluteRid != null && this.key.absoluteRid != ak.rid || ak.o.isConflicting(InterprNode.visitedCounter++)) {
            return null;
        }
        return new Activation.Key(this, new Range(this.key.startRangeMapping.getSignalPos(ak.r), this.key.endRangeMapping.getSignalPos(ak.r)), this.key.relativeRid != null ? ak.rid : null, ak.o);
    }

    @Override
    public void computeNullHyp(Model m) {
        this.nullHypFreq = this.frequency;
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        return true;
    }

    @Override
    protected boolean hasSupport(Activation act) {
        for (Activation iAct : act.inputs.values()) {
            if (iAct.isRemoved || !(iAct.upperBound > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Range preProcessAddedActivation(Document doc, Activation.Key ak, Collection<Activation> inputActs) {
        if (this.neuron == null && (this.key.startRangeMapping == Range.Mapping.NONE || this.key.endRangeMapping == Range.Mapping.NONE)) {
            boolean dir = this.key.startRangeMapping == Range.Mapping.NONE;
            int pos = ak.r.getBegin(dir);
            List tmp = Activation.select(doc, this, ak.rid, new Range(pos, pos), Range.Operator.LESS_THAN, Range.Operator.GREATER_THAN, ak.o, InterprNode.Relation.CONTAINS).collect(Collectors.toList());
            for (Activation act : tmp) {
                this.addActivationInternal(doc, new Activation.Key(this, new Range(act.key.r.getBegin(dir), pos).invert(dir), act.key.rid, act.key.o), act.inputs.values(), false);
                ++Activation.removedIdCounter;
                act.removedId = act.removedId;
                act.isRemoved = true;
                this.removeActivationInternal(doc, act, act.inputs.values());
            }
            Activation cAct = Activation.getNextSignal(this, doc, pos, ak.rid, ak.o, dir, dir);
            return new Range(ak.r.getBegin(dir), cAct != null ? cAct.key.r.getBegin(dir) : (dir ? Integer.MIN_VALUE : Integer.MAX_VALUE)).invert(dir);
        }
        return ak.r;
    }

    @Override
    protected void postProcessRemovedActivation(Document doc, Activation act, Collection<Activation> inputActs) {
        Activation.Key ak = act.key;
        if (this.neuron == null && (this.key.startRangeMapping == Range.Mapping.NONE || this.key.endRangeMapping == Range.Mapping.NONE)) {
            boolean dir = this.key.startRangeMapping == Range.Mapping.NONE;
            List tmp = Activation.select(doc, this, ak.rid, new Range(ak.r.getBegin(dir), dir ? Integer.MAX_VALUE : Integer.MIN_VALUE).invert(!dir), dir ? Range.Operator.EQUALS : Range.Operator.NONE, dir ? Range.Operator.NONE : Range.Operator.EQUALS, ak.o, InterprNode.Relation.CONTAINS).collect(Collectors.toList());
            for (Activation cAct : tmp) {
                Activation.Key cak = cAct.key;
                this.processAddedActivation(doc, new Activation.Key(cak.n, new Range(dir ? Integer.MIN_VALUE : cak.r.begin, dir ? cak.r.end : Integer.MAX_VALUE), cak.rid, cak.o), cAct.inputs.values());
                if (cAct.isRemoved) continue;
                ++Activation.removedIdCounter;
                cAct.removedId = cAct.removedId;
                cAct.isRemoved = true;
                this.removeActivationInternal(doc, cAct, cAct.inputs.values());
            }
        }
    }

    public void addActivation(Document doc, Activation inputAct) {
        Activation.Key ak = this.computeActivationKey(inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(doc, ak, Collections.singleton(inputAct));
        }
    }

    public void removeActivation(Document doc, Activation inputAct) {
        for (Activation act : inputAct.outputs.values()) {
            if (act.key.n != this) continue;
            InputNode.removeActivationAndPropagate(doc, act, Collections.singleton(inputAct));
        }
    }

    @Override
    public void propagateAddedActivation(Document doc, Activation act, InterprNode removedConflict) {
        if (this.neuron instanceof InputNeuron) {
            if (removedConflict == null) {
                this.neuron.propagateAddedActivation(doc, act);
            }
        } else if (!this.key.isNeg && !this.key.isRecurrent) {
            this.apply(doc, act, removedConflict);
        }
    }

    @Override
    public void propagateRemovedActivation(Document doc, Activation act) {
        if (this.neuron instanceof InputNeuron) {
            this.neuron.propagateRemovedActivation(doc, act);
        } else if (!this.key.isNeg && !this.key.isRecurrent) {
            this.removeFromNextLevel(doc, act);
        }
    }

    @Override
    public boolean isAllowedOption(Document doc, InterprNode n, Activation act, long v) {
        return false;
    }

    @Override
    protected Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        ArrayList<AndNode.Refinement> result = new ArrayList<AndNode.Refinement>(2);
        result.add(new AndNode.Refinement(this.key.relativeRid, newRef.rid, this));
        result.add(newRef);
        return result;
    }

    @Override
    public void apply(Document doc, Activation act, InterprNode removedConflict) {
        if (act.isRemoved || this.passive) {
            return;
        }
        this.lock.acquireReadLock();
        if (this.andChildren != null) {
            for (Map.Entry me : this.andChildren.entrySet()) {
                InputNode.addNextLevelActivations(doc, ((AndNode.Refinement)me.getKey()).input, (AndNode.Refinement)me.getKey(), (AndNode)me.getValue(), act, removedConflict);
            }
        }
        this.lock.releaseReadLock();
        if (removedConflict == null) {
            OrNode.processCandidate(doc, this, act, false);
        }
    }

    private static void addNextLevelActivations(Document doc, InputNode secondNode, AndNode.Refinement ref, AndNode nlp, Activation act, InterprNode removedConflict) {
        Activation.Key ak = act.key;
        InputNode firstNode = (InputNode)ak.n;
        Integer secondRid = Utils.nullSafeAdd(ak.rid, false, ref.rid, false);
        Activation.select(doc, secondNode, secondRid, ak.r, InputNode.computeStartRangeMatch(firstNode.key, secondNode.key), InputNode.computeEndRangeMatch(firstNode.key, secondNode.key), null, null).forEach(secondAct -> {
            InterprNode o;
            if (!secondAct.isRemoved && (o = InterprNode.add(doc, true, key.o, secondAct.key.o)) != null && (removedConflict == null || o.contains(removedConflict, false))) {
                nlp.addActivation(doc, new Activation.Key(nlp, Range.mergeRange(Range.getOutputRange(key.r, new boolean[]{inputNode.key.startRangeOutput, inputNode.key.endRangeOutput}), Range.getOutputRange(secondAct.key.r, new boolean[]{inputNode2.key.startRangeOutput, inputNode2.key.endRangeOutput})), Utils.nullSafeMin(key.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
            }
        });
    }

    private static Range.Operator computeStartRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k1.startRangeMatch == Range.Operator.FIRST || k1.startRangeMatch == Range.Operator.LAST) {
            return k1.startRangeMatch;
        }
        if (k2.startRangeMatch == Range.Operator.FIRST || k2.startRangeMatch == Range.Operator.LAST) {
            return Range.Operator.invert(k2.startRangeMatch);
        }
        if (k2.startRangeOutput) {
            return k1.startRangeMatch;
        }
        if (k1.startRangeOutput) {
            return Range.Operator.invert(k2.startRangeMatch);
        }
        return Range.Operator.NONE;
    }

    private static Range.Operator computeEndRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k1.endRangeMatch == Range.Operator.FIRST || k1.endRangeMatch == Range.Operator.LAST) {
            return k1.endRangeMatch;
        }
        if (k2.endRangeMatch == Range.Operator.FIRST || k2.endRangeMatch == Range.Operator.LAST) {
            return Range.Operator.invert(k2.endRangeMatch);
        }
        if (k2.endRangeOutput) {
            return k1.endRangeMatch;
        }
        if (k1.endRangeOutput) {
            return Range.Operator.invert(k2.endRangeMatch);
        }
        return Range.Operator.NONE;
    }

    @Override
    public void discover(Document doc, Activation act) {
        long v = Node.visitedCounter++;
        for (Activation secondAct : doc.inputNodeActivations) {
            AndNode.Refinement ref = new AndNode.Refinement(secondAct.key.rid, act.key.rid, (InputNode)secondAct.key.n);
            Range.Operator srm = InputNode.computeStartRangeMatch(this.key, ref.input.key);
            Range.Operator erm = InputNode.computeEndRangeMatch(this.key, ref.input.key);
            Integer ridDelta = Utils.nullSafeSub(act.key.rid, false, secondAct.key.rid, false);
            if (act == secondAct || this == ref.input || ref.input.visitedTrain == v || ref.input.key.isNeg || ref.input.key.isRecurrent || (!srm.compare(act.key.r.begin, act.key.r.end, secondAct.key.r.begin, secondAct.key.r.end) || !erm.compare(act.key.r.end, act.key.r.begin, secondAct.key.r.end, secondAct.key.r.begin)) && (ridDelta == null || ridDelta >= AndNode.MAX_RID_RANGE)) continue;
            ref.input.visitedTrain = v;
            AndNode.createNextLevelNode(doc, this, ref, true);
        }
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        return n.bias + Math.abs(this.getSynapse((SynapseKey)new SynapseKey((Integer)(this.key.relativeRid == null ? null : offset), (Neuron)n)).w);
    }

    public Synapse getSynapse(SynapseKey sk) {
        this.lock.acquireReadLock();
        Synapse s = this.synapses != null ? this.synapses.get(sk) : null;
        this.lock.releaseReadLock();
        return s;
    }

    public void setSynapse(Document doc, SynapseKey sk, Synapse s) {
        this.lock.acquireWriteLock(doc.threadId);
        if (this.synapses == null) {
            this.synapses = new TreeMap<SynapseKey, Synapse>();
        }
        this.synapses.put(sk, s);
        this.lock.releaseWriteLock();
    }

    @Override
    public void cleanup(Document doc) {
    }

    @Override
    public void remove(Document doc) {
        this.inputNeuron.outputNodes.remove(this.key);
        super.remove(doc);
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.isNeg ? "N" : "P");
        sb.append(this.key.isRecurrent ? "R" : "");
        sb.append(this.getRangeBrackets(this.key.startRangeOutput, this.key.startRangeMapping));
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.label != null) {
                sb.append(",");
                sb.append(this.inputNeuron.label);
            }
        }
        sb.append(this.getRangeBrackets(this.key.endRangeOutput, this.key.endRangeMapping));
        return sb.toString();
    }

    private String getRangeBrackets(boolean ro, Range.Mapping rs) {
        if (rs == Range.Mapping.NONE) {
            return "|";
        }
        if (ro) {
            return rs == Range.Mapping.START ? "[" : "]";
        }
        if (!ro) {
            return rs == Range.Mapping.START ? "<" : ">";
        }
        return "|";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("I");
        super.write(out);
        this.key.write(out);
    }

    @Override
    public void readFields(DataInput in, Document doc) throws IOException {
        super.readFields(in, doc);
        this.key = Synapse.Key.read(in, doc);
    }

    public static class SynapseKey
    implements Comparable<SynapseKey> {
        final Integer rid;
        final Neuron n;

        public SynapseKey(Integer rid, Neuron n) {
            this.rid = rid;
            this.n = n;
        }

        @Override
        public int compareTo(SynapseKey sk) {
            int r = Utils.compareInteger(this.rid, sk.rid);
            if (r != 0) {
                return r;
            }
            return this.n.compareTo(sk.n);
        }
    }
}

