/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.aika.Activation;
import org.aika.Model;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.OrNode;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Node
implements Comparable<Node>,
Writable {
    public static int minFrequency = 5;
    public static int MAX_RID = 20;
    public static boolean LINK_NEURON_RELATIONS_OPTIMIZATION = true;
    public static final DummyNode MIN_NODE = new DummyNode(Integer.MIN_VALUE);
    public static final DummyNode MAX_NODE = new DummyNode(Integer.MAX_VALUE);
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public static AtomicInteger currentNodeId = new AtomicInteger(0);
    public int id;
    public TreeMap<ReverseAndRefinement, AndNode.Refinement> reverseAndChildren;
    public TreeMap<AndNode.Refinement, AndNode> andChildren;
    public TreeSet<OrNode.OrEntry> orChildren;
    public int level;
    public boolean passive;
    public volatile int frequency;
    public volatile double nullHypFreq;
    public volatile double oldNullHypFreq;
    public boolean isBlocked;
    public boolean endRequired;
    public boolean ridRequired;
    public int numberOfNeuronRefs = 0;
    public volatile boolean isRemoved;
    public volatile int isRemovedId;
    public static int isRemovedIdCounter = 0;
    public volatile boolean frequencyHasChanged = true;
    public volatile int nOffset;
    public volatile int sizeSum = 0;
    public volatile int instanceSum = 0;
    public ReadWriteLock lock = new ReadWriteLock();
    public boolean isQueued = false;
    public long queueId;
    public Neuron neuron = null;
    public static long visitedCounter = 0L;
    public ThreadState[] threads;
    public static final Comparator<Activation.Key> BEGIN_COMP = new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key k1, Activation.Key k2) {
            int r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<Activation.Key> END_COMP = new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key k1, Activation.Key k2) {
            int r = Range.compare(k1.r, k2.r, true);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<Activation.Key> RID_COMP = new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key k1, Activation.Key k2) {
            int r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };

    public ThreadState getThreadState(Document doc, boolean create) {
        ThreadState th = this.threads[doc.threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[doc.threadId] = th = new ThreadState(this.endRequired, this.ridRequired);
        }
        th.lastUsed = doc.iterationId;
        return th;
    }

    public abstract void propagateAddedActivation(Document var1, Activation var2, InterprNode var3);

    public abstract void propagateRemovedActivation(Document var1, Activation var2);

    public abstract boolean isAllowedOption(Document var1, InterprNode var2, Activation var3, long var4);

    public abstract void cleanup(Document var1);

    public abstract void initActivation(Document var1, Activation var2);

    public abstract void deleteActivation(Document var1, Activation var2);

    public abstract double computeSynapseWeightSum(Integer var1, Neuron var2);

    public abstract String logicToString();

    public abstract void apply(Document var1, Activation var2, InterprNode var3);

    public abstract void discover(Document var1, Activation var2);

    protected abstract Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement var1);

    protected abstract void changeNumberOfNeuronRefs(Document var1, long var2, int var4);

    protected abstract boolean hasSupport(Activation var1);

    public abstract void computeNullHyp(Model var1);

    public abstract boolean isExpandable(boolean var1);

    protected Node() {
    }

    public Node(Document doc, int level) {
        Model m = doc.m;
        this.threads = new ThreadState[m.numberOfThreads];
        this.id = currentNodeId.addAndGet(1);
        this.level = level;
        if (m != null) {
            m.allNodes[doc.threadId].add(this);
            this.nOffset = m.numberOfPositions;
        }
    }

    public void addOrChild(Document doc, OrNode.OrEntry oe) {
        this.lock.acquireWriteLock(doc.threadId);
        if (this.orChildren == null) {
            this.orChildren = new TreeSet();
        }
        this.orChildren.add(oe);
        this.lock.releaseWriteLock();
    }

    public void removeOrChild(Document doc, OrNode.OrEntry oe) {
        this.lock.acquireWriteLock(doc.threadId);
        if (this.orChildren != null) {
            this.orChildren.remove(oe);
            if (this.orChildren.isEmpty()) {
                this.orChildren = null;
            }
        }
        this.lock.releaseWriteLock();
    }

    public void addAndChild(AndNode.Refinement ref, AndNode child) {
        if (this.andChildren == null) {
            this.andChildren = new TreeMap();
            this.reverseAndChildren = new TreeMap();
        }
        AndNode n = this.andChildren.put(ref, child);
        assert (n == null);
        this.reverseAndChildren.put(new ReverseAndRefinement(child, ref.rid, 0), ref);
    }

    public void removeAndChild(AndNode.Refinement ref) {
        if (this.andChildren != null) {
            this.andChildren.remove(ref);
            this.reverseAndChildren.remove(new ReverseAndRefinement(this, ref.rid, 0));
            if (this.andChildren.isEmpty()) {
                this.andChildren = null;
                this.reverseAndChildren = null;
            }
        }
    }

    public void count(Document doc) {
        ThreadState ts = this.getThreadState(doc, false);
        if (ts == null) {
            return;
        }
        for (Activation act : ts.activations.values()) {
            ++this.frequency;
            this.frequencyHasChanged = true;
            this.sizeSum += act.key.r.end == null || act.key.r.begin == null || act.key.r.end == Integer.MAX_VALUE ? 1 : Math.max(1, act.key.r.end - act.key.r.begin);
            ++this.instanceSum;
        }
    }

    public Activation addActivationInternal(Document doc, Activation.Key ak, Collection<Activation> inputActs, boolean isTrainingAct) {
        Activation act = Activation.get(doc, this, ak);
        if (act == null) {
            act = new Activation(doc.activationIdCounter++, ak);
            act.isTrainingAct = isTrainingAct;
            if (this.neuron != null) {
                act.neuronInputs = new TreeSet<Activation.SynapseActivation>(Activation.SynapseActivation.INPUT_COMP);
                act.neuronOutputs = new TreeSet<Activation.SynapseActivation>(Activation.SynapseActivation.OUTPUT_COMP);
            }
            this.initActivation(doc, act);
            act.register(doc);
            act.link(inputActs);
            if (this.neuron != null) {
                this.linkNeuronRelations(doc, act);
            }
            if (!isTrainingAct) {
                this.propagateAddedActivation(doc, act, null);
            }
        } else {
            if (this.neuron != null) {
                this.linkNeuronRelations(doc, act);
            }
            act.link(inputActs);
        }
        return act;
    }

    public boolean removeActivationInternal(Document doc, Activation act, Collection<Activation> inputActs) {
        boolean flag = false;
        if (act.isRemoved) {
            act.unregister(doc);
            this.deleteActivation(doc, act);
            this.propagateRemovedActivation(doc, act);
            act.key.releaseRef();
            if (this.neuron != null) {
                this.unlinkNeuronRelations(doc, act);
            }
            flag = true;
        }
        act.unlink(inputActs);
        return flag;
    }

    private void linkNeuronRelations(Document doc, Activation act) {
        long v = visitedCounter++;
        for (int dir = 0; dir < (this.passive ? 1 : 2); ++dir) {
            TreeSet<Synapse> syns;
            ArrayList recNegTmp = new ArrayList();
            this.neuron.lock.acquireReadLock();
            TreeSet<Synapse> treeSet = syns = dir == 0 ? this.neuron.inputSynapses : this.neuron.outputSynapses;
            if (LINK_NEURON_RELATIONS_OPTIMIZATION && syns.size() > 10 && doc.activatedNeurons.size() * 20 < syns.size()) {
                TreeSet<Synapse> newSyns = new TreeSet<Synapse>(dir == 0 ? Synapse.INPUT_SYNAPSE_COMP : Synapse.OUTPUT_SYNAPSE_COMP);
                Synapse lk = new Synapse(null, Synapse.Key.MIN_KEY);
                Synapse uk = new Synapse(null, Synapse.Key.MAX_KEY);
                for (Neuron n : doc.activatedNeurons) {
                    if (dir == 0) {
                        lk.input = n;
                        uk.input = n;
                    } else {
                        lk.output = n;
                        uk.output = n;
                    }
                    newSyns.addAll(syns.subSet(lk, true, uk, true));
                }
                syns = newSyns;
            }
            for (Synapse s : syns) {
                Node n = (dir == 0 ? s.input : s.output).node;
                ThreadState th = n.getThreadState(doc, false);
                if (th == null || th.activations.isEmpty()) continue;
                Integer rid = dir == 0 ? (s.key.absoluteRid != null ? s.key.absoluteRid : Utils.nullSafeAdd(act.key.rid, false, s.key.relativeRid, false)) : Utils.nullSafeSub(act.key.rid, false, s.key.relativeRid, false);
                Range.Operator begin = this.replaceFirstAndLast(s.key.startRangeMatch);
                Range.Operator end = this.replaceFirstAndLast(s.key.endRangeMatch);
                Range r = act.key.r;
                if (dir == 0) {
                    begin = Range.Operator.invert(s.key.startRangeMapping == Range.Mapping.START ? begin : (s.key.endRangeMapping == Range.Mapping.START ? end : Range.Operator.NONE));
                    end = Range.Operator.invert(s.key.endRangeMapping == Range.Mapping.END ? end : (s.key.startRangeMapping == Range.Mapping.END ? begin : Range.Operator.NONE));
                    if (s.key.startRangeMapping != Range.Mapping.START || s.key.endRangeMapping != Range.Mapping.END) {
                        r = new Range(s.key.endRangeMapping == Range.Mapping.START ? r.end : (s.key.startRangeMapping == Range.Mapping.START ? r.begin : null), s.key.startRangeMapping == Range.Mapping.END ? r.begin : (s.key.endRangeMapping == Range.Mapping.END ? r.end : null));
                    }
                } else if (s.key.startRangeMapping != Range.Mapping.START || s.key.endRangeMapping != Range.Mapping.END) {
                    r = new Range(s.key.startRangeMapping == Range.Mapping.END ? r.end : (s.key.startRangeMapping == Range.Mapping.START ? r.begin : null), s.key.endRangeMapping == Range.Mapping.START ? r.begin : (s.key.endRangeMapping == Range.Mapping.END ? r.end : null));
                }
                Stream<Activation> tmp = Activation.select(doc, n, rid, r, begin, end, null, null);
                int d = dir;
                tmp.forEach(rAct -> {
                    Activation oAct = d == 0 ? act : rAct;
                    Activation iAct = d == 0 ? rAct : act;
                    Activation.SynapseActivation sa = new Activation.SynapseActivation(s, iAct, oAct);
                    oAct.neuronInputs.add(sa);
                    iAct.neuronOutputs.add(sa);
                    if (synapse.key.isNeg && synapse.key.isRecurrent) {
                        recNegTmp.add(rAct);
                    }
                });
            }
            this.neuron.lock.releaseReadLock();
            for (Activation rAct2 : recNegTmp) {
                Activation oAct = dir == 0 ? act : rAct2;
                Activation iAct = dir == 0 ? rAct2 : act;
                this.markConflicts(iAct, oAct, v);
                Node.addConflict(doc, oAct.key.o, iAct.key.o, iAct, Collections.singleton(act), v);
            }
        }
    }

    private Range.Operator replaceFirstAndLast(Range.Operator rm) {
        return rm == Range.Operator.FIRST || rm == Range.Operator.LAST ? Range.Operator.EQUALS : rm;
    }

    private void unlinkNeuronRelations(Document doc, Activation act) {
        int dir;
        long v = visitedCounter++;
        for (dir = 0; dir < 2; ++dir) {
            for (Activation.SynapseActivation sa : dir == 0 ? act.neuronInputs : act.neuronOutputs) {
                Activation rAct;
                Synapse s = sa.s;
                Activation activation = rAct = dir == 0 ? sa.input : sa.output;
                if (!s.key.isNeg || !s.key.isRecurrent) continue;
                Activation oAct = dir == 0 ? act : rAct;
                Activation iAct = dir == 0 ? rAct : act;
                this.markConflicts(iAct, oAct, v);
                Node.removeConflict(doc, oAct.key.o, iAct.key.o, iAct, act, v);
            }
        }
        for (dir = 0; dir < 2; ++dir) {
            for (Activation.SynapseActivation sa : dir == 0 ? act.neuronInputs : act.neuronOutputs) {
                Activation rAct = dir == 0 ? sa.input : sa.output;
                (dir == 0 ? rAct.neuronOutputs : rAct.neuronInputs).remove(sa);
            }
        }
    }

    public static void addConflict(Document doc, InterprNode io, InterprNode o, Activation act, Collection<Activation> inputActs, long v) {
        if (o.markedConflict == v || o.orInterprNodes == null) {
            if (!Node.isAllowed(doc, io, o, inputActs)) {
                Conflicts.add(doc, act, io, o);
            }
        } else {
            for (InterprNode no : o.orInterprNodes.values()) {
                Node.addConflict(doc, io, no, act, inputActs, v);
            }
        }
    }

    public static void removeConflict(Document doc, InterprNode io, InterprNode o, Activation act, Activation nAct, long v) {
        if (o.markedConflict == v || o.orInterprNodes == null) {
            if (!nAct.key.n.isAllowedOption(doc, o, nAct, visitedCounter++)) {
                assert (io != null);
                Conflicts.remove(doc, act, io, o);
            }
        } else {
            for (InterprNode no : o.orInterprNodes.values()) {
                Node.removeConflict(doc, io, no, act, nAct, v);
            }
        }
    }

    private void markConflicts(Activation iAct, Activation oAct, long v) {
        oAct.key.o.markedConflict = v;
        for (Activation.SynapseActivation sa : iAct.neuronOutputs) {
            if (!sa.s.key.isRecurrent || !sa.s.key.isNeg) continue;
            sa.output.key.o.markedConflict = v;
        }
    }

    private static boolean isAllowed(Document doc, InterprNode io, InterprNode o, Collection<Activation> inputActs) {
        if (io != null && o.contains(io, false)) {
            return true;
        }
        for (Activation act : inputActs) {
            if (!act.key.n.isAllowedOption(doc, o, act, visitedCounter++)) continue;
            return true;
        }
        return false;
    }

    public void processChanges(Document doc) {
        ThreadState th = this.getThreadState(doc, true);
        NavigableMap<Activation.Key, Collection<Activation>> tmpAdded = th.added;
        NavigableMap<Activation.Key, RemovedEntry> tmpRemoved = th.removed;
        th.added = new TreeMap<Activation.Key, Collection<Activation>>();
        th.removed = new TreeMap<Activation.Key, RemovedEntry>();
        Iterator it = tmpRemoved.entrySet().iterator();
        while (it.hasNext()) {
            Activation.Key key = (Activation.Key)it.next().getKey();
            boolean remove = false;
            for (Activation.Key aka : tmpAdded.keySet()) {
                if (aka.o != key.o || aka.rid != key.rid || aka.r != key.r) continue;
                remove = true;
            }
            if (!remove) continue;
            it.remove();
        }
        for (RemovedEntry removedEntry : tmpRemoved.values()) {
            if (this.hasSupport(removedEntry.act)) continue;
            ++Activation.removedIdCounter;
            removedEntry.act.removedId = removedEntry.act.removedId;
            removedEntry.act.isRemoved = true;
        }
        for (RemovedEntry removedEntry : tmpRemoved.values()) {
            this.processRemovedActivation(doc, removedEntry.act, removedEntry.iActs);
        }
        for (Map.Entry entry : tmpAdded.entrySet()) {
            this.processAddedActivation(doc, (Activation.Key)entry.getKey(), (Collection)entry.getValue());
        }
    }

    public static void addActivationAndPropagate(Document doc, Activation.Key ak, Collection<Activation> inputActs) {
        ThreadState th = ak.n.getThreadState(doc, true);
        ArrayList<Activation> iActs = (ArrayList<Activation>)th.added.get(ak);
        if (iActs == null) {
            iActs = new ArrayList<Activation>();
            th.added.put(ak, iActs);
        }
        iActs.addAll(inputActs);
        doc.queue.add(ak.n);
    }

    protected Range preProcessAddedActivation(Document doc, Activation.Key ak, Collection<Activation> inputActs) {
        return ak.r;
    }

    public void processAddedActivation(Document doc, Activation.Key ak, Collection<Activation> inputActs) {
        Range r = this.preProcessAddedActivation(doc, ak, inputActs);
        if (r == null) {
            return;
        }
        Activation.Key nak = new Activation.Key(this, r, ak.rid, ak.o);
        if (Document.APPLY_DEBUG_OUTPUT) {
            log.info("add: " + nak + " - " + nak.n);
        }
        this.addActivationInternal(doc, nak, inputActs, false);
    }

    public static void removeActivationAndPropagate(Document doc, Activation act, Collection<Activation> inputActs) {
        if (act == null || act.isRemoved) {
            return;
        }
        ThreadState th = act.key.n.getThreadState(doc, true);
        RemovedEntry re = (RemovedEntry)th.removed.get(act.key);
        if (re == null) {
            re = new RemovedEntry();
            re.act = act;
            th.removed.put(act.key, re);
        }
        re.iActs.addAll(inputActs);
        doc.queue.add(act.key.n);
    }

    protected void postProcessRemovedActivation(Document doc, Activation act, Collection<Activation> inputActs) {
    }

    public void processRemovedActivation(Document doc, Activation act, Collection<Activation> inputActs) {
        if (Document.APPLY_DEBUG_OUTPUT) {
            log.info("remove: " + act.key + " - " + act.key.n);
        }
        if (this.removeActivationInternal(doc, act, inputActs)) {
            this.postProcessRemovedActivation(doc, act, inputActs);
        }
    }

    public Collection<Activation> getActivations(Document doc) {
        ThreadState th = this.getThreadState(doc, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.activations.values();
    }

    public synchronized Activation getFirstActivation(Document doc) {
        ThreadState th = this.getThreadState(doc, false);
        if (th == null || th.activations.isEmpty()) {
            return null;
        }
        return th.activations.firstEntry().getValue();
    }

    public void clearActivations(Document doc) {
        ThreadState th = this.getThreadState(doc, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        if (th.activationsEnd != null) {
            th.activationsEnd.clear();
        }
        if (th.activationsRid != null) {
            th.activationsRid.clear();
        }
        th.added.clear();
        th.removed.clear();
    }

    public void clearActivations(Model m) {
        for (int i = 0; i < m.numberOfThreads; ++i) {
            this.clearActivations(m.createDocument(null, i));
        }
    }

    public boolean isFrequent() {
        return this.frequency >= minFrequency;
    }

    public boolean isPublic() {
        return this instanceof AndNode && this.orChildren != null && !this.orChildren.isEmpty();
    }

    public boolean computeAndParents(Document doc, Integer offset, SortedSet<AndNode.Refinement> inputs, Map<AndNode.Refinement, Node> parents, boolean discoverPatterns, long v) {
        RidVisited nv = this.getThreadState(doc, true).lookupVisited(offset);
        if (nv.computeParents == v) {
            return true;
        }
        nv.computeParents = v;
        if (inputs.size() == 1) {
            parents.put(inputs.first(), this);
            return true;
        }
        for (AndNode.Refinement ref : inputs) {
            Integer nOffset;
            TreeSet<AndNode.Refinement> childInputs = new TreeSet<AndNode.Refinement>(inputs);
            childInputs.remove(ref);
            AndNode.Refinement nRef = new AndNode.Refinement(ref.getRelativePosition(), offset, ref.input);
            this.lock.acquireReadLock();
            AndNode cp = this.andChildren != null ? this.andChildren.get(nRef) : null;
            this.lock.releaseReadLock();
            if (cp == null) {
                if (discoverPatterns) {
                    return false;
                }
                cp = AndNode.createNextLevelNode(doc, this, nRef, discoverPatterns);
                if (cp == null) {
                    return false;
                }
            }
            if (cp.computeAndParents(doc, nOffset = Utils.nullSafeMin(ref.getRelativePosition(), offset), childInputs, parents, discoverPatterns, v)) continue;
            return false;
        }
        return true;
    }

    public void removeFromNextLevel(Document doc, Activation iAct) {
        AndNode.removeActivation(doc, iAct);
        if (this.orChildren != null) {
            for (OrNode.OrEntry oe : this.orChildren) {
                ((OrNode)oe.node).removeActivation(doc, oe.ridOffset, iAct);
            }
        }
    }

    public void remove(Document doc) {
        assert (!this.isRemoved);
        if (this.neuron != null) {
            this.neuron.remove(doc);
        }
        this.lock.acquireWriteLock(doc.threadId);
        while (this.andChildren != null && !this.andChildren.isEmpty()) {
            this.andChildren.pollFirstEntry().getValue().remove(doc);
        }
        while (this.orChildren != null && !this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().node.remove(doc);
        }
        this.lock.releaseWriteLock();
        this.clearActivations(doc.m);
        this.isRemoved = true;
        this.isRemovedId = isRemovedIdCounter++;
    }

    public AndNode getAndChild(AndNode.Refinement ref) {
        this.lock.acquireReadLock();
        AndNode result = this.andChildren != null ? this.andChildren.get(ref) : null;
        this.lock.releaseReadLock();
        return result;
    }

    private static int evaluate(Neuron n, RSKey rsk) {
        double sum = rsk.pa.computeSynapseWeightSum(rsk.offset, n);
        if (sum < 0.0) {
            return -1;
        }
        if (rsk.pa == null) {
            return 0;
        }
        if (rsk.pa instanceof AndNode) {
            AndNode an = (AndNode)rsk.pa;
            for (AndNode.Refinement ref : an.parents.keySet()) {
                Synapse s = ref.input.getSynapse(new InputNode.SynapseKey(rsk.offset, n));
                if (!(sum - Math.abs(s.w) >= 0.0)) continue;
                return 1;
            }
        } else {
            InputNode in = (InputNode)rsk.pa;
            Synapse s = in.getSynapse(new InputNode.SynapseKey(rsk.offset, n));
            if (sum - Math.abs(s.w) >= 0.0) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean adjust(Document doc, Neuron neuron, final int dir) {
        long v = visitedCounter++;
        OrNode outputNode = (OrNode)neuron.node;
        if (neuron.inputSynapsesByWeight.isEmpty()) {
            return false;
        }
        neuron.maxRecurrentSum = 0.0;
        for (Synapse s : neuron.inputSynapsesByWeight) {
            s.input.lock.acquireWriteLock(doc.threadId);
            if (s.inputNode == null) {
                s.inputNode = InputNode.add(doc, s.key.createInputNodeKey(), s.input);
                s.inputNode.isBlocked = s.input.isBlocked;
                s.inputNode.setSynapse(doc, new InputNode.SynapseKey(s.key.relativeRid, neuron), s);
            }
            if (s.key.isRecurrent) {
                neuron.maxRecurrentSum += Math.abs(s.w);
            }
            s.input.lock.releaseWriteLock();
        }
        TreeSet<RSKey> queue = new TreeSet<RSKey>(new Comparator<RSKey>(){

            @Override
            public int compare(RSKey rsk1, RSKey rsk2) {
                if (rsk1.pa == null && rsk2.pa != null) {
                    return -1;
                }
                if (rsk1.pa != null && rsk2.pa == null) {
                    return 1;
                }
                if (rsk1.pa == null && rsk2.pa == null) {
                    return 0;
                }
                int r = Integer.compare(rsk2.pa.level, rsk1.pa.level) * dir;
                if (r != 0) {
                    return r;
                }
                r = rsk1.pa.compareTo(rsk2.pa);
                if (r != 0) {
                    return r;
                }
                return Utils.compareInteger(rsk1.offset, rsk2.offset);
            }
        });
        if (queue.isEmpty()) {
            queue.add(new RSKey(null, null));
        }
        ArrayList<RSKey> outputs = new ArrayList<RSKey>();
        ArrayList<RSKey> cleanup = new ArrayList<RSKey>();
        while (!queue.isEmpty()) {
            RSKey rsk = queue.pollFirst();
            Node n = rsk.pa;
            if (dir == -1) {
                Node.computeRefinements(doc, queue, neuron, rsk, v, outputs, cleanup);
                continue;
            }
            if (!(n instanceof AndNode)) continue;
            AndNode an = (AndNode)n;
            for (Map.Entry<AndNode.Refinement, Node> me : an.parents.entrySet()) {
                Node pn = me.getValue();
                RSKey prsk = new RSKey(pn, me.getKey().getOffset());
                switch (Node.evaluate(neuron, prsk)) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        outputs.add(prsk);
                        break;
                    }
                    case 1: {
                        RidVisited nv = pn.getThreadState(doc, true).lookupVisited(rsk.offset);
                        if (nv.adjust == v) break;
                        nv.adjust = v;
                        queue.add(prsk);
                    }
                }
            }
            cleanup.add(rsk);
        }
        if (outputs.isEmpty()) {
            return false;
        }
        outputNode.lock.acquireWriteLock(doc.threadId);
        outputNode.removeAllInputs(doc);
        for (RSKey rsk : outputs) {
            rsk.pa.lock.acquireWriteLock(doc.threadId);
            outputNode.addInput(doc, rsk.offset, rsk.pa);
            rsk.pa.lock.releaseWriteLock();
        }
        outputNode.lock.releaseWriteLock();
        for (RSKey on : cleanup) {
            on.pa.cleanup(doc);
        }
        return true;
    }

    public static void computeRefinements(Document doc, TreeSet<RSKey> queue, Neuron n, RSKey rsk, long v, List<RSKey> outputs, List<RSKey> cleanup) {
        n.lock.acquireWriteLock(doc.threadId);
        Synapse minSyn = null;
        double sum = 0.0;
        if (rsk.pa != null) {
            Node node;
            if (rsk.pa instanceof InputNode) {
                node = (InputNode)rsk.pa;
                minSyn = ((InputNode)node).getSynapse(new InputNode.SynapseKey(rsk.offset, n));
                sum = Math.abs(minSyn.w);
            } else {
                node = (AndNode)rsk.pa;
                for (AndNode.Refinement ref : ((AndNode)node).parents.keySet()) {
                    Synapse s = ref.getSynapse(rsk.offset, n);
                    if (minSyn == null || Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP.compare(minSyn, s) > 0) {
                        minSyn = s;
                    }
                    sum += Math.abs(s.w);
                }
            }
        }
        for (Synapse synapse : minSyn != null ? n.inputSynapsesByWeight.headSet(minSyn, false) : n.inputSynapsesByWeight) {
            InputNode nln;
            if (!(n.bias - (n.negDirSum + n.negRecSum) + n.posRecSum + sum + Math.abs(synapse.w) + synapse.maxLowerWeightsSum > 0.0) || synapse.key.isNeg || synapse.key.isRecurrent || (nln = rsk.pa == null ? synapse.inputNode : AndNode.createNextLevelNode(doc, rsk.pa, new AndNode.Refinement(synapse.key.relativeRid, rsk.offset, synapse.inputNode), false)) == null) continue;
            nln.prepareResultsForPredefinedNodes(doc, queue, v, outputs, cleanup, n, synapse, Utils.nullSafeMin(synapse.key.relativeRid, rsk.offset));
        }
        n.lock.releaseWriteLock();
    }

    protected void prepareResultsForPredefinedNodes(Document doc, TreeSet<RSKey> queue, long v, List<RSKey> outputs, List<RSKey> cleanup, Neuron n, Synapse s, Integer offset) {
        RSKey rs = new RSKey(this, offset);
        RidVisited nv = this.getThreadState(doc, true).lookupVisited(offset);
        if (this.computeSynapseWeightSum(offset, n) + n.posRecSum - (n.negDirSum + n.negRecSum) > 0.0 || !this.isExpandable(false) || Math.abs(s.w) / -n.bias < 0.1) {
            if (nv.outputNode != v) {
                nv.outputNode = v;
                if (this.isCovered(doc, offset, v)) {
                    cleanup.add(rs);
                } else {
                    outputs.add(rs);
                }
            }
        } else if (nv.adjust != v) {
            nv.adjust = v;
            queue.add(rs);
        }
    }

    public boolean isCovered(Document doc, Integer offset, long v) {
        return false;
    }

    public boolean isRequired() {
        return this.numberOfNeuronRefs > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toSimpleString());
        sb.append(" - ");
        sb.append(this.logicToString());
        sb.append(" - ");
        sb.append(this.weightsToString());
        return sb.toString();
    }

    public String toSimpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        if (this.neuron != null && this.neuron.label != null) {
            sb.append(" ");
            sb.append(this.neuron.label);
        }
        return sb.toString();
    }

    public String weightsToString() {
        return "";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.level);
        out.writeBoolean(this.passive);
        out.writeInt(this.frequency);
        out.writeDouble(this.nullHypFreq);
        out.writeDouble(this.oldNullHypFreq);
        out.writeBoolean(this.isBlocked);
        out.writeBoolean(this.endRequired);
        out.writeBoolean(this.ridRequired);
        out.writeInt(this.numberOfNeuronRefs);
        out.writeBoolean(this.frequencyHasChanged);
        out.writeInt(this.nOffset);
        out.writeInt(this.sizeSum);
        out.writeInt(this.instanceSum);
    }

    @Override
    public void readFields(DataInput in, Document doc) throws IOException {
        this.id = in.readInt();
        this.level = in.readInt();
        this.passive = in.readBoolean();
        this.frequency = in.readInt();
        this.nullHypFreq = in.readDouble();
        this.oldNullHypFreq = in.readDouble();
        this.isBlocked = in.readBoolean();
        this.endRequired = in.readBoolean();
        this.ridRequired = in.readBoolean();
        this.numberOfNeuronRefs = in.readInt();
        this.frequencyHasChanged = in.readBoolean();
        this.nOffset = in.readInt();
        this.sizeSum = in.readInt();
        this.instanceSum = in.readInt();
        this.threads = new ThreadState[doc.m.numberOfThreads];
    }

    public static Node read(DataInput in, Document doc) throws IOException {
        String type = in.readUTF();
        Node n = null;
        switch (type) {
            case "I": {
                n = new InputNode();
                break;
            }
            case "A": {
                n = new AndNode();
                break;
            }
            case "O": {
                n = new OrNode();
            }
        }
        ((Node)n).readFields(in, doc);
        return n;
    }

    @Override
    public int compareTo(Node n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }

    public static int compare(Node a, Node b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static class ReverseAndRefinement
    implements Comparable<ReverseAndRefinement> {
        boolean dir;
        Node node;

        public ReverseAndRefinement(Node n, Integer a, Integer b) {
            this.node = n;
            this.dir = Utils.compareNullSafe(a, b);
        }

        @Override
        public int compareTo(ReverseAndRefinement rar) {
            int r = this.node.compareTo(rar.node);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.dir, rar.dir);
        }
    }

    public static class Similarity {
        public volatile int frequency;
        public int neuronFreqOffset;
        public int nodeFreqOffset;
    }

    private static class DummyNode
    extends InputNode {
        public DummyNode(int id) {
            this.id = id;
        }

        @Override
        public boolean isAllowedOption(Document doc, InterprNode n, Activation act, long v) {
            return false;
        }

        @Override
        public void cleanup(Document doc) {
        }

        @Override
        public void initActivation(Document doc, Activation act) {
        }

        @Override
        public void deleteActivation(Document doc, Activation act) {
        }

        @Override
        public double computeSynapseWeightSum(Integer offset, Neuron n) {
            return n.bias;
        }

        @Override
        public void propagateAddedActivation(Document doc, Activation act, InterprNode removedConflict) {
        }

        @Override
        public void propagateRemovedActivation(Document doc, Activation act) {
        }

        @Override
        public String logicToString() {
            return null;
        }

        @Override
        public void apply(Document doc, Activation act, InterprNode conflict) {
        }

        @Override
        public void discover(Document doc, Activation act) {
        }

        protected Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
            return null;
        }

        @Override
        protected void changeNumberOfNeuronRefs(Document doc, long v, int d) {
        }
    }

    private static class RemovedEntry {
        Activation act;
        Set<Activation> iActs = new TreeSet<Activation>();

        private RemovedEntry() {
        }
    }

    public static class RSKey
    implements Comparable<RSKey> {
        Node pa;
        Integer offset;

        public RSKey(Node pa, Integer offset) {
            this.pa = pa;
            this.offset = offset;
        }

        public String toString() {
            return "Offset:" + this.offset + " PA:" + this.pa.logicToString();
        }

        @Override
        public int compareTo(RSKey rs) {
            int r = this.pa.compareTo(rs.pa);
            if (r != 0) {
                return r;
            }
            return Utils.compareInteger(this.offset, rs.offset);
        }
    }

    public static class RidVisited {
        public long computeParents = -1L;
        public long outputNode = -1L;
        public long adjust = -1L;
    }

    public static class ThreadState {
        public long lastUsed;
        public TreeMap<Activation.Key, Activation> activations;
        public TreeMap<Activation.Key, Activation> activationsEnd;
        public TreeMap<Activation.Key, Activation> activationsRid;
        public NavigableMap<Activation.Key, Collection<Activation>> added;
        public NavigableMap<Activation.Key, RemovedEntry> removed;
        protected long visitedNeuronRefsChange = -1L;
        public long visitedAllowedOption = -1L;
        public long visitedComputeWeight = -1L;
        private RidVisited nullRidVisited;
        private RidVisited[] ridVisited = new RidVisited[2 * MAX_RID];

        public ThreadState(boolean endRequired, boolean ridRequired) {
            this.activations = new TreeMap(BEGIN_COMP);
            this.activationsEnd = endRequired ? new TreeMap(END_COMP) : null;
            this.activationsRid = ridRequired ? new TreeMap(RID_COMP) : null;
            this.added = new TreeMap<Activation.Key, Collection<Activation>>();
            this.removed = new TreeMap<Activation.Key, RemovedEntry>();
        }

        public RidVisited lookupVisited(Integer offset) {
            if (offset == null) {
                if (this.nullRidVisited == null) {
                    this.nullRidVisited = new RidVisited();
                }
                return this.nullRidVisited;
            }
            RidVisited v = this.ridVisited[offset + MAX_RID];
            if (v == null) {
                this.ridVisited[offset.intValue() + Node.MAX_RID] = v = new RidVisited();
            }
            return v;
        }
    }
}

