/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.aika.Activation;
import org.aika.Model;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;

public class OrNode
extends Node {
    public TreeMap<Integer, TreeSet<Node>> parents = new TreeMap();

    public OrNode() {
    }

    public OrNode(Document doc) {
        super(doc, -1);
        Model m = doc.m;
        ++m.stat.nodes;
        ++m.stat.orNodes;
        this.endRequired = true;
        this.ridRequired = true;
    }

    @Override
    public void computeNullHyp(Model m) {
    }

    @Override
    public boolean isExpandable(boolean checkFrequency) {
        return false;
    }

    @Override
    public boolean isAllowedOption(Document doc, InterprNode n, Activation act, long v) {
        return false;
    }

    @Override
    public void initActivation(Document doc, Activation act) {
        Node.ThreadState th = this.getThreadState(doc, false);
        if (th == null || th.activations.isEmpty()) {
            doc.activatedNeurons.add(this.neuron);
        }
    }

    @Override
    public void deleteActivation(Document doc, Activation act) {
        Node.ThreadState th = this.getThreadState(doc, false);
        if (th == null || th.activations.isEmpty()) {
            doc.activatedNeurons.remove(this.neuron);
        }
    }

    private void retrieveInputs(Document doc, Range inputR, Integer rid, List<Activation> inputs, Integer pRidOffset, TreeSet<Node> parents) {
        if (parents.size() > 10) {
            this.retrieveInputs(doc, null, inputR, rid, inputs, pRidOffset, parents);
        } else {
            for (Node pn : parents) {
                this.retrieveInputs(doc, pn, inputR, rid, inputs, pRidOffset, parents);
            }
        }
    }

    private void retrieveInputs(Document doc, Node n, Range inputR, Integer rid, List<Activation> inputs, Integer pRidOffset, TreeSet<Node> parents) {
        for (Activation iAct : Activation.select(doc, n, Utils.nullSafeAdd(rid, true, pRidOffset, false), inputR, Range.Operator.EQUALS, Range.Operator.EQUALS, null, null).collect(Collectors.toList())) {
            if (iAct.isRemoved || !parents.contains(iAct.key.n) || this.checkSelfReferencing(doc, iAct)) continue;
            inputs.add(iAct);
        }
    }

    public void addActivation(Document doc, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(doc, inputAct)) {
            return;
        }
        Activation.Key ak = inputAct.key;
        Range r = ak.r;
        Integer rid = Utils.nullSafeSub(ak.rid, true, ridOffset, false);
        ArrayList<Activation> inputs = new ArrayList<Activation>();
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            this.retrieveInputs(doc, r, rid, inputs, me.getKey() != Integer.MIN_VALUE ? (Integer)me.getKey() : null, (TreeSet)me.getValue());
        }
        if (inputs.isEmpty()) {
            return;
        }
        InterprNode no = this.lookupOrOption(doc, r, true);
        for (Activation iAct : inputs) {
            no.addOrOption(iAct, iAct.key.o);
        }
        Activation.Key nak = new Activation.Key(this, r, rid, no);
        OrNode.addActivationAndPropagate(doc, nak, inputs);
    }

    public void removeActivation(Document doc, Integer ridOffset, Activation inputAct) {
        if (this.checkSelfReferencing(doc, inputAct)) {
            return;
        }
        for (Activation oAct : inputAct.outputs.values()) {
            if (oAct.key.n != this || oAct.isRemoved || oAct.inputs.size() > 1) continue;
            OrNode.removeActivationAndPropagate(doc, oAct, oAct.inputs.values());
        }
    }

    private boolean checkSelfReferencing(Document doc, Activation inputAct) {
        InterprNode o = this.lookupOrOption(doc, inputAct.key.r, false);
        if (o == null) {
            return false;
        }
        return inputAct.key.o.contains(o, true);
    }

    @Override
    public void propagateAddedActivation(Document doc, Activation act, InterprNode removedConflict) {
        if (removedConflict == null) {
            this.neuron.propagateAddedActivation(doc, act);
        }
    }

    @Override
    public void propagateRemovedActivation(Document doc, Activation act) {
        this.neuron.propagateRemovedActivation(doc, act);
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, Neuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup(Document doc) {
    }

    @Override
    protected boolean hasSupport(Activation act) {
        for (Activation iAct : act.inputs.values()) {
            if (iAct.isRemoved) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(Document doc, Activation act, InterprNode conflict) {
        if (conflict == null) {
            OrNode.processCandidate(doc, this, act, false);
        }
    }

    @Override
    public void discover(Document doc, Activation act) {
    }

    public static void processCandidate(Document doc, Node parentNode, Activation inputAct, boolean train) {
        Activation.Key ak = inputAct.key;
        parentNode.lock.acquireReadLock();
        if (parentNode.orChildren != null) {
            for (OrEntry oe : parentNode.orChildren) {
                if (ak.o.isConflicting(InterprNode.visitedCounter++)) continue;
                ((OrNode)oe.node).addActivation(doc, oe.ridOffset, inputAct);
            }
        }
        parentNode.lock.releaseReadLock();
    }

    public InterprNode lookupOrOption(Document doc, Range r, boolean create) {
        Activation act = Activation.select(doc, this, null, r, Range.Operator.EQUALS, Range.Operator.EQUALS, null, null).findFirst().orElse(null);
        if (act != null) {
            return act.key.o;
        }
        Node.ThreadState th = this.getThreadState(doc, false);
        if (th != null) {
            for (Activation.Key ak : th.added.keySet()) {
                if (Range.compare(ak.r, r) != 0) continue;
                return ak.o;
            }
        }
        return create ? InterprNode.addPrimitive(doc) : null;
    }

    protected Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void changeNumberOfNeuronRefs(Document doc, long v, int d) {
        throw new UnsupportedOperationException();
    }

    public void addInput(Document doc, Integer ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(doc, Node.visitedCounter++, 1);
        in.addOrChild(doc, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(doc.threadId);
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeSet<Node> pn = this.parents.get(key);
        if (pn == null) {
            pn = new TreeSet();
            this.parents.put(key, pn);
        }
        pn.add(in);
        this.lock.releaseWriteLock();
    }

    public void removeInput(Document doc, Integer ridOffset, Node in) {
        in.changeNumberOfNeuronRefs(doc, Node.visitedCounter++, -1);
        in.removeOrChild(doc, new OrEntry(ridOffset, this));
        this.lock.acquireWriteLock(doc.threadId);
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeSet<Node> pn = this.parents.get(key);
        if (pn != null) {
            pn.remove(in);
            if (pn.isEmpty() && ridOffset != null) {
                this.parents.remove(key);
            }
        }
        this.lock.releaseWriteLock();
    }

    public void removeAllInputs(Document doc) {
        this.lock.acquireWriteLock(doc.threadId);
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                pn.changeNumberOfNeuronRefs(doc, Node.visitedCounter++, -1);
                pn.removeOrChild(doc, new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this));
            }
        }
        this.parents.clear();
        this.lock.releaseWriteLock();
    }

    @Override
    public void remove(Document doc) {
        super.remove(doc);
        this.lock.acquireReadLock();
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                pn.removeOrChild(doc, new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this));
            }
        }
        this.lock.releaseReadLock();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        block0: for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            for (Node pn : me.getValue()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(me.getKey() != Integer.MIN_VALUE ? me.getKey() : "X");
                sb.append(":");
                sb.append(pn.logicToString());
                if (i > 10) {
                    sb.append(",...");
                    continue block0;
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF("O");
        super.write(out);
        out.writeInt(this.parents.size());
        for (Map.Entry<Integer, TreeSet<Node>> me : this.parents.entrySet()) {
            out.writeInt(me.getKey());
            out.writeInt(me.getValue().size());
            for (Node pn : me.getValue()) {
                out.writeInt(pn.id);
            }
        }
    }

    @Override
    public void readFields(DataInput in, Document doc) throws IOException {
        super.readFields(in, doc);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            TreeSet<Node> ridParents = new TreeSet<Node>();
            Integer ridOffset = in.readInt();
            this.parents.put(ridOffset, ridParents);
            int sa = in.readInt();
            for (int j = 0; j < sa; ++j) {
                Node pn = doc.m.initialNodes.get(in.readInt());
                pn.addOrChild(doc, new OrEntry(ridOffset, this));
                ridParents.add(pn);
            }
        }
    }

    public static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public Integer ridOffset;
        public Node node;

        private OrEntry() {
        }

        public OrEntry(Integer ridOffset, Node node) {
            this.ridOffset = ridOffset;
            this.node = node;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ridOffset != null);
            if (this.ridOffset != null) {
                out.writeInt(this.ridOffset);
            }
            out.writeInt(this.node.id);
        }

        @Override
        public void readFields(DataInput in, Document doc) throws IOException {
            if (in.readBoolean()) {
                this.ridOffset = in.readInt();
            }
            this.node = doc.m.initialNodes.get(in.readInt());
        }

        public static OrEntry read(DataInput in, Document doc) throws IOException {
            OrEntry n = new OrEntry();
            n.readFields(in, doc);
            return n;
        }

        @Override
        public int compareTo(OrEntry on) {
            int r = Utils.compareInteger(this.ridOffset, on.ridOffset);
            if (r != 0) {
                return r;
            }
            return this.node.compareTo(on.node);
        }
    }
}

