/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.util.Collections;
import org.aika.Activation;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;

public class InputNeuron
extends Neuron {
    public InputNeuron() {
    }

    public InputNeuron(String label) {
        this.label = label;
    }

    public InputNeuron(String label, boolean isBlocked) {
        super(label, isBlocked, true);
    }

    public static InputNeuron create(Document doc, InputNeuron n) {
        n.m = doc.m;
        InputNode node = InputNode.add(doc, new Synapse.Key(false, false, null, 0, Range.Operator.NONE, Range.Mapping.NONE, true, Range.Operator.NONE, Range.Mapping.NONE, true), null);
        node.neuron = n;
        n.node = node;
        n.publish(doc);
        n.initialized = true;
        return n;
    }

    @Override
    public void remove(Document doc) {
        this.unpublish(doc);
    }

    @Override
    public void propagateAddedActivation(Document doc, Activation act) {
        Activation.State s = new Activation.State(1.0, 0, Neuron.NormWeight.ZERO_WEIGHT);
        act.rounds.set(0, s);
        act.finalState = s;
        act.upperBound = 1.0;
        act.lowerBound = 1.0;
        for (InputNode out : this.outputNodes.values()) {
            out.addActivation(doc, act);
        }
    }

    public void addInput(Document doc, int begin, int end) {
        this.addInput(doc, begin, end, null, doc.bottom);
    }

    public void addInput(Document doc, int begin, int end, InterprNode o) {
        this.addInput(doc, begin, end, null, o);
    }

    public void addInput(Document doc, int begin, int end, Integer rid) {
        this.addInput(doc, begin, end, rid, doc.bottom);
    }

    public void addInput(Document doc, int begin, int end, Integer rid, InterprNode o) {
        Node.addActivationAndPropagate(doc, new Activation.Key(this.node, new Range(begin, end), rid, o), Collections.emptySet());
        doc.propagate();
    }

    public void addInput(Document doc, int begin, int end, Integer rid, InterprNode o, double value) {
        Range r = new Range(begin, end);
        Node.addActivationAndPropagate(doc, new Activation.Key(this.node, r, rid, o), Collections.emptySet());
        doc.propagate();
        Activation act = Activation.get(doc, this.node, rid, r, Range.Operator.EQUALS, Range.Operator.EQUALS, o, InterprNode.Relation.EQUALS);
        Activation.State s = new Activation.State(value, 0, Neuron.NormWeight.ZERO_WEIGHT);
        act.rounds.set(0, s);
        act.finalState = s;
    }

    public void removeInput(Document doc, int begin, int end) {
        this.removeInput(doc, begin, end, null, doc.bottom);
    }

    public void removeInput(Document doc, int begin, int end, InterprNode o) {
        this.removeInput(doc, begin, end, null, o);
    }

    public void removeInput(Document doc, int begin, int end, Integer rid) {
        this.removeInput(doc, begin, end, rid, doc.bottom);
    }

    public void removeInput(Document doc, int begin, int end, Integer rid, InterprNode o) {
        Range r = new Range(begin, end);
        Activation act = Activation.get(doc, this.node, rid, r, Range.Operator.EQUALS, Range.Operator.EQUALS, o, InterprNode.Relation.EQUALS);
        Node.removeActivationAndPropagate(doc, act, Collections.emptySet());
        doc.propagate();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("in(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }
}

