/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.neuron.Neuron;

public class Synapse
implements Writable {
    public static final Comparator<Synapse> INPUT_SYNAPSE_BY_WEIGHTS_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = Synapse.compareWeights(s1.w, s2.w, 1.0E-5);
            if (r != 0) {
                return r;
            }
            r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.output.compareTo(s2.output);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public Neuron input;
    public Neuron output;
    public InputNode inputNode;
    public Key key;
    public double w;
    public double maxLowerWeightsSum = Double.MAX_VALUE;

    public Synapse() {
    }

    public Synapse(Neuron input) {
        this.input = input;
    }

    public Synapse(Neuron input, Key key) {
        this.input = input;
        this.key = key;
        assert (this.w >= 0.0 && !key.isNeg || this.w <= 0.0 && key.isNeg);
    }

    public void link(Document doc) {
        boolean dir = this.input.id < this.output.id;
        (dir ? this.input : this.output).lock.acquireWriteLock(doc.threadId);
        (dir ? this.output : this.input).lock.acquireWriteLock(doc.threadId);
        this.input.outputSynapses.add(this);
        this.output.inputSynapses.add(this);
        this.output.inputSynapsesByWeight.add(this);
        (dir ? this.input : this.output).lock.releaseWriteLock();
        (dir ? this.output : this.input).lock.releaseWriteLock();
        if (this.output.m != null) {
            ++this.output.m.stat.synapses;
        }
    }

    public static int compareWeights(Double a, Double b, double tolerance) {
        double bAbs;
        double aAbs = Math.abs(a);
        if (aAbs + tolerance < (bAbs = Math.abs(b))) {
            return -1;
        }
        if (aAbs > bAbs + tolerance) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "S " + this.w + " " + this.key.relativeRid + " S:" + (Object)((Object)this.key.startRangeMapping) + " E:" + (Object)((Object)this.key.endRangeMapping) + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.inputNode.id);
        this.key.write(out);
        out.writeDouble(this.w);
        out.writeDouble(this.maxLowerWeightsSum);
    }

    @Override
    public void readFields(DataInput in, Document doc) throws IOException {
        this.input = doc.m.neurons.get(in.readInt());
        this.output = doc.m.neurons.get(in.readInt());
        this.inputNode = (InputNode)doc.m.initialNodes.get(in.readInt());
        this.key = Key.read(in, doc);
        this.w = in.readDouble();
        this.maxLowerWeightsSum = in.readDouble();
        this.input.outputSynapses.add(this);
        this.inputNode.setSynapse(doc, new InputNode.SynapseKey(this.key.relativeRid, this.output), this);
    }

    public static Synapse read(DataInput in, Document doc) throws IOException {
        Synapse k = new Synapse();
        k.readFields(in, doc);
        return k;
    }

    public static class Key
    implements Comparable<Key>,
    Writable {
        public static final Key MIN_KEY = new Key();
        public static final Key MAX_KEY = new Key();
        public boolean isNeg;
        public boolean isRecurrent;
        public Integer relativeRid;
        public Integer absoluteRid;
        public Range.Operator startRangeMatch;
        public Range.Operator endRangeMatch;
        public Range.Mapping startRangeMapping;
        public Range.Mapping endRangeMapping;
        public boolean startRangeOutput;
        public boolean endRangeOutput;

        public Key() {
        }

        public Key(boolean isNeg, boolean isRecurrent, Integer relativeRid, Integer absoluteRid, Range.Operator startRangeMatch, Range.Mapping startRangeMapping, boolean startRangeOutput, Range.Operator endRangeMatch, Range.Mapping endRangeMapping, boolean endRangeOutput) {
            this.isNeg = isNeg;
            this.isRecurrent = isRecurrent;
            this.relativeRid = relativeRid;
            this.absoluteRid = absoluteRid;
            this.startRangeMatch = startRangeMatch;
            this.endRangeMatch = endRangeMatch;
            this.startRangeMapping = startRangeMapping;
            this.endRangeMapping = endRangeMapping;
            this.startRangeOutput = startRangeOutput;
            this.endRangeOutput = endRangeOutput;
        }

        public Key createInputNodeKey() {
            return this.relativeRid != null ? new Key(this.isNeg, this.isRecurrent, 0, this.absoluteRid, this.startRangeMatch, this.startRangeMapping, this.startRangeOutput, this.endRangeMatch, this.endRangeMapping, this.endRangeOutput) : this;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isNeg);
            out.writeBoolean(this.isRecurrent);
            out.writeBoolean(this.relativeRid != null);
            if (this.relativeRid != null) {
                out.writeInt(this.relativeRid);
            }
            out.writeBoolean(this.absoluteRid != null);
            if (this.absoluteRid != null) {
                out.writeInt(this.absoluteRid);
            }
            out.writeUTF(this.startRangeMatch.name());
            out.writeUTF(this.endRangeMatch.name());
            out.writeUTF(this.startRangeMapping.name());
            out.writeUTF(this.endRangeMapping.name());
            out.writeBoolean(this.startRangeOutput);
            out.writeBoolean(this.endRangeOutput);
        }

        @Override
        public void readFields(DataInput in, Document doc) throws IOException {
            this.isNeg = in.readBoolean();
            this.isRecurrent = in.readBoolean();
            if (in.readBoolean()) {
                this.relativeRid = in.readInt();
            }
            if (in.readBoolean()) {
                this.absoluteRid = in.readInt();
            }
            this.startRangeMatch = Range.Operator.valueOf(in.readUTF());
            this.endRangeMatch = Range.Operator.valueOf(in.readUTF());
            this.startRangeMapping = Range.Mapping.valueOf(in.readUTF());
            this.endRangeMapping = Range.Mapping.valueOf(in.readUTF());
            this.startRangeOutput = in.readBoolean();
            this.endRangeOutput = in.readBoolean();
        }

        public static Key read(DataInput in, Document doc) throws IOException {
            Key k = new Key();
            k.readFields(in, doc);
            return k;
        }

        @Override
        public int compareTo(Key k) {
            if (this == MIN_KEY && k != MIN_KEY) {
                return -1;
            }
            if (this != MIN_KEY && k == MIN_KEY) {
                return 1;
            }
            if (this == MAX_KEY && k != MAX_KEY) {
                return 1;
            }
            if (this != MAX_KEY && k == MAX_KEY) {
                return -1;
            }
            int r = Boolean.compare(this.isNeg, k.isNeg);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.isRecurrent, k.isRecurrent);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, k.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, k.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = this.startRangeMatch.compareTo(k.startRangeMatch);
            if (r != 0) {
                return r;
            }
            r = this.endRangeMatch.compareTo(k.endRangeMatch);
            if (r != 0) {
                return r;
            }
            r = this.startRangeMapping.compareTo(k.startRangeMapping);
            if (r != 0) {
                return r;
            }
            r = this.endRangeMapping.compareTo(k.endRangeMapping);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.startRangeOutput, k.startRangeOutput);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.endRangeOutput, k.endRangeOutput);
        }
    }
}

