/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = 100000;
    public int id;
    public SearchNode excludedParent;
    public SearchNode selectedParent;
    public int visited;
    List<InterprNode> refinement;
    RefMarker marker;
    INeuron.NormWeight[] weightDelta = new INeuron.NormWeight[]{INeuron.NormWeight.ZERO_WEIGHT, INeuron.NormWeight.ZERO_WEIGHT};
    INeuron.NormWeight[] accumulatedWeight = new INeuron.NormWeight[2];
    public List<StateChange> modifiedActs = new ArrayList<StateChange>();
    public TreeSet<SearchNode> candidates = new TreeSet();

    private SearchNode(Document doc, List<InterprNode> changed, SearchNode selParent, SearchNode exclParent, List<InterprNode> ref, RefMarker m) {
        this.id = doc.searchNodeIdCounter++;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        this.refinement = this.expandRefinement(ref, doc.visitedCounter++);
        this.markSelected(changed, this.refinement);
        this.markExcluded(changed, this.refinement);
        this.marker = m;
        this.weightDelta = doc.vQueue.adjustWeight(this, changed);
        if (this.selectedParent != null) {
            for (int i = 0; i < 2; ++i) {
                this.accumulatedWeight[i] = this.weightDelta[i].add(this.selectedParent.accumulatedWeight[i]);
            }
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id + "  Candidate Weight Delta: " + this.weightDelta);
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
        this.changeState(StateChange.Mode.OLD);
    }

    private void collectResults(Collection<InterprNode> results) {
        results.addAll(this.refinement);
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    public static SearchNode createRootSearchNode(Document doc) {
        ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
        changed.add(doc.bottom);
        return new SearchNode(doc, changed, null, null, Arrays.asList(doc.bottom), null);
    }

    public void computeBestInterpretation(Document doc) {
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        results.add(doc.bottom);
        doc.selectedSearchNode = null;
        int[] searchSteps = new int[1];
        List<InterprNode> rootRefs = SearchNode.expandRootRefinement(doc);
        this.refinement = this.expandRefinement(rootRefs, doc.visitedCounter++);
        this.markCandidatesRecursiveStep(doc.bottom, true);
        this.markSelected(null, this.refinement);
        this.markExcluded(null, this.refinement);
        this.weightDelta = doc.vQueue.adjustWeight(this, rootRefs);
        this.accumulatedWeight = this.weightDelta;
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Root SearchNode:" + this.toString());
        }
        doc.bottom.storeFinalWeight(doc.visitedCounter++);
        this.generateInitialCandidates(doc);
        SearchNode child = this.selectCandidate();
        if (child != null) {
            child.search(doc, this, null, searchSteps);
        }
        if (doc.selectedSearchNode != null) {
            doc.selectedSearchNode.reconstructSelectedResult(doc);
            doc.selectedSearchNode.collectResults(results);
        }
        doc.bestInterpretation = results;
        if (doc.interrupted) {
            log.warn("The search for the best interpretation has been interrupted. Too many search steps!");
        }
    }

    private void reconstructSelectedResult(Document doc) {
        if (this.selectedParent != null) {
            this.selectedParent.reconstructSelectedResult(doc);
        }
        this.changeState(StateChange.Mode.NEW);
        for (StateChange sc : this.modifiedActs) {
            Activation act = sc.act;
            if (act.finalState == null || !(act.finalState.value > 0.0)) continue;
            doc.finallyActivatedNeurons.add((INeuron)((OrNode)act.key.n).neuron.get());
        }
    }

    private double search(Document doc, SearchNode selectedParent, SearchNode excludedParent, int[] searchSteps) {
        SearchNode child;
        double selectedWeight = 0.0;
        double excludedWeight = 0.0;
        if (searchSteps[0] > MAX_SEARCH_STEPS) {
            doc.interrupted = true;
        }
        searchSteps[0] = searchSteps[0] + 1;
        this.markCandidates(selectedParent.candidates);
        this.markSelected(null, this.refinement);
        this.markExcluded(null, this.refinement);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id);
            log.info(this.toString());
        }
        this.changeState(StateChange.Mode.NEW);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
        this.generateNextLevelCandidates(doc, selectedParent, excludedParent);
        if (this.candidates.size() == 0) {
            double selectedAccNW;
            SearchNode en = this;
            while (en != null) {
                if (en.marker != null && !en.marker.complete) {
                    en.marker.complete = !this.hasUnsatisfiedPositiveFeedbackLink(en.refinement);
                }
                en = en.selectedParent;
            }
            double accNW = this.accumulatedWeight[0].getNormWeight();
            double d = selectedAccNW = doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight[0].getNormWeight() : 0.0;
            if (accNW > selectedAccNW) {
                doc.selectedSearchNode = this;
                doc.bottom.storeFinalWeight(doc.visitedCounter++);
            }
        } else {
            child = this.selectCandidate();
            if (!(child == null || this.marker.excluded && this.marker.complete)) {
                selectedWeight = child.search(doc, this, excludedParent, searchSteps);
            }
        }
        this.changeState(StateChange.Mode.OLD);
        if (doc.interrupted) {
            return 0.0;
        }
        while ((child = selectedParent.selectCandidate()) != null && this.marker.selected && child.marker.complete) {
        }
        if (child != null) {
            excludedWeight = child.search(doc, selectedParent, this, searchSteps);
        }
        if (selectedWeight >= excludedWeight) {
            this.marker.selected = true;
            return selectedWeight;
        }
        this.marker.excluded = true;
        return excludedWeight;
    }

    private boolean hasUnsatisfiedPositiveFeedbackLink(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (!this.hasUnsatisfiedPositiveFeedbackLink(x)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsatisfiedPositiveFeedbackLink(InterprNode n) {
        if (n.hasUnsatisfiedPosFeedbackLinksCache != null) {
            return n.hasUnsatisfiedPosFeedbackLinksCache;
        }
        for (Activation act : n.getNeuronActivations()) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                if (!sa.s.key.isRecurrent || !((double)sa.s.w > 0.0) || this.isCovered(sa.output.key.o.markedSelected)) continue;
                n.hasUnsatisfiedPosFeedbackLinksCache = true;
                return true;
            }
        }
        for (InterprNode pn : n.parents) {
            if (!this.hasUnsatisfiedPositiveFeedbackLink(pn)) continue;
            n.hasUnsatisfiedPosFeedbackLinksCache = true;
            return true;
        }
        n.hasUnsatisfiedPosFeedbackLinksCache = false;
        return false;
    }

    private SearchNode selectCandidate() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.pollFirst();
    }

    public void generateInitialCandidates(Document doc) {
        this.candidates = new TreeSet();
        for (InterprNode cn : SearchNode.collectConflicts(doc)) {
            ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
            this.candidates.add(new SearchNode(doc, changed, this, null, Arrays.asList(cn), new RefMarker()));
        }
    }

    public void generateNextLevelCandidates(Document doc, SearchNode selectedParent, SearchNode excludedParent) {
        this.candidates = new TreeSet();
        for (SearchNode pc : selectedParent.candidates) {
            if (this.checkSelected(pc.refinement) || this.checkExcluded(pc.refinement, doc.visitedCounter++)) continue;
            ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
            SearchNode c = new SearchNode(doc, changed, this, excludedParent, pc.refinement, pc.marker);
            if (doc.selectedSearchNode != null && !(doc.selectedSearchNode.accumulatedWeight[0].getNormWeight() < c.accumulatedWeight[1].getNormWeight())) continue;
            this.candidates.add(c);
        }
    }

    private boolean checkSelected(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (this.isCovered(x.markedSelected)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExcluded(List<InterprNode> n, int v) {
        for (InterprNode x : n) {
            if (!this.checkExcluded(x, v)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExcluded(InterprNode ref, int v) {
        if (ref.visitedCheckExcluded == v) {
            return false;
        }
        ref.visitedCheckExcluded = v;
        if (this.isCovered(ref.markedExcluded)) {
            return true;
        }
        for (InterprNode pn : ref.parents) {
            if (!this.checkExcluded(pn, v)) continue;
            return true;
        }
        return false;
    }

    public static List<InterprNode> collectConflicts(Document doc) {
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        int v = doc.visitedCounter++;
        for (InterprNode n : doc.bottom.children) {
            for (Conflicts.Conflict c : n.conflicts.primary.values()) {
                if (c.secondary.visitedCollectConflicts == v) continue;
                c.secondary.visitedCollectConflicts = v;
                results.add(c.secondary);
            }
        }
        return results;
    }

    private static List<InterprNode> expandRootRefinement(Document doc) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        tmp.add(doc.bottom);
        for (InterprNode pn : doc.bottom.children) {
            if (pn.orInterprNodes != null && !pn.orInterprNodes.isEmpty() || !pn.conflicts.primary.isEmpty() || !pn.conflicts.secondary.isEmpty()) continue;
            tmp.add(pn);
        }
        return tmp;
    }

    private List<InterprNode> expandRefinement(List<InterprNode> ref, int v) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        for (InterprNode n : ref) {
            this.markExpandRefinement(n, v);
            tmp.add(n);
        }
        for (InterprNode n : ref) {
            this.expandRefinementRecursiveStep(tmp, n, v);
        }
        if (ref.size() == tmp.size()) {
            return tmp;
        }
        return this.expandRefinement(tmp, v);
    }

    private void markExpandRefinement(InterprNode n, int v) {
        if (n.markedExpandRefinement == v) {
            return;
        }
        n.markedExpandRefinement = v;
        for (InterprNode pn : n.parents) {
            this.markExpandRefinement(pn, v);
        }
    }

    private boolean hasUncoveredConflicts(InterprNode n) {
        if (!n.conflicts.hasConflicts()) {
            return false;
        }
        ArrayList<InterprNode> conflicts = new ArrayList<InterprNode>();
        Conflicts.collectDirectConflicting(conflicts, n);
        for (InterprNode cn : conflicts) {
            if (this.isCovered(cn.markedExcluded)) continue;
            return true;
        }
        return false;
    }

    private void expandRefinementRecursiveStep(Collection<InterprNode> results, InterprNode n, int v) {
        if (n.visitedExpandRefinementRecursiveStep == v) {
            return;
        }
        n.visitedExpandRefinementRecursiveStep = v;
        if (n.refByOrInterprNode != null) {
            for (InterprNode on : n.refByOrInterprNode) {
                if (on.markedExpandRefinement == v || this.hasUncoveredConflicts(on) || this.isCovered(on.markedSelected)) continue;
                this.markExpandRefinement(on, v);
                results.add(on);
            }
        }
        for (InterprNode pn : n.parents) {
            if (pn.isBottom()) continue;
            this.expandRefinementRecursiveStep(results, pn, v);
        }
        if (n.isBottom()) {
            return;
        }
        for (InterprNode cn : n.children) {
            if (cn.visitedExpandRefinementRecursiveStep == v) break;
            boolean covered = true;
            for (InterprNode cnp : cn.parents) {
                if (cnp.visitedExpandRefinementRecursiveStep == v || this.isCovered(cnp.markedSelected)) continue;
                covered = false;
                break;
            }
            if (!covered) continue;
            this.expandRefinementRecursiveStep(results, cn, v);
        }
    }

    public Coverage getCoverage(InterprNode n) {
        if (this.isCovered(n.markedSelected)) {
            return Coverage.SELECTED;
        }
        if (this.selectedParent != null && n.markedHasCandidate != this.selectedParent.visited) {
            return Coverage.EXCLUDED;
        }
        if (this.isCovered(n.markedExcluded)) {
            return Coverage.EXCLUDED;
        }
        return Coverage.UNKNOWN;
    }

    public boolean isCovered(int g) {
        SearchNode n = this;
        do {
            if (g == n.visited) {
                return true;
            }
            if (g <= n.visited) continue;
            return false;
        } while ((n = n.selectedParent) != null);
        return false;
    }

    private void markSelected(List<InterprNode> changed, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markSelected(changed, x);
        }
    }

    private boolean markSelected(List<InterprNode> changed, InterprNode n) {
        if (this.isCovered(n.markedSelected)) {
            return false;
        }
        n.markedSelected = this.visited;
        if (n.isBottom()) {
            return false;
        }
        for (InterprNode p : n.parents) {
            if (!this.markSelected(changed, p)) continue;
            return true;
        }
        for (InterprNode c : n.children) {
            if (this.isCovered(n.markedSelected) || !this.containedInSelectedBranch(c)) continue;
            if (c.isConflicting(n.doc.visitedCounter++)) {
                return true;
            }
            if (!this.markSelected(changed, c)) continue;
            return true;
        }
        if (changed != null) {
            changed.add(n);
        }
        return false;
    }

    private void markExcluded(List<InterprNode> changed, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markExcluded(changed, x);
        }
    }

    private void markExcluded(List<InterprNode> changed, InterprNode n) {
        ArrayList<InterprNode> conflicting = new ArrayList<InterprNode>();
        Conflicts.collectAllConflicting(conflicting, n, n.doc.visitedCounter++);
        for (InterprNode cn : conflicting) {
            this.markExcludedRecursiveStep(changed, cn);
        }
    }

    private void markExcludedRecursiveStep(List<InterprNode> changed, InterprNode n) {
        if (this.isCovered(n.markedExcluded)) {
            return;
        }
        n.markedExcluded = this.visited;
        for (InterprNode c : n.children) {
            this.markExcludedRecursiveStep(changed, c);
        }
        if (n.linkedByLCS != null) {
            for (InterprNode c : n.linkedByLCS) {
                if (!this.checkOrNodeExcluded(c)) continue;
                this.markExcludedRecursiveStep(changed, c);
            }
        }
        if (changed != null) {
            changed.add(n);
        }
    }

    private boolean checkOrNodeExcluded(InterprNode n) {
        for (InterprNode on : n.orInterprNodes.values()) {
            if (this.isCovered(on.markedExcluded)) continue;
            return false;
        }
        return true;
    }

    private void markCandidates(Collection<SearchNode> candidates) {
        for (SearchNode sn : candidates) {
            for (InterprNode ref : sn.refinement) {
                this.markCandidatesRecursiveStep(ref, false);
            }
        }
    }

    private void markCandidatesRecursiveStep(InterprNode n, boolean dir) {
        if (n.markedHasCandidate == this.visited) {
            return;
        }
        n.markedHasCandidate = this.visited;
        for (InterprNode pn : dir ? n.children : n.parents) {
            if (pn.isBottom()) continue;
            this.markCandidatesRecursiveStep(pn, dir);
        }
    }

    public boolean containedInSelectedBranch(InterprNode n) {
        for (InterprNode p : n.parents) {
            if (this.isCovered(p.markedSelected)) continue;
            return false;
        }
        return true;
    }

    public String pathToString(Document doc) {
        return (this.selectedParent != null ? this.selectedParent.pathToString(doc) : "") + " - " + this.toString(doc);
    }

    public String toString(Document doc) {
        TreeSet<InterprNode> tmp = new TreeSet<InterprNode>();
        for (InterprNode n : this.refinement) {
            n.collectPrimitiveNodes(tmp, doc.interprIdCounter++);
        }
        StringBuilder sb = new StringBuilder();
        for (InterprNode n : tmp) {
            sb.append(n.primId);
            sb.append(", ");
        }
        return sb.toString();
    }

    public void changeState(StateChange.Mode m) {
        for (StateChange sc : this.modifiedActs) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode c) {
        int r = Double.compare(c.accumulatedWeight[0].getNormWeight(), this.accumulatedWeight[0].getNormWeight());
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }

    private static class RefMarker {
        public boolean selected;
        public boolean excluded;
        public boolean complete;

        private RefMarker() {
        }
    }

    public static class StateChange {
        public Activation act;
        public Activation.Rounds oldRounds;
        public Activation.Rounds newRounds;

        public static void saveOldState(List<StateChange> changes, Activation act, long v) {
            StateChange sc = act.currentStateChange;
            if (sc == null || act.currentStateV != v) {
                sc = new StateChange();
                sc.oldRounds = act.rounds.copy();
                act.currentStateChange = sc;
                act.currentStateV = v;
                sc.act = act;
                if (changes != null) {
                    changes.add(sc);
                }
            }
        }

        public static void saveNewState(Activation act) {
            StateChange sc = act.currentStateChange;
            sc.newRounds = act.rounds;
        }

        public void restoreState(Mode m) {
            this.act.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public static enum Mode {
            OLD,
            NEW;

        }
    }

    public static enum Coverage {
        SELECTED,
        UNKNOWN,
        EXCLUDED;

    }
}

