/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.apache.commons.math3.distribution.BinomialDistribution;

public class AndNode
extends Node<AndNode, NodeActivation<AndNode>> {
    private static double SIGNIFICANCE_THRESHOLD = 0.98;
    public static int MAX_POS_NODES = 4;
    public static int MAX_RID_RANGE = 5;
    SortedMap<Refinement, Provider<? extends Node>> parents = new TreeMap<Refinement, Provider<? extends Node>>();
    public volatile int numberOfPositionsNotify;
    private volatile int frequencyNotify;
    private double weight = -1.0;

    public AndNode() {
    }

    public AndNode(Model m, int level, SortedMap<Refinement, Provider<? extends Node>> parents) {
        super(m, level);
        this.parents = parents;
        ++m.stat.nodes;
        int n = level;
        m.stat.nodesPerLevel[n] = m.stat.nodesPerLevel[n] + 1;
        this.ridRequired = false;
        for (Map.Entry<Refinement, Provider<? extends Node>> me : parents.entrySet()) {
            Refinement ref = me.getKey();
            Node pn = me.getValue().get();
            pn.addAndChild(ref, this.provider);
            pn.provider.setModified();
            if (ref.rid == null) continue;
            this.ridRequired = true;
        }
        this.endRequired = false;
    }

    @Override
    public boolean isAllowedOption(int threadId, InterprNode n, NodeActivation<?> act, long v) {
        Node.ThreadState th = this.getThreadState(threadId, true);
        if (th.visitedAllowedOption == v) {
            return false;
        }
        th.visitedAllowedOption = v;
        for (NodeActivation pAct : act.inputs.values()) {
            if (!((Node)pAct.key.n).isAllowedOption(threadId, n, pAct, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    NodeActivation<AndNode> processAddedActivation(Document doc, NodeActivation.Key<AndNode> ak, Collection<NodeActivation> inputActs, boolean isTrainingAct) {
        int s = 0;
        for (NodeActivation iAct : inputActs) {
            if (iAct.isRemoved) continue;
            ++s;
        }
        if (s != this.level) {
            return null;
        }
        return super.processAddedActivation(doc, ak, inputActs, isTrainingAct);
    }

    void addActivation(Document doc, NodeActivation.Key ak, Collection<NodeActivation<?>> directInputActs) {
        Node.addActivationAndPropagate(doc, ak, directInputActs);
    }

    static void removeActivation(Document doc, NodeActivation<?> iAct) {
        for (NodeActivation act : iAct.outputs.values()) {
            if (!(act.key.n instanceof AndNode)) continue;
            Node.removeActivationAndPropagate(doc, act, Collections.singleton(iAct));
        }
    }

    @Override
    public void propagateAddedActivation(Document doc, NodeActivation act, InterprNode removedConflict) {
        this.apply(doc, act, removedConflict);
    }

    @Override
    public void propagateRemovedActivation(Document doc, NodeActivation act) {
        this.removeFromNextLevel(doc, act);
    }

    @Override
    boolean hasSupport(NodeActivation<AndNode> act) {
        int expected = this.parents.size();
        int support = 0;
        NodeActivation lastAct = null;
        for (NodeActivation iAct : act.inputs.values()) {
            if (!(iAct.isRemoved || lastAct != null && lastAct.key.n == iAct.key.n)) {
                ++support;
            }
            lastAct = iAct;
        }
        assert (support <= expected);
        return support == expected;
    }

    @Override
    public void computeNullHyp(Model m) {
        double avgSize = this.sizeSum / this.instanceSum;
        double n = (double)(m.numberOfPositions - this.nOffset) / avgSize;
        double nullHyp = 0.0;
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            Node pn = me.getValue().get();
            InputNode in = me.getKey().input.get();
            double inputNA = (double)(m.numberOfPositions - in.nOffset) / avgSize;
            double inputNB = (double)(m.numberOfPositions - pn.nOffset) / avgSize;
            double nh = Math.min(1.0, (double)in.frequency / inputNA) * Math.min(1.0, Math.max((double)pn.frequency, pn.nullHypFreq) / inputNB);
            nullHyp = Math.max(nullHyp, nh);
        }
        this.nullHypFreq = nullHyp * n;
    }

    public void updateWeight(Document doc, long v) {
        Node.ThreadState th = this.getThreadState(doc.threadId, true);
        Model m = doc.m;
        if (this.isBlocked || m.numberOfPositions - this.nOffset == 0 || this.frequency < Node.minFrequency || th.visitedComputeWeight == v || this.numberOfPositionsNotify > m.numberOfPositions && this.frequencyNotify > this.frequency && Math.abs(this.nullHypFreq - this.oldNullHypFreq) < 0.01) {
            return;
        }
        th.visitedComputeWeight = v;
        double avgSize = this.sizeSum / this.instanceSum;
        double n = (double)(m.numberOfPositions - this.nOffset) / avgSize;
        doc.m.numberOfPositionsQueue.remove(this.provider);
        this.numberOfPositionsNotify = this.computeNotify(n) + m.numberOfPositions;
        doc.m.numberOfPositionsQueue.add(this.provider);
        BinomialDistribution binDist = new BinomialDistribution(null, (int)Math.round(n), this.nullHypFreq / n);
        this.weight = binDist.cumulativeProbability(this.frequency - 1);
        this.frequencyNotify = this.computeNotify(this.frequency) + this.frequency;
        this.oldNullHypFreq = this.nullHypFreq;
        if (this.weight >= SIGNIFICANCE_THRESHOLD) {
            // empty if block
        }
    }

    public int computeNotify(double x) {
        return 1 + (int)Math.floor(Math.pow(x, 1.15) - x);
    }

    @Override
    public void cleanup(Model m, int threadId) {
        if (!(this.isRemoved || this.isFrequent() || this.isRequired())) {
            this.remove(m, threadId);
            for (Provider<? extends Node> p : this.parents.values()) {
                p.get().cleanup(m, threadId);
            }
        }
    }

    @Override
    void apply(Document doc, NodeActivation<AndNode> act, InterprNode removedConflict) {
        if (act.isRemoved) {
            return;
        }
        for (NodeActivation pAct : act.inputs.values()) {
            Object pn = pAct.key.n;
            ((Node)pn).lock.acquireReadLock();
            Refinement ref = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((AndNode)act.key.n).provider, act.key.rid, pAct.key.rid));
            if (ref != null) {
                for (NodeActivation secondAct : pAct.outputs.values()) {
                    Refinement nRef;
                    Provider<AndNode> nlp;
                    Refinement secondRef;
                    if (act == secondAct || secondAct.isRemoved || (secondRef = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((Node)secondAct.key.n).provider, secondAct.key.rid, pAct.key.rid))) == null || (nlp = this.getAndChild(nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input))) == null) continue;
                    AndNode.addNextLevelActivation(doc, act, secondAct, nlp, removedConflict);
                }
            }
            ((Node)pn).lock.releaseReadLock();
        }
        if (removedConflict == null) {
            OrNode.processCandidate(doc, this, act, false);
        }
    }

    @Override
    public void discover(Document doc, NodeActivation<AndNode> act) {
        if (!this.isExpandable(true)) {
            return;
        }
        for (NodeActivation pAct : act.inputs.values()) {
            Object pn = pAct.key.n;
            ((Node)pn).lock.acquireReadLock();
            Refinement ref = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((AndNode)act.key.n).provider, act.key.rid, pAct.key.rid));
            for (NodeActivation secondAct : pAct.outputs.values()) {
                if (!(secondAct.key.n instanceof AndNode)) continue;
                Object secondNode = secondAct.key.n;
                Integer ridDelta = Utils.nullSafeSub(act.key.rid, false, secondAct.key.rid, false);
                if (act == secondAct || ((Node)secondNode).isBlocked || !((Node)secondNode).isFrequent() || ridDelta != null && ridDelta >= MAX_RID_RANGE) continue;
                Refinement secondRef = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((Node)secondAct.key.n).provider, secondAct.key.rid, pAct.key.rid));
                Refinement nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input);
                AndNode nln = AndNode.createNextLevelNode(doc.m, doc.threadId, this, nRef, true);
                if (nln == null) continue;
                doc.addedNodes.add(nln);
            }
            ((Node)pn).lock.releaseReadLock();
        }
    }

    @Override
    boolean isExpandable(boolean checkFrequency) {
        if (checkFrequency && !this.isFrequent()) {
            return false;
        }
        int numPosNodes = 0;
        for (Refinement ref : this.parents.keySet()) {
            if (ref.input.get().key.isNeg) continue;
            ++numPosNodes;
        }
        return numPosNodes < MAX_POS_NODES;
    }

    private static boolean checkRidRange(SortedMap<Refinement, Provider<? extends Node>> parents) {
        int maxRid = 0;
        for (Refinement ref : parents.keySet()) {
            if (ref.rid == null) continue;
            maxRid = Math.max(maxRid, ref.rid);
        }
        return maxRid < MAX_RID_RANGE;
    }

    @Override
    boolean contains(Refinement ref) {
        if (ref.rid == null || ref.rid >= 0) {
            boolean flag = false;
            this.lock.acquireReadLock();
            if (ref.rid == null || ref.rid > 0) {
                flag = this.parents.containsKey(ref);
            } else if (ref.rid == 0) {
                for (Refinement pRef : this.parents.keySet()) {
                    if (pRef.rid != null && pRef.rid > 0 || pRef.input != ref.input) continue;
                    flag = true;
                    break;
                }
            }
            this.lock.releaseReadLock();
            return flag;
        }
        return false;
    }

    static AndNode createNextLevelNode(Model m, int threadId, Node n, Refinement ref, boolean discoverPatterns) {
        Provider<AndNode> pnln = n.getAndChild(ref);
        if (pnln != null) {
            return discoverPatterns ? null : pnln.get();
        }
        if (n.contains(ref)) {
            return null;
        }
        SortedMap<Refinement, Provider<? extends Node>> parents = AndNode.computeNextLevelParents(m, threadId, n, ref, discoverPatterns);
        AndNode nln = null;
        if (parents != null && (!discoverPatterns || AndNode.checkRidRange(parents))) {
            TreeSet<Provider<? extends Node>> parentsForLocking = new TreeSet<Provider<? extends Node>>(parents.values());
            for (Provider<? extends Node> pn : parentsForLocking) {
                pn.get().lock.acquireWriteLock(threadId);
            }
            if (n.andChildren == null || !n.andChildren.containsKey(ref)) {
                nln = new AndNode(m, n.level + 1, parents);
                nln.isBlocked = n.isBlocked || ref.input.get().isBlocked;
            }
            for (Provider<? extends Node> pn : parentsForLocking) {
                pn.get().lock.releaseWriteLock();
            }
        }
        return nln;
    }

    public static void addNextLevelActivation(Document doc, NodeActivation<AndNode> act, NodeActivation<AndNode> secondAct, Provider<AndNode> pnlp, InterprNode conflict) {
        NodeActivation.Key ak = act.key;
        InterprNode o = InterprNode.add(doc, true, ak.o, secondAct.key.o);
        if (o != null && (conflict == null || o.contains(conflict, false))) {
            AndNode nlp = pnlp.get();
            nlp.addActivation(doc, new NodeActivation.Key<AndNode>(nlp, Range.mergeRange(ak.r, secondAct.key.r), Utils.nullSafeMin(ak.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
        }
    }

    public static Collection<NodeActivation<?>> prepareInputActs(NodeActivation<?> firstAct, NodeActivation<?> secondAct) {
        ArrayList inputActs = new ArrayList(2);
        inputActs.add(firstAct);
        inputActs.add(secondAct);
        return inputActs;
    }

    public static SortedMap<Refinement, Provider<? extends Node>> computeNextLevelParents(Model m, int threadId, Node pa, Refinement ref, boolean discoverPatterns) {
        Collection<Refinement> refinements = pa.collectNodeAndRefinements(ref);
        long v = visitedCounter++;
        TreeMap<Refinement, Provider<? extends Node>> parents = new TreeMap<Refinement, Provider<? extends Node>>();
        for (Refinement pRef : refinements) {
            TreeSet<Refinement> childInputs = new TreeSet<Refinement>(refinements);
            childInputs.remove(pRef);
            try {
                if (pRef.input.get().computeAndParents(m, threadId, pRef.getRelativePosition(), childInputs, parents, discoverPatterns, v)) continue;
                return null;
            }
            catch (Node.ThreadState.RidOutOfRange e) {
                return null;
            }
        }
        return parents;
    }

    @Override
    Collection<Refinement> collectNodeAndRefinements(Refinement newRef) {
        ArrayList<Refinement> inputs = new ArrayList<Refinement>(this.parents.size() + 1);
        inputs.add(newRef);
        int numRidRefs = 0;
        for (Refinement ref : this.parents.keySet()) {
            if (ref.rid == null) continue;
            ++numRidRefs;
        }
        for (Refinement ref : this.parents.keySet()) {
            if (newRef.rid != null && newRef.rid != null && (newRef.rid < 0 || numRidRefs == 1)) {
                inputs.add(new Refinement(ref.getRelativePosition(), newRef.rid, ref.input));
                continue;
            }
            if (ref.rid != null && newRef.rid != null && ref.getOffset() < 0) {
                inputs.add(new Refinement(0, Math.min(-ref.getOffset().intValue(), newRef.getRelativePosition()), ref.input));
                continue;
            }
            inputs.add(ref);
        }
        return inputs;
    }

    @Override
    void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        Node.ThreadState th = this.getThreadState(threadId, true);
        if (th.visitedNeuronRefsChange == v) {
            return;
        }
        th.visitedNeuronRefsChange = v;
        this.numberOfNeuronRefs += d;
        for (Provider<? extends Node> n : this.parents.values()) {
            n.get().changeNumberOfNeuronRefs(threadId, v, d);
        }
    }

    @Override
    public boolean isCovered(int threadId, Integer offset, long v) throws Node.ThreadState.RidOutOfRange {
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            Node.RidVisited nv = me.getValue().get().getThreadState(threadId, true).lookupVisited(Utils.nullSafeSub(offset, true, me.getKey().getOffset(), false));
            if (nv.outputNode != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        double sum = n.bias;
        for (Refinement ref : this.parents.keySet()) {
            Synapse s = ref.getSynapse(offset, (Neuron)n.provider);
            sum += (double)Math.abs(s.w);
        }
        return sum;
    }

    @Override
    protected NodeActivation<AndNode> createActivation(Document doc, NodeActivation.Key ak, boolean isTrainingAct) {
        NodeActivation<AndNode> act = new NodeActivation<AndNode>(doc.activationIdCounter++, ak);
        act.isTrainingAct = isTrainingAct;
        return act;
    }

    @Override
    public void deleteActivation(Document doc, NodeActivation act) {
    }

    @Override
    void remove(Model m, int threadId) {
        super.remove(m, threadId);
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            Node pn = me.getValue().get();
            pn.lock.acquireWriteLock(threadId);
            pn.removeAndChild(me.getKey());
            pn.provider.setModified();
            pn.lock.releaseWriteLock();
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND[");
        boolean first = true;
        for (Refinement ref : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(ref);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String weightsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" - ");
        sb.append(" F:");
        sb.append(this.frequency);
        sb.append("  BW:");
        sb.append(Utils.round(this.weight));
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeUTF("A");
        super.write(out);
        out.writeInt(this.numberOfPositionsNotify);
        out.writeInt(this.frequencyNotify);
        out.writeDouble(this.weight);
        out.writeInt(this.parents.size());
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            me.getKey().write(out);
            out.writeInt(me.getValue().id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.numberOfPositionsNotify = in.readInt();
        this.frequencyNotify = in.readInt();
        this.weight = in.readDouble();
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Refinement ref = Refinement.read(in, m);
            Object pn = m.lookupNodeProvider(in.readInt());
            this.parents.put(ref, (Provider<? extends Node>)pn);
        }
    }

    static class Refinement
    implements Comparable<Refinement> {
        public static Refinement MIN = new Refinement(null, null);
        public static Refinement MAX = new Refinement(null, null);
        public Integer rid;
        public Provider<InputNode> input;

        private Refinement() {
        }

        public Refinement(Integer rid, Provider<InputNode> input) {
            this.rid = rid;
            this.input = input;
        }

        public Refinement(Integer rid, Integer offset, Provider<InputNode> input) {
            this.rid = offset == null && rid != null ? Integer.valueOf(0) : (offset == null || rid == null ? null : Integer.valueOf(rid - offset));
            this.input = input;
        }

        public Integer getOffset() {
            return this.rid != null ? Integer.valueOf(Math.min(0, this.rid)) : null;
        }

        public Integer getRelativePosition() {
            return this.rid != null ? Integer.valueOf(Math.max(0, this.rid)) : null;
        }

        public Synapse getSynapse(Integer offset, Neuron n) {
            return this.input.get().getSynapse(Utils.nullSafeAdd(this.getRelativePosition(), false, offset, false), n);
        }

        public String toString() {
            return "(" + (this.rid != null ? this.rid + ":" : "") + this.input.get().logicToString() + ")";
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.input.id);
        }

        public boolean readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.input = m.lookupNodeProvider(in.readInt());
            return true;
        }

        public static Refinement read(DataInput in, Model m) throws IOException {
            Refinement k = new Refinement();
            k.readFields(in, m);
            return k;
        }

        @Override
        public int compareTo(Refinement ref) {
            if (this == MIN || ref == MAX) {
                return -1;
            }
            if (this == MAX || ref == MIN) {
                return 1;
            }
            int r = this.input.compareTo(ref.input);
            if (r != 0) {
                return r;
            }
            return Utils.compareInteger(this.rid, ref.rid);
        }
    }
}

