/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class InputNode
extends Node<InputNode, NodeActivation<InputNode>> {
    public Synapse.Key key;
    public Neuron inputNeuron;
    Map<SynapseKey, Synapse> synapses;
    private long visitedTrain = -1L;

    public InputNode() {
    }

    public InputNode(Model m, Synapse.Key key) {
        super(m, 1);
        this.key = Synapse.lookupKey(key);
        if (m != null) {
            ++m.stat.nodes;
            int n = this.level;
            m.stat.nodesPerLevel[n] = m.stat.nodesPerLevel[n] + 1;
        }
        this.endRequired = false;
        this.ridRequired = false;
        if (key != null) {
            this.endRequired = key.startRangeMapping == Range.Mapping.NONE;
            this.ridRequired = key.relativeRid != null || key.absoluteRid != null;
        }
    }

    public static InputNode add(Model m, Synapse.Key key, INeuron input) {
        Provider<InputNode> pin;
        Provider<InputNode> provider = pin = input != null ? input.outputNodes.get(key) : null;
        if (pin != null) {
            return pin.get();
        }
        InputNode in = new InputNode(m, key);
        if (input != null && in.inputNeuron == null) {
            in.inputNeuron = (Neuron)input.provider;
            input.outputNodes.put(key, in.provider);
            ((Neuron)input.provider).setModified();
        }
        return in;
    }

    @Override
    void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        Node.ThreadState th = this.getThreadState(threadId, true);
        if (th.visitedNeuronRefsChange == v) {
            return;
        }
        th.visitedNeuronRefsChange = v;
        this.numberOfNeuronRefs += d;
    }

    @Override
    protected NodeActivation<InputNode> createActivation(Document doc, NodeActivation.Key ak, boolean isTrainingAct) {
        NodeActivation<InputNode> act = new NodeActivation<InputNode>(doc.activationIdCounter++, ak);
        act.isTrainingAct = isTrainingAct;
        return act;
    }

    @Override
    public void deleteActivation(Document doc, NodeActivation act) {
    }

    private NodeActivation.Key computeActivationKey(NodeActivation iAct) {
        NodeActivation.Key ak = iAct.key;
        if (this.key.absoluteRid != null && this.key.absoluteRid != ak.rid || ak.o.isConflicting(ak.o.doc.visitedCounter++)) {
            return null;
        }
        return new NodeActivation.Key<InputNode>(this, new Range(this.key.startRangeMapping.getSignalPos(ak.r), this.key.endRangeMapping.getSignalPos(ak.r)), this.key.relativeRid != null ? ak.rid : null, ak.o);
    }

    @Override
    public void computeNullHyp(Model m) {
        this.nullHypFreq = this.frequency;
    }

    @Override
    boolean isExpandable(boolean checkFrequency) {
        return true;
    }

    @Override
    boolean hasSupport(NodeActivation<InputNode> act) {
        for (NodeActivation iAct : act.inputs.values()) {
            Activation iNAct = (Activation)iAct;
            if (iAct.isRemoved || !(iNAct.upperBound > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    NodeActivation<InputNode> processAddedActivation(Document doc, NodeActivation.Key<InputNode> ak, Collection<NodeActivation> inputActs, boolean isTrainingAct) {
        Range r = ak.r;
        if (this.key.startRangeMapping == Range.Mapping.NONE || this.key.endRangeMapping == Range.Mapping.NONE) {
            boolean dir = this.key.startRangeMapping == Range.Mapping.NONE;
            int pos = ak.r.getBegin(dir);
            List tmp = NodeActivation.select(doc, this, ak.rid, new Range(pos, pos), Range.Operator.LESS_THAN, Range.Operator.GREATER_THAN, ak.o, InterprNode.Relation.CONTAINS).collect(Collectors.toList());
            for (NodeActivation act : tmp) {
                super.processAddedActivation(doc, new NodeActivation.Key<InputNode>(this, new Range(act.key.r.getBegin(dir), pos).invert(dir), act.key.rid, act.key.o), act.inputs.values(), false);
                ++NodeActivation.removedIdCounter;
                act.removedId = act.removedId;
                act.isRemoved = true;
                super.processRemovedActivation(doc, act, act.inputs.values());
            }
            NodeActivation cAct = NodeActivation.getNextSignal(this, doc, pos, ak.rid, ak.o, dir, dir);
            r = new Range(ak.r.getBegin(dir), cAct != null ? cAct.key.r.getBegin(dir) : (dir ? Integer.MIN_VALUE : Integer.MAX_VALUE)).invert(dir);
        }
        return super.processAddedActivation(doc, new NodeActivation.Key<InputNode>(this, r, ak.rid, ak.o), inputActs, isTrainingAct);
    }

    @Override
    void processRemovedActivation(Document doc, NodeActivation<InputNode> act, Collection<NodeActivation> inputActs) {
        super.processRemovedActivation(doc, act, inputActs);
        if (act.isRemoved) {
            NodeActivation.Key ak = act.key;
            if (this.key.startRangeMapping == Range.Mapping.NONE || this.key.endRangeMapping == Range.Mapping.NONE) {
                boolean dir = this.key.startRangeMapping == Range.Mapping.NONE;
                List tmp = NodeActivation.select(doc, this, ak.rid, new Range(ak.r.getBegin(dir), dir ? Integer.MAX_VALUE : Integer.MIN_VALUE).invert(!dir), dir ? Range.Operator.EQUALS : Range.Operator.NONE, dir ? Range.Operator.NONE : Range.Operator.EQUALS, ak.o, InterprNode.Relation.CONTAINS).collect(Collectors.toList());
                for (NodeActivation cAct : tmp) {
                    NodeActivation.Key cak = cAct.key;
                    this.processAddedActivation(doc, new NodeActivation.Key<InputNode>((InputNode)cak.n, new Range(dir ? Integer.MIN_VALUE : cak.r.begin, dir ? cak.r.end : Integer.MAX_VALUE), cak.rid, cak.o), cAct.inputs.values(), false);
                    if (cAct.isRemoved) continue;
                    ++NodeActivation.removedIdCounter;
                    cAct.removedId = cAct.removedId;
                    cAct.isRemoved = true;
                    super.processRemovedActivation(doc, cAct, cAct.inputs.values());
                }
            }
        }
    }

    public void addActivation(Document doc, NodeActivation inputAct) {
        NodeActivation.Key ak = this.computeActivationKey(inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(doc, ak, Collections.singleton(inputAct));
        }
    }

    public void removeActivation(Document doc, NodeActivation<?> inputAct) {
        for (NodeActivation act : inputAct.outputs.values()) {
            if (act.key.n != this) continue;
            InputNode.removeActivationAndPropagate(doc, act, Collections.singleton(inputAct));
        }
    }

    @Override
    public void propagateAddedActivation(Document doc, NodeActivation act, InterprNode removedConflict) {
        if (!this.key.isNeg && !this.key.isRecurrent) {
            this.apply(doc, act, removedConflict);
        }
    }

    @Override
    public void propagateRemovedActivation(Document doc, NodeActivation act) {
        if (!this.key.isNeg && !this.key.isRecurrent) {
            this.removeFromNextLevel(doc, act);
        }
    }

    @Override
    public boolean isAllowedOption(int threadId, InterprNode n, NodeActivation act, long v) {
        return false;
    }

    @Override
    Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        ArrayList<AndNode.Refinement> result = new ArrayList<AndNode.Refinement>(2);
        result.add(new AndNode.Refinement(this.key.relativeRid, newRef.rid, this.provider));
        result.add(newRef);
        return result;
    }

    @Override
    void apply(Document doc, NodeActivation act, InterprNode removedConflict) {
        if (act.isRemoved) {
            return;
        }
        this.lock.acquireReadLock();
        if (this.andChildren != null) {
            for (Map.Entry me : this.andChildren.entrySet()) {
                Provider<InputNode> refInput = ((AndNode.Refinement)me.getKey()).input;
                if (refInput.isSuspended()) continue;
                InputNode.addNextLevelActivations(doc, refInput.get(), (AndNode.Refinement)me.getKey(), (Provider)me.getValue(), act, removedConflict);
            }
        }
        this.lock.releaseReadLock();
        if (removedConflict == null) {
            OrNode.processCandidate(doc, this, act, false);
        }
    }

    private static void addNextLevelActivations(Document doc, InputNode secondNode, AndNode.Refinement ref, Provider<AndNode> pnlp, NodeActivation act, InterprNode removedConflict) {
        Node.ThreadState th = secondNode.getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return;
        }
        NodeActivation.Key ak = act.key;
        InputNode firstNode = (InputNode)ak.n;
        Integer secondRid = Utils.nullSafeAdd(ak.rid, false, ref.rid, false);
        Stream s = NodeActivation.select(th, secondNode, secondRid, ak.r, InputNode.computeStartRangeMatch(firstNode.key, secondNode.key), InputNode.computeEndRangeMatch(firstNode.key, secondNode.key), null, null);
        s.forEach(secondAct -> {
            InterprNode o;
            if (!secondAct.isRemoved && (o = InterprNode.add(doc, true, key.o, secondAct.key.o)) != null && (removedConflict == null || o.contains(removedConflict, false))) {
                AndNode nlp = (AndNode)pnlp.get();
                nlp.addActivation(doc, new NodeActivation.Key<AndNode>(nlp, Range.mergeRange(Range.getOutputRange(key.r, new boolean[]{inputNode.key.startRangeOutput, inputNode.key.endRangeOutput}), Range.getOutputRange(secondAct.key.r, new boolean[]{inputNode2.key.startRangeOutput, inputNode2.key.endRangeOutput})), Utils.nullSafeMin(key.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
            }
        });
    }

    private static Range.Operator computeStartRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k1.startRangeMatch == Range.Operator.FIRST || k1.startRangeMatch == Range.Operator.LAST) {
            return k1.startRangeMatch;
        }
        if (k2.startRangeMatch == Range.Operator.FIRST || k2.startRangeMatch == Range.Operator.LAST) {
            return Range.Operator.invert(k2.startRangeMatch);
        }
        if (k2.startRangeOutput) {
            return k1.startRangeMatch;
        }
        if (k1.startRangeOutput) {
            return Range.Operator.invert(k2.startRangeMatch);
        }
        return Range.Operator.NONE;
    }

    private static Range.Operator computeEndRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k1.endRangeMatch == Range.Operator.FIRST || k1.endRangeMatch == Range.Operator.LAST) {
            return k1.endRangeMatch;
        }
        if (k2.endRangeMatch == Range.Operator.FIRST || k2.endRangeMatch == Range.Operator.LAST) {
            return Range.Operator.invert(k2.endRangeMatch);
        }
        if (k2.endRangeOutput) {
            return k1.endRangeMatch;
        }
        if (k1.endRangeOutput) {
            return Range.Operator.invert(k2.endRangeMatch);
        }
        return Range.Operator.NONE;
    }

    @Override
    public void discover(Document doc, NodeActivation<InputNode> act) {
        long v = Node.visitedCounter++;
        for (INeuron n : doc.finallyActivatedNeurons) {
            for (Activation secondNAct : n.getFinalActivations(doc)) {
                for (NodeActivation secondAct : secondNAct.outputs.values()) {
                    AndNode.Refinement ref = new AndNode.Refinement(secondAct.key.rid, act.key.rid, ((Node)secondAct.key.n).provider);
                    InputNode in = ref.input.get();
                    Range.Operator srm = InputNode.computeStartRangeMatch(this.key, in.key);
                    Range.Operator erm = InputNode.computeEndRangeMatch(this.key, in.key);
                    Integer ridDelta = Utils.nullSafeSub(act.key.rid, false, secondAct.key.rid, false);
                    if (act == secondAct || this == in || in.visitedTrain == v || in.key.isNeg || in.key.isRecurrent || (!srm.compare(act.key.r.begin, act.key.r.end, secondAct.key.r.begin, secondAct.key.r.end) || !erm.compare(act.key.r.end, act.key.r.begin, secondAct.key.r.end, secondAct.key.r.begin)) && (ridDelta == null || ridDelta >= AndNode.MAX_RID_RANGE)) continue;
                    in.visitedTrain = v;
                    AndNode.createNextLevelNode(doc.m, doc.threadId, this, ref, true);
                }
            }
        }
    }

    @Override
    boolean contains(AndNode.Refinement ref) {
        return this == ref.input.get() && Utils.compareInteger(this.key.relativeRid, ref.rid) == 0;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        return n.bias + (double)Math.abs(this.getSynapse((Integer)(this.key.relativeRid == null ? null : offset), (Neuron)((Neuron)n.provider)).w);
    }

    public Synapse getSynapse(Integer rid, Neuron outputNeuron) {
        this.lock.acquireReadLock();
        Synapse s = this.synapses != null ? this.synapses.get(new SynapseKey(rid, outputNeuron)) : null;
        this.lock.releaseReadLock();
        return s;
    }

    public void setSynapse(int threadId, Synapse s) {
        this.lock.acquireWriteLock(threadId);
        if (this.synapses == null) {
            this.synapses = new TreeMap<SynapseKey, Synapse>();
        }
        this.synapses.put(new SynapseKey(s.key.relativeRid, s.output), s);
        this.lock.releaseWriteLock();
    }

    public void removeSynapse(int threadId, Synapse s) {
        this.lock.acquireWriteLock(threadId);
        this.synapses.remove(new SynapseKey(s.key.relativeRid, s.output));
        this.lock.releaseWriteLock();
    }

    @Override
    public void reactivate() {
        this.inputNeuron.inMemoryOutputSynapses.values().forEach(s -> {
            if (this.key.compareTo(s.key.createInputNodeKey()) == 0) {
                this.setSynapse(this.provider.m.defaultThreadId, (Synapse)s);
            }
        });
    }

    @Override
    public void cleanup(Model m, int threadId) {
    }

    @Override
    void remove(Model m, int threadId) {
        ((INeuron)this.inputNeuron.get()).outputNodes.remove(this.key);
        super.remove(m, threadId);
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.isNeg ? "N" : "P");
        sb.append(this.key.isRecurrent ? "R" : "");
        sb.append(this.getRangeBrackets(this.key.startRangeOutput, this.key.startRangeMapping));
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (((INeuron)this.inputNeuron.get()).label != null) {
                sb.append(",");
                sb.append(((INeuron)this.inputNeuron.get()).label);
            }
        }
        sb.append(this.getRangeBrackets(this.key.endRangeOutput, this.key.endRangeMapping));
        return sb.toString();
    }

    private String getRangeBrackets(boolean ro, Range.Mapping rs) {
        if (rs == Range.Mapping.NONE) {
            return "|";
        }
        if (ro) {
            return rs == Range.Mapping.START ? "[" : "]";
        }
        if (!ro) {
            return rs == Range.Mapping.START ? "<" : ">";
        }
        return "|";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeUTF("I");
        super.write(out);
        this.key.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.key = Synapse.lookupKey(Synapse.Key.read(in, m));
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    private static class SynapseKey
    implements Writable,
    Comparable<SynapseKey> {
        Integer rid;
        Neuron n;

        private SynapseKey() {
        }

        public SynapseKey(Integer rid, Neuron n) {
            this.rid = rid;
            this.n = n;
        }

        @Override
        public int compareTo(SynapseKey sk) {
            int r = Utils.compareInteger(this.rid, sk.rid);
            if (r != 0) {
                return r;
            }
            return this.n.compareTo(sk.n);
        }

        public static SynapseKey read(DataInput in, Model m) throws IOException {
            SynapseKey sk = new SynapseKey();
            sk.readFields(in, m);
            return sk;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.n.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.n = m.lookupNeuron(in.readInt());
        }
    }
}

