/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.AbstractNode;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Node<T extends Node, A extends NodeActivation<T>>
extends AbstractNode<Provider<T>>
implements Comparable<Node> {
    public static int minFrequency = 5;
    public static int MAX_RID = 25;
    public static double TOLERANCE = 0.1;
    public static final Node MIN_NODE = new InputNode();
    public static final Node MAX_NODE = new InputNode();
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    TreeMap<ReverseAndRefinement, AndNode.Refinement> reverseAndChildren;
    TreeMap<AndNode.Refinement, Provider<AndNode>> andChildren;
    TreeSet<OrNode.OrEntry> orChildren;
    public int level;
    public volatile int frequency;
    public volatile double nullHypFreq;
    public volatile double oldNullHypFreq;
    public boolean isBlocked;
    public boolean endRequired;
    public boolean ridRequired;
    public int numberOfNeuronRefs = 0;
    volatile boolean isRemoved;
    volatile int isRemovedId;
    static int isRemovedIdCounter = 0;
    public volatile boolean frequencyHasChanged = true;
    public volatile int nOffset;
    public volatile int sizeSum = 0;
    public volatile int instanceSum = 0;
    public ReadWriteLock lock = new ReadWriteLock();
    public boolean isQueued = false;
    public long queueId;
    public static long visitedCounter = 1L;
    public ThreadState<T, A>[] threads;
    public static final Comparator<NodeActivation.Key> BEGIN_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<NodeActivation.Key> END_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Range.compare(k1.r, k2.r, true);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<NodeActivation.Key> RID_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };

    public ThreadState<T, A> getThreadState(int threadId, boolean create) {
        ThreadState<T, A> th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState(this.endRequired, this.ridRequired);
        }
        th.lastUsed = Document.docIdCounter;
        return th;
    }

    public abstract void propagateAddedActivation(Document var1, A var2, InterprNode var3);

    public abstract void propagateRemovedActivation(Document var1, NodeActivation var2);

    public abstract boolean isAllowedOption(int var1, InterprNode var2, NodeActivation<?> var3, long var4);

    abstract void cleanup(Model var1, int var2);

    abstract A createActivation(Document var1, NodeActivation.Key var2, boolean var3);

    abstract void deleteActivation(Document var1, A var2);

    public abstract double computeSynapseWeightSum(Integer var1, INeuron var2);

    public abstract String logicToString();

    abstract void apply(Document var1, A var2, InterprNode var3);

    public abstract void discover(Document var1, NodeActivation<T> var2);

    abstract Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement var1);

    abstract void changeNumberOfNeuronRefs(int var1, long var2, int var4);

    abstract boolean hasSupport(A var1);

    public abstract void computeNullHyp(Model var1);

    abstract boolean isExpandable(boolean var1);

    abstract boolean contains(AndNode.Refinement var1);

    protected Node() {
    }

    public Node(Model m, int level) {
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Provider<Node>(m, this);
        this.level = level;
        if (m != null) {
            this.nOffset = m.numberOfPositions;
        }
        this.provider.setModified();
    }

    void addOrChild(OrNode.OrEntry oe) {
        if (this.orChildren == null) {
            this.orChildren = new TreeSet();
        }
        this.orChildren.add(oe);
    }

    void removeOrChild(int threadId, OrNode.OrEntry oe) {
        this.lock.acquireWriteLock(threadId);
        if (this.orChildren != null) {
            this.orChildren.remove(oe);
            if (this.orChildren.isEmpty()) {
                this.orChildren = null;
            }
        }
        this.lock.releaseWriteLock();
    }

    void addAndChild(AndNode.Refinement ref, Provider<AndNode> child) {
        Provider<AndNode> n;
        if (this.andChildren == null) {
            this.andChildren = new TreeMap();
            this.reverseAndChildren = new TreeMap();
        }
        if ((n = this.andChildren.put(ref, child)) != null) {
            System.out.println();
        }
        assert (n == null);
        this.reverseAndChildren.put(new ReverseAndRefinement(child, ref.rid, 0), ref);
    }

    void removeAndChild(AndNode.Refinement ref) {
        if (this.andChildren != null) {
            Provider<AndNode> child = this.andChildren.remove(ref);
            this.reverseAndChildren.remove(new ReverseAndRefinement(child, ref.rid, 0));
            if (this.andChildren.isEmpty()) {
                this.andChildren = null;
                this.reverseAndChildren = null;
            }
        }
    }

    public void count(int threadId) {
        ThreadState<T, A> ts = this.getThreadState(threadId, false);
        if (ts == null) {
            return;
        }
        for (NodeActivation act : ts.activations.values()) {
            ++this.frequency;
            this.frequencyHasChanged = true;
            this.sizeSum += act.key.r.end == null || act.key.r.begin == null || act.key.r.end == Integer.MAX_VALUE ? 1 : Math.max(1, act.key.r.end - act.key.r.begin);
            ++this.instanceSum;
        }
    }

    A processAddedActivation(Document doc, NodeActivation.Key<T> ak, Collection<NodeActivation> inputActs, boolean isTrainingAct) {
        Object act;
        if (Document.APPLY_DEBUG_OUTPUT) {
            log.info("add: " + ak + " - " + ak.n);
        }
        if ((act = NodeActivation.get(doc, this, ak)) == null) {
            act = this.createActivation(doc, ak, isTrainingAct);
            this.register(act, doc);
            ((NodeActivation)act).link(inputActs);
            if (!isTrainingAct) {
                this.propagateAddedActivation(doc, act, null);
            }
        } else {
            ((NodeActivation)act).link(inputActs);
        }
        return act;
    }

    void processRemovedActivation(Document doc, A act, Collection<NodeActivation> inputActs) {
        if (((NodeActivation)act).isRemoved) {
            this.unregister(act, doc);
            this.deleteActivation(doc, act);
            this.propagateRemovedActivation(doc, (NodeActivation)act);
            ((NodeActivation)act).key.releaseRef();
        }
        ((NodeActivation)act).unlink(inputActs);
    }

    public void register(A act, Document doc) {
        TreeMap actRid;
        NodeActivation.Key ak = ((NodeActivation)act).key;
        ThreadState<T, A> th = ((Node)ak.n).getThreadState(doc.threadId, true);
        if (th.activations.isEmpty()) {
            (((NodeActivation)act).isTrainingAct ? doc.activatedNodesForTraining : doc.activatedNodes).add((Node)ak.n);
        }
        th.activations.put(ak, act);
        TreeMap actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.put(ak, act);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.put(ak, act);
        }
        if (ak.o.activations == null) {
            ak.o.activations = new TreeMap<NodeActivation.Key, NodeActivation>();
        }
        ak.o.activations.put(ak, (NodeActivation)act);
        ((Node)ak.n).lastUsedDocumentId = doc.id;
        if (ak.rid != null) {
            doc.activationsByRid.put(ak, (NodeActivation)act);
        }
    }

    public void unregister(A act, Document doc) {
        TreeMap actRid;
        NodeActivation.Key ak = ((NodeActivation)act).key;
        assert (!ak.o.activations.isEmpty());
        ThreadState<T, A> th = ((Node)ak.n).getThreadState(doc.threadId, true);
        th.activations.remove(ak);
        TreeMap actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.remove(ak);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.remove(ak);
        }
        if (th.activations.isEmpty()) {
            (((NodeActivation)act).isTrainingAct ? doc.activatedNodesForTraining : doc.activatedNodes).remove(ak.n);
        }
        ak.o.activations.remove(ak);
        if (ak.rid != null) {
            doc.activationsByRid.remove(ak);
        }
    }

    public void processChanges(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, true);
        NavigableMap<NodeActivation.Key, Set<NodeActivation<?>>> tmpAdded = th.added;
        NavigableMap<NodeActivation.Key, RemovedEntry> tmpRemoved = th.removed;
        th.added = new TreeMap();
        th.removed = new TreeMap<NodeActivation.Key, RemovedEntry>();
        Iterator it = tmpRemoved.entrySet().iterator();
        while (it.hasNext()) {
            NodeActivation.Key key = (NodeActivation.Key)it.next().getKey();
            boolean remove = false;
            for (NodeActivation.Key aka : tmpAdded.keySet()) {
                if (aka.o != key.o || aka.rid != key.rid || aka.r != key.r) continue;
                remove = true;
            }
            if (!remove) continue;
            it.remove();
        }
        for (RemovedEntry removedEntry : tmpRemoved.values()) {
            if (this.hasSupport(removedEntry.act)) continue;
            ++NodeActivation.removedIdCounter;
            ((NodeActivation)removedEntry.act).removedId = ((NodeActivation)removedEntry.act).removedId;
            ((NodeActivation)removedEntry.act).isRemoved = true;
        }
        for (RemovedEntry removedEntry : tmpRemoved.values()) {
            this.processRemovedActivation(doc, removedEntry.act, removedEntry.iActs);
        }
        for (Map.Entry entry : tmpAdded.entrySet()) {
            this.processAddedActivation(doc, (NodeActivation.Key)entry.getKey(), (Collection)entry.getValue(), false);
        }
    }

    public static <T extends Node, A extends NodeActivation<T>> void addActivationAndPropagate(Document doc, NodeActivation.Key<T> ak, Collection<NodeActivation<?>> inputActs) {
        ThreadState<T, A> th = ((Node)ak.n).getThreadState(doc.threadId, true);
        TreeSet iActs = (TreeSet)th.added.get(ak);
        if (iActs == null) {
            iActs = new TreeSet();
            th.added.put(ak, iActs);
        }
        iActs.addAll(inputActs);
        doc.queue.add((Node)ak.n);
    }

    public static <T extends Node, A extends NodeActivation<T>> void removeActivationAndPropagate(Document doc, A act, Collection<NodeActivation<?>> inputActs) {
        if (act == null || act.isRemoved) {
            return;
        }
        ThreadState<T, A> th = ((Node)act.key.n).getThreadState(doc.threadId, true);
        RemovedEntry re = (RemovedEntry)th.removed.get(act.key);
        if (re == null) {
            re = new RemovedEntry();
            re.act = act;
            th.removed.put(act.key, re);
        }
        re.iActs.addAll(inputActs);
        doc.queue.add((Node)act.key.n);
    }

    public Collection<A> getActivations(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.activations.values();
    }

    public synchronized A getFirstActivation(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return null;
        }
        return (A)((NodeActivation)th.activations.firstEntry().getValue());
    }

    public void clearActivations(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        if (th.activationsEnd != null) {
            th.activationsEnd.clear();
        }
        if (th.activationsRid != null) {
            th.activationsRid.clear();
        }
        th.added.clear();
        th.removed.clear();
    }

    public void clearActivations(Model m) {
        for (int i = 0; i < m.numberOfThreads; ++i) {
            this.clearActivations(m.createDocument(null, i));
        }
    }

    public boolean isFrequent() {
        return this.frequency >= minFrequency;
    }

    public boolean isPublic() {
        return this instanceof AndNode && this.orChildren != null && !this.orChildren.isEmpty();
    }

    boolean computeAndParents(Model m, int threadId, Integer offset, SortedSet<AndNode.Refinement> inputs, Map<AndNode.Refinement, Provider<? extends Node>> parents, boolean discoverPatterns, long v) throws ThreadState.RidOutOfRange {
        RidVisited nv = this.getThreadState(threadId, true).lookupVisited(offset);
        if (nv.computeParents == v) {
            return true;
        }
        nv.computeParents = v;
        if (inputs.size() == 1) {
            parents.put(inputs.first(), this.provider);
            return true;
        }
        for (AndNode.Refinement ref : inputs) {
            TreeSet<AndNode.Refinement> childInputs = new TreeSet<AndNode.Refinement>(inputs);
            childInputs.remove(ref);
            AndNode.Refinement nRef = new AndNode.Refinement(ref.getRelativePosition(), offset, ref.input);
            this.lock.acquireReadLock();
            Provider cp = this.andChildren != null ? this.andChildren.get(nRef) : null;
            this.lock.releaseReadLock();
            if (cp == null) {
                if (discoverPatterns) {
                    return false;
                }
                cp = AndNode.createNextLevelNode((Model)m, (int)threadId, (Node)this, (AndNode.Refinement)nRef, (boolean)discoverPatterns).provider;
                if (cp == null) {
                    return false;
                }
            }
            Integer nOffset = Utils.nullSafeMin(ref.getRelativePosition(), offset);
            if (cp.get().computeAndParents(m, threadId, nOffset, childInputs, parents, discoverPatterns, v)) continue;
            return false;
        }
        return true;
    }

    void removeFromNextLevel(Document doc, NodeActivation iAct) {
        AndNode.removeActivation(doc, iAct);
        if (this.orChildren != null) {
            for (OrNode.OrEntry oe : this.orChildren) {
                oe.node.get().removeActivation(doc, oe.ridOffset, iAct);
            }
        }
    }

    void remove(Model m, int threadId) {
        assert (!this.isRemoved);
        this.lock.acquireWriteLock(threadId);
        this.provider.setModified();
        while (this.andChildren != null && !this.andChildren.isEmpty()) {
            this.andChildren.pollFirstEntry().getValue().get().remove(m, threadId);
        }
        while (this.orChildren != null && !this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().node.get().remove(m, threadId);
        }
        this.lock.releaseWriteLock();
        this.clearActivations(m);
        this.isRemoved = true;
        this.isRemovedId = isRemovedIdCounter++;
    }

    Provider<AndNode> getAndChild(AndNode.Refinement ref) {
        this.lock.acquireReadLock();
        Provider<AndNode> result = this.andChildren != null ? this.andChildren.get(ref) : null;
        this.lock.releaseReadLock();
        return result;
    }

    public static boolean adjust(Model m, int threadId, INeuron neuron, final int dir, Collection<Synapse> modifiedSynapses) {
        long v = visitedCounter++;
        OrNode outputNode = neuron.node.get();
        if (modifiedSynapses.isEmpty()) {
            return false;
        }
        int numAboveTolerance = 0;
        double sumBelowTolerance = 0.0;
        neuron.maxRecurrentSum = 0.0;
        for (Synapse s : modifiedSynapses) {
            INeuron in = (INeuron)s.input.get();
            in.lock.acquireWriteLock(threadId);
            if (s.inputNode == null) {
                InputNode iNode = InputNode.add(m, s.key.createInputNodeKey(), (INeuron)s.input.get());
                iNode.provider.setModified();
                iNode.isBlocked = in.isBlocked;
                iNode.setSynapse(threadId, s);
                s.inputNode = iNode.provider;
            }
            if (s.key.isRecurrent) {
                neuron.maxRecurrentSum += (double)Math.abs(s.w);
                ((Neuron)neuron.provider).setModified();
            }
            in.lock.releaseWriteLock();
            if (s.key.isNeg || s.key.isRecurrent) continue;
            if ((double)s.w >= -neuron.bias * TOLERANCE) {
                ++numAboveTolerance;
                continue;
            }
            sumBelowTolerance += (double)s.w;
        }
        assert (numAboveTolerance >= 1);
        TreeSet<RSKey> queue = new TreeSet<RSKey>(new Comparator<RSKey>(){

            @Override
            public int compare(RSKey rsk1, RSKey rsk2) {
                if (rsk1.pa == null && rsk2.pa != null) {
                    return -1;
                }
                if (rsk1.pa != null && rsk2.pa == null) {
                    return 1;
                }
                if (rsk1.pa == null && rsk2.pa == null) {
                    return 0;
                }
                int r = Integer.compare(rsk2.pa.get().level, rsk1.pa.get().level) * dir;
                if (r != 0) {
                    return r;
                }
                r = rsk1.pa.compareTo(rsk2.pa);
                if (r != 0) {
                    return r;
                }
                return Utils.compareInteger(rsk1.offset, rsk2.offset);
            }
        });
        if (queue.isEmpty()) {
            queue.add(new RSKey(null, null));
        }
        ArrayList<RSKey> outputs = new ArrayList<RSKey>();
        ArrayList<RSKey> cleanup = new ArrayList<RSKey>();
        while (!queue.isEmpty()) {
            RSKey rsk = queue.pollFirst();
            Node.computeRefinements(m, threadId, queue, neuron, rsk, v, outputs, cleanup, modifiedSynapses, numAboveTolerance, sumBelowTolerance);
        }
        if (outputs.isEmpty()) {
            return false;
        }
        outputNode.lock.acquireWriteLock(threadId);
        for (RSKey rsk : outputs) {
            Node pa = rsk.pa.get();
            pa.lock.acquireWriteLock(threadId);
            outputNode.addInput(threadId, rsk.offset, pa);
            pa.lock.releaseWriteLock();
        }
        outputNode.lock.releaseWriteLock();
        for (RSKey on : cleanup) {
            on.pa.get().cleanup(m, threadId);
        }
        return true;
    }

    private static void computeRefinements(Model m, int threadId, TreeSet<RSKey> queue, INeuron n, RSKey rsk, long v, List<RSKey> outputs, List<RSKey> cleanup, Collection<Synapse> modifiedSynapses, int numAboveTolerance, double sumBelowTolerance) {
        Collection<Synapse> tmp;
        n.lock.acquireWriteLock(threadId);
        Node pa = rsk.pa != null ? rsk.pa.get() : null;
        double sum = n.posRecSum - (n.negDirSum + n.negRecSum);
        double x = sum + ((pa != null ? pa.level : 0) + 1 == numAboveTolerance ? sumBelowTolerance : 0.0);
        if (pa == null) {
            tmp = modifiedSynapses;
        } else {
            sum += pa.computeSynapseWeightSum(rsk.offset, n);
            tmp = n.inputSynapses.values();
        }
        for (Synapse s : tmp) {
            Node nln;
            if (!((double)s.w >= -n.bias * TOLERANCE) || s.key.isNeg || s.key.isRecurrent || !(sum + (double)Math.abs(s.w) + (double)s.maxLowerWeightsSum > 0.0) || (nln = rsk.pa == null ? (Node)s.inputNode.get() : AndNode.createNextLevelNode(m, threadId, pa, new AndNode.Refinement(s.key.relativeRid, rsk.offset, s.inputNode), false)) == null) continue;
            nln.prepareResultsForPredefinedNodes(threadId, queue, v, outputs, cleanup, n, s, Utils.nullSafeMin(s.key.relativeRid, rsk.offset), x);
        }
        n.lock.releaseWriteLock();
    }

    void prepareResultsForPredefinedNodes(int threadId, TreeSet<RSKey> queue, long v, List<RSKey> outputs, List<RSKey> cleanup, INeuron n, Synapse s, Integer offset, double x) {
        RSKey rs = new RSKey(this.provider, offset);
        try {
            RidVisited nv = this.getThreadState(threadId, true).lookupVisited(offset);
            if (this.computeSynapseWeightSum(offset, n) + x > 0.0 || !this.isExpandable(false)) {
                if (nv.outputNode != v) {
                    nv.outputNode = v;
                    if (this.isCovered(threadId, offset, v)) {
                        cleanup.add(rs);
                    } else {
                        outputs.add(rs);
                    }
                }
            } else if (nv.adjust != v) {
                nv.adjust = v;
                queue.add(rs);
            }
        }
        catch (ThreadState.RidOutOfRange ridOutOfRange) {
            // empty catch block
        }
    }

    public boolean isCovered(int threadId, Integer offset, long v) throws ThreadState.RidOutOfRange {
        return false;
    }

    public boolean isRequired() {
        return this.numberOfNeuronRefs > 0;
    }

    public String getNeuronLabel() {
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNeuronLabel());
        sb.append(" - ");
        sb.append(this.logicToString());
        sb.append(" - ");
        sb.append(this.weightsToString());
        return sb.toString();
    }

    public String weightsToString() {
        return "";
    }

    @Override
    public int compareTo(Node n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NODE) {
            return -1;
        }
        if (n == MIN_NODE) {
            return 1;
        }
        if (this == MAX_NODE) {
            return 1;
        }
        if (n == MAX_NODE) {
            return -1;
        }
        return this.provider.compareTo(n.provider);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        out.writeInt(this.frequency);
        out.writeDouble(this.nullHypFreq);
        out.writeDouble(this.oldNullHypFreq);
        out.writeBoolean(this.isBlocked);
        out.writeBoolean(this.endRequired);
        out.writeBoolean(this.ridRequired);
        out.writeInt(this.numberOfNeuronRefs);
        out.writeBoolean(this.frequencyHasChanged);
        out.writeInt(this.nOffset);
        out.writeInt(this.sizeSum);
        out.writeInt(this.instanceSum);
        if (this.andChildren != null) {
            out.writeInt(this.andChildren.size());
            for (Map.Entry<AndNode.Refinement, Provider<AndNode>> me : this.andChildren.entrySet()) {
                me.getKey().write(out);
                out.writeInt(me.getValue().id);
            }
        } else {
            out.writeInt(0);
        }
        if (this.orChildren != null) {
            out.writeInt(this.orChildren.size());
            for (OrNode.OrEntry oe : this.orChildren) {
                oe.write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int i;
        this.level = in.readInt();
        this.frequency = in.readInt();
        this.nullHypFreq = in.readDouble();
        this.oldNullHypFreq = in.readDouble();
        this.isBlocked = in.readBoolean();
        this.endRequired = in.readBoolean();
        this.ridRequired = in.readBoolean();
        this.numberOfNeuronRefs = in.readInt();
        this.frequencyHasChanged = in.readBoolean();
        this.nOffset = in.readInt();
        this.sizeSum = in.readInt();
        this.instanceSum = in.readInt();
        int s = in.readInt();
        for (i = 0; i < s; ++i) {
            this.addAndChild(AndNode.Refinement.read(in, m), (Provider<AndNode>)m.lookupNodeProvider(in.readInt()));
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            if (this.orChildren == null) {
                this.orChildren = new TreeSet();
            }
            this.orChildren.add(OrNode.OrEntry.read(in, m));
        }
        this.threads = new ThreadState[m.numberOfThreads];
    }

    public static Node readNode(DataInput in, Provider p) throws IOException {
        String type = in.readUTF();
        Node n = null;
        switch (type) {
            case "I": {
                n = new InputNode();
                break;
            }
            case "A": {
                n = new AndNode();
                break;
            }
            case "O": {
                n = new OrNode();
            }
        }
        n.provider = p;
        n.readFields(in, p.m);
        return n;
    }

    static class ReverseAndRefinement
    implements Comparable<ReverseAndRefinement> {
        boolean dir;
        Provider node;

        public ReverseAndRefinement(Provider n, Integer a, Integer b) {
            this.node = n;
            this.dir = Utils.compareNullSafe(a, b);
        }

        @Override
        public int compareTo(ReverseAndRefinement rar) {
            int r = this.node.compareTo(rar.node);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.dir, rar.dir);
        }
    }

    private static class RemovedEntry<T extends Node, A extends NodeActivation<T>> {
        A act;
        Set<NodeActivation> iActs = new TreeSet<NodeActivation>();

        private RemovedEntry() {
        }
    }

    private static class RSKey
    implements Comparable<RSKey> {
        Provider<? extends Node> pa;
        Integer offset;

        public RSKey(Provider<? extends Node> pa, Integer offset) {
            this.pa = pa;
            this.offset = offset;
        }

        public String toString() {
            return "Offset:" + this.offset + " PA:" + this.pa.get().logicToString();
        }

        @Override
        public int compareTo(RSKey rs) {
            int r = this.pa.compareTo(rs.pa);
            if (r != 0) {
                return r;
            }
            return Utils.compareInteger(this.offset, rs.offset);
        }
    }

    static class RidVisited {
        public long computeParents = -1L;
        public long outputNode = -1L;
        public long adjust = -1L;

        RidVisited() {
        }
    }

    public static class ThreadState<T extends Node, A extends NodeActivation<T>> {
        public long lastUsed;
        public TreeMap<NodeActivation.Key, A> activations;
        public TreeMap<NodeActivation.Key, A> activationsEnd;
        public TreeMap<NodeActivation.Key, A> activationsRid;
        public NavigableMap<NodeActivation.Key, Set<NodeActivation<?>>> added;
        public NavigableMap<NodeActivation.Key, RemovedEntry> removed;
        long visitedNeuronRefsChange = -1L;
        public long visitedAllowedOption = -1L;
        public long visitedComputeWeight = -1L;
        private RidVisited nullRidVisited;
        private RidVisited[] ridVisited = new RidVisited[2 * MAX_RID];

        public ThreadState(boolean endRequired, boolean ridRequired) {
            this.activations = new TreeMap(BEGIN_COMP);
            this.activationsEnd = endRequired ? new TreeMap(END_COMP) : null;
            this.activationsRid = ridRequired ? new TreeMap(RID_COMP) : null;
            this.added = new TreeMap();
            this.removed = new TreeMap<NodeActivation.Key, RemovedEntry>();
        }

        public RidVisited lookupVisited(Integer offset) throws RidOutOfRange {
            if (offset != null && (offset >= MAX_RID || offset <= -MAX_RID)) {
                log.warn("RID too large:" + offset);
                throw new RidOutOfRange("RID too large:" + offset);
            }
            if (offset == null) {
                if (this.nullRidVisited == null) {
                    this.nullRidVisited = new RidVisited();
                }
                return this.nullRidVisited;
            }
            RidVisited v = this.ridVisited[offset + MAX_RID];
            if (v == null) {
                this.ridVisited[offset.intValue() + Node.MAX_RID] = v = new RidVisited();
            }
            return v;
        }

        public static class RidOutOfRange
        extends Exception {
            public RidOutOfRange(String s) {
                super(s);
            }
        }
    }
}

