/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.util.Collection;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.Node;

public class NodeActivation<T extends Node>
implements Comparable<NodeActivation> {
    public int id;
    public final Key<T> key;
    public boolean isRemoved;
    public int removedId;
    public long visitedNeuronTrain = -1L;
    public static int removedIdCounter = 1;
    public static long visitedCounter = 1L;
    public boolean isTrainingAct;
    public TreeMap<Key, NodeActivation> inputs = new TreeMap();
    public TreeMap<Key, NodeActivation> outputs = new TreeMap();

    public NodeActivation(int id, Key<T> key) {
        this.id = id;
        this.key = key;
    }

    public NodeActivation(int id, T n, Range pos, Integer rid, InterprNode o) {
        this.id = id;
        this.key = new Key<T>(n, pos, rid, o);
    }

    public void link(Collection<NodeActivation> inputActs) {
        for (NodeActivation iAct : inputActs) {
            this.inputs.put(iAct.key, iAct);
            iAct.outputs.put(this.key, this);
        }
    }

    public void unlink(Collection<NodeActivation> inputActs) {
        for (NodeActivation iAct : inputActs) {
            this.inputs.remove(iAct.key);
            iAct.outputs.remove(this.key);
        }
    }

    public void unlink() {
        for (NodeActivation act : this.inputs.values()) {
            act.outputs.remove(this.key);
        }
        for (NodeActivation act : this.outputs.values()) {
            act.inputs.remove(this.key);
        }
    }

    public static <T extends Node, A extends NodeActivation<T>> A get(Document doc, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<A> s = NodeActivation.select(doc, n, rid, r, begin, end, o, or);
        return (A)((NodeActivation)s.findFirst().orElse(null));
    }

    public static <T extends Node, A extends NodeActivation<T>> A get(Document doc, T n, Key ak) {
        return NodeActivation.get(doc, n, ak.rid, ak.r, Range.Operator.EQUALS, Range.Operator.EQUALS, ak.o, InterprNode.Relation.EQUALS);
    }

    public static NodeActivation getNextSignal(Node n, Document doc, int from, Integer rid, InterprNode o, boolean dir, boolean inv) {
        Node.ThreadState th = n.getThreadState(doc.threadId, false);
        if (th == null) {
            return null;
        }
        Key<Object> bk = new Key<Object>(null, new Range(from, dir ? Integer.MIN_VALUE : Integer.MAX_VALUE).invert(inv), rid, o);
        TreeMap tmp = inv ? th.activationsEnd : th.activations;
        tmp = dir ? tmp.descendingMap() : tmp;
        for (NodeActivation act : tmp.tailMap(bk, false).values()) {
            if (!act.filter(n, rid, null, null, null, o, InterprNode.Relation.CONTAINED_IN)) continue;
            return act;
        }
        return null;
    }

    public static Stream<NodeActivation> select(Document doc, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<Object> results;
        if (rid != null) {
            Key<Node> bk = new Key<Node>(Node.MIN_NODE, Range.MIN, rid, InterprNode.MIN);
            Key<Node> ek = new Key<Node>(Node.MAX_NODE, Range.MAX, rid, InterprNode.MAX);
            results = doc.activationsByRid.subMap(bk, true, ek, true).values().stream();
        } else {
            results = doc.activatedNodes.stream().flatMap(node -> NodeActivation.getActivationsStream(node, doc));
        }
        return results.filter(act -> act.filter(null, rid, r, begin, end, o, or));
    }

    public static <T extends Node, A extends NodeActivation<T>> Stream<A> select(Document doc, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Node.ThreadState th = n.getThreadState(doc.threadId, false);
        if (th == null) {
            return Stream.empty();
        }
        return NodeActivation.select(th, n, rid, r, begin, end, o, or);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Node, A extends NodeActivation<T>> Stream<A> select(Node.ThreadState<T, A> th, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        void var8_12;
        int s = th.activations.size();
        if (s == 0) {
            return Stream.empty();
        }
        if (s == 1) {
            Stream stream = th.activations.values().stream();
            return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if (rid != null) {
            Key<T> bk = new Key<T>(n, Range.MIN, rid, InterprNode.MIN);
            Key<T> ek = new Key<T>(n, Range.MAX, rid, InterprNode.MAX);
            if (th.activationsRid == null) return Stream.empty();
            Stream stream = th.activationsRid.subMap(bk, true, ek, true).values().stream();
            return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else {
            if (begin != null || end != null) return NodeActivation.getActivationsByRange(th, n, rid, r, begin, end, o, or);
            Stream stream = th.activations.values().stream();
        }
        return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
    }

    public static <T extends Node, A extends NodeActivation<T>> Stream<A> getActivationsByRange(Node.ThreadState<T, A> th, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<NodeActivation> s;
        if ((begin == Range.Operator.GREATER_THAN || begin == Range.Operator.EQUALS || end == Range.Operator.FIRST) && r.begin != null) {
            int er = (end == Range.Operator.LESS_THAN || end == Range.Operator.EQUALS || end == Range.Operator.FIRST) && r.end != null ? r.end : Integer.MAX_VALUE;
            s = th.activations.subMap(new Key<T>(n, new Range(r.begin, null), null, InterprNode.MIN), true, new Key<T>(n, new Range(er, Integer.MAX_VALUE), Integer.MAX_VALUE, InterprNode.MAX), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if ((begin == Range.Operator.LESS_THAN || begin == Range.Operator.EQUALS) && r.begin != null) {
            s = th.activations.descendingMap().subMap(new Key<T>(n, new Range(r.begin, Integer.MAX_VALUE), null, InterprNode.MAX), true, new Key<T>(n, new Range(null, null), null, InterprNode.MIN), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if (end == Range.Operator.LAST) {
            s = th.activationsEnd.tailMap(new Key<T>(n, new Range(null, r.begin), null, InterprNode.MIN), true).values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else {
            if (begin == Range.Operator.LAST || begin == Range.Operator.FIRST || end == Range.Operator.FIRST) {
                throw new RuntimeException("Not implemented yet!");
            }
            s = th.activations.values().stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
        }
        return s;
    }

    private static <T extends Node, A extends NodeActivation<T>> Stream<A> getActivationsStream(T n, Document doc) {
        Node.ThreadState th = n.getThreadState(doc.threadId, false);
        return th == null ? Stream.empty() : th.activations.values().stream();
    }

    public <T extends Node> boolean filter(T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        return !(n != null && this.key.n != n || rid != null && (this.key.rid == null || this.key.rid.intValue() != rid.intValue()) || r != null && (begin != null && !begin.compare(this.key.r.begin, this.key.r.end, r.begin, r.end) || end != null && !end.compare(this.key.r.end, this.key.r.begin, r.end, r.begin)) || o != null && !or.compare(this.key.o, o));
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.r);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.r.begin - 3), Math.min(doc.length(), this.key.r.end + 3)));
        sb.append(",");
        sb.append(this.key.n);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(NodeActivation act) {
        return this.key.compareTo(act.key);
    }

    public static int compare(NodeActivation a, NodeActivation b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static final class Key<T extends Node>
    implements Comparable<Key> {
        public final T n;
        public final Range r;
        public final Integer rid;
        public final InterprNode o;
        private int refCount = 0;

        public Key(T n, Range r, Integer rid, InterprNode o) {
            this.n = n;
            this.r = r;
            this.rid = rid;
            this.o = o;
            this.countRef();
            if (o != null) {
                o.countRef();
            }
        }

        public void countRef() {
            ++this.refCount;
        }

        public void releaseRef() {
            assert (this.refCount > 0);
            --this.refCount;
            if (this.refCount == 0) {
                this.o.releaseRef();
            }
        }

        @Override
        public int compareTo(Key k) {
            int x = ((Node)this.n).compareTo((Node)k.n);
            if (x != 0) {
                return x;
            }
            x = Range.compare(this.r, k.r, false);
            if (x != 0) {
                return x;
            }
            x = Utils.compareInteger(this.rid, k.rid);
            if (x != 0) {
                return x;
            }
            return this.o.compareTo(k.o);
        }

        public String toString() {
            return (this.n != null ? ((Node)this.n).getNeuronLabel() : "") + this.r + " " + this.rid + " " + this.o;
        }
    }
}

